/*
 * JBoss, Home of Professional Open Source
 * Copyright 2008, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE. See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * (C) 2005-2008, JBoss Inc.
 */
package org.jboss.soa.esb.actions.soap;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Map;

import junit.framework.TestCase;

public class SchemaDeployerTest extends TestCase {

	private SchemaDeployer deployer;

	@Override
	protected void setUp() {
		deployer = new SchemaDeployerImpl() {
			// mock method to eschew actual network access
			@Override
			public String getXSDString(URL url, File tempFile) throws IOException {
				return "!!! Dummy XSD data !!!";
			}
		};
	}

	@Override
	protected void tearDown() {
		deployer = null;
	}

	public void testDeploy_JBossWS_Native() {
		String rewrittenLocation = deployer.deploy("http://127.0.0.1:8080/Quickstart_HelloWorldWS/HelloWorldWS?wsdl&resource=HelloWorldService.xsd",
				"http://www.jboss.org/HelloWorld");

		assertEquals("http://www.jboss.org/HelloWorld?wsdl&resource=HelloWorldService.xsd", rewrittenLocation);
		Map<String, String> resources = deployer.getResources();
		assertEquals(resources.size(), 1);
		assertEquals("!!! Dummy XSD data !!!", resources.get("HelloWorldService.xsd"));
	}

	public void testDeploy_JBossWS_CXF() {
		String rewrittenLocation = deployer.deploy("http://127.0.0.1:8080/Quickstart_HelloWorldWS/HelloWorldWS?xsd=HelloWorldService.xsd",
				"http://www.jboss.org/HelloWorld");

		assertEquals("http://www.jboss.org/HelloWorld?wsdl&resource=HelloWorldService.xsd", rewrittenLocation);
		Map<String, String> resources = deployer.getResources();
		assertEquals(resources.size(), 1);
		assertEquals("!!! Dummy XSD data !!!", resources.get("HelloWorldService.xsd"));
	}

	public void testDeploy_DuplicateNames() {
		String rewrittenLocation1 = deployer.deploy("http://127.0.0.1:8080/Quickstart_HelloWorldWS/HelloWorldWS?wsdl&resource=HelloWorldService.xsd",
				"http://www.jboss.org/HelloWorld");
		String rewrittenLocation2 = deployer.deploy("http://127.0.0.1:8080/Quickstart_HelloWorldWS/HelloWorldWS?wsdl&resource=HelloWorldService.xsd",
				"http://www.jboss.org/HelloWorld");
		String rewrittenLocation3 = deployer.deploy("http://127.0.0.1:8080/Quickstart_HelloWorldWS/HelloWorldWS?wsdl&resource=HelloWorldService.xsd",
				"http://www.jboss.org/HelloWorld");

		assertEquals("http://www.jboss.org/HelloWorld?wsdl&resource=HelloWorldService.xsd", rewrittenLocation1);
		assertEquals("http://www.jboss.org/HelloWorld?wsdl&resource=1HelloWorldService.xsd", rewrittenLocation2);
		assertEquals("http://www.jboss.org/HelloWorld?wsdl&resource=2HelloWorldService.xsd", rewrittenLocation3);
		Map<String, String> resources = deployer.getResources();
		assertEquals(resources.size(), 3);
		assertEquals("!!! Dummy XSD data !!!", resources.get("HelloWorldService.xsd"));
		assertEquals("!!! Dummy XSD data !!!", resources.get("1HelloWorldService.xsd"));
		assertEquals("!!! Dummy XSD data !!!", resources.get("2HelloWorldService.xsd"));
	}
}
