/*
 * JBoss, Home of Professional Open Source
 * Copyright 2006, JBoss Inc., and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 *
 * (C) 2005-2006, JBoss Inc.
 */
package org.jboss.soa.esb.services.soapui;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.*;

import javax.xml.transform.stream.StreamResult;

import junit.framework.TestCase;

import org.jboss.soa.esb.ConfigurationException;
import org.jboss.soa.esb.http.HttpClientFactory;
import org.jboss.soa.esb.dom.YADOMUtil;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class JBESB_1713_SoapUIClientServiceMBeanUnitTest extends TestCase {
	
    private class PostBlahMessage1 {
    	public String arg0 = "argument 0";
        public List<String> arg1;
        public List<String> arg2;
        public boolean arg3 = true;
        public String arg4 = "argument 4";
        public long arg5 = 1;
        public long arg6 = 2;
    }

    private class PostBlahMessage2 {
    	public String arg0 = "argument 0";
        public String[] arg1;
        public String[] arg2;
        public boolean arg3 = true;
        public String arg4 = "argument 4";
        public long arg5 = 1;
        public long arg6 = 2;
    }

    private void addBlahs(List<String> trains, int num) {
        for(int i = 0; i < num; i++) {
            trains.add(String.valueOf(i + 1));
        }
    }

    private void addRoles(List<String> roles, int num) {
        for(int i = 0; i < num; i++) {
            roles.add(new String("Role " + (i + 1)));
        }
    }

    private static final String WSDL_LOCATAION = "src/test/java/org/jboss/soa/esb/services/soapui";
    private Properties properties;

    protected void setUp() throws Exception {
        properties = new Properties();
    }

    public void test_JBESB_1713_single() throws IOException, SAXException, ConfigurationException {
        test_JBESB_1713(1, "expected_JBESB_1713_01.xml");
    }

    public void test_JBESB_1713_multiple() throws IOException, SAXException, ConfigurationException {
        test_JBESB_1713(4, "expected_JBESB_1713_02.xml");
    }

    public void test_JBESB_1713(int num, String expected) throws IOException, SAXException, ConfigurationException {
    	File wsdlFile = new File(WSDL_LOCATAION + "/handdator.wsdl");
        SoapUIClientService mbean = new SoapUIClientService();
        Map params = new HashMap();

        params.put("dumpSOAP", null);
        
        PostBlahMessage1 postBlahMessage1 = new PostBlahMessage1();
        PostBlahMessage2 postBlahMessage2 = new PostBlahMessage2();

        List<String> blahs1 = new ArrayList<String>();
        List<String> roles1 = new ArrayList<String>();
        String[] blahs2 = new String[num];
        String[] roles2 = new String[num];

        properties.setProperty(HttpClientFactory.TARGET_HOST_URL, wsdlFile.toURI().toString());
        
        addBlahs(blahs1, num);
        addRoles(roles1, num);
        postBlahMessage1.arg1 = blahs1;
        postBlahMessage1.arg2 = roles1;
        blahs1.toArray(blahs2);
        roles1.toArray(roles2);
        postBlahMessage2.arg1 = blahs2;
        postBlahMessage2.arg2 = roles2;

        params.put("postBlahMessage", postBlahMessage1);

        String message = mbean.buildRequest(wsdlFile.toURI().toString(), "postBlahMessage", null, params, properties, null, null);
        assertTrue("Generated SOAP message not as expected. See " + expected + ".  Generated message: \n" + message, compareCharStreams(getClass().getResourceAsStream(expected), new ByteArrayInputStream(message.getBytes())));

        params.put("postBlahMessage", postBlahMessage2);

        message = mbean.buildRequest(wsdlFile.toURI().toString(), "postBlahMessage", null, params, properties, null, null);

        assertTrue("Generated SOAP message not as expected. See " + expected + ".  Generated message: \n" + message, compareCharStreams(getClass().getResourceAsStream(expected), new ByteArrayInputStream(message.getBytes())));
    }

    // Lifted from milyn commons
    public static boolean compareCharStreams(InputStream s1, InputStream s2) {
        try {
            final String xml1 = trimLines(s1).toString() ;
            final String xml2 = trimLines(s2).toString() ;
            
            final Document doc1 = YADOMUtil.parse(xml1) ;
            final Document doc2 = YADOMUtil.parse(xml2) ;
            
            final StringWriter writer1 = new StringWriter() ;
            final StringWriter writer2 = new StringWriter() ;
            YADOMUtil.serialize(doc1, new StreamResult(writer1)) ;
            YADOMUtil.serialize(doc2, new StreamResult(writer2)) ;
            return (writer1.toString().equals(writer2.toString())) ;
        } catch (IOException e) {
            // fail the comparison
        } catch (SAXException e) {
            // fail the comparison
        } catch (ConfigurationException e) {
            // fail the comparison
        }

        return false;
    }
    public static StringBuffer trimLines(InputStream charStream) throws IOException {
        StringBuffer stringBuf = new StringBuffer();
        BufferedReader reader = new BufferedReader(new InputStreamReader(charStream));
        String line;

        while((line = reader.readLine()) != null) {
            stringBuf.append(line.trim());
        }

        return stringBuf;
    }
}
