/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.deployer.as5;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.annotations.AnnotationEnvironment;
import org.jboss.deployers.vfs.spi.structure.StructureContext;
import org.jboss.deployers.vfs.spi.structure.helpers.AbstractStructureDeployer;
import org.jboss.soa.bpel.deployer.BPELDeploymentUnit;
import org.jboss.virtual.VirtualFile;

/**
 * Implementation of the BPEL Structure Deployer, used to locate the
 * BPEL deployment descriptor and create a context for the BPEL
 * deployment unit.
 * 
 * @author gbrown
 *
 */
public class BPELStructureDeployer extends AbstractStructureDeployer {

	@Override
	protected AnnotationEnvironment createAnnotationEnvironment(VirtualFile arg0) {
		return null;
	}

	public boolean determineStructure(StructureContext sc)
			throws DeploymentException {
		boolean ret=false;
		
		try {
			// Must look for the deployment descriptor, as opposed to the container
			// that contains the descriptor, because in the case of a Jar with the descriptor
			// at the top level, the deployer will not get called with the Jar top level
			// node, as this is handled by a Jar deployer.
			if (sc.getName().equals(BPELDeploymentUnit.DEPLOY_XML) ||
					sc.getName().equals(BPELDeploymentUnit.BPEL_DEPLOY_XML)) {
				ret = true;
				
				// Create the context for the deployment associated with
				// the deployment descriptor's parent container
				createContext(sc);								
			}
		} catch (Exception e) {
			throw new DeploymentException(e);
		}
		
		return(ret);
	}

}
