/*
 * JBoss, Home of Professional Open Source
 * Copyright 2009, Red Hat Middleware LLC, and others contributors as indicated
 * by the @authors tag. All rights reserved.
 * See the copyright.txt in the distribution for a
 * full listing of individual contributors.
 * This copyrighted material is made available to anyone wishing to use,
 * modify, copy, or redistribute it subject to the terms and conditions
 * of the GNU Lesser General Public License, v. 2.1.
 * This program is distributed in the hope that it will be useful, but WITHOUT A
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
 * PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details.
 * You should have received a copy of the GNU Lesser General Public License,
 * v.2.1 along with this distribution; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA  02110-1301, USA.
 */
package org.jboss.soa.bpel.runtime;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.soa.dsp.deployer.ServiceDeployer;
import org.jboss.soa.dsp.server.ServerConfig;
import org.jboss.soa.dsp.server.ServerConfigFactory;

/**
 * This class provides a factory for retrieving the Dynamic Service
 * Provider components suitable for the JBoss environment.
 *
 */
public class JBossDSPFactory {

	private static final String BPEL_DSP_SERVICE_DEPLOYER = "bpel.dsp.service.deployer";
	private static final String BPEL_DSP_SERVER_CONFIG_FACTORY = "bpel.dsp.server.config.factory";
	
	private static final Log log = LogFactory.getLog(JBossDSPFactory.class);
	
	private static ServiceDeployer m_serviceDeployer=null;
	private static ServerConfig m_serverConfig=null;
	
	public static ServerConfig getServerConfig() {
		if (m_serverConfig == null) {
			java.util.ResourceBundle bundle=java.util.ResourceBundle.getBundle("bpel");
			
			String configFactoryClassName=bundle.getString(BPEL_DSP_SERVER_CONFIG_FACTORY);
			  
			if (configFactoryClassName != null) {
				try {
					Class<?> cls=Class.forName(configFactoryClassName);
						
					ServerConfigFactory factory = (ServerConfigFactory)cls.newInstance();
					
					m_serverConfig = factory.getServerConfig();
						
				} catch(Exception e) {
					log.error("Failed to get server config factory '"+configFactoryClassName+"'", e);
				}
			} else {
				log.error("Failed to find server config factory property '"+BPEL_DSP_SERVER_CONFIG_FACTORY+"'");
			}
		}

		return(m_serverConfig);
	}
	
	public static synchronized ServiceDeployer getServiceDeployer() {
		if (m_serviceDeployer == null) {
			java.util.ResourceBundle bundle=java.util.ResourceBundle.getBundle("bpel");
			
			String deployerClassName=bundle.getString(BPEL_DSP_SERVICE_DEPLOYER);
			  
			if (deployerClassName != null) {
				try {
					Class<?> cls=Class.forName(deployerClassName);
						
					m_serviceDeployer = (ServiceDeployer)cls.newInstance();
						
				} catch(Exception e) {
					log.error("Failed to get service deployer '"+deployerClassName+"'", e);
				}
			} else {
				log.error("Failed to find service deployer property '"+BPEL_DSP_SERVICE_DEPLOYER+"'");
			}
		}
		  
		return(m_serviceDeployer);
	}
	  
}
