/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.jdbc;

import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.CacheResultSet;
import com.intersys.jdbc.CacheStatement;
import java.sql.SQLException;

public class CacheStaticResultSet
extends CacheResultSet {
    protected int lastRow = -1;
    protected int lastFetchedRow = 0;

    CacheStaticResultSet(CacheStatement cacheStatement) throws SQLException {
        super(cacheStatement);
    }

    public synchronized boolean next() throws SQLException {
        if (this.currentRow == 0) {
            return this.staticFetch(1, this.statement.fetchSize);
        }
        if (this.isAfterLast || this.lastRow != -1 && this.currentRow > this.lastRow) {
            return false;
        }
        if (this.currentRow == this.lastRow) {
            this.isAfterLast = true;
            return false;
        }
        if (this.currentRow == this.lastFetchedRow) {
            if (this.statement.fetchDone) {
                this.isAfterLast = true;
                return false;
            }
            return this.staticFetch(this.currentRow + 1, this.statement.fetchSize);
        }
        this.currentColumn = this.statement.input.wire.advance(this.currentColumn, this.statement.columns.size() + 1);
        if (this.currentColumn != this.statement.columns.size() + 1) {
            if (this.statement.fetchDone) {
                this.isAfterLast = true;
                return false;
            }
            return this.staticFetch(this.currentRow + 1, this.statement.fetchSize);
        }
        this.currentColumn = 1;
        this.statement.input.wire.saveCurrentRowPosition();
        ++this.currentRow;
        return true;
    }

    public boolean isBeforeFirst() throws SQLException {
        return this.currentRow == 0;
    }

    public boolean isAfterLast() throws SQLException {
        return this.isAfterLast;
    }

    public boolean isFirst() throws SQLException {
        return this.currentRow == 1;
    }

    public boolean isLast() throws SQLException {
        return this.lastRow == this.currentRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void beforeFirst() throws SQLException {
        CacheStatement cacheStatement = this.statement;
        synchronized (cacheStatement) {
            this.statement.fetchDone = false;
        }
        this.currentRow = 0;
        this.lastFetchedRow = 0;
        this.isAfterLast = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void afterLast() throws SQLException {
        CacheStatement cacheStatement = this.statement;
        synchronized (cacheStatement) {
            this.statement.fetchDone = false;
        }
        if (!this.isAfterLast) {
            this.last();
            this.next();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean first() throws SQLException {
        CacheStatement cacheStatement = this.statement;
        synchronized (cacheStatement) {
            this.statement.fetchDone = false;
        }
        return this.staticFetch(1, this.statement.fetchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean last() throws SQLException {
        this.isAfterLast = false;
        CacheStatement cacheStatement = this.statement;
        synchronized (cacheStatement) {
            this.statement.fetchDone = false;
        }
        if (!this.staticFetch(0, 1)) {
            return false;
        }
        this.lastRow = this.currentRow;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean absolute(int n) throws SQLException {
        this.isAfterLast = false;
        CacheStatement cacheStatement = this.statement;
        synchronized (cacheStatement) {
            this.statement.fetchDone = false;
        }
        if (n == 0) {
            throw new SQLException("Invalid cursor position");
        }
        if (n == 1) {
            return this.first();
        }
        if (n == -1) {
            return this.last();
        }
        if (this.lastRow == -1) {
            int n2 = this.currentRow;
            this.last();
            this.currentRow = n2;
        }
        if (n < 0) {
            if ((n = this.lastRow + n + 1) <= 0) {
                this.currentRow = 0;
                return false;
            }
            return this.staticFetch(n, this.statement.fetchSize);
        }
        if (n > this.lastRow) {
            this.isAfterLast = true;
            return false;
        }
        return this.staticFetch(n, this.statement.fetchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean relative(int n) throws SQLException {
        if (this.isAfterLast || this.currentRow == 0) {
            throw new SQLException("Invalid cursor position");
        }
        CacheStatement cacheStatement = this.statement;
        synchronized (cacheStatement) {
            this.statement.fetchDone = false;
        }
        this.isAfterLast = false;
        if (n == 0) {
            return true;
        }
        if ((n += this.currentRow) <= 0) {
            this.currentRow = 0;
            return false;
        }
        if (this.lastRow == -1) {
            int n2 = this.currentRow;
            this.last();
            this.currentRow = n2;
        }
        if (n > this.lastRow) {
            this.isAfterLast = true;
            return false;
        }
        return this.staticFetch(n, this.statement.fetchSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean previous() throws SQLException {
        CacheStatement cacheStatement = this.statement;
        synchronized (cacheStatement) {
            this.statement.fetchDone = false;
        }
        if (this.isAfterLast) {
            this.isAfterLast = false;
            return this.staticFetch(this.lastRow, this.statement.fetchSize);
        }
        if (this.currentRow <= 1) {
            this.currentRow = 0;
            return false;
        }
        return this.staticFetch(this.currentRow - 1, this.statement.fetchSize);
    }

    public void setFetchDirection(int n) throws SQLException {
        if (n != 1000) {
            throw new SQLException("Not supported", "IM001");
        }
    }

    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    public int getType() throws SQLException {
        return 1004;
    }

    public int getRow() throws SQLException {
        if (this.isAfterLast) {
            return 0;
        }
        return this.currentRow;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized boolean staticFetch(int n, int n2) throws SQLException {
        if (n2 == 0) {
            n2 = 10;
        }
        this.isAfterLast = false;
        this.statement.fetchDone = false;
        CacheConnection.MessageCount messageCount = this.statement.connection.messageCount;
        synchronized (messageCount) {
            CacheConnection cfr_ignored_0 = this.statement.connection;
            this.statement.output.wire.writeHeader(this.statement.serverCursorNumber, CacheConnection.FETCH_STATIC_CURSOR);
            this.statement.output.wire.set(n);
            this.statement.output.wire.set(n2);
            this.statement.output.send(this.statement.connection.messageCount.getCount());
            int n3 = this.statement.input.readHeader(this.statement.serverCursorNumber, 0, 100);
            int n4 = this.statement.input.wire.getInt();
            int n5 = this.statement.input.wire.getInt();
            this.lastFetchedRow = n4 + n5 - 1;
            if (n == 0 || n3 == 100) {
                this.statement.fetchDone = true;
                this.lastRow = this.lastFetchedRow;
            }
            this.currentRow = n > 0 ? n : this.lastRow;
            if (n5 == 0) {
                return false;
            }
            this.currentColumn = 1;
            this.statement.input.wire.saveCurrentRowPosition();
            return true;
        }
    }
}

