/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.Dataholder;
import com.intersys.cache.jbind.CacheANTBase;
import com.intersys.cache.jbind.CacheIface;
import com.intersys.cache.jbind.JBindCacheObject;
import com.intersys.cache.jbind.JBindDatabase;
import com.intersys.cache.jbind.ZObjectValueRep;
import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.Logger;
import com.intersys.objects.Oid;
import com.intersys.objects.SystemError;
import java.io.PrintWriter;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CacheProcessor
extends CacheANTBase
implements CacheIface {
    private JBindDatabase mDB;
    private boolean mOidSent = false;
    private boolean mCleanZObjVal;
    private Map mTempMap;
    private boolean mAssertZobjVal;

    public CacheProcessor(JBindDatabase jBindDatabase, boolean bl, String string) {
        super(bl, string);
        this.mDB = jBindDatabase;
        this.mTempMap = new HashMap();
        this.mCleanZObjVal = true;
        this.mAssertZobjVal = ConnectionUtils.determineAssertZobjVal();
    }

    public void setOidSent(boolean bl) {
        this.mOidSent = bl;
    }

    public void setRecieveChangedNodesOnly(boolean bl) {
        this.mCleanZObjVal = !bl;
    }

    public boolean find(int n) throws SystemError {
        JBindCacheObject jBindCacheObject = this.mDB.find(n);
        if (jBindCacheObject == null) {
            return false;
        }
        return jBindCacheObject.isZobjvalCached();
    }

    public void remove(int n) throws SystemError {
        JBindCacheObject jBindCacheObject = this.mDB.find(n);
        if (jBindCacheObject == null) {
            return;
        }
        jBindCacheObject.invalidateZobjval();
    }

    public void notifyModified(int n) throws SystemError {
        if (this.mCleanZObjVal) {
            this.remove(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getData(Object object, Map map, CacheServerSensitive cacheServerSensitive, boolean bl) throws CacheException {
        try {
            int n = SysListProxy.getInteger(object);
            if (Logger.getDebugCache()) {
                Logger.out.println("Received " + n + " changed orefs " + "in cache from server");
            }
            HashSet<Integer> hashSet = new HashSet<Integer>();
            for (int i = 0; i < n; ++i) {
                int n2 = SysListProxy.getInteger(object);
                hashSet.add(new Integer(n2));
                Object object2 = null;
                if (this.mOidSent) {
                    object2 = SysListProxy.getSysList(object);
                    if (Logger.getDebugCache()) {
                        Logger.out.println("Got oid = " + object2);
                    }
                }
                int n3 = SysListProxy.getInteger(object);
                ZObjectValueRep zObjectValueRep = this.getZobjval(n2, n3, object2, bl);
                Map map2 = zObjectValueRep.getValueMap();
                PrintWriter printWriter = null;
                if (Logger.getDebugCache()) {
                    Logger.out.println("Got oref=" + n2 + "; nnodes=" + n3);
                    printWriter = Logger.out;
                }
                for (int j = 0; j < n3; ++j) {
                    int n4;
                    int n5;
                    try {
                        n5 = CacheProcessor.processNode(map2, object, printWriter);
                    }
                    catch (SQLException sQLException) {
                        throw new CacheException(sQLException, "Failed to extract server data for cache");
                    }
                    if (this.mCleanZObjVal || n5 >= 0 || (n4 = CacheProcessor.checkNextNode(zObjectValueRep, -n5)) <= 0) continue;
                    hashSet.add(new Integer(n4));
                }
                if (!this.mAssertZobjVal) continue;
                Object[][] objectArray = this.mDB.getZobjVal(n2);
                String[] stringArray = (String[])objectArray[0];
                zObjectValueRep.assertEquals(stringArray);
            }
            JBindDatabase jBindDatabase = this.mDB;
            synchronized (jBindDatabase) {
                CacheProcessor.notifySensitiveObjects(hashSet, map, cacheServerSensitive);
            }
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Bad data in cache received from server");
        }
    }

    private static int checkNextNode(ZObjectValueRep zObjectValueRep, int n) throws CacheException {
        Dataholder dataholder;
        if ((dataholder = zObjectValueRep.getProperty(++n, 0)) == null) {
            return 0;
        }
        if (dataholder.getObject() == null) {
            return 0;
        }
        switch (dataholder.getType()) {
            case 1026: {
                return dataholder.getCacheObject().getOref();
            }
            case 24: 
            case 4096: {
                String string = dataholder.getString();
                int n2 = string.indexOf("@%Collection");
                if (n2 < 0) {
                    return 0;
                }
                try {
                    return JBindDatabase.parseOrefString((String)string).oref;
                }
                catch (NumberFormatException numberFormatException) {
                    return 0;
                }
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ZObjectValueRep getZobjval(int n, int n2, Object object, boolean bl) throws CacheException {
        JBindDatabase jBindDatabase = this.mDB;
        synchronized (jBindDatabase) {
            ZObjectValueRep zObjectValueRep = null;
            boolean bl2 = this.mDB.isObjectAlive(n);
            if (this.mCleanZObjVal) {
                zObjectValueRep = this.newZObjVal(n2, object);
                if (bl2) {
                    JBindCacheObject jBindCacheObject = this.mDB.find(n);
                    jBindCacheObject.setZobjval(zObjectValueRep);
                }
            } else if (bl2) {
                JBindCacheObject jBindCacheObject = this.mDB.find(n);
                zObjectValueRep = jBindCacheObject.getZobjval();
                if (zObjectValueRep == null) {
                    zObjectValueRep = this.newZObjVal(n2, object);
                    jBindCacheObject.setZobjval(zObjectValueRep);
                }
            } else {
                zObjectValueRep = this.newZObjVal(n2, object);
            }
            if (!bl2 && bl) {
                this.mTempMap.put(new Integer(n), zObjectValueRep);
            }
            return zObjectValueRep;
        }
    }

    private ZObjectValueRep newZObjVal(int n, Object object) {
        HashMap hashMap = new HashMap(n);
        if (this.mOidSent) {
            return new ZObjectValueRep(hashMap, new Oid(object));
        }
        return new ZObjectValueRep(hashMap, null);
    }

    public synchronized void checkIfInTempMap(JBindCacheObject jBindCacheObject) throws CacheException {
        if (this.mTempMap == null) {
            throw new SystemError("Temporary map can not be null");
        }
        int n = jBindCacheObject.getOref();
        ZObjectValueRep zObjectValueRep = (ZObjectValueRep)this.mTempMap.remove(new Integer(n));
        if (zObjectValueRep == null) {
            return;
        }
        jBindCacheObject.setZobjval(zObjectValueRep);
    }

    public void clearTempMap() {
        this.mTempMap.clear();
    }

    public static int processNode(Map map, Object object, PrintWriter printWriter) throws SQLException {
        Object object2;
        int n = SysListProxy.getInteger(object);
        boolean bl = false;
        if (n < 0) {
            bl = true;
            n = -n;
        }
        if (printWriter != null) {
            printWriter.print("ii = " + n);
        }
        if (bl) {
            CacheProcessor.processMDProperty(n, map, object, printWriter);
            return -n;
        }
        Object object3 = SysListProxy.getWrappedItem(object);
        Dataholder dataholder = new Dataholder(4096, object3);
        if (printWriter != null) {
            Object object4 = object2 = object3 == null ? null : object3.toString();
            if (object2 != null) {
                object2 = ((String)object2).substring(4, ((String)object2).length() - 1);
            }
            printWriter.println(": val = " + (String)object2);
            SysListProxy.rewind(object3);
        }
        object2 = new Integer(n);
        map.put(object2, dataholder);
        return n;
    }

    private static void processMDProperty(int n, Map map, Object object, PrintWriter printWriter) throws SQLException {
        byte[] byArray = SysListProxy.getByte(object);
        if (printWriter != null) {
            if (byArray != null) {
                printWriter.println(": val = byte[" + byArray.length + "]");
            } else {
                printWriter.println(": val = null");
            }
        }
    }

    public Dataholder getProperty(int n, int n2, int n3, int n4, String string) throws CacheException {
        return this.getUnsetProperty(n, n2, n3, n4);
    }
}

