/*
 * Decompiled with CFR 0.152.
 */
package com.jalapeno.tools.objects.gui.wizard;

import com.jalapeno.tools.SchemaBuilder;
import com.jalapeno.tools.SchemaBuilderWizard;
import com.jalapeno.tools.objects.common.Messages;
import com.jalapeno.tools.objects.common.PersisterProperties;
import com.jalapeno.tools.objects.gui.LoginPanelDescriptor;
import com.jalapeno.tools.objects.gui.OptionsStandardPanelDescriptor;
import com.jalapeno.tools.objects.gui.ProjectionDescriptor;
import com.jalapeno.tools.objects.gui.ProjectionPanel;
import com.jalapeno.tools.objects.gui.RunPersisterWizardPanel;
import com.jalapeno.tools.objects.gui.SelectAndGenClassesOrDirsPanelDescriptor;
import com.jalapeno.tools.objects.gui.SelectAndGenJarsOrZipsPanelDescriptor;
import com.jalapeno.tools.objects.gui.SelectClassPathPanelDescriptor;
import com.jalapeno.tools.objects.gui.WhatToSelectPanelDescriptor;
import com.jalapeno.tools.objects.gui.wizard.ExtensionFileFilter;
import com.jalapeno.tools.objects.gui.wizard.WizardController;
import com.jalapeno.tools.objects.gui.wizard.WizardModel;
import com.jalapeno.tools.objects.gui.wizard.WizardPanel;
import com.jalapeno.tools.objects.gui.wizard.WizardPanelDescriptor;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.net.URL;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.border.EmptyBorder;

public class Wizard
extends WindowAdapter
implements PropertyChangeListener {
    public static final int FINISH_RETURN_CODE = 0;
    public static final int CANCEL_RETURN_CODE = 1;
    public static final int ERROR_RETURN_CODE = 2;
    public static final String NEXT_BUTTON_ACTION_COMMAND = "NextButtonActionCommand";
    public static final String BACK_BUTTON_ACTION_COMMAND = "BackButtonActionCommand";
    public static final String CANCEL_BUTTON_ACTION_COMMAND = "CancelButtonActionCommand";
    static String BACK_TEXT;
    static String NEXT_TEXT;
    static String FINISH_TEXT;
    static String CANCEL_TEXT;
    static Icon BACK_ICON;
    static Icon NEXT_ICON;
    static Icon FINISH_ICON;
    static Icon CANCEL_ICON;
    private WizardModel wizardModel;
    private WizardController wizardController;
    private JFrame wizardFrame;
    private JPanel cardPanel;
    private CardLayout cardLayout;
    private JButton backButton;
    private JButton nextButton;
    private JButton cancelButton;
    private int returnCode;
    private static final String OPEN;
    private static final String SAVE;
    private static final String SAVE_AS;
    private static final String PROJECTION_OPTIONS;
    private static final String EXIT;
    private String mConfigFileName = SchemaBuilder.CONFIG_FILE_NAME;
    private PersisterProperties mPersisterProperties;
    private static Wizard mWizard;
    private SchemaBuilderWizard mSchemaBuilderWizard;
    private Object mCurrentId;
    private ProjectionPanel jProjectionPanel;
    private JDialog jProjectionDialog;

    public String getConfigFileName() {
        return this.mConfigFileName;
    }

    public Wizard() {
        this.wizardModel = new WizardModel();
        this.wizardFrame = new JFrame();
        this.initComponents();
    }

    public static Wizard getWizard() {
        if (mWizard == null) {
            mWizard = new Wizard();
        }
        return mWizard;
    }

    public void setPersisterProperties(PersisterProperties persisterProperties) {
        this.mPersisterProperties = persisterProperties;
    }

    public void setRunPersisterWizard(SchemaBuilderWizard schemaBuilderWizard) {
        this.mSchemaBuilderWizard = schemaBuilderWizard;
    }

    public JFrame getFrame() {
        return this.wizardFrame;
    }

    public Component getOwner() {
        return this.wizardFrame.getOwner();
    }

    public void setTitle(String string) {
        this.wizardFrame.setTitle(string);
    }

    public String getTitle() {
        return this.wizardFrame.getTitle();
    }

    public int showFrame() {
        this.wizardFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                Wizard.this.returnCode = 1;
                System.exit(0);
            }
        });
        this.wizardFrame.pack();
        this.wizardFrame.setVisible(true);
        return this.returnCode;
    }

    public void repack() {
        this.wizardFrame.pack();
    }

    public WizardModel getModel() {
        return this.wizardModel;
    }

    public void registerWizardPanel(Object object, WizardPanelDescriptor wizardPanelDescriptor) {
        this.cardPanel.add(wizardPanelDescriptor.getPanelComponent(), object);
        wizardPanelDescriptor.setWizard(this);
        wizardPanelDescriptor.showComponent((WizardPanel)wizardPanelDescriptor.getPanelComponent());
        this.wizardModel.registerPanel(object, wizardPanelDescriptor);
        if (object == "ADVANCED_OPTIONS_PANEL") {
            this.jProjectionPanel = (ProjectionPanel)wizardPanelDescriptor.getPanelComponent();
            this.jProjectionDialog = new JDialog(this.getFrame(), "Projection Options", false);
            this.jProjectionDialog.getContentPane().setLayout(new BorderLayout());
            this.jProjectionDialog.getContentPane().add(this.jProjectionPanel.getJContentPane());
            this.jProjectionPanel.setDialogParent(this.jProjectionDialog);
            this.jProjectionDialog.pack();
            this.jProjectionDialog.setVisible(false);
        }
    }

    public void setCurrentPanel(Object object) {
        WizardPanelDescriptor wizardPanelDescriptor;
        this.mCurrentId = object;
        if (object == null) {
            this.close(2);
        }
        if ((wizardPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor()) != null && !wizardPanelDescriptor.getId().equals(this.mCurrentId)) {
            wizardPanelDescriptor.aboutToHidePanel();
        }
        this.wizardModel.setCurrentPanel(object);
        this.wizardModel.getCurrentPanelDescriptor().aboutToDisplayPanel();
        this.cardLayout.show(this.cardPanel, object.toString());
        this.wizardModel.getCurrentPanelDescriptor().displayingPanel();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("currentPanelDescriptorProperty")) {
            this.wizardController.resetButtonsToPanelRules();
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonTextProperty")) {
            this.nextButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonTextProperty")) {
            this.backButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonTextProperty")) {
            this.cancelButton.setText(propertyChangeEvent.getNewValue().toString());
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonEnabledProperty")) {
            this.nextButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonEnabledProperty")) {
            this.backButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonEnabledProperty")) {
            this.cancelButton.setEnabled((Boolean)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("nextButtonIconProperty")) {
            this.nextButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("backButtonIconProperty")) {
            this.backButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        } else if (propertyChangeEvent.getPropertyName().equals("cancelButtonIconProperty")) {
            this.cancelButton.setIcon((Icon)propertyChangeEvent.getNewValue());
        }
    }

    public int getReturnCode() {
        return this.returnCode;
    }

    public boolean getBackButtonEnabled() {
        return this.wizardModel.getBackButtonEnabled();
    }

    public void setBackButtonEnabled(boolean bl) {
        this.wizardModel.setBackButtonEnabled(new Boolean(bl));
    }

    public boolean getNextFinishButtonEnabled() {
        return this.wizardModel.getNextFinishButtonEnabled();
    }

    public void setNextFinishButtonEnabled(boolean bl) {
        this.wizardModel.setNextFinishButtonEnabled(new Boolean(bl));
    }

    public boolean getCancelButtonEnabled() {
        return this.wizardModel.getCancelButtonEnabled();
    }

    public void setCancelButtonEnabled(boolean bl) {
        this.wizardModel.setCancelButtonEnabled(new Boolean(bl));
    }

    void close(int n) {
        this.returnCode = n;
        WizardPanelDescriptor wizardPanelDescriptor = this.wizardModel.getCurrentPanelDescriptor();
        if (wizardPanelDescriptor != null) {
            wizardPanelDescriptor.aboutToCloseWizard();
        }
        this.wizardFrame.dispose();
        this.jProjectionDialog.dispose();
    }

    private void initComponents() {
        this.wizardModel.addPropertyChangeListener(this);
        this.wizardController = new WizardController(this);
        this.wizardFrame.getContentPane().setLayout(new BorderLayout());
        this.wizardFrame.addWindowListener(this);
        JMenuBar jMenuBar = new JMenuBar();
        jMenuBar.setBackground(RunPersisterWizardPanel.ROCKET_BLUE);
        JMenu jMenu = new JMenu("File");
        jMenu.setMnemonic(70);
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem(OPEN, 79);
        jMenu.add(jMenuItem);
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(Wizard.this.mConfigFileName);
                String string = file.getParent();
                if (string == null) {
                    string = ".";
                }
                File file2 = new File(string);
                JFileChooser jFileChooser = new JFileChooser(file2);
                jFileChooser.addChoosableFileFilter(new ExtensionFileFilter("properties", "properties"));
                jFileChooser.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = (JFileChooser)actionEvent.getSource();
                        String string = actionEvent.getActionCommand();
                        if (string.equals("ApproveSelection")) {
                            Wizard.this.mConfigFileName = jFileChooser.getSelectedFile().toString();
                            SchemaBuilderWizard.setFromConfigPropertiesFile(Wizard.this.mSchemaBuilderWizard.getConfigProperties(), Wizard.this.mConfigFileName);
                            Wizard.this.mPersisterProperties.setRunTimeSwitches(Wizard.this.mSchemaBuilderWizard.getConfigProperties());
                            Wizard.this.registerAll(Wizard.this.mSchemaBuilderWizard);
                            Wizard.this.mCurrentId = "LOGIN_PANEL";
                            Wizard.this.setCurrentPanel(Wizard.this.mCurrentId);
                        }
                    }
                });
                jFileChooser.showOpenDialog(null);
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(SAVE, 83);
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.wizardModel.getCurrentPanelDescriptor().updatePersisterProperties();
                Wizard.this.mSchemaBuilderWizard.writePropertiesToConfigFile();
            }
        });
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem(SAVE_AS);
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(Wizard.this.mConfigFileName);
                String string = file.getParent();
                if (string == null) {
                    string = ".";
                }
                File file2 = new File(string);
                JFileChooser jFileChooser = new JFileChooser(file2);
                jFileChooser.addChoosableFileFilter(new ExtensionFileFilter("properties", "properties"));
                jFileChooser.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        JFileChooser jFileChooser = (JFileChooser)actionEvent.getSource();
                        String string = actionEvent.getActionCommand();
                        if (string.equals("ApproveSelection")) {
                            Wizard.this.mConfigFileName = jFileChooser.getSelectedFile().toString();
                            boolean bl = Wizard.this.mConfigFileName.endsWith(".properties");
                            if (!bl) {
                                Wizard.this.mConfigFileName = Wizard.this.mConfigFileName + ".properties";
                            }
                            Wizard.this.mSchemaBuilderWizard.writePropertiesToConfigFile();
                        }
                    }
                });
                jFileChooser.showSaveDialog(null);
            }
        });
        jMenu.add(jMenuItem3);
        jMenu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(PROJECTION_OPTIONS);
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.jProjectionDialog.setVisible(true);
            }
        });
        jMenu.add(jMenuItem4);
        jMenu.addSeparator();
        JMenuItem jMenuItem5 = new JMenuItem(EXIT, 88);
        jMenuItem5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Wizard.this.close(1);
                System.exit(0);
            }
        });
        jMenu.add(jMenuItem5);
        this.wizardFrame.setJMenuBar(jMenuBar);
        JPanel jPanel = new JPanel();
        JSeparator jSeparator = new JSeparator();
        Box box = new Box(0);
        this.cardPanel = new JPanel();
        this.cardLayout = new CardLayout();
        this.cardPanel.setLayout(this.cardLayout);
        this.backButton = new JButton(new ImageIcon("com/intersys/jalapeno/tools/objects/gui/wizard/backIcon.gif"));
        this.nextButton = new JButton();
        this.cancelButton = new JButton();
        this.backButton.setActionCommand(BACK_BUTTON_ACTION_COMMAND);
        this.nextButton.setActionCommand(NEXT_BUTTON_ACTION_COMMAND);
        this.cancelButton.setActionCommand(CANCEL_BUTTON_ACTION_COMMAND);
        this.backButton.addActionListener(this.wizardController);
        this.nextButton.addActionListener(this.wizardController);
        this.cancelButton.addActionListener(this.wizardController);
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jSeparator, "North");
        box.setBorder(new EmptyBorder(new Insets(5, 10, 5, 10)));
        box.add(this.backButton);
        box.add(Box.createHorizontalStrut(10));
        box.add(this.nextButton);
        box.add(Box.createHorizontalStrut(30));
        box.add(this.cancelButton);
        jPanel.add((Component)box, "East");
        this.wizardFrame.getContentPane().add((Component)jPanel, "South");
        this.wizardFrame.getContentPane().add((Component)this.cardPanel, "Center");
    }

    private static Object getImage(String string) {
        URL uRL = null;
        try {
            Class<?> clazz = Class.forName("com.jalapeno.tools.objects.gui.wizard.Wizard");
            uRL = clazz.getResource(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("Unable to find Wizard class");
        }
        return uRL;
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.returnCode = 1;
    }

    public void registerAll(SchemaBuilderWizard schemaBuilderWizard) {
        LoginPanelDescriptor loginPanelDescriptor = new LoginPanelDescriptor(schemaBuilderWizard);
        mWizard.registerWizardPanel("LOGIN_PANEL", loginPanelDescriptor);
        OptionsStandardPanelDescriptor optionsStandardPanelDescriptor = new OptionsStandardPanelDescriptor(schemaBuilderWizard);
        mWizard.registerWizardPanel("STANDARD_OPTIONS_PANEL", optionsStandardPanelDescriptor);
        ProjectionDescriptor projectionDescriptor = new ProjectionDescriptor(schemaBuilderWizard);
        mWizard.registerWizardPanel("ADVANCED_OPTIONS_PANEL", projectionDescriptor);
        WhatToSelectPanelDescriptor whatToSelectPanelDescriptor = new WhatToSelectPanelDescriptor(schemaBuilderWizard);
        mWizard.registerWizardPanel("WHAT_TO_SELECT_PANEL", whatToSelectPanelDescriptor);
        SelectAndGenJarsOrZipsPanelDescriptor selectAndGenJarsOrZipsPanelDescriptor = new SelectAndGenJarsOrZipsPanelDescriptor(schemaBuilderWizard);
        mWizard.registerWizardPanel("GENERATE_JARS_OR_ZIPS_PANEL", selectAndGenJarsOrZipsPanelDescriptor);
        SelectClassPathPanelDescriptor selectClassPathPanelDescriptor = new SelectClassPathPanelDescriptor(schemaBuilderWizard);
        mWizard.registerWizardPanel("SELECT_CLASSPATH_PANEL", selectClassPathPanelDescriptor);
        SelectAndGenClassesOrDirsPanelDescriptor selectAndGenClassesOrDirsPanelDescriptor = new SelectAndGenClassesOrDirsPanelDescriptor(schemaBuilderWizard);
        mWizard.registerWizardPanel("GENERATE_CLASSES_PANEL", selectAndGenClassesOrDirsPanelDescriptor);
    }

    static {
        OPEN = Messages.getString("Menu.OPEN");
        SAVE = Messages.getString("Menu.SAVE");
        SAVE_AS = Messages.getString("Menu.SAVE_AS");
        PROJECTION_OPTIONS = Messages.getString("Menu.PROJECTION_OPTIONS");
        EXIT = Messages.getString("Menu.EXIT");
        try {
            PropertyResourceBundle propertyResourceBundle = (PropertyResourceBundle)ResourceBundle.getBundle("com.jalapeno.tools.objects.gui.wizard.wizard");
            BACK_TEXT = (String)propertyResourceBundle.getObject("backButtonText");
            NEXT_TEXT = (String)propertyResourceBundle.getObject("nextButtonText");
            CANCEL_TEXT = (String)propertyResourceBundle.getObject("cancelButtonText");
            FINISH_TEXT = (String)propertyResourceBundle.getObject("finishButtonText");
            BACK_ICON = new ImageIcon((URL)Wizard.getImage((String)propertyResourceBundle.getObject("backButtonIcon")));
            NEXT_ICON = new ImageIcon((URL)Wizard.getImage((String)propertyResourceBundle.getObject("nextButtonIcon")));
            CANCEL_ICON = new ImageIcon((URL)Wizard.getImage((String)propertyResourceBundle.getObject("cancelButtonIcon")));
            FINISH_ICON = new ImageIcon((URL)Wizard.getImage((String)propertyResourceBundle.getObject("finishButtonIcon")));
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException);
            System.exit(1);
        }
    }
}

