/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.db2.app;

import COM.ibm.db2.app.DB2Struct;
import COM.ibm.db2.app.DB2StructConstant;
import COM.ibm.db2.app.DereferencedNativeArray;
import COM.ibm.db2.app.NativeArray;
import COM.ibm.db2.app.TypeMapTableElement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;

public class DB2StructInput
extends DB2Struct
implements SQLInput {
    public boolean currAttrIsNull;
    public boolean prevAttrWasNull;

    public DB2StructInput(DereferencedNativeArray dereferencedNativeArray, HashMap hashMap, int n2, ClassLoader classLoader) throws SQLException {
        super(dereferencedNativeArray, hashMap, n2, classLoader);
        this.numAttr = dereferencedNativeArray.getShort(n2 + 6);
        this.typeTag = dereferencedNativeArray.getInt(n2 + 12);
        this.totalLength = dereferencedNativeArray.getInt(n2 + 8);
        DB2StructConstant.print("numAttr = " + this.numAttr);
        DB2StructConstant.print("typeTag = " + this.typeTag);
        DB2StructConstant.print("totalLength = " + this.totalLength);
        this.nextAttr();
    }

    public DB2StructInput() {
    }

    public void reset(DereferencedNativeArray dereferencedNativeArray, HashMap hashMap, int n2) throws SQLException {
        super.reset(dereferencedNativeArray, hashMap, n2);
        this.numAttr = dereferencedNativeArray.getShort(n2 + 6);
        this.typeTag = dereferencedNativeArray.getInt(n2 + 12);
        this.totalLength = dereferencedNativeArray.getInt(n2 + 8);
        DB2StructConstant.print("numAttr = " + this.numAttr);
        DB2StructConstant.print("typeTag = " + this.typeTag);
        DB2StructConstant.print("totalLength = " + this.totalLength);
        this.nextAttr();
    }

    public void reset() throws SQLException {
        super.reset();
        this.numAttr = this.nativeStructTypeBuff.getShort(this.indexof_currStructTypeFrame + 6);
        this.typeTag = this.nativeStructTypeBuff.getInt(this.indexof_currStructTypeFrame + 12);
        this.totalLength = this.nativeStructTypeBuff.getInt(this.indexof_currStructTypeFrame + 8);
        DB2StructConstant.print("numAttr = " + this.numAttr);
        DB2StructConstant.print("typeTag = " + this.typeTag);
        DB2StructConstant.print("totalLength = " + this.totalLength);
        this.nextAttr();
    }

    public void nextAttr() throws SQLException {
        super.nextAttr();
        this.currAttrType = this.nativeStructTypeBuff.getShort(this.indexof_currStructTypeFrame + this.indexof_metaFlag);
        DB2StructConstant.print("indexof_metaFlag  = " + this.indexof_metaFlag);
        DB2StructConstant.print("indexof_currStructTypeFrame = " + this.indexof_currStructTypeFrame);
        DB2StructConstant.print("currAttrType = " + this.currAttrType);
        this.prevAttrWasNull = this.currAttrIsNull;
        this.currAttrIsNull = (this.currAttrType & 0x40) != 0;
    }

    public static HashMap loadTypeMap(NativeArray nativeArray) throws SQLException {
        return DB2Struct.loadTypeMap(nativeArray, true);
    }

    public String readString() throws SQLException {
        DB2StructConstant.print("Beginning readString");
        if (this.currAttrType != 1536) {
            DB2Struct.error("Current Attribute is not of type String !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        String string = this.nativeStructTypeBuff.getDereferencedString(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (string == null) {
            DB2Struct.error("Null string object returned");
        }
        this.nextAttr();
        DB2StructConstant.print("Ending readString");
        return string;
    }

    public boolean readBoolean() throws SQLException {
        DB2Struct.error("DB2 does not currently support boolean data types");
        return false;
    }

    public URL readURL() throws SQLException {
        DB2Struct.error("DB2 does not currently support DATALINK data types");
        return null;
    }

    public byte readByte() throws SQLException {
        DB2Struct.error("DB2 does not currently support byte data types");
        return 0;
    }

    public short readShort() throws SQLException {
        DB2StructConstant.print("Beginning readShort");
        if (this.currAttrType != 8192) {
            DB2Struct.error("Current Attribute is not of type Short Integer !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0;
        }
        short s2 = this.nativeStructTypeBuff.getShort(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("Ending readShort");
        return s2;
    }

    public int readInt() throws SQLException {
        DB2StructConstant.print("Beginning readInt");
        if (this.currAttrType != 8448) {
            DB2Struct.error("Current Attribute is not of type Integer !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0;
        }
        int n2 = this.nativeStructTypeBuff.getInt(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("Ending readInt");
        return n2;
    }

    public long readLong() throws SQLException {
        DB2StructConstant.print("Beginning readLong");
        if (this.currAttrType != 8704) {
            DB2Struct.error("Current Attribute is not of type Long Integer !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0L;
        }
        long l2 = this.nativeStructTypeBuff.getLong(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("ENDING getLong");
        return l2;
    }

    public float readFloat() throws SQLException {
        DB2StructConstant.print("Beginning ReadFloat");
        if (this.currAttrType != 8960) {
            DB2Struct.error("Current Attribute is not of type float !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0.0f;
        }
        float f2 = this.nativeStructTypeBuff.getFloat(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("Ending ReadFloat");
        return f2;
    }

    public double readDouble() throws SQLException {
        DB2StructConstant.print("Beginning ReadFloat");
        if (this.currAttrType != 9216) {
            DB2Struct.error("Current Attribute is not of type double !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return 0.0;
        }
        double d2 = this.nativeStructTypeBuff.getLong(this.indexof_currStructTypeFrame + this.indexof_srp);
        this.nextAttr();
        DB2StructConstant.print("Ending ReadFloat");
        return d2;
    }

    public BigDecimal readBigDecimal() throws SQLException {
        if (this.currAttrType != 0) {
            DB2Struct.error("Current Attribute is not of type decimal !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        BigDecimal bigDecimal = this.nativeStructTypeBuff.getDereferencedBigDecimal(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (bigDecimal == null) {
            DB2Struct.error("Null BigDecimal Object Returned");
        }
        this.nextAttr();
        return bigDecimal;
    }

    public byte[] readBytes() throws SQLException {
        DB2Struct.error("DB2 does not currently support byte array data types");
        return null;
    }

    public Date readDate() throws SQLException {
        if (this.currAttrType != 9728) {
            DB2Struct.error("Current Attribute is not of type decimal !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Date date = this.nativeStructTypeBuff.getDate(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (date == null) {
            DB2Struct.error("Null Date Object Returned");
        }
        this.nextAttr();
        return date;
    }

    public Time readTime() throws SQLException {
        DB2StructConstant.print("Beginning readTime");
        if (this.currAttrType != 9984) {
            DB2Struct.error("Current Attribute is not of type time !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Time time = this.nativeStructTypeBuff.getTime(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (time == null) {
            DB2Struct.error("Null Time Object returned");
        }
        this.nextAttr();
        DB2StructConstant.print("Ending readTime");
        return time;
    }

    public Timestamp readTimestamp() throws SQLException {
        if (this.currAttrType != 768) {
            DB2Struct.error("Current Attribute is not of type timestamp !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Timestamp timestamp = this.nativeStructTypeBuff.getDereferencedTimestamp(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (timestamp == null) {
            DB2Struct.error("Null Timestamp object Returned");
        }
        this.nextAttr();
        return timestamp;
    }

    public Reader readCharacterStream() throws SQLException {
        DB2Struct.error("DB2 does not currently support character streams");
        return null;
    }

    public InputStream readAsciiStream() throws SQLException {
        DB2Struct.error("DB2 does not currently support ascii streams");
        return null;
    }

    public InputStream readBinaryStream() throws SQLException {
        DB2Struct.error("DB2 does not currently support binary streams");
        return null;
    }

    public Object readObject() throws SQLException {
        DB2StructConstant.print("Beginning ReadObject");
        DB2StructConstant.print("Going to typeMapTable.get...");
        TypeMapTableElement typeMapTableElement = (TypeMapTableElement)this.typeMapTable.get(new Integer(this.typeTag));
        if (typeMapTableElement == null) {
            DB2Struct.error("Invalid typetag" + this.typeTag);
        }
        DB2StructConstant.print("Survived typeMapTable.get...");
        if (typeMapTableElement.classRef == null) {
            try {
                typeMapTableElement.classRef = this.classLoader.loadClass(typeMapTableElement.className);
                this.typeMapTable.put(new Integer(this.typeTag), typeMapTableElement);
            }
            catch (ClassNotFoundException classNotFoundException) {
                DB2StructConstant.print("Failed classloader!!!");
            }
            DB2StructConstant.print("Passed classloader!!!");
        }
        SQLData sQLData = null;
        if (!this.isStructTypeHeaderProcessed) {
            this.isStructTypeHeaderProcessed = true;
            try {
                sQLData = (SQLData)typeMapTableElement.classRef.newInstance();
            }
            catch (Exception exception) {
                DB2StructConstant.print("Exception calling classRef.newInstance!!!");
                DB2Struct.error(exception.toString());
            }
            DB2StructConstant.print("Survived created java object instance...");
            sQLData.readSQL(this, typeMapTableElement.className);
        } else {
            if (this.currAttrType != 4096) {
                DB2Struct.error("Current Attribute is not of type structured type !!");
            }
            if (this.currAttrIsNull) {
                this.nextAttr();
                return null;
            }
            long l2 = this.nativeStructTypeBuff.getLong(this.indexof_currStructTypeFrame + this.indexof_srp);
            DB2StructInput dB2StructInput = new DB2StructInput(this.nativeStructTypeBuff, this.typeMapTable, this.indexof_currStructTypeFrame + (int)l2, this.classLoader);
            sQLData = (SQLData)dB2StructInput.readObject();
        }
        super.nextAttr();
        DB2StructConstant.print("Ending readObject");
        return sQLData;
    }

    public Ref readRef() throws SQLException {
        if (this.currAttrType != 32) {
            DB2Struct.error("Current Attribute is not of type reference type !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Ref ref = this.nativeStructTypeBuff.getDereferencedRef(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (ref == null) {
            DB2Struct.error("Null Ref Object Returned");
        }
        this.nextAttr();
        return ref;
    }

    public Blob readBlob() throws SQLException {
        if (this.currAttrType != 12544) {
            DB2Struct.error("Current Attribute is not of type structured type !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Blob blob = this.nativeStructTypeBuff.getDereferencedBlob(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (blob == null) {
            DB2Struct.error("Null Blob Object Returned");
        }
        this.nextAttr();
        return blob;
    }

    public Clob readClob() throws SQLException {
        if (this.currAttrType != 12288) {
            DB2Struct.error("Current Attribute is not of type structured type !!");
        }
        if (this.currAttrIsNull) {
            this.nextAttr();
            return null;
        }
        Clob clob = this.nativeStructTypeBuff.getDereferencedClob(this.indexof_currStructTypeFrame + this.indexof_srp);
        if (clob == null) {
            DB2Struct.error("Null Clob object returned");
        }
        this.nextAttr();
        return clob;
    }

    public Array readArray() throws SQLException {
        DB2Struct.error("DB2 does not support Array data types");
        return null;
    }

    public boolean wasNull() throws SQLException {
        return this.prevAttrWasNull;
    }
}

