/*
 * Decompiled with CFR 0.152.
 */
package org.postgresql.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.SQLException;
import org.postgresql.util.GT;
import org.postgresql.util.PSQLState;
import org.postgresql.util.ServerErrorMessage;

public class PSQLException
extends SQLException {
    private ServerErrorMessage _serverError;

    public PSQLException(String msg, PSQLState state, Throwable cause) {
        super(PSQLException.addCauseToMessage(msg, cause), state == null ? null : state.getState());
        this.initCause(cause);
    }

    public PSQLException(String msg, PSQLState state) {
        this(msg, state, null);
    }

    public PSQLException(ServerErrorMessage serverError) {
        this(serverError.toString(), new PSQLState(serverError.getSQLState()));
        this._serverError = serverError;
    }

    public ServerErrorMessage getServerErrorMessage() {
        return this._serverError;
    }

    private static String addCauseToMessage(String msg, Throwable cause) {
        block2: {
            boolean hasInitCause = true;
            if (hasInitCause || cause == null) break block2;
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                PrintWriter pw = new PrintWriter(baos);
                pw.println();
                pw.println(GT.tr("Exception: {0}", cause.toString()));
                pw.println(GT.tr("Stack Trace:"));
                cause.printStackTrace(pw);
                pw.println(GT.tr("End of Stack Trace"));
                pw.flush();
                msg = msg + baos.toString();
                pw.close();
                baos.close();
            }
            catch (IOException ioe) {
                msg = msg + GT.tr("Exception generating stacktrace for: {0} encountered: {1}", new Object[]{cause.toString(), ioe.toString()});
            }
        }
        return msg;
    }
}

