/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.quick;

import com.intersys.cache.SysDatabase;
import com.intersys.cache.jdbcutil.SQLReservedWords;
import com.intersys.cache.metadata.AbstractCacheClass;
import com.intersys.cache.quick.ChildTableField;
import com.intersys.cache.quick.ColumnBasedField;
import com.intersys.cache.quick.ColumnOnlyField;
import com.intersys.cache.quick.FieldForEmeddedObj;
import com.intersys.cache.quick.LightDatabase;
import com.intersys.cache.quick.QuickCacheField;
import com.intersys.cache.quick.SimpleField;
import com.intersys.cache.quick.TableBasedClass;
import com.intersys.classes.Compiler.LG.JavaClassDef;
import com.intersys.classes.Compiler.LG.JavaMethodDef;
import com.intersys.classes.Compiler.LG.JavaMtdArgDef;
import com.intersys.classes.Compiler.LG.JavaPropDef;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheArgument;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassMetadata;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheMethod;
import com.intersys.objects.reflect.CacheModifier;
import com.intersys.objects.reflect.CacheSerialStorageMetadata;
import com.intersys.objects.reflect.SQLColumn;
import com.intersys.objects.reflect.TableMetadata;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class QuickCacheClassNew
extends AbstractCacheClass
implements TableBasedClass {
    private ColumnBasedField[] mFieldsByIndex;
    private ColumnBasedField[] mColumns;
    private List mSQLRepresentedFields;
    private ColumnBasedField[] mSerialFields;
    private Map mFieldsByName;
    private Map mSerialElementsByName;
    private LightDatabase mDB;
    private String mColumnsSQL = null;
    private ColumnBasedField mIdField = null;
    private TableMetadata mTable;
    private int mNumberOfCachedElements;
    private boolean mFixChildTablesFromSuper = false;

    public QuickCacheClassNew(LightDatabase lightDatabase, JavaClassDef javaClassDef) throws CacheException {
        super(javaClassDef);
        this.init(lightDatabase);
    }

    public QuickCacheClassNew(QuickCacheClassNew quickCacheClassNew) throws CacheException {
        super(quickCacheClassNew);
    }

    public QuickCacheClassNew(LightDatabase lightDatabase, String string, boolean bl, boolean bl2) throws CacheException {
        super((Database)lightDatabase.getReadOnlyDatabase(), string, bl, bl2);
        this.init(lightDatabase);
    }

    protected void initChild(LightDatabase lightDatabase) throws CacheException {
        this.mDB = lightDatabase;
        if (this.isSerial()) {
            this.preSetupSerialFields();
        }
        this.initTableMetaData();
        this.makeFieldsByIndex();
        this.setupSerialFields();
    }

    private void initTableMetaData() throws CacheException {
        this.setupColumns();
        this.setupChildTables();
        this.mTable = this.getSQLTableMetadata();
        SQLColumn sQLColumn = this.mTable.getRowIdColumn();
        this.mIdField = this.fieldByColumn(sQLColumn);
    }

    private void init(LightDatabase lightDatabase) throws CacheException {
        this.mDB = lightDatabase;
        lightDatabase.registerClass(this);
        if (this.getSQLTableName() != null) {
            lightDatabase.mTableToClassMap.put(this.getFullSQLTableName(), this);
        }
        if (this.isPersistent() && !"%Library.Persistent".equals(this.getName())) {
            this.initTableMetaData();
        }
        if (this.isSerial()) {
            this.preSetupSerialFields();
            this.setupSerialFields();
        }
        if (!this.isDatatype() && !this.isCollection()) {
            this.makeFieldsByIndex();
        }
    }

    private void makeFieldsByIndex() throws CacheException {
        List list = this.getAllFieldsAsList();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            int n2 = ((CacheField)iterator.next()).getII();
            if (n2 <= n) continue;
            n = n2;
        }
        this.mFieldsByIndex = new ColumnBasedField[n + 1];
        for (ColumnBasedField columnBasedField : list) {
            int n3 = columnBasedField.getII();
            if (n3 < 0) continue;
            this.mFieldsByIndex[n3] = columnBasedField;
        }
    }

    private ColumnBasedField fieldByColumn(SQLColumn sQLColumn) throws CacheException {
        int n = sQLColumn.getNumber();
        int n2 = 1;
        if (this.isChild()) {
            --n2;
        }
        if (this.mColumns[n -= n2] != null) {
            return this.mColumns[n];
        }
        String string = sQLColumn.getFieldName();
        if (sQLColumn.isFromEmbeddedObject()) {
            CacheClass cacheClass = sQLColumn.getContainingClass();
            CacheField cacheField = cacheClass.getField(string);
            if (cacheField == null) {
                return new ColumnOnlyField(this.mDB, sQLColumn, n2);
            }
            CacheField cacheField2 = ((QuickCacheField)cacheField).cloneForColumn(sQLColumn, this);
            SQLColumn sQLColumn2 = sQLColumn.getContainingColumn();
            FieldForEmeddedObj fieldForEmeddedObj = (FieldForEmeddedObj)this.fieldByColumn(sQLColumn2);
            fieldForEmeddedObj.addChild((QuickCacheField)cacheField2);
            return (ColumnBasedField)cacheField2;
        }
        if (sQLColumn.isXClassName()) {
            return new ColumnOnlyField(this.mDB, sQLColumn, n2);
        }
        if (sQLColumn.isRowIdColumn()) {
            return new ColumnOnlyField(this.mDB, sQLColumn, n2);
        }
        CacheField cacheField = this.getField(string);
        if (cacheField == null) {
            return new ColumnOnlyField(this.mDB, sQLColumn, n2);
        }
        SQLColumn sQLColumn3 = cacheField.getSQLColumn();
        if (!sQLColumn.equals(sQLColumn3)) {
            cacheField = ((QuickCacheField)cacheField).cloneForColumn(sQLColumn, this);
        }
        return (ColumnBasedField)cacheField;
    }

    private void preSetupSerialFields() {
        CacheSerialStorageMetadata.SerialStorageElement[] serialStorageElementArray = this.getSerialStateInfo().getStorageElements();
        if (serialStorageElementArray == null) {
            return;
        }
        this.mSerialElementsByName = new HashMap();
        for (int i = 0; i < serialStorageElementArray.length; ++i) {
            this.mSerialElementsByName.put(serialStorageElementArray[i].getFieldName(), serialStorageElementArray[i]);
        }
    }

    private void setupSerialFields() throws CacheException {
        CacheSerialStorageMetadata.SerialStorageElement[] serialStorageElementArray = this.getSerialStateInfo().getStorageElements();
        if (serialStorageElementArray == null) {
            return;
        }
        this.mSerialFields = new ColumnBasedField[serialStorageElementArray.length];
        for (int i = 0; i < this.mSerialFields.length; ++i) {
            this.mSerialFields[i] = (ColumnBasedField)this.getField(serialStorageElementArray[i].getFieldName());
        }
        this.mSerialElementsByName.clear();
        this.mSerialElementsByName = null;
    }

    protected CacheSerialStorageMetadata.SerialStorageElement getSerialElementByName(String string) {
        if (this.mSerialElementsByName == null) {
            return null;
        }
        return (CacheSerialStorageMetadata.SerialStorageElement)this.mSerialElementsByName.get(string);
    }

    private void setupChildTables() throws CacheException {
        this.mSQLRepresentedFields = new ArrayList<ColumnBasedField>(Arrays.asList(this.mColumns));
        for (ColumnBasedField columnBasedField : this.getAllFieldsAsList()) {
            if (!columnBasedField.isChildTable()) continue;
            this.mSQLRepresentedFields.add(columnBasedField);
        }
    }

    private void setupColumns() throws CacheException {
        this.mColumnsSQL = null;
        String string = this.getFullSQLTableNameQuoted();
        SQLColumn[] sQLColumnArray = this.getSQLTableMetadata().getColumns();
        this.mColumns = new ColumnBasedField[sQLColumnArray.length];
        this.mNumberOfCachedElements = this.mColumns.length;
        this.mFieldsByName = new HashMap(this.mColumns.length);
        for (int i = 0; i < sQLColumnArray.length; ++i) {
            String string2 = sQLColumnArray[i].getName();
            String string3 = SQLReservedWords.isReserved(string2) ? string + '.' + "\"" + string2 + "\"" : string + '.' + string2;
            this.mColumnsSQL = this.mColumnsSQL == null ? string3 : this.mColumnsSQL + "," + string3;
            this.mColumns[i] = this.fieldByColumn(sQLColumnArray[i]);
            this.mFieldsByName.put(this.mColumns[i].getName(), new Integer(i));
        }
        this.mFields = null;
        this.mFixChildTablesFromSuper = true;
        this.checkFields();
    }

    public String getFullSQLTableNameQuoted() {
        String string;
        String string2 = this.getSchemaName();
        if (SQLReservedWords.isReserved(string2)) {
            string2 = "\"" + string2 + "\"";
        }
        if (SQLReservedWords.isReserved(string = this.getSQLTableName())) {
            string = "\"" + string + "\"";
        }
        return string2 + "." + string;
    }

    public int getNumberOfCachedElements() {
        return this.mNumberOfCachedElements;
    }

    public int getNumberOfSerialElements() {
        if (this.mSerialFields != null) {
            return this.mSerialFields.length;
        }
        return 0;
    }

    public int getKeyColumn() throws CacheException {
        throw new SystemError("Method getKeyColumn() should never be called in class com.intersys.cache.quick.QuickCacheClassNew");
    }

    public int getNumberOfColumnsForGet() {
        return this.mColumns.length;
    }

    public int getNumberOfColumnsForSet() {
        return this.mColumns.length;
    }

    public String getColumnsSQL() {
        return this.mColumnsSQL;
    }

    public void close() {
        this.mDeclaredFields = null;
        this.mFields = null;
        this.mDB.removeClassFromMap(this.getName());
    }

    public ColumnBasedField getField(String string, int n, int n2) throws CacheException {
        if (n < 0 || n > this.mFieldsByIndex.length) {
            return (QuickCacheField)this.getField(string);
        }
        ColumnBasedField columnBasedField = this.mFieldsByIndex[n];
        if (columnBasedField == null) {
            return (QuickCacheField)this.getField(string);
        }
        return columnBasedField;
    }

    public ColumnBasedField getColumnBasedField(String string) throws CacheException {
        TableMetadata tableMetadata = this.getSQLTableMetadata();
        if (tableMetadata != null) {
            SQLColumn sQLColumn = tableMetadata.getColumn(string);
            return this.fieldByColumn(sQLColumn);
        }
        return null;
    }

    public ColumnBasedField getIdField() {
        return this.mIdField;
    }

    public boolean hasSerialStorage() {
        return this.isSerial();
    }

    public int getXClassNameColumn() throws CacheException {
        int n = this.mTable.getXClassNameColumnNumber();
        if (this.isChild()) {
            ++n;
        }
        return n;
    }

    public void setupEmbeddedField(ColumnBasedField columnBasedField) throws CacheException {
        throw new SystemError("Method setupEmbeddedField() should never be called in class com.intersys.cache.quick.QuickCacheClassNew");
    }

    protected boolean isCalculatedPropertyGetter(String string) throws CacheException {
        if (!string.endsWith("Get")) {
            return false;
        }
        String string2 = string.substring(0, string.length() - 3);
        CacheField cacheField = this.getField(string2);
        if (cacheField == null) {
            return false;
        }
        return CacheModifier.isReadOnly(cacheField.getModifiers());
    }

    public Iterator getAllSettableFieldsIterator() {
        if (this.isPersistent()) {
            return this.mSQLRepresentedFields.iterator();
        }
        if (this.mSerialFields != null) {
            return Arrays.asList(this.mSerialFields).iterator();
        }
        return null;
    }

    protected List getAllFieldsAsList() throws CacheException {
        return Arrays.asList(this.getFields());
    }

    protected CacheField validateFieldFromSuper(CacheField cacheField) throws CacheException {
        Object object;
        Integer n;
        if (this.mFieldsByName != null && (n = (Integer)this.mFieldsByName.get(object = cacheField.getName())) != null) {
            return this.mColumns[n];
        }
        if (this.mSerialElementsByName != null) {
            object = (CacheSerialStorageMetadata.SerialStorageElement)this.mSerialElementsByName.get(cacheField.getName());
            if (object != null) {
                cacheField = ((QuickCacheField)cacheField).cloneForSerialElement((CacheSerialStorageMetadata.SerialStorageElement)object, this);
            }
        } else if (this.mFixChildTablesFromSuper && cacheField.isChildTable()) {
            cacheField = ((QuickCacheField)cacheField).cloneForChildTable(this, this.mNumberOfCachedElements++);
        }
        return cacheField;
    }

    public static String tableName2className(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return string;
        }
        String string2 = string.substring(n + 1);
        String string3 = string.substring(0, n);
        string3 = string3.replace('_', '.');
        return string3 + '.' + string2;
    }

    public SysDatabase getDatabase() {
        return this.mDB;
    }

    public CacheField isGetterForCalculatedProperty(String string) {
        return null;
    }

    public CacheClass createClass(JavaClassDef javaClassDef) throws CacheException {
        return new QuickCacheClassNew(this.mDB, javaClassDef);
    }

    public CacheClass createClass(String string) throws CacheException {
        TableBasedClass tableBasedClass = this.mDB.createQuickCacheClass(string, false);
        return tableBasedClass;
    }

    public CacheField createField(JavaPropDef javaPropDef) throws CacheException {
        boolean bl = this.getSQLTableName() != null;
        ColumnBasedField columnBasedField = new SimpleField(this, javaPropDef, !bl);
        if (columnBasedField.isChildTable()) {
            columnBasedField = this.createChildTableField(javaPropDef);
        } else if (columnBasedField.isOneToManyRelationship()) {
            columnBasedField = this.createChildTableField(javaPropDef);
        } else if (bl && columnBasedField.isEmbedded()) {
            columnBasedField = new FieldForEmeddedObj(this, javaPropDef, false);
        } else if (!bl && columnBasedField.isSerial()) {
            columnBasedField = new FieldForEmeddedObj(this, javaPropDef, true);
        }
        return columnBasedField;
    }

    private ColumnBasedField createChildTableField(JavaPropDef javaPropDef) throws CacheException {
        return new ChildTableField(this, javaPropDef, this.mNumberOfCachedElements++);
    }

    protected CacheMethod createMethod(CacheClassMetadata cacheClassMetadata, JavaMethodDef javaMethodDef) throws CacheException {
        throw new UnsupportedOperationException("Methods are not supported in Light mode");
    }

    protected CacheArgument createArgument(JavaMtdArgDef javaMtdArgDef) throws CacheException {
        throw new UnsupportedOperationException("Methods are not supported in Light mode");
    }
}

