/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.serial;

import com.intersys.cache.CacheObject;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.metadata.ArrayIterator;
import com.intersys.cache.metadata.JavaClassController;
import com.intersys.cache.serial.FullSerialStorageInfo;
import com.intersys.cache.serial.SerialField;
import com.intersys.objects.CacheException;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.Id;
import com.intersys.objects.Oid;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheClassInfo;
import com.intersys.objects.reflect.CacheField;
import com.intersys.objects.reflect.CacheForeignKeyInfo;
import com.intersys.objects.reflect.CacheIndexInfo;
import com.intersys.objects.reflect.CacheMethod;
import com.intersys.objects.reflect.CacheQueryDefinition;
import com.intersys.objects.reflect.CacheSerialStorageMetadata;
import com.intersys.objects.reflect.CandidateKeyInfo;
import com.intersys.objects.reflect.TableMetadata;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SerialCacheClass
implements CacheClass {
    private SysDatabase mDB;
    private FullSerialStorageInfo mStorage;
    private String mName;
    private CacheField[] mFields;
    private Map mFieldsByName;
    private JavaClassController mController = null;

    protected SerialCacheClass(String string, SysDatabase sysDatabase, FullSerialStorageInfo fullSerialStorageInfo) {
        this.mName = string;
        this.mDB = sysDatabase;
        this.mStorage = fullSerialStorageInfo;
        this.createFieldArray();
        this.mController = new JavaClassController(this.mDB, this, false);
    }

    private void createFieldArray() {
        FullSerialStorageInfo.Element[] elementArray = (FullSerialStorageInfo.Element[])this.mStorage.getStorageElements();
        this.mFields = new CacheField[elementArray.length];
        this.mFieldsByName = new HashMap();
        for (int i = 0; i < elementArray.length; ++i) {
            this.mFields[i] = new SerialField(this.mDB, this, elementArray[i]);
            this.mFieldsByName.put(this.mFields[i].getName(), this.mFields[i]);
        }
    }

    private JavaClassController getController() {
        if (this.mController == null) {
            this.mController = new JavaClassController(this.mDB, this);
        }
        return this.mController;
    }

    public String getName() {
        return this.mName;
    }

    public String getFullSQLTableName() {
        return null;
    }

    public String getPackageName() {
        throw new UnsupportedOperationException("Method getPackageName() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public Class getJavaClass() throws CacheException {
        return this.getController().getJavaClass();
    }

    public String getJavaClassName() {
        if (this.mName.startsWith("%Compiler.LG.")) {
            String string = "com.intersys.classes.Compiler.LG." + this.mName.substring("%Compiler.LG.".length());
            return string;
        }
        return this.getName();
    }

    public CacheField[] getFields() {
        return this.mFields;
    }

    public CacheField getField(String string) {
        return (CacheField)this.mFieldsByName.get(string);
    }

    int getNumberOfSerialElements() {
        return this.mFields.length;
    }

    public String getJavaPackage() throws CacheException {
        throw new UnsupportedOperationException("Method getJavaPackage() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CacheMethod[] getMethods() throws CacheException {
        return new CacheMethod[0];
    }

    public CacheQueryDefinition[] getQueries() throws CacheException {
        return new CacheQueryDefinition[0];
    }

    public Iterator getFieldNames() throws CacheException {
        return new ArrayIterator.FieldNameIterator(this.mFields);
    }

    public Iterator getMethodSignatures() throws CacheException {
        return new ArrayList().iterator();
    }

    public CacheMethod getMethod(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getMethod() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CacheMethod getMethod(String string, CacheClassInfo[] cacheClassInfoArray) throws CacheException {
        throw new UnsupportedOperationException("Method getMethod() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CacheQueryDefinition getQuery(String string) throws CacheException {
        throw new UnsupportedOperationException("Method getQuery() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CacheClass getSuperclass() throws CacheException {
        throw new UnsupportedOperationException("Method getSuperclass() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CacheClass[] getCacheSuperclasses() throws CacheException {
        throw new UnsupportedOperationException("Method getCacheSuperclasses() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean isAssignableFrom(CacheClassInfo cacheClassInfo) throws CacheException {
        throw new UnsupportedOperationException("Method isAssignableFrom() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public int getModifiers() {
        throw new UnsupportedOperationException("Method getModifiers() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean isPersistent() throws CacheException {
        throw new UnsupportedOperationException("Method isPersistent() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean isSerial() throws CacheException {
        throw new UnsupportedOperationException("Method isSerial() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean isDatatype() {
        throw new UnsupportedOperationException("Method isDatatype() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean isAbstract() {
        throw new UnsupportedOperationException("Method isAbstract() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public TableMetadata getSQLTableMetadata() {
        throw new UnsupportedOperationException("Method getSQLTableMetadata() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CacheField[] getDeclaredFields() throws CacheException {
        throw new UnsupportedOperationException("Method getDeclaredFields() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CandidateKeyInfo[] getAvailableCandidateKeys() throws CacheException {
        return new CandidateKeyInfo[0];
    }

    public CandidateKeyInfo getBestCandidateKey() throws CacheException {
        return null;
    }

    public CandidateKeyInfo getKeyInfo(String string) throws CacheException {
        throw new CacheException("No key with name " + string + " available in class " + this.getName());
    }

    public Class getJavaClass(boolean bl) throws CacheException {
        return this.getController().getJavaClass(bl);
    }

    public void setJavaClass(String string, boolean bl) throws CacheException {
        this.getController().setJavaClass(string, bl);
    }

    public boolean isJavaClassSet() {
        return this.getController().isJavaClassSet();
    }

    public Object openObject(Id id) throws CacheException {
        return this.getController().openObject(id);
    }

    public Object openObject(Oid oid) throws CacheException {
        return this.getController().openObject(oid);
    }

    public void deleteObject(Id id) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CandidateKey createBestCandidateKey() throws CacheException {
        return null;
    }

    public Object newInstance(String string) throws CacheException {
        return this.getController().newInstance(string);
    }

    public Object newInstance(CacheObject cacheObject) throws CacheException {
        return this.getController().newInstance(cacheObject);
    }

    public Object newInstance(CacheObject cacheObject, boolean bl) throws CacheException {
        return this.getController().newInstance(cacheObject, bl);
    }

    public Object createClientObject() throws CacheException {
        return this.newInstance("");
    }

    public boolean isVerified() {
        return this.getController().isVerified();
    }

    public void verifyClass() throws CacheException {
        this.getController().verifyClass();
    }

    public void close() {
        throw new UnsupportedOperationException("Method close() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CandidateKey createKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method createKey() can not be used for serial class");
    }

    public CandidateKey createKey(String string, String string2) throws CacheException {
        throw new UnsupportedOperationException("Method createKey() can not be used for serial class");
    }

    public CandidateKey createPrimaryKey() throws CacheException {
        throw new UnsupportedOperationException("Method createPrimaryKey() can not be used for serial class");
    }

    public CandidateKey createPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method createPrimaryKey() can not be used for serial class");
    }

    public Object openByKey(CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method openByKey() can not be used for serial class");
    }

    public Object openByPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method openByKey() can not be used for serial class");
    }

    public boolean deleteObjectByKey(CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObjectByKey() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean deleteObjectByPrimaryKey(String string) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObjectByPrimaryKey() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public int getClassTypeId() {
        throw new UnsupportedOperationException("Method getClassTypeId() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean hasDeleteIdMethod() {
        throw new UnsupportedOperationException("Method hasDeleteIdMethod() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean hasExistsIdMethod() {
        throw new UnsupportedOperationException("Method hasExistsIdMethod() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean hasOpenIdMethod() {
        throw new UnsupportedOperationException("Method hasOpenIdMethod() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean hasOpenMethod() {
        throw new UnsupportedOperationException("Method hasOpenMethod() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean isChild() {
        throw new UnsupportedOperationException("Method isChild() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public String getParentClassName() {
        throw new UnsupportedOperationException("Method getParentClassName() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public CacheSerialStorageMetadata getSerialStateInfo() {
        throw new UnsupportedOperationException("Method getSerialStateInfo() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public String getSchemaName() {
        throw new UnsupportedOperationException("Method getSchemaName() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public int getRowIdJDBCCode() {
        throw new UnsupportedOperationException("Method getRowIdJDBCCode() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean isExternallyMapped() throws CacheException {
        return false;
    }

    public CacheField getParentField() throws CacheException {
        throw new UnsupportedOperationException("Method getParentField() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public String getSQLTableName() {
        throw new UnsupportedOperationException("Method getSQLTableName() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public String getIdPlaceholder() {
        throw new UnsupportedOperationException("Method getIdPlaceholder() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public boolean eagerFetchRequiredForPOJO() throws CacheException {
        throw new UnsupportedOperationException("Method eagerFetchRequiredForPOJO() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public String getVersionPropertyName() throws CacheException {
        return null;
    }

    public String getJavaImplements() {
        throw new UnsupportedOperationException("Method getJavaImplements() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public String getJavaInterfaceName() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Method getJavaInterfaceName() is not implemented in class com.intersys.cache.serial.SerialCacheClass");
    }

    public String getJavaPojoName() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Method getJavaPojoName() is not implemented in com.intersys.cache.serial.SerialCacheClass");
    }

    public CacheIndexInfo[] getIndexInfo() throws CacheException {
        throw new UnsupportedOperationException("Method getIndexInfo() is not implemented in com.intersys.cache.serial.SerialCacheClass");
    }

    public CacheForeignKeyInfo[] getForeignKeyInfo() throws CacheException {
        throw new UnsupportedOperationException("Method getForeginKeyInfo() is not implemented in com.intersys.cache.serial.SerialCacheClass");
    }
}

