/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbcext;

import com.sap.dbtech.jdbcext.ClientConnectionSapDB;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Savepoint;

public class ClientSavepointSapDB
implements Savepoint {
    Savepoint originalSavepoint;
    private ClientConnectionSapDB clientConnection;

    static Savepoint createNew(Savepoint savepoint, ClientConnectionSapDB clientConnectionSapDB) {
        ClientSavepointSapDB clientSavepointSapDB = new ClientSavepointSapDB(savepoint, clientConnectionSapDB);
        return clientSavepointSapDB;
    }

    private ClientSavepointSapDB(Savepoint savepoint, ClientConnectionSapDB clientConnectionSapDB) {
        this.originalSavepoint = savepoint;
        this.clientConnection = clientConnectionSapDB;
    }

    void exceptionOccurred(SQLException sQLException) {
        this.clientConnection.exceptionOccurred(sQLException);
    }

    public int getSavepointId() throws SQLException {
        try {
            return this.originalSavepoint.getSavepointId();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    public String getSavepointName() throws SQLException {
        try {
            return this.originalSavepoint.getSavepointName();
        }
        catch (SQLException sQLException) {
            this.exceptionOccurred(sQLException);
            throw sQLException;
        }
    }

    static Savepoint setSavepoint(ClientConnectionSapDB clientConnectionSapDB) throws SQLException {
        Savepoint savepoint = clientConnectionSapDB.getPhysicalConnection().setSavepoint();
        return savepoint == null ? null : ClientSavepointSapDB.createNew(savepoint, clientConnectionSapDB);
    }

    static Savepoint setSavepoint(String string, ClientConnectionSapDB clientConnectionSapDB) throws SQLException {
        Savepoint savepoint = clientConnectionSapDB.getPhysicalConnection().setSavepoint(string);
        return savepoint == null ? null : ClientSavepointSapDB.createNew(savepoint, clientConnectionSapDB);
    }

    static void releaseSavepoint(Connection connection, Savepoint savepoint) throws SQLException {
        if (savepoint instanceof ClientSavepointSapDB) {
            connection.releaseSavepoint(((ClientSavepointSapDB)savepoint).originalSavepoint);
        } else {
            connection.releaseSavepoint(savepoint);
        }
    }

    static void rollback(Connection connection, Savepoint savepoint) throws SQLException {
        if (savepoint instanceof ClientSavepointSapDB) {
            connection.rollback(((ClientSavepointSapDB)savepoint).originalSavepoint);
        } else {
            connection.rollback(savepoint);
        }
    }
}

