/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.objects;

import com.intersys.cache.Dataholder;
import com.intersys.jdbc.CachePreparedStatement;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheServerException;
import com.intersys.objects.Database;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheQueryDefinition;
import com.intersys.objects.reflect.CacheQueryInfo;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class CacheQuery
implements Serializable {
    private Database mDatabase;
    private PreparedStatement mPreparedStatement;
    private int mNumOfParameters = -1;

    public CacheQuery(Database database, String string, String string2) throws CacheException {
        this.mDatabase = database;
        CacheClass cacheClass = this.mDatabase.getCacheClass(string);
        CacheQueryDefinition cacheQueryDefinition = cacheClass.getQuery(string2);
        this.prepareStatements(cacheQueryDefinition);
    }

    public CacheQuery(Database database, CacheQueryInfo cacheQueryInfo) throws CacheException {
        this.mDatabase = database;
        this.prepareStatements(cacheQueryInfo);
    }

    public CacheQuery(Database database, String string) throws CacheException {
        this.mDatabase = database;
        this.mPreparedStatement = this.mDatabase.prepareStatement(string);
    }

    public CacheQuery(Database database, String string, int n, int n2) throws CacheException {
        this.mDatabase = database;
        String string2 = Dataholder.makeQueryStatement(string, n);
        this.mPreparedStatement = this.mDatabase.prepareCall(string2);
        this.mNumOfParameters = n;
    }

    public ResultSetMetaData getMetaData() throws CacheException {
        try {
            return this.mPreparedStatement.getMetaData();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public ResultSet execute() throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[]{};
        return this.execute(dataholderArray);
    }

    public ResultSet execute(Object object) throws CacheException {
        Object[] objectArray = new Object[]{object};
        return this.execute(objectArray);
    }

    public ResultSet execute(Object object, Object object2) throws CacheException {
        Object[] objectArray = new Object[]{object, object2};
        return this.execute(objectArray);
    }

    public ResultSet execute(Object object, Object object2, Object object3) throws CacheException {
        Object[] objectArray = new Object[]{object, object2, object3};
        return this.execute(objectArray);
    }

    public ResultSet execute(Object[] objectArray) throws CacheException {
        Dataholder[] dataholderArray = new Dataholder[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            dataholderArray[i] = Dataholder.create(objectArray[i]);
        }
        return this.execute(dataholderArray);
    }

    protected ResultSet execute(Dataholder[] dataholderArray) throws CacheException {
        try {
            int n;
            for (n = 0; n < dataholderArray.length; ++n) {
                if (Dataholder.isBinaryType(dataholderArray[n].getType())) {
                    this.mPreparedStatement.setBytes(n + 1, dataholderArray[n].getBinary());
                    continue;
                }
                String string = dataholderArray[n].getString();
                if (string.length() == 0) {
                    this.mPreparedStatement.setString(n + 1, null);
                    continue;
                }
                this.mPreparedStatement.setObject(n + 1, dataholderArray[n].getObject());
            }
            for (n = dataholderArray.length; n < this.mNumOfParameters; ++n) {
                ((CachePreparedStatement)this.mPreparedStatement).setDefault(n + 1);
            }
            return this.mPreparedStatement.executeQuery();
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException);
        }
    }

    public void close() throws CacheServerException {
        try {
            this.mPreparedStatement.close();
            this.mPreparedStatement = null;
        }
        catch (SQLException sQLException) {
            throw new CacheServerException(sQLException, "Failed to close statement: " + sQLException.getMessage());
        }
    }

    public boolean isClosed() throws CacheServerException {
        try {
            if (this.mPreparedStatement == null) {
                return true;
            }
            if (this.mPreparedStatement.getConnection() == null) {
                return true;
            }
            return this.mPreparedStatement.getConnection().isClosed();
        }
        catch (SQLException sQLException) {
            return true;
        }
    }

    private void prepareStatements(CacheQueryInfo cacheQueryInfo) throws CacheException {
        this.mNumOfParameters = cacheQueryInfo.getNumberOfParameters();
        String string = cacheQueryInfo.getStatement(this.mNumOfParameters);
        this.mPreparedStatement = this.mDatabase.prepareCall(string);
    }

    protected void finalize() throws Throwable {
        super.finalize();
    }
}

