/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache;

import com.intersys.VersionInfo;
import com.intersys.cache.SysDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.Database;
import com.intersys.objects.DatabaseUtilities;
import com.intersys.objects.reflect.CacheClass;
import java.io.File;
import java.io.FileInputStream;
import java.util.HashMap;
import java.util.Map;

public class CacheClassLoader
extends ClassLoader {
    private File mClassScratchDir;
    private File mSrcScratchDir;
    private static String bin = "bin";
    private static String src = "src";
    private SysDatabase mDB = null;
    private Map mPackages;

    public CacheClassLoader(String string, SysDatabase sysDatabase) throws CacheException {
        this.mClassScratchDir = new File(string, bin);
        this.mSrcScratchDir = new File(string, src);
        this.mDB = sysDatabase;
        this.mPackages = new HashMap();
    }

    public CacheClassLoader(ClassLoader classLoader, String string, String string2, Database database) throws CacheException {
        super(classLoader);
        this.mClassScratchDir = new File(string);
        this.mSrcScratchDir = new File(string2);
        this.mDB = (SysDatabase)database;
        this.mPackages = new HashMap();
    }

    public Class findClass(String string) throws ClassNotFoundException {
        Object object;
        File file = this.findClassFile(string);
        if (file == null) {
            object = this.findSourceFile(string);
            if (object == null) {
                if (this.mDB != null) {
                    this.generateClass(string);
                }
                if ((object = this.findSourceFile(string)) == null) {
                    throw new ClassNotFoundException(string);
                }
            }
            this.compileSourceFile((File)object);
            file = this.findClassFile(string);
        }
        object = this.loadClassData(file);
        return this.defineClass(string, (byte[])object, 0, ((Object)object).length);
    }

    private byte[] loadClassData(File file) throws ClassNotFoundException {
        try {
            FileInputStream fileInputStream = new FileInputStream(file);
            int n = fileInputStream.available();
            byte[] byArray = new byte[n];
            fileInputStream.read(byArray);
            return byArray;
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Can not open file " + file, exception);
        }
    }

    protected File findClassFile(String string) throws ClassNotFoundException {
        return DatabaseUtilities.findFile(this.mClassScratchDir, string, "class");
    }

    protected File findSourceFile(String string) throws ClassNotFoundException {
        return DatabaseUtilities.findFile(this.mSrcScratchDir, string, "java");
    }

    private void compileSourceFile(File file) throws ClassNotFoundException {
        if (!this.mClassScratchDir.exists()) {
            this.mClassScratchDir.mkdirs();
        }
        DatabaseUtilities.compileJavaClass(file.toString(), this.mSrcScratchDir.toString(), this.mClassScratchDir.toString(), this.mClassScratchDir.toString());
    }

    protected void generateClass(String string) throws ClassNotFoundException {
        String string2 = null;
        try {
            string2 = this.mDB.getCacheClassName(string);
            if (string2 == null) {
                throw new ClassNotFoundException("Class for " + string + " is not found in Cache");
            }
            this.mDB.utilities().generateClass(string2, this.mSrcScratchDir.toString());
            if (this.getPackage(string) == null) {
                this.definePackage(string2);
            }
        }
        catch (Exception exception) {
            throw new ClassNotFoundException("Failed to generate class " + string2 + " for java class " + string, exception);
        }
    }

    private void definePackage(String string) throws CacheException {
        CacheClass cacheClass = this.mDB.getCacheClass(string);
        String string2 = cacheClass.getJavaPackage();
        this.mPackages.put(string2, this.definePackage(string2, null, null, null, "Generated by Cache", VersionInfo.getClientVersion(), "Intersystems Corporation", null));
    }

    protected Package getPackage(String string) {
        Package package_ = super.getPackage(string);
        if (package_ == null) {
            return (Package)this.mPackages.get(string);
        }
        return package_;
    }

    public static void main(String[] stringArray) throws Exception {
        bin = "build";
        src = ".";
        CacheClassLoader cacheClassLoader = new CacheClassLoader(stringArray[0], null);
        System.out.println(cacheClassLoader.findClass(stringArray[1]).getName());
    }

    public static ClassLoader wrapClassLoader(ClassLoader classLoader) {
        return new WrapperClassLoader(classLoader);
    }

    private static class WrapperClassLoader
    extends ClassLoader {
        private ClassLoader mLoader;

        public WrapperClassLoader(ClassLoader classLoader) {
            this.mLoader = classLoader;
        }

        public Class findClass(String string) throws ClassNotFoundException {
            return this.mLoader.loadClass(string);
        }
    }
}

