/*
 * Decompiled with CFR 0.152.
 */
package dagger.internal;

import dagger.internal.Collections;
import dagger.internal.Factory;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.inject.Provider;

public final class SetFactory<T>
implements Factory<Set<T>> {
    private final Set<Provider<Set<T>>> contributingProviders;

    public static <T> Factory<Set<T>> create(Provider<Set<T>> first, Provider<Set<T>> ... rest) {
        if (first == null) {
            throw new NullPointerException();
        }
        if (rest == null) {
            throw new NullPointerException();
        }
        LinkedHashSet<Provider<Set<T>>> contributingProviders = Collections.newLinkedHashSetWithExpectedSize(1 + rest.length);
        contributingProviders.add(first);
        for (Provider<Set<T>> provider : rest) {
            if (provider == null) {
                throw new NullPointerException();
            }
            contributingProviders.add(provider);
        }
        return new SetFactory<T>(contributingProviders);
    }

    private SetFactory(Set<Provider<Set<T>>> contributingProviders) {
        this.contributingProviders = contributingProviders;
    }

    public Set<T> get() {
        ArrayList<Set> providedSets = new ArrayList<Set>(this.contributingProviders.size());
        for (Provider<Set<T>> provider : this.contributingProviders) {
            Set providedSet = (Set)provider.get();
            if (providedSet == null) {
                throw new NullPointerException(provider + " returned null");
            }
            providedSets.add(providedSet);
        }
        int size = 0;
        for (Set providedSet : providedSets) {
            size += providedSet.size();
        }
        LinkedHashSet result = Collections.newLinkedHashSetWithExpectedSize(size);
        for (Set s : providedSets) {
            for (Object element : s) {
                if (element == null) {
                    throw new NullPointerException("a null element was provided");
                }
                result.add(element);
            }
        }
        return java.util.Collections.unmodifiableSet(result);
    }
}

