/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.google;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.Multimap;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import com.google.common.collect.testing.google.AbstractMultimapTester;

@GwtCompatible
public class MultimapToStringTester<K, V>
extends AbstractMultimapTester<K, V, Multimap<K, V>> {
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testToStringEmpty() {
        MultimapToStringTester.assertEquals((String)"{}", (String)this.multimap().toString());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testToStringSingleton() {
        MultimapToStringTester.assertEquals((String)("{" + this.sampleKeys().e0 + "=[" + this.sampleValues().e0 + "]}"), (String)this.multimap().toString());
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_KEYS})
    public void testToStringWithNullKey() {
        this.initMultimapWithNullKey();
        this.testToStringMatchesAsMap();
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    @MapFeature.Require(value={MapFeature.ALLOWS_NULL_VALUES})
    public void testToStringWithNullValue() {
        this.initMultimapWithNullValue();
        this.testToStringMatchesAsMap();
    }

    public void testToStringMatchesAsMap() {
        MultimapToStringTester.assertEquals((String)this.multimap().asMap().toString(), (String)this.multimap().toString());
    }
}

