/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.htmlparser.dom;

import org.w3c.dom.DocumentType;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class Dom2Sax {
    private final NamedNodeMapAttributes attributes = new NamedNodeMapAttributes();
    private final ContentHandler contentHandler;
    private final LexicalHandler lexicalHandler;

    private static String emptyIfNull(String namespaceURI) {
        return namespaceURI == null ? "" : namespaceURI;
    }

    public Dom2Sax(ContentHandler contentHandler, LexicalHandler lexicalHandler) {
        if (contentHandler == null) {
            throw new IllegalArgumentException("ContentHandler must not be null.");
        }
        this.contentHandler = contentHandler;
        this.lexicalHandler = lexicalHandler;
    }

    public void parse(Node node) throws SAXException {
        Node current = node;
        block14: while (true) {
            String localName;
            switch (current.getNodeType()) {
                case 1: {
                    this.attributes.setNamedNodeMap(current.getAttributes());
                    localName = current.getLocalName();
                    this.contentHandler.startElement(Dom2Sax.emptyIfNull(current.getNamespaceURI()), localName == null ? current.getNodeName() : localName, null, this.attributes);
                    this.attributes.clear();
                    break;
                }
                case 3: {
                    char[] buf = current.getNodeValue().toCharArray();
                    this.contentHandler.characters(buf, 0, buf.length);
                    break;
                }
                case 4: {
                    if (this.lexicalHandler != null) {
                        this.lexicalHandler.startCDATA();
                    }
                    char[] buf = current.getNodeValue().toCharArray();
                    this.contentHandler.characters(buf, 0, buf.length);
                    if (this.lexicalHandler == null) break;
                    this.lexicalHandler.endCDATA();
                    break;
                }
                case 8: {
                    if (this.lexicalHandler == null) break;
                    char[] buf = current.getNodeValue().toCharArray();
                    this.lexicalHandler.comment(buf, 0, buf.length);
                    break;
                }
                case 9: {
                    this.contentHandler.startDocument();
                    break;
                }
                case 10: {
                    if (this.lexicalHandler == null) break;
                    DocumentType doctype = (DocumentType)current;
                    this.lexicalHandler.startDTD(doctype.getName(), doctype.getPublicId(), doctype.getSystemId());
                    this.lexicalHandler.endDTD();
                    break;
                }
                case 7: {
                    this.contentHandler.processingInstruction(current.getNodeName(), current.getNodeValue());
                    break;
                }
                case 5: {
                    this.contentHandler.skippedEntity(current.getNodeName());
                }
            }
            Node next = current.getFirstChild();
            if (next != null) {
                current = next;
                continue;
            }
            while (true) {
                switch (current.getNodeType()) {
                    case 1: {
                        localName = current.getLocalName();
                        this.contentHandler.endElement(Dom2Sax.emptyIfNull(current.getNamespaceURI()), localName == null ? current.getNodeName() : localName, null);
                        break;
                    }
                    case 9: {
                        this.contentHandler.endDocument();
                    }
                }
                if (current == node) {
                    return;
                }
                next = current.getNextSibling();
                if (next != null) {
                    current = next;
                    continue block14;
                }
                current = current.getParentNode();
            }
            break;
        }
    }

    private class NamedNodeMapAttributes
    implements Attributes {
        private NamedNodeMap map;
        private int length;

        private NamedNodeMapAttributes() {
        }

        public void setNamedNodeMap(NamedNodeMap attributes) {
            this.map = attributes;
            this.length = attributes.getLength();
        }

        public void clear() {
            this.map = null;
        }

        @Override
        public int getIndex(String qName) {
            int i = 0;
            while (i < this.length) {
                Node n = this.map.item(i);
                if (n.getNodeName().equals(qName)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getIndex(String uri, String localName) {
            int i = 0;
            while (i < this.length) {
                Node n = this.map.item(i);
                if (n.getLocalName().equals(localName) && Dom2Sax.emptyIfNull(n.getNamespaceURI()).equals(uri)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getLength() {
            return this.length;
        }

        @Override
        public String getLocalName(int index) {
            if (index < this.length && index >= 0) {
                return this.map.item(index).getLocalName();
            }
            return null;
        }

        @Override
        public String getQName(int index) {
            if (index < this.length && index >= 0) {
                return this.map.item(index).getNodeName();
            }
            return null;
        }

        @Override
        public String getType(int index) {
            if (index < this.length && index >= 0) {
                return "id".equals(this.map.item(index).getLocalName()) ? "ID" : "CDATA";
            }
            return null;
        }

        @Override
        public String getType(String qName) {
            int index = this.getIndex(qName);
            if (index == -1) {
                return null;
            }
            return this.getType(index);
        }

        @Override
        public String getType(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (index == -1) {
                return null;
            }
            return this.getType(index);
        }

        @Override
        public String getURI(int index) {
            if (index < this.length && index >= 0) {
                return Dom2Sax.emptyIfNull(this.map.item(index).getNamespaceURI());
            }
            return null;
        }

        @Override
        public String getValue(int index) {
            if (index < this.length && index >= 0) {
                return this.map.item(index).getNodeValue();
            }
            return null;
        }

        @Override
        public String getValue(String qName) {
            int index = this.getIndex(qName);
            if (index == -1) {
                return null;
            }
            return this.getValue(index);
        }

        @Override
        public String getValue(String uri, String localName) {
            int index = this.getIndex(uri, localName);
            if (index == -1) {
                return null;
            }
            return this.getValue(index);
        }
    }
}

