/*
 * Decompiled with CFR 0.152.
 */
package com.db4o.internal.fileheader;

import com.db4o.Db4oIOException;
import com.db4o.ext.OldFormatException;
import com.db4o.internal.Buffer;
import com.db4o.internal.Exceptions4;
import com.db4o.internal.LocalObjectContainer;
import com.db4o.internal.StatefulBuffer;
import com.db4o.internal.SystemData;
import com.db4o.internal.Transaction;
import com.db4o.internal.fileheader.FileHeader0;
import com.db4o.internal.fileheader.FileHeader1;

public abstract class FileHeader {
    private static final FileHeader[] AVAILABLE_FILE_HEADERS = new FileHeader[]{new FileHeader0(), new FileHeader1()};

    private static int readerLength() {
        int n = AVAILABLE_FILE_HEADERS[0].length();
        for (int i = 1; i < AVAILABLE_FILE_HEADERS.length; ++i) {
            n = Math.max(n, AVAILABLE_FILE_HEADERS[i].length());
        }
        return n;
    }

    public static FileHeader readFixedPart(LocalObjectContainer localObjectContainer) throws OldFormatException {
        Buffer buffer = FileHeader.prepareFileHeaderReader(localObjectContainer);
        FileHeader fileHeader = FileHeader.detectFileHeader(localObjectContainer, buffer);
        if (fileHeader == null) {
            Exceptions4.throwRuntimeException(17);
        } else {
            fileHeader.readFixedPart(localObjectContainer, buffer);
        }
        return fileHeader;
    }

    private static Buffer prepareFileHeaderReader(LocalObjectContainer localObjectContainer) {
        Buffer buffer = new Buffer(FileHeader.readerLength());
        buffer.read(localObjectContainer, 0, 0);
        return buffer;
    }

    private static FileHeader detectFileHeader(LocalObjectContainer localObjectContainer, Buffer buffer) {
        for (int i = 0; i < AVAILABLE_FILE_HEADERS.length; ++i) {
            buffer.seek(0);
            FileHeader fileHeader = AVAILABLE_FILE_HEADERS[i].newOnSignatureMatch(localObjectContainer, buffer);
            if (fileHeader == null) continue;
            return fileHeader;
        }
        return null;
    }

    public abstract void close() throws Db4oIOException;

    public abstract void initNew(LocalObjectContainer var1) throws Db4oIOException;

    public abstract Transaction interruptedTransaction();

    public abstract int length();

    protected abstract FileHeader newOnSignatureMatch(LocalObjectContainer var1, Buffer var2);

    protected long timeToWrite(long l, boolean bl) {
        return bl ? 0L : l;
    }

    protected abstract void readFixedPart(LocalObjectContainer var1, Buffer var2);

    public abstract void readVariablePart(LocalObjectContainer var1);

    protected boolean signatureMatches(Buffer buffer, byte[] byArray, byte by) {
        for (int i = 0; i < byArray.length; ++i) {
            if (buffer.readByte() == byArray[i]) continue;
            return false;
        }
        return buffer.readByte() == by;
    }

    public abstract void writeFixedPart(LocalObjectContainer var1, boolean var2, boolean var3, StatefulBuffer var4, int var5, int var6);

    public abstract void writeTransactionPointer(Transaction var1, int var2);

    protected void writeTransactionPointer(Transaction transaction, int n, int n2, int n3) {
        StatefulBuffer statefulBuffer = new StatefulBuffer(transaction, n2, 8);
        statefulBuffer.moveForward(n3);
        statefulBuffer.writeInt(n);
        statefulBuffer.writeInt(n);
        statefulBuffer.write();
    }

    public abstract void writeVariablePart(LocalObjectContainer var1, int var2);

    protected void readClassCollectionAndFreeSpace(LocalObjectContainer localObjectContainer, Buffer buffer) {
        SystemData systemData = localObjectContainer.systemData();
        systemData.classCollectionID(buffer.readInt());
        systemData.freespaceID(buffer.readInt());
    }

    public static boolean lockedByOtherSession(LocalObjectContainer localObjectContainer, long l) {
        return localObjectContainer.needsLockFileThread() && l != 0L;
    }
}

