/*
 * Decompiled with CFR 0.152.
 */
package com.intersys.cache.jbind;

import com.intersys.cache.CacheObject;
import com.intersys.cache.Dataholder;
import com.intersys.cache.ExternalObjectProvider;
import com.intersys.cache.SysDatabase;
import com.intersys.cache.jbind.CacheProcessor;
import com.intersys.cache.jbind.CustomMsgDBAdapter;
import com.intersys.cache.jbind.ReadOnlyCacheClassNew;
import com.intersys.cache.jbind.ReadOnlyCacheObject;
import com.intersys.cache.jbind.ReadOnlyCollectionObject;
import com.intersys.cache.jbind.ZObjValReader;
import com.intersys.cache.jdbcutil.ConnectionUtils;
import com.intersys.cache.jdbcutil.ParseUtils;
import com.intersys.cache.metadata.MetaMetaClass;
import com.intersys.cache.oldmetadata.ReadOnlyCacheClass;
import com.intersys.cache.oldmetadata.ReadOnlyCacheField;
import com.intersys.cache.serial.SerialObjectFactory;
import com.intersys.classes.ObjectHandle;
import com.intersys.classes.RelationshipObject;
import com.intersys.jdbc.CacheConnection;
import com.intersys.jdbc.ConnectionInfo;
import com.intersys.jdbc.SysListProxy;
import com.intersys.objects.CacheDatabase;
import com.intersys.objects.CacheException;
import com.intersys.objects.CacheInputStream;
import com.intersys.objects.CacheOutputStream;
import com.intersys.objects.CacheReader;
import com.intersys.objects.CacheServerSensitive;
import com.intersys.objects.CacheWriter;
import com.intersys.objects.CandidateKey;
import com.intersys.objects.DatabaseUtilities;
import com.intersys.objects.Id;
import com.intersys.objects.Logger;
import com.intersys.objects.ObjectServerInfo;
import com.intersys.objects.Oid;
import com.intersys.objects.StatusCode;
import com.intersys.objects.SystemError;
import com.intersys.objects.reflect.CacheClass;
import com.intersys.objects.reflect.CacheField;
import com.jalapeno.runtime.DetachedObjectsManager;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReadOnlyDatabase
extends ExternalObjectProvider
implements SysDatabase {
    private CustomMsgDBAdapter mAdapter = null;
    SysDatabase mParentDB = null;
    private String mURL = null;
    private String mUser = null;
    private String mPassword = null;
    private ConnectionInfo mConnectionInfo;
    private boolean mConnected;
    private boolean mIamForMetadata = false;
    private ObjectServerInfo mInfo;
    private int mReflectionVersion = -1;
    private Map mOrefs;
    private Map mClassMap;
    private int mDepth;
    private boolean mGotConnection;
    private ReadOnlyCacheObject mRoot = null;
    private DetachedObjectsManager mDetachedbjectsManager;
    private ClassLoader mClassLoader;

    public ReadOnlyDatabase(Connection connection, SysDatabase sysDatabase, boolean bl) throws CacheException {
        this.mAdapter = new CustomMsgDBAdapter(connection);
        this.mParentDB = sysDatabase;
        this.mIamForMetadata = bl;
        this.mConnected = true;
        this.initClientDatabase();
    }

    public ReadOnlyDatabase(CustomMsgDBAdapter customMsgDBAdapter, SysDatabase sysDatabase, boolean bl) {
        this.mAdapter = customMsgDBAdapter;
        this.mParentDB = sysDatabase;
        this.mIamForMetadata = bl;
        this.mConnected = true;
        this.initClientDatabase();
    }

    public ReadOnlyDatabase(String string, String string2, String string3) throws CacheException {
        this(string, string2, string3, null, false);
    }

    public ReadOnlyDatabase(String string, String string2, String string3, SysDatabase sysDatabase, boolean bl) throws CacheException {
        this.mURL = ConnectionUtils.createURLString(string);
        this.mUser = string2;
        this.mPassword = string3;
        this.mConnected = false;
        this.mParentDB = sysDatabase;
        this.mIamForMetadata = bl;
        this.initClientDatabase();
    }

    public ReadOnlyDatabase getReadOnlyDatabase() throws CacheException {
        SysDatabase sysDatabase;
        SysDatabase sysDatabase2 = sysDatabase = this.mParentDB != null ? this.mParentDB : this;
        if (this.mConnected) {
            return new ReadOnlyDatabase(this.myAdapter(), sysDatabase, true);
        }
        return new ReadOnlyDatabase(this.mURL, this.mUser, this.mPassword, sysDatabase, true);
    }

    private void initClientDatabase() {
        this.mOrefs = new HashMap();
        this.mClassMap = new HashMap();
        this.mInfo = null;
        this.mDepth = 0;
        this.mGotConnection = false;
        this.mConnectionInfo = new ConnectionInfo();
    }

    public CacheObject openCacheObject(String string, byte[] byArray) throws CacheException {
        Object object;
        if (this.needChildDatabase()) {
            ReadOnlyDatabase readOnlyDatabase = this.createChildDatabase();
            return readOnlyDatabase.openCacheObject(string, byArray);
        }
        if (Logger.debugOn()) {
            Logger.out.println("Opening instance of class " + string + " by oid \"" + new Oid(byArray).toString() + "\"");
        }
        this.connect();
        Object object2 = new Oid(byArray);
        if (((Oid)object2).getClassName().equals("")) {
            object = ((Oid)object2).getId().toString();
            object2 = new Oid((String)object, string);
            byArray = ((Oid)object2).getData();
        }
        object2 = this.myAdapter().loadReadOnly(string, byArray);
        object = this.sysListForData((byte[])object2);
        this.processOrefs(object, true);
        this.disconnect();
        return this.mRoot;
    }

    public CacheObject openCacheObject(String string, String string2) throws CacheException {
        if (this.needChildDatabase()) {
            ReadOnlyDatabase readOnlyDatabase = this.createChildDatabase();
            return readOnlyDatabase.openCacheObject(string, string2);
        }
        if (Logger.debugOn()) {
            Logger.out.println("Opening instance of class " + string + " by id \"" + string2 + "\"");
        }
        this.connect();
        byte[] byArray = this.myAdapter().loadReadOnly(string, string2);
        Object object = this.sysListForData(byArray);
        this.processOrefs(object, true);
        this.disconnect();
        return this.mRoot;
    }

    private void connect() throws CacheException {
        if (this.mConnected) {
            return;
        }
        ++this.mDepth;
        if (this.mDepth > 1) {
            return;
        }
        if (this.myAdapter() != null) {
            return;
        }
        CacheConnection cacheConnection = ConnectionUtils.staticInitConnection(this.mURL, this.mUser, this.mPassword);
        this.mGotConnection = true;
        this.mAdapter = new CustomMsgDBAdapter(cacheConnection);
        if (this.mInfo == null) {
            this.mInfo = new ObjectServerInfo();
            this.myAdapter().setupServerInfo(this.mInfo);
            this.mConnectionInfo = ((CacheConnection)this.myAdapter().getConnection()).getConnectionInfo();
        }
        if (this.mReflectionVersion < 0) {
            this.mReflectionVersion = this.myAdapter().getReflectionVersion();
        }
    }

    private void disconnect() throws CacheException {
        if (this.mConnected) {
            return;
        }
        --this.mDepth;
        if (this.mDepth > 0) {
            return;
        }
        if (!this.mGotConnection) {
            return;
        }
        this.mAdapter.close(true);
        this.mAdapter = null;
        this.mGotConnection = false;
    }

    private void processOrefs(Object object, boolean bl) throws CacheException {
        PrintWriter printWriter = null;
        if (Logger.getDebugCache()) {
            printWriter = Logger.out;
        }
        int n = 0;
        try {
            while (!SysListProxy.atEnd(object)) {
                this.processOref(object, printWriter, bl);
                ++n;
            }
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to get Data");
        }
        if (Logger.debugOn()) {
            Logger.out.println("Received " + n + " orefs from server.");
        }
    }

    private void processOref(Object object, PrintWriter printWriter, boolean bl) throws CacheException, SQLException {
        ReadOnlyCacheObject readOnlyCacheObject;
        Object object2;
        String string = SysListProxy.getString(object);
        int n = string.indexOf(64);
        if (n < 0) {
            throw new CacheException("Invalid oref: " + string);
        }
        int n2 = Integer.parseInt(string.substring(0, n));
        String string2 = string.substring(n + 1);
        Object object3 = SysListProxy.getSysList(object);
        int n3 = SysListProxy.getInteger(object);
        HashMap hashMap = new HashMap(n3);
        if (printWriter != null) {
            printWriter.println("Got oref=" + string + "; nnodes=" + n3);
            printWriter.println("Got oid = " + object3);
        }
        for (int i = 0; i < n3; ++i) {
            CacheProcessor.processNode(hashMap, object, printWriter);
        }
        if (ReadOnlyDatabase.isCollection(string2)) {
            object2 = this.processCollection(object, printWriter);
            readOnlyCacheObject = new ReadOnlyCollectionObject(object2, string2, n2);
        } else {
            object2 = new ZObjValReader(hashMap, new Oid(object3));
            readOnlyCacheObject = new ReadOnlyCacheObject(this, string2, n2, (ZObjValReader)object2);
        }
        object2 = this.constructKey(string2, n2);
        ReadOnlyCollectionObject readOnlyCollectionObject = this.mOrefs.put(object2, readOnlyCacheObject);
        if (readOnlyCollectionObject != null) {
            throw new SystemError("Key for object " + readOnlyCacheObject + " is already in use: " + readOnlyCollectionObject);
        }
        this.getCacheClass(string2);
        if (this.mRoot == null || !bl) {
            this.mRoot = readOnlyCacheObject;
        }
    }

    protected boolean isObjectLoaded(Object object) {
        return this.mOrefs.containsKey(object);
    }

    public CacheObject getCacheObjectUnsafe(String string, int n) throws CacheException {
        ReadOnlyCacheObject readOnlyCacheObject = (ReadOnlyCacheObject)this.mOrefs.get(this.constructKey(string, n));
        if (Logger.getDebugReferenceCountLevel() > 1) {
            Logger.out.println("RODB: Oref " + n + " was found in map");
        }
        return readOnlyCacheObject;
    }

    public CacheClass getCacheClass(String string) throws CacheException {
        CacheClass cacheClass = this.getCacheClassIfLoaded(string);
        if (cacheClass != null && cacheClass instanceof ReadOnlyCacheClassNew) {
            return cacheClass;
        }
        if (cacheClass != null && cacheClass instanceof MetaMetaClass) {
            return cacheClass;
        }
        if (cacheClass != null && cacheClass instanceof ReadOnlyCacheClass) {
            ((ReadOnlyCacheClass)cacheClass).setAdapter(this.myAdapter());
            return cacheClass;
        }
        if (this.mIamForMetadata) {
            cacheClass = new MetaMetaClass(this, string);
        } else {
            this.connect();
            if (this.getReflectionVersion() >= 10) {
                cacheClass = new ReadOnlyCacheClassNew(this, string, true);
            } else {
                cacheClass = new ReadOnlyCacheClass(string, this.myAdapter(), this);
                ((ReadOnlyCacheClass)cacheClass).loadAll();
            }
            this.disconnect();
        }
        this.addClass(cacheClass, string);
        return cacheClass;
    }

    public CacheClass getCacheClassIfLoaded(String string) throws CacheException {
        CacheClass cacheClass = (CacheClass)this.mClassMap.get(string);
        if (cacheClass == null && this.mParentDB != null) {
            cacheClass = this.mParentDB.getCacheClassIfLoaded(string);
        }
        return cacheClass;
    }

    protected final Object constructKey(String string, int n) {
        return new Integer(n);
    }

    protected final Object constructKey(String string) {
        int n = string.indexOf(64);
        int n2 = Integer.parseInt(string.substring(0, n));
        String string2 = string.substring(n + 1);
        return this.constructKey(string2, n2);
    }

    public CacheField createCacheField(String string, String string2, String string3, String string4, int n, int n2, int n3) {
        return new ReadOnlyCacheField(this, string, string2, string3, string4, n, n2, n3);
    }

    public ObjectServerInfo getServerInfo() {
        if (this.mInfo == null) {
            if (this.mParentDB != null) {
                this.mInfo = this.mParentDB.getServerInfo();
            } else {
                this.mInfo = new ObjectServerInfo();
                try {
                    this.connect();
                    this.myAdapter().setupServerInfo(this.mInfo);
                    this.disconnect();
                }
                catch (CacheException cacheException) {
                    throw new IllegalStateException();
                }
            }
        }
        try {
            return (ObjectServerInfo)this.mInfo.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return null;
        }
    }

    public boolean existsObject(Oid oid) throws CacheException {
        return this.existsObject(oid.getClassName(), oid.getId());
    }

    public boolean existsObject(String string, Id id) throws CacheException {
        boolean bl;
        this.connect();
        int n = this.myAdapter().countElements(string, "ID=" + id.toString());
        if (n == 1) {
            bl = true;
        } else if (n == 0) {
            bl = false;
        } else {
            throw new SystemError("Unknown error checking object existence");
        }
        this.disconnect();
        return bl;
    }

    public int getReflectionVersion() throws CacheException {
        if (this.mReflectionVersion < 0) {
            this.mReflectionVersion = this.myAdapter().getReflectionVersion();
        }
        return this.mReflectionVersion;
    }

    private static boolean isCollection(String string) {
        if (string == null) {
            return false;
        }
        if (string.startsWith("%Collection")) {
            return true;
        }
        if (string.startsWith("%Library.Array")) {
            return true;
        }
        if (string.startsWith("%Library.Relationship")) {
            return true;
        }
        return string.startsWith("%Library.List");
    }

    private Object processCollection(Object object, PrintWriter printWriter) throws SQLException, CacheException {
        Object object2;
        int n = SysListProxy.getInteger(object);
        if (printWriter != null) {
            printWriter.println("Processing collection of type " + n);
        }
        switch (n) {
            case 1: {
                object2 = this.processList(object, false, printWriter);
                break;
            }
            case 3: {
                object2 = this.processList(object, true, printWriter);
                break;
            }
            case 2: {
                object2 = this.processArray(object, false, printWriter);
                break;
            }
            case 4: {
                object2 = this.processArray(object, true, printWriter);
                break;
            }
            case 5: {
                List list = this.processList(object, true, printWriter);
                object2 = new RelationshipObject(list, this);
                break;
            }
            default: {
                throw new CacheException("Unknown collection type: " + n);
            }
        }
        return object2;
    }

    private List processList(Object object, boolean bl, PrintWriter printWriter) throws SQLException, CacheException {
        int n = SysListProxy.getInteger(object);
        if (printWriter != null) {
            printWriter.println("Getting " + n + " list elements");
        }
        ArrayList<String> arrayList = new ArrayList<String>(n);
        for (int i = 0; i < n; ++i) {
            Object object2 = SysListProxy.getString(object);
            if (printWriter != null) {
                printWriter.println("\t" + i + ":" + object2);
            }
            if (bl) {
                object2 = this.createObject((String)object2);
            }
            arrayList.add((String)object2);
        }
        return arrayList;
    }

    private Map processArray(Object object, boolean bl, PrintWriter printWriter) throws SQLException, CacheException {
        int n = SysListProxy.getInteger(object);
        if (printWriter != null) {
            printWriter.println("Getting " + n + " array elements");
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(n);
        for (int i = 0; i < n; ++i) {
            String string = SysListProxy.getString(object);
            Object object2 = SysListProxy.getString(object);
            if (printWriter != null) {
                printWriter.println("\t<" + string + "><" + object2 + ">");
            }
            if (bl) {
                object2 = this.createObject((String)object2);
            }
            hashMap.put(string, (String)object2);
        }
        return hashMap;
    }

    private Object createObject(String string) throws CacheException {
        Object object = this.constructKey(string);
        CacheObject cacheObject = (CacheObject)this.mOrefs.get(object);
        if (cacheObject == null) {
            throw new SystemError("Object " + string + " is not loaded.");
        }
        if (Logger.getDebugReferenceCountLevel() > 1) {
            Logger.out.println("RODB: Oref " + string + " was found in map");
        }
        return cacheObject.newJavaInstance();
    }

    public static void main(String[] stringArray) throws Exception {
        String string = "jdbc:Cache://localhost:1972/SAMPLES/jdbc.log";
        ReadOnlyDatabase readOnlyDatabase = new ReadOnlyDatabase(string, "_SYSTEM", "sys");
        CacheObject cacheObject = readOnlyDatabase.openCacheObject("Sample.Person", "1");
        System.out.println(cacheObject);
    }

    public Dataholder runClassMethod(String string, String string2, Dataholder[] dataholderArray, int n) throws CacheException {
        int[] nArray = new int[]{};
        Dataholder[] dataholderArray2 = this.runClassMethod(string, string2, nArray, dataholderArray, n);
        return dataholderArray2[0];
    }

    public Dataholder[] runClassMethod(String string, String string2, int[] nArray, Dataholder[] dataholderArray, int n) throws CacheException {
        int n2;
        int n3;
        boolean bl;
        if (this.needChildDatabase()) {
            ReadOnlyDatabase readOnlyDatabase = this.createChildDatabase();
            return readOnlyDatabase.runClassMethod(string, string2, nArray, dataholderArray, n);
        }
        switch (n) {
            case 1: {
                bl = true;
                break;
            }
            case 3: {
                throw new CacheException("Methods without return values  are not yet supported in read-only mode");
            }
            default: {
                bl = false;
            }
        }
        this.connect();
        if (Logger.debugOn()) {
            Logger.out.print("running method " + string + "." + string2 + " (");
            for (int i = 0; i < dataholderArray.length; ++i) {
                Logger.out.print("" + dataholderArray[i]);
                if (i >= dataholderArray.length - 1) continue;
                Logger.out.print(", ");
            }
            Logger.out.println(")");
        }
        byte[] byArray = this.myAdapter().runMethodRO(string, string2, nArray, dataholderArray, bl);
        Object object = this.sysListForData(byArray);
        Dataholder[] dataholderArray2 = new Dataholder[nArray.length + 1];
        for (n3 = 0; n3 <= nArray.length; ++n3) {
            try {
                dataholderArray2[n3] = new Dataholder(4096, SysListProxy.getWrappedItem(object));
                continue;
            }
            catch (SQLException sQLException) {
                throw new SystemError(sQLException, "Failed to interpet server return");
            }
        }
        this.processOrefs(object, true);
        if (bl) {
            dataholderArray2[0] = new Dataholder(1026, this.mRoot);
        }
        for (n3 = 0; n3 < nArray.length && (n2 = nArray[n3] - 1) < dataholderArray.length; ++n3) {
            boolean bl2;
            if (n2 < 0) continue;
            int n4 = dataholderArray[n2].getType();
            boolean bl3 = bl2 = n4 == 512 || n4 == 1026;
            if (!bl2) continue;
            dataholderArray2[n3 + 1] = this.getCacheObject(dataholderArray2[n3 + 1]);
        }
        this.disconnect();
        return dataholderArray2;
    }

    protected Dataholder getCacheObject(Dataholder dataholder) throws CacheException {
        String string = dataholder.getString();
        if (string == null || string.equals("")) {
            return new Dataholder(1026, null);
        }
        int n = string.indexOf(64);
        if (n >= 0) {
            int n2 = Integer.parseInt(string.substring(0, n));
            String string2 = string.substring(n + 1);
            if (!this.isObjectLoaded(this.constructKey(string2, n2))) {
                throw new CacheException("Object " + string + " is not loaded");
            }
            CacheObject cacheObject = this.getCacheObjectUnsafe(string2, n2);
            cacheObject.setCacheClass(this.getCacheClass(string2));
            dataholder = new Dataholder(cacheObject);
        } else {
            int n3 = Integer.parseInt(string);
            if (!this.isObjectLoaded(this.constructKey("", n3))) {
                throw new CacheException("Object " + string + " is not loaded");
            }
            CacheObject cacheObject = this.getCacheObjectUnsafe("", n3);
            dataholder = new Dataholder(cacheObject);
        }
        return dataholder;
    }

    public CacheObject openByKey(String string, CandidateKey candidateKey, int n) throws CacheException {
        if (this.needChildDatabase()) {
            ReadOnlyDatabase readOnlyDatabase = this.createChildDatabase();
            return readOnlyDatabase.openByKey(string, candidateKey, n);
        }
        String string2 = candidateKey.getOpenMethodName();
        Dataholder[] dataholderArray = new Dataholder[candidateKey.getLength() + 1];
        candidateKey.fillArguments(dataholderArray);
        Dataholder dataholder = this.runClassMethod(string, string2, dataholderArray, 1);
        return dataholder.getCacheObject();
    }

    public DetachedObjectsManager getDetachedObjectsManager() {
        if (this.mDetachedbjectsManager == null) {
            this.mDetachedbjectsManager = DetachedObjectsManager.createDetachedObjectsManager(this);
        }
        return this.mDetachedbjectsManager;
    }

    public void setConnectionOwner(boolean bl) {
        throw new UnsupportedOperationException("Method setConnectionOwner() is not implemented in class com.intersys.cache.jbind.ReadOnlyDatabase");
    }

    public ConnectionInfo getConnectionInfo() {
        return (ConnectionInfo)this.mConnectionInfo.clone();
    }

    public Iterator openByQuery(String string, String string2) throws CacheException {
        String string3 = this.getCacheClass(string).getFullSQLTableName();
        String string4 = ParseUtils.sqlForOpenyQuery(string3, string2);
        return this.openObjectsByQuery(string, string4, null);
    }

    public Iterator openByQuery(String string, String string2, Object[] objectArray) throws CacheException {
        String string3 = this.getCacheClass(string).getFullSQLTableName();
        String string4 = ParseUtils.sqlForOpenyQuery(string3, string2);
        return this.openObjectsByQuery(string, string4, objectArray);
    }

    public Iterator openByQuery(String string) throws CacheException {
        String string2 = ParseUtils.retrieveTableNameFromQuery(string);
        return this.openObjectsByQuery(string2, string, null);
    }

    public Iterator openByQuery(String string, Object[] objectArray) throws CacheException {
        String string2 = ParseUtils.retrieveTableNameFromQuery(string);
        return this.openObjectsByQuery(string2, string, objectArray);
    }

    private Iterator openObjectsByQuery(String string, String string2, Object[] objectArray) throws CacheException {
        if (this.needChildDatabase()) {
            ReadOnlyDatabase readOnlyDatabase = this.createChildDatabase();
            return readOnlyDatabase.openObjectsByQuery(string, string2, objectArray);
        }
        if (Logger.debugOn()) {
            Logger.out.print("Opening objects of class " + string + " by query \"" + string2 + "\"");
            if (objectArray != null && objectArray.length > 0) {
                Logger.out.print(" [");
                for (int i = 0; i < objectArray.length; ++i) {
                    if (i > 0) {
                        Logger.out.print(',');
                    }
                    Logger.out.print(objectArray[i]);
                }
                Logger.out.println("]");
            } else {
                Logger.out.println(" []");
            }
        }
        this.connect();
        byte[] byArray = this.myAdapter().bulkLoadRO(string, string2, objectArray);
        Object object = this.sysListForData(byArray);
        this.processOrefs(object, false);
        this.disconnect();
        List list = (List)this.mRoot.newJavaInstance();
        return list.iterator();
    }

    private Object sysListForData(byte[] byArray) {
        Object object = SysListProxy.createSysList(byArray, false, this.mConnectionInfo);
        return object;
    }

    public Map close() throws CacheException {
        if (this.mAdapter == null && this.mURL == null) {
            throw new CacheException("Attempt to close already closed Database " + this.toString());
        }
        if (this.mDetachedbjectsManager != null) {
            this.mDetachedbjectsManager.close();
        }
        this.closeAllObjects(false);
        while (this.mGotConnection) {
            this.disconnect();
        }
        this.mAdapter = null;
        this.mURL = null;
        return this.mOrefs;
    }

    public void onConnectionClosed() {
        try {
            this.close();
        }
        catch (Exception exception) {
            ConnectionUtils.processErrorOnConnectionClose(exception, this, 0L);
        }
    }

    public synchronized void closeAllObjects(boolean bl) {
        if (this.mDetachedbjectsManager != null) {
            this.mDetachedbjectsManager.clear();
        }
        this.mOrefs.clear();
    }

    public void closeAllObjects() throws CacheException {
        this.closeAllObjects(false);
    }

    public void flush() {
    }

    public void addClass(CacheClass cacheClass, String string) throws CacheException {
        this.mClassMap.put(cacheClass.getName(), cacheClass);
    }

    public boolean isConnected() {
        return this.mConnected;
    }

    public String getConnectionString() {
        return this.getServerInfo().connectionInfo;
    }

    public ClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public CacheInputStream getInputStream(CacheObject cacheObject) throws CacheException {
        return null;
    }

    public CacheInputStream getInputStream(int n) throws CacheException {
        return null;
    }

    public CacheOutputStream getOutputStream(CacheObject cacheObject) throws CacheException {
        return null;
    }

    public CacheOutputStream getOutputStream(int n) throws CacheException {
        return null;
    }

    public CacheObject newClientObject(String string) throws CacheException {
        throw new CacheException("Operation not supported in read-only mode.");
    }

    public CacheObject deserializeObject(String string, byte[] byArray) throws CacheException {
        SysDatabase sysDatabase = this.getSerialObjectFactory();
        return sysDatabase.deserializeObject(string, byArray);
    }

    public CacheObject deserializeObject(String string, Object object) throws CacheException {
        SysDatabase sysDatabase = this.getSerialObjectFactory();
        return sysDatabase.deserializeObject(string, object);
    }

    private SysDatabase getSerialObjectFactory() throws CacheException {
        if (!this.mConnected && this.mDepth < 1) {
            if (this.mParentDB == null || !(this.mParentDB instanceof ReadOnlyDatabase)) {
                throw new CacheException("Operation not supported in read-only mode.");
            }
            return ((ReadOnlyDatabase)this.mParentDB).getSerialObjectFactory();
        }
        Connection connection = this.myAdapter().getConnection();
        return SerialObjectFactory.getSerialObjectFactory(connection);
    }

    public final SysDatabase getLightDatabase() throws CacheException {
        if (this.mParentDB == null) {
            if (!this.mConnected) {
                throw new CacheException("Operation not supported in disconnected mode");
            }
            return (SysDatabase)CacheDatabase.getLightDatabase(this.myAdapter().getConnection());
        }
        return this.mParentDB.getLightDatabase();
    }

    public Object getExternalObject(Object object) {
        throw new UnsupportedOperationException("Method getExternalObject() is not implemented in class com.intersys.cache.jbind.ReadOnlyDatabase");
    }

    public CacheObject newCacheObject(String string) throws CacheException {
        throw new CacheException("Operation not supported in read-only mode.");
    }

    public CacheObject newCacheObject(String string, String string2) throws CacheException {
        throw new CacheException("Operation not supported in read-only mode.");
    }

    public CacheObject openCacheObject(String string, String string2, int n) throws CacheException {
        return null;
    }

    public CacheObject openCacheObject(String string, byte[] byArray, int n, int n2) throws CacheException {
        return null;
    }

    public CacheObject openCacheObject(String string, byte[] byArray, int n) throws CacheException {
        return null;
    }

    public CacheObject openCacheObject(String string, String string2, int n, int n2) throws CacheException {
        return null;
    }

    public Object getListBuffer(int n, int n2, int n3) throws CacheException {
        return null;
    }

    public Object getArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        return null;
    }

    public Object getObjectListBuffer(int n, int n2, int n3) throws CacheException {
        return null;
    }

    public Object getObjectArrayBuffer(int n, String string, int n2, int n3) throws CacheException {
        return null;
    }

    public void processObjectBuffer(Object object, Object object2, CacheServerSensitive cacheServerSensitive) throws CacheException {
    }

    public void decreaseServerReferenceCount(int n, int n2) throws CacheException {
    }

    public void deleteObject(Oid oid) throws CacheException {
    }

    public void deleteObject(String string, Id id, int n) throws CacheException {
    }

    public void deleteObject(Oid oid, int n) throws CacheException {
    }

    public void deleteObject(String string, Id id) throws CacheException {
    }

    public boolean deleteObject(String string, CandidateKey candidateKey) throws CacheException {
        throw new UnsupportedOperationException("Method deleteObject() is not supported in read-only mode");
    }

    public void removeClass(CacheClass cacheClass) throws CacheException {
    }

    public void removeClass(String string) {
    }

    public String getCacheClassForJavaClassSQL() {
        throw new UnsupportedOperationException("Method getCacheClassForJavaClassSQL() is not implemented in class com.intersys.cache.jbind.ReadOnlyDatabase");
    }

    public String getCacheClassName(String string) throws CacheException {
        return null;
    }

    public long getProcessNumber() {
        return 0L;
    }

    public boolean ensureInMap(int n, String string) throws CacheException {
        return false;
    }

    public void releaseFromMap(int n) throws CacheException {
    }

    public ResultSet getCacheResultSet(String string) throws CacheException {
        return null;
    }

    public CacheReader getReader(int n) throws CacheException {
        return null;
    }

    public CacheReader getReader(CacheObject cacheObject) throws CacheException {
        return null;
    }

    public CacheWriter getWriter(CacheObject cacheObject) throws CacheException {
        return null;
    }

    public CacheWriter getWriter(int n) throws CacheException {
        return null;
    }

    public boolean equals(Object object) {
        return false;
    }

    public void setClassLoader(ClassLoader classLoader) {
        this.mClassLoader = classLoader;
    }

    public boolean addListener(EventListener eventListener) {
        return false;
    }

    public boolean removeListener(EventListener eventListener) {
        return false;
    }

    public int transactionLevel() throws CacheException {
        return 0;
    }

    public void printStatistics() {
    }

    public void printStatistics(PrintStream printStream) {
    }

    public Statement createStatement() throws CacheException {
        if (!this.mConnected) {
            throw new CacheException("Operation is not supported in read-only disconnected mode");
        }
        try {
            return this.myAdapter().getConnection().createStatement();
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to create statement.");
        }
    }

    public PreparedStatement prepareStatement(String string) throws CacheException {
        if (!this.mConnected) {
            throw new CacheException("Operation is not supported in read-only disconnected mode");
        }
        try {
            return this.myAdapter().getConnection().prepareStatement(string);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to prepare statement: " + string);
        }
    }

    public CallableStatement prepareCall(String string) throws CacheException {
        if (!this.mConnected) {
            throw new CacheException("Operation is not supported in read-only disconnected mode");
        }
        try {
            return this.myAdapter().getConnection().prepareCall(string);
        }
        catch (SQLException sQLException) {
            throw new CacheException(sQLException, "Failed to prepare call: " + string);
        }
    }

    private boolean needChildDatabase() {
        return !this.mIamForMetadata && this.mDepth < 1 && !this.mOrefs.isEmpty();
    }

    private ReadOnlyDatabase createChildDatabase() throws CacheException {
        ReadOnlyDatabase readOnlyDatabase = this.mConnected ? new ReadOnlyDatabase(this.mAdapter, this.mParentDB, false) : new ReadOnlyDatabase(this.mURL, this.mUser, this.mPassword, this, false);
        readOnlyDatabase.setClassLoader(this.getClassLoader());
        return readOnlyDatabase;
    }

    public void closeObject(int n) throws CacheException {
    }

    public void closeObject(Object object) throws CacheException {
    }

    public void releaseObject(Object object) throws CacheException {
    }

    public boolean isLowLevelConnectionClosed() throws CacheException {
        return false;
    }

    public boolean isLightConnection() {
        return false;
    }

    public int parseStatus(Dataholder dataholder) throws CacheException {
        try {
            int n = dataholder.getIntValue();
            if (n != 0) {
                return n;
            }
        }
        catch (NumberFormatException numberFormatException) {
        }
        catch (CacheException cacheException) {
            // empty catch block
        }
        byte[] byArray = dataholder.getBinary();
        this.connect();
        byte[] byArray2 = this.myAdapter().decomposeStatus(byArray);
        this.disconnect();
        Object object = SysListProxy.createSysList(byArray2, this.mConnectionInfo);
        try {
            Integer n = SysListProxy.getIntegerWrapper(object, 1);
            if (n == null) {
                return 1;
            }
            String string = SysListProxy.getString(object);
            throw new CacheException(string, n);
        }
        catch (SQLException sQLException) {
            throw new SystemError(sQLException, "Failed to decompose status " + object);
        }
    }

    public int parseStatus(StatusCode statusCode) throws CacheException {
        return 0;
    }

    public void createObjects(String string, Collection collection) throws CacheException {
    }

    public void saveObjects(String string, Collection collection) throws CacheException {
    }

    public DatabaseUtilities utilities() {
        return null;
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, Set set) throws CacheException {
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, int n) throws CacheException {
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive) {
    }

    public void registerSensitiveObject(CacheServerSensitive cacheServerSensitive, ObjectHandle objectHandle) throws CacheException {
    }

    public boolean unRegisterSensitiveObject(CacheServerSensitive cacheServerSensitive) throws CacheException {
        return false;
    }

    public void transactionStart() throws CacheException {
    }

    public void transactionCommit() throws CacheException {
    }

    public void transactionRollback() throws CacheException {
    }

    public int getCacheType() throws CacheException {
        return 0;
    }

    public int getNumberOfOpenObjects() {
        return 0;
    }

    public long getServerTime() throws CacheException {
        return 0L;
    }

    public long getServerTime(int n) throws CacheException {
        return 0L;
    }

    public int getNumberOfServerCalls(int n) throws CacheException {
        return 0;
    }

    public int getNumberOfServerCalls() throws CacheException {
        return 0;
    }

    public void setProfileOn(int n) throws CacheException {
    }

    public void resetProfile(int n) throws CacheException {
    }

    public void setProfileOff(int n) throws CacheException {
    }

    public void setConsoleOutput(PrintStream printStream) {
    }

    public void logMetadata(PrintStream printStream) throws Exception {
        printStream.println("Logging netadata content:");
        printStream.println("There are " + this.mOrefs.size() + " objects in cache.");
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (CacheObject object : this.mOrefs.values()) {
            String string = object.getTypeName();
            if (string.endsWith("JavaClassDef")) {
                ++n;
            } else if (string.endsWith("JavaPropDef")) {
                ++n2;
            } else if (string.endsWith("JavaMethodDef")) {
                ++n3;
            } else if (string.endsWith("JavaMtdArgDef")) {
                ++n4;
            }
            Integer n5 = (Integer)hashMap.get(string);
            if (n5 == null) {
                hashMap.put(string, new Integer(1));
                continue;
            }
            hashMap.put(string, new Integer(n5 + 1));
        }
        printStream.println("Classes: " + n);
        printStream.println("Properties: " + n2);
        printStream.println("Methods: " + n3);
        printStream.println("MtdArgDef: " + n4);
        printStream.println("Total different classes: " + hashMap.size());
        for (Map.Entry entry : hashMap.entrySet()) {
            printStream.println(entry.getKey() + " \t" + entry.getValue());
        }
    }

    private CustomMsgDBAdapter myAdapter() {
        if (this.mAdapter != null) {
            return this.mAdapter;
        }
        if (this.mParentDB != null && this.mParentDB instanceof ReadOnlyDatabase) {
            ReadOnlyDatabase readOnlyDatabase = (ReadOnlyDatabase)this.mParentDB;
            if (readOnlyDatabase.mDepth > 0) {
                return readOnlyDatabase.myAdapter();
            }
        }
        return this.mAdapter;
    }
}

