/*
 * Decompiled with CFR 0.152.
 */
package org.h2.expression;

import org.h2.engine.Session;
import org.h2.expression.Comparison;
import org.h2.expression.Expression;
import org.h2.expression.ExpressionVisitor;
import org.h2.expression.ParameterInterface;
import org.h2.expression.ValueExpression;
import org.h2.message.DbException;
import org.h2.table.Column;
import org.h2.table.ColumnResolver;
import org.h2.table.TableFilter;
import org.h2.value.Value;
import org.h2.value.ValueBoolean;
import org.h2.value.ValueNull;

public class Parameter
extends Expression
implements ParameterInterface {
    private Value value;
    private Column column;
    private int index;

    public Parameter(int n) {
        this.index = n;
    }

    public String getSQL() {
        return "?" + (this.index + 1);
    }

    public void setValue(Value value, boolean bl) {
        this.value = value;
    }

    public void setValue(Value value) {
        this.value = value;
    }

    public Value getParamValue() {
        if (this.value == null) {
            return ValueNull.INSTANCE;
        }
        return this.value;
    }

    public Value getValue(Session session) {
        return this.getParamValue();
    }

    public int getType() {
        if (this.value != null) {
            return this.value.getType();
        }
        if (this.column != null) {
            return this.column.getType();
        }
        return -1;
    }

    public void mapColumns(ColumnResolver columnResolver, int n) {
    }

    public void checkSet() {
        if (this.value == null) {
            throw DbException.get(90012, "#" + (this.index + 1));
        }
    }

    public Expression optimize(Session session) {
        return this;
    }

    public boolean isConstant() {
        return false;
    }

    public boolean isValueSet() {
        return this.value != null;
    }

    public void setEvaluatable(TableFilter tableFilter, boolean bl) {
    }

    public int getScale() {
        if (this.value != null) {
            return this.value.getScale();
        }
        if (this.column != null) {
            return this.column.getScale();
        }
        return 0;
    }

    public long getPrecision() {
        if (this.value != null) {
            return this.value.getPrecision();
        }
        if (this.column != null) {
            return this.column.getPrecision();
        }
        return 0L;
    }

    public int getDisplaySize() {
        if (this.value != null) {
            return this.value.getDisplaySize();
        }
        if (this.column != null) {
            return this.column.getDisplaySize();
        }
        return 0;
    }

    public void updateAggregate(Session session) {
    }

    public boolean isEverything(ExpressionVisitor expressionVisitor) {
        switch (expressionVisitor.getType()) {
            case 1: {
                return true;
            }
            case 2: 
            case 5: {
                return true;
            }
            case 0: {
                return this.value != null;
            }
            case 3: {
                return true;
            }
            case 4: {
                return true;
            }
            case 6: {
                return true;
            }
            case 7: {
                return true;
            }
        }
        throw DbException.throwInternalError("type=" + expressionVisitor.getType());
    }

    public int getCost() {
        return 0;
    }

    public Expression getNotIfPossible(Session session) {
        return new Comparison(session, 0, this, ValueExpression.get(ValueBoolean.get(false)));
    }

    public void setColumn(Column column) {
        this.column = column;
    }

    public int getIndex() {
        return this.index;
    }
}

