/*
 * Copyright 2021 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.keycloak.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author Vaclav Muzikar <vmuzikar@redhat.com>
 */
public class SearchQueryUtils {
    public static final Pattern queryPattern = Pattern.compile("\\s*(?:(?<name>[^: ]+):)(?:(?<value>[^\"][^ ]*)|\"(?<escaped>(?:\\\\.|[^\\\\\"])+)\")\\s*");

    public static Map<String, String> getFields(final String query) {
        Matcher matcher = queryPattern.matcher(query);
        Map<String, String> ret = new HashMap<>();
        while (matcher.find()) {
            String value;
            if (matcher.group("escaped") != null) {
                value = matcher.group("escaped").replaceAll("\\\\(.)", "$1");
            }
            else {
                value = matcher.group("value");
            }

            ret.put(matcher.group("name"), value);
        }
        return ret;
    }
}
