/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jk.status;

import java.util.List;
import org.apache.catalina.ant.BaseRedirectorHelperTask;
import org.apache.jk.status.JkBalancer;
import org.apache.jk.status.JkBalancerMapping;
import org.apache.jk.status.JkBalancerMember;
import org.apache.jk.status.JkResult;
import org.apache.jk.status.JkServer;
import org.apache.jk.status.JkSoftware;
import org.apache.jk.status.JkStatus;
import org.apache.jk.status.JkStatusAccessor;
import org.apache.tomcat.util.IntrospectionUtils;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class JkStatusTask
extends BaseRedirectorHelperTask {
    private static final String info = "org.apache.jk.status.JkStatusTask/1.2";
    protected String resultproperty;
    protected boolean echo = false;
    protected String password = null;
    protected String url = "http://localhost:80/jkstatus";
    protected String username = null;
    private String errorProperty;
    private String worker;
    private String loadbalancer;

    public String getInfo() {
        return info;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public boolean isEcho() {
        return this.echo;
    }

    public void setEcho(boolean echo) {
        this.echo = echo;
    }

    public String getResultproperty() {
        return this.resultproperty;
    }

    public void setResultproperty(String resultproperty) {
        this.resultproperty = resultproperty;
    }

    public String getLoadbalancer() {
        return this.loadbalancer;
    }

    public void setLoadbalancer(String loadbalancer) {
        this.loadbalancer = loadbalancer;
    }

    public String getWorker() {
        return this.worker;
    }

    public void setWorker(String worker) {
        this.worker = worker;
    }

    public void execute() throws BuildException {
        if (this.url == null) {
            throw new BuildException("Must specify an 'url'");
        }
        boolean isWorkerOnly = this.worker != null && !"".equals(this.worker);
        boolean isLoadbalancerOnly = this.loadbalancer != null && !"".equals(this.loadbalancer);
        StringBuffer error = new StringBuffer();
        try {
            JkStatusAccessor accessor = new JkStatusAccessor();
            JkStatus status = accessor.status(this.url, this.username, this.password);
            if (status.result != null && !"OK".equals(status.result.type)) {
                if (this.getErrorProperty() != null) {
                    this.getProject().setNewProperty(this.errorProperty, status.result.message);
                }
                if (this.isFailOnError()) {
                    throw new BuildException(status.result.message);
                }
                this.handleErrorOutput(status.result.message);
                return;
            }
            if (!isWorkerOnly && !isLoadbalancerOnly) {
                JkServer server = status.getServer();
                JkSoftware software = status.getSoftware();
                JkResult result = status.getResult();
                if (this.resultproperty != null) {
                    this.createProperty(server, "server", "name");
                    this.createProperty(server, "server", "port");
                    this.createProperty(software, "web_server");
                    this.createProperty(software, "jk_version");
                    this.createProperty(result, "result", "type");
                    this.createProperty(result, "result", "message");
                }
                if (this.isEcho()) {
                    this.handleOutput("server name=" + server.getName() + ":" + server.getPort() + " - " + software.getWeb_server() + " - " + software.getJk_version());
                }
            }
            List balancers = status.getBalancers();
            for (JkBalancer balancer : balancers) {
                String balancerIndex = null;
                if (isLoadbalancerOnly) {
                    if (!this.loadbalancer.equals(balancer.getName())) continue;
                    if (this.resultproperty != null) {
                        this.setPropertyBalancerOnly(balancer);
                    }
                    this.echoBalancer(balancer);
                    return;
                }
                if (!isWorkerOnly) {
                    if (this.resultproperty != null) {
                        balancerIndex = balancer.getId() >= 0 ? Integer.toString(balancer.getId()) : balancer.getName();
                        this.setPropertyBalancer(balancer, balancerIndex);
                    }
                    this.echoBalancer(balancer);
                }
                List members = balancer.getBalancerMembers();
                for (JkBalancerMember member : members) {
                    if (isWorkerOnly) {
                        if (!this.worker.equals(member.getName())) continue;
                        if (this.resultproperty != null) {
                            this.setPropertyWorkerOnly(balancer, member);
                        }
                        this.echoWorker(member);
                        return;
                    }
                    if (this.resultproperty != null) {
                        this.setPropertyWorker(null, member);
                    }
                    this.echoWorker(member);
                    if (member.getStatus() != null && !"OK".equals(member.getStatus())) {
                        error.append(" worker name=" + member.getName() + " status=" + member.getStatus() + " host=" + member.getAddress());
                    }
                    if (member.getState() == null || "OK".equals(member.getState()) || "N/A".equals(member.getState())) continue;
                    error.append(" worker name=" + member.getName() + " state=" + member.getState() + " host=" + member.getAddress());
                }
                if (isWorkerOnly) continue;
                if (this.resultproperty != null && members.size() > 0) {
                    this.getProject().setNewProperty(this.resultproperty + "." + balancer.getName() + ".length", Integer.toString(members.size()));
                }
                List mappings = balancer.getBalancerMappings();
                int j = 0;
                String mapIndex = balancerIndex != null ? balancerIndex + ".map" : "map";
                for (JkBalancerMapping mapping : mappings) {
                    if (this.resultproperty != null) {
                        String stringIndex2 = mapping.getId() >= 0 ? Integer.toString(mapping.getId()) : Integer.toString(j);
                        this.createProperty(mapping, mapIndex, stringIndex2, "type");
                        this.createProperty(mapping, mapIndex, stringIndex2, "uri");
                        this.createProperty(mapping, mapIndex, stringIndex2, "context");
                        this.createProperty(mapping, mapIndex, stringIndex2, "source");
                    }
                    if (this.isEcho()) {
                        String mappingOut = mapping.source != null ? "balancer name=" + balancer.getName() + " mappingtype=" + mapping.getType() + " uri=" + mapping.getUri() + " source=" + mapping.getSource() : "balancer name=" + balancer.getName() + " mappingtype=" + mapping.getType() + " uri=" + mapping.getUri() + " context=" + mapping.getContext();
                        this.handleOutput(mappingOut);
                    }
                    ++j;
                }
                if (this.resultproperty == null || mappings.size() <= 0) continue;
                this.getProject().setNewProperty(this.resultproperty + "." + mapIndex + ".length", Integer.toString(mappings.size()));
            }
            if (!isWorkerOnly && !isLoadbalancerOnly && this.resultproperty != null && balancers.size() > 0) {
                this.getProject().setNewProperty(this.resultproperty + ".length", Integer.toString(balancers.size()));
            }
        }
        catch (Throwable t) {
            error.append(t.getMessage());
            if (this.getErrorProperty() != null) {
                this.getProject().setNewProperty(this.errorProperty, error.toString());
            }
            if (this.isFailOnError()) {
                throw new BuildException(t);
            }
            this.handleErrorOutput(t.getMessage());
            return;
        }
        if (error.length() != 0) {
            if (this.getErrorProperty() != null) {
                this.getProject().setNewProperty(this.errorProperty, error.toString());
            }
            if (this.isFailOnError()) {
                throw new BuildException(error.toString());
            }
        }
    }

    private void echoWorker(JkBalancerMember member) {
        if (this.isEcho()) {
            StringBuffer state = new StringBuffer("worker name=");
            state.append(member.getName());
            if (member.getStatus() != null) {
                state.append(" status=");
                state.append(member.getStatus());
            }
            if (member.getState() != null) {
                state.append(" state=");
                state.append(member.getState());
            }
            state.append(" host=");
            state.append(member.getAddress());
            this.handleOutput(state.toString());
        }
    }

    private void echoBalancer(JkBalancer balancer) {
        if (this.isEcho()) {
            this.handleOutput("balancer name=" + balancer.getName() + " type=" + balancer.getType());
        }
    }

    private void setPropertyBalancerOnly(JkBalancer balancer) {
        String prefix = this.resultproperty + "." + balancer.getName();
        if (balancer.getId() >= 0) {
            this.getProject().setNewProperty(prefix + ".id", Integer.toString(balancer.getId()));
        }
        this.getProject().setNewProperty(prefix + ".type", balancer.getType());
        this.getProject().setNewProperty(prefix + ".stick_session", Boolean.toString(balancer.isSticky_session()));
        this.getProject().setNewProperty(prefix + ".sticky_session_force", Boolean.toString(balancer.isSticky_session_force()));
        this.getProject().setNewProperty(prefix + ".retries", Integer.toString(balancer.getRetries()));
        this.getProject().setNewProperty(prefix + ".recover_time", Integer.toString(balancer.getRecover_time()));
        this.getProject().setNewProperty(prefix + ".method", balancer.getMethod());
        this.getProject().setNewProperty(prefix + ".good", Integer.toString(balancer.getGood()));
        this.getProject().setNewProperty(prefix + ".degraded", Integer.toString(balancer.getDegraded()));
        this.getProject().setNewProperty(prefix + ".bad", Integer.toString(balancer.getBad()));
        this.getProject().setNewProperty(prefix + ".busy", Integer.toString(balancer.getBusy()));
        this.getProject().setNewProperty(prefix + ".map_count", Integer.toString(balancer.getMap_count()));
        this.getProject().setNewProperty(prefix + ".member_count", Integer.toString(balancer.getMember_count()));
        this.getProject().setNewProperty(prefix + ".max_busy", Integer.toString(balancer.getMax_busy()));
        this.getProject().setNewProperty(prefix + ".time_to_maintenance_min", Integer.toString(balancer.getTime_to_maintenance_min()));
        this.getProject().setNewProperty(prefix + ".time_to_maintenance_max", Integer.toString(balancer.getTime_to_maintenance_max()));
        this.getProject().setNewProperty(prefix + ".lock", balancer.getLock());
    }

    private void setPropertyBalancer(JkBalancer balancer, String balancerIndex) {
        if (balancer.id >= 0) {
            this.createProperty(balancer, balancerIndex, "id");
        }
        this.createProperty(balancer, balancerIndex, "name");
        this.createProperty(balancer, balancerIndex, "type");
        this.createProperty(balancer, balancerIndex, "sticky_session");
        this.createProperty(balancer, balancerIndex, "sticky_session_force");
        this.createProperty(balancer, balancerIndex, "retries");
        this.createProperty(balancer, balancerIndex, "recover_time");
        if (balancer.getMethod() != null) {
            this.createProperty(balancer, balancerIndex, "method");
        }
        if (balancer.getLock() != null) {
            this.createProperty(balancer, balancerIndex, "lock");
        }
        if (balancer.getGood() >= 0) {
            this.createProperty(balancer, balancerIndex, "good");
        }
        if (balancer.getDegraded() >= 0) {
            this.createProperty(balancer, balancerIndex, "degraded");
        }
        if (balancer.getBad() >= 0) {
            this.createProperty(balancer, balancerIndex, "bad");
        }
        if (balancer.getBusy() >= 0) {
            this.createProperty(balancer, balancerIndex, "busy");
        }
        if (balancer.getMax_busy() >= 0) {
            this.createProperty(balancer, balancerIndex, "max_busy");
        }
        if (balancer.getMember_count() >= 0) {
            this.createProperty(balancer, balancerIndex, "member_count");
        }
        if (balancer.getMap_count() >= 0) {
            this.createProperty(balancer, balancerIndex, "map_count");
        }
        if (balancer.getTime_to_maintenance_min() >= 0) {
            this.createProperty(balancer, balancerIndex, "time_to_maintenance_min");
        }
        if (balancer.getTime_to_maintenance_max() >= 0) {
            this.createProperty(balancer, balancerIndex, "time_to_maintenance_max");
        }
    }

    private void setPropertyWorker(String balancerIndex, JkBalancerMember member) {
        String workerIndex;
        if (member.getId() >= 0) {
            workerIndex = Integer.toString(member.getId());
            this.createProperty(member, balancerIndex, workerIndex, "id");
            this.createProperty(member, balancerIndex, workerIndex, "name");
        } else {
            workerIndex = member.getName();
        }
        this.createProperty(member, balancerIndex, workerIndex, "type");
        this.createProperty(member, balancerIndex, workerIndex, "host");
        this.createProperty(member, balancerIndex, workerIndex, "port");
        this.createProperty(member, balancerIndex, workerIndex, "address");
        if (member.getJvm_route() != null) {
            this.createProperty(member, balancerIndex, workerIndex, "jvm_route");
        }
        if (member.getRoute() != null) {
            this.createProperty(member, balancerIndex, workerIndex, "route");
        }
        if (member.getStatus() != null) {
            this.createProperty(member, balancerIndex, workerIndex, "status");
        }
        if (member.getActivation() != null) {
            this.createProperty(member, balancerIndex, workerIndex, "activation");
        }
        if (member.getState() != null) {
            this.createProperty(member, balancerIndex, workerIndex, "state");
        }
        this.createProperty(member, balancerIndex, workerIndex, "lbfactor");
        this.createProperty(member, balancerIndex, workerIndex, "lbvalue");
        if (member.getLbmult() >= 0L) {
            this.createProperty(member, balancerIndex, workerIndex, "lbmult");
        }
        this.createProperty(member, balancerIndex, workerIndex, "elected");
        this.createProperty(member, balancerIndex, workerIndex, "readed");
        this.createProperty(member, balancerIndex, workerIndex, "busy");
        if (member.getMax_busy() >= 0) {
            this.createProperty(member, balancerIndex, workerIndex, "max_busy");
        }
        this.createProperty(member, balancerIndex, workerIndex, "transferred");
        this.createProperty(member, balancerIndex, workerIndex, "errors");
        if (member.getClient_errors() >= 0L) {
            this.createProperty(member, balancerIndex, workerIndex, "client_errors");
        }
        if (member.getDistance() >= 0) {
            this.createProperty(member, balancerIndex, workerIndex, "distance");
        }
        if (member.getDomain() != null) {
            this.createProperty(member, balancerIndex, workerIndex, "domain");
        } else {
            this.getProject().setNewProperty(this.resultproperty + "." + balancerIndex + "." + workerIndex + ".domain", "");
        }
        if (member.getRedirect() != null) {
            this.createProperty(member, balancerIndex, workerIndex, "redirect");
        } else {
            this.getProject().setNewProperty(this.resultproperty + "." + balancerIndex + "." + workerIndex + ".redirect", "");
        }
    }

    private void setPropertyWorkerOnly(JkBalancer balancer, JkBalancerMember member) {
        String prefix = this.resultproperty + "." + member.getName();
        Project currentProject = this.getProject();
        if (balancer.getId() >= 0) {
            currentProject.setNewProperty(prefix + ".lb.id", Integer.toString(balancer.getId()));
        }
        if (member.getId() >= 0) {
            currentProject.setNewProperty(prefix + ".id", Integer.toString(member.getId()));
        }
        currentProject.setNewProperty(prefix + ".type", member.getType());
        if (member.getJvm_route() != null) {
            currentProject.setNewProperty(prefix + ".jvm_route", member.getJvm_route());
        }
        if (member.getRoute() != null) {
            currentProject.setNewProperty(prefix + ".route", member.getRoute());
        }
        if (member.getStatus() != null) {
            currentProject.setNewProperty(prefix + ".status", member.getStatus());
        }
        if (member.getActivation() != null) {
            currentProject.setNewProperty(prefix + ".activation", member.getActivation());
        }
        if (member.getState() != null) {
            currentProject.setNewProperty(prefix + ".state", member.getState());
        }
        currentProject.setNewProperty(prefix + ".host", member.getHost());
        currentProject.setNewProperty(prefix + ".address", member.getAddress());
        currentProject.setNewProperty(prefix + ".port", Integer.toString(member.getPort()));
        currentProject.setNewProperty(prefix + ".lbfactor", Integer.toString(member.getLbfactor()));
        currentProject.setNewProperty(prefix + ".lbvalue", Long.toString(member.getLbvalue()));
        if (member.getLbmult() >= 0L) {
            currentProject.setNewProperty(prefix + ".lbmult", Long.toString(member.getLbmult()));
        }
        currentProject.setNewProperty(prefix + ".elected", Long.toString(member.getElected()));
        currentProject.setNewProperty(prefix + ".readed", Long.toString(member.getReaded()));
        currentProject.setNewProperty(prefix + ".transferred", Long.toString(member.getTransferred()));
        currentProject.setNewProperty(prefix + ".busy", Integer.toString(member.getBusy()));
        if (member.getMax_busy() >= 0) {
            currentProject.setNewProperty(prefix + ".max_busy", Long.toString(member.getMax_busy()));
        }
        currentProject.setNewProperty(prefix + ".errors", Long.toString(member.getErrors()));
        if (member.getClient_errors() >= 0L) {
            currentProject.setNewProperty(prefix + ".client_errors", Long.toString(member.getClient_errors()));
        }
        if (member.getDistance() >= 0) {
            currentProject.setNewProperty(prefix + ".distance", Integer.toString(member.getDistance()));
        }
        if (member.getDomain() != null) {
            currentProject.setNewProperty(prefix + ".domain", member.getDomain());
        } else {
            currentProject.setNewProperty(prefix + ".domain", "");
        }
        if (member.getRedirect() != null) {
            currentProject.setNewProperty(prefix + ".redirect", member.getRedirect());
        } else {
            currentProject.setNewProperty(prefix + ".redirect", "");
        }
        if (member.getTime_to_recover() >= 0) {
            currentProject.setNewProperty(prefix + ".time_to_recover", Integer.toString(member.getTime_to_recover()));
        }
        if (member.getTime_to_recover_min() >= 0) {
            currentProject.setNewProperty(prefix + ".time_to_recover_min", Integer.toString(member.getTime_to_recover_min()));
        }
        if (member.getTime_to_recover_max() >= 0) {
            currentProject.setNewProperty(prefix + ".time_to_recover_max", Integer.toString(member.getTime_to_recover_max()));
            currentProject.setNewProperty(prefix + ".time_to_recover", Integer.toString((member.getTime_to_recover_min() + member.getTime_to_recover_max()) / 2));
        }
    }

    public void setErrorProperty(String arg0) {
        this.errorProperty = arg0;
        super.setErrorProperty(arg0);
    }

    public String getErrorProperty() {
        return this.errorProperty;
    }

    protected void createProperty(Object result, String attribute) {
        this.createProperty(result, null, null, attribute);
    }

    protected void createProperty(Object result, String arraymark, String attribute) {
        this.createProperty(result, arraymark, null, attribute);
    }

    protected void createProperty(Object result, String arraymark, String arraymark2, String attribute) {
        Object value;
        if (this.resultproperty != null && (value = IntrospectionUtils.getProperty((Object)result, (String)attribute)) != null) {
            StringBuffer propertyname = new StringBuffer(this.resultproperty);
            if (result instanceof JkBalancer) {
                if (arraymark != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark);
                }
            } else if (result instanceof JkServer) {
                if (arraymark != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark);
                }
            } else if (result instanceof JkSoftware) {
                if (arraymark != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark);
                }
            } else if (result instanceof JkResult) {
                if (arraymark != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark);
                }
            } else if (result instanceof JkBalancerMember) {
                if (arraymark != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark);
                }
                if (arraymark2 != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark2);
                }
            } else if (result instanceof JkBalancerMapping) {
                if (arraymark != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark);
                }
                if (arraymark2 != null) {
                    propertyname.append(".");
                    propertyname.append(arraymark2);
                }
            }
            propertyname.append(".");
            propertyname.append(attribute);
            this.getProject().setNewProperty(propertyname.toString(), value.toString());
        }
    }
}

