/*
 * Decompiled with CFR 0.152.
 */
package org.apache.taglibs.standard.tag.common.core;

import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.tagext.BodyTagSupport;
import org.apache.taglibs.standard.resources.Resources;
import org.apache.taglibs.standard.tag.common.core.ImportSupport;
import org.apache.taglibs.standard.tag.common.core.ParamParent;
import org.apache.taglibs.standard.tag.common.core.ParamSupport;
import org.apache.taglibs.standard.tag.common.core.Util;

public abstract class UrlSupport
extends BodyTagSupport
implements ParamParent {
    protected String value;
    protected String context;
    private String var;
    private int scope;
    private ParamSupport.ParamManager params;

    public UrlSupport() {
        this.init();
    }

    private void init() {
        this.var = null;
        this.value = null;
        this.params = null;
        this.context = null;
        this.scope = 1;
    }

    public void setVar(String string) {
        this.var = string;
    }

    public void setScope(String string) {
        this.scope = Util.getScope(string);
    }

    public void addParameter(String string, String string2) {
        this.params.addParameter(string, string2);
    }

    public int doStartTag() throws JspException {
        this.params = new ParamSupport.ParamManager();
        return 2;
    }

    public int doEndTag() throws JspException {
        String string = UrlSupport.resolveUrl(this.value, this.context, this.pageContext);
        String string2 = this.params.aggregateParams(string);
        if (!ImportSupport.isAbsoluteUrl(string2)) {
            HttpServletResponse httpServletResponse = (HttpServletResponse)this.pageContext.getResponse();
            string2 = httpServletResponse.encodeURL(string2);
        }
        if (this.var != null) {
            this.pageContext.setAttribute(this.var, (Object)string2, this.scope);
        } else {
            try {
                this.pageContext.getOut().print(string2);
            }
            catch (IOException iOException) {
                throw new JspTagException(iOException.toString(), (Throwable)iOException);
            }
        }
        return 6;
    }

    public void release() {
        this.init();
    }

    public static String resolveUrl(String string, String string2, PageContext pageContext) throws JspException {
        if (ImportSupport.isAbsoluteUrl(string)) {
            return string;
        }
        HttpServletRequest httpServletRequest = (HttpServletRequest)pageContext.getRequest();
        if (string2 == null) {
            if (string.startsWith("/")) {
                return httpServletRequest.getContextPath() + string;
            }
            return string;
        }
        if (!string2.startsWith("/") || !string.startsWith("/")) {
            throw new JspTagException(Resources.getMessage("IMPORT_BAD_RELATIVE"));
        }
        if (string2.equals("/")) {
            return string;
        }
        return string2 + string;
    }
}

