/*
 * Decompiled with CFR 0.152.
 */
package mx4j.tools.i18n;

import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanConstructorInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;

public class I18NStandardMBean
extends StandardMBean {
    private static final String IDPROP_DEFAULT_LOCALE = "mx4j.descriptionLocale";
    private static final String RESOURCE_SUFFIX = "MBeanResources";
    private static final String KEY_DESCR = "descr";
    private static final String KEY_CONS = "cons";
    private static final String KEY_ATTR = "attr";
    private static final String KEY_OP = "op";
    private static final String KEY_PARAM = "param";
    private static final String KEY_PARAM_NAME = "paramName";
    private static final String KEY_SIG = "sig";
    private static Locale g_defaultLocale = null;
    private NestedResourceBundle m_bundle;
    private Map m_mapConstructorSignatureToResourceIndex;
    private Map m_mapConstructorParamCountToResourceIndex;
    private Map m_mapConstructorToResourceIndex = new HashMap();
    private Map m_mapOperationNameToSignatures = new HashMap();
    private Map m_mapOperationNameToParamCounts = new HashMap();
    private Set m_setAmbiguousConstructors = new HashSet();
    private Set m_setAmbiguousOperations = new HashSet();

    public I18NStandardMBean(Object implementation, Class mbeanInterface) throws NotCompliantMBeanException {
        this(implementation, mbeanInterface, null);
    }

    public I18NStandardMBean(Object implementation, Class mbeanInterface, Locale locale) throws NotCompliantMBeanException {
        super(implementation, mbeanInterface);
        this.setupBundle(implementation, locale);
    }

    protected I18NStandardMBean(Class mbeanInterface) throws NotCompliantMBeanException {
        super(mbeanInterface);
        this.setupBundle(this, null);
    }

    protected I18NStandardMBean(Class mbeanInterface, Locale locale) throws NotCompliantMBeanException {
        super(mbeanInterface);
        this.setupBundle(this, locale);
    }

    private void setupBundle(Object implementation, Locale locale) {
        if (locale == null) {
            locale = g_defaultLocale;
        }
        if (locale == null) {
            locale = this.getLocaleFromSystemProperties();
        }
        NestedResourceBundle cur = null;
        Throwable ex = null;
        for (Class<?> c = implementation.getClass(); c != null; c = c.getSuperclass()) {
            String bundleName = c.getName() + RESOURCE_SUFFIX;
            try {
                ResourceBundle b = ResourceBundle.getBundle(bundleName, locale);
                NestedResourceBundle nb = new NestedResourceBundle(b);
                if (cur == null) {
                    this.m_bundle = nb;
                } else {
                    cur.setParent(nb);
                }
                cur = nb;
                continue;
            }
            catch (MissingResourceException e) {
                if (this.m_bundle != null) continue;
                ex = e;
            }
        }
        if (this.m_bundle == null) {
            ex.fillInStackTrace();
            throw ex;
        }
    }

    private Locale getLocaleFromSystemProperties() {
        Locale locale = Locale.getDefault();
        String stdLocale = System.getProperty(IDPROP_DEFAULT_LOCALE);
        if (stdLocale != null && stdLocale.length() > 0) {
            StringTokenizer st = new StringTokenizer(stdLocale, "_");
            switch (st.countTokens()) {
                case 2: {
                    locale = new Locale(st.nextToken(), st.nextToken());
                    break;
                }
                case 3: {
                    locale = new Locale(st.nextToken(), st.nextToken(), st.nextToken());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid locale in mx4j.descriptionLocale:" + stdLocale);
                }
            }
        }
        return locale;
    }

    public static void setDefaultLocale(Locale locale) {
        g_defaultLocale = locale;
    }

    @Override
    protected MBeanInfo getCachedMBeanInfo() {
        MBeanInfo info = super.getCachedMBeanInfo();
        if (info == null) {
            this.m_mapConstructorToResourceIndex = new HashMap();
            this.m_mapOperationNameToSignatures = new HashMap();
            this.m_mapOperationNameToParamCounts = new HashMap();
            this.m_setAmbiguousConstructors = new HashSet();
            this.m_setAmbiguousOperations = new HashSet();
            this.m_mapConstructorSignatureToResourceIndex = this.getSignatureMap(KEY_CONS);
            this.m_mapConstructorParamCountToResourceIndex = this.getParamCountMap(KEY_CONS);
        }
        return info;
    }

    @Override
    protected void cacheMBeanInfo(MBeanInfo info) {
        super.cacheMBeanInfo(info);
        this.m_mapConstructorToResourceIndex = null;
        this.m_mapOperationNameToSignatures = null;
        this.m_mapOperationNameToParamCounts = null;
        this.m_setAmbiguousConstructors = null;
        this.m_setAmbiguousOperations = null;
        this.m_mapConstructorSignatureToResourceIndex = null;
        this.m_mapConstructorParamCountToResourceIndex = null;
    }

    @Override
    protected MBeanConstructorInfo[] getConstructors(MBeanConstructorInfo[] cstrs, Object impl) {
        HashMap<Integer, MBeanConstructorInfo> argCountToCstr = new HashMap<Integer, MBeanConstructorInfo>();
        for (int i = 0; i < cstrs.length; ++i) {
            MBeanConstructorInfo ci = cstrs[i];
            MBeanParameterInfo[] params = ci.getSignature();
            Integer count = new Integer(params.length);
            Object first = argCountToCstr.get(count);
            if (first != null) {
                this.m_setAmbiguousConstructors.add(first);
                this.m_setAmbiguousConstructors.add(ci);
            } else {
                argCountToCstr.put(count, ci);
            }
            String sig = this.makeSignatureString(params);
            Integer idx = (Integer)this.m_mapConstructorSignatureToResourceIndex.get(sig);
            if (idx == null) continue;
            this.m_mapConstructorToResourceIndex.put(ci, idx);
        }
        return super.getConstructors(cstrs, impl);
    }

    @Override
    protected String getDescription(MBeanInfo info) {
        this.findAmbiguousOperations(info);
        return this.getValueFromBundle(KEY_DESCR);
    }

    @Override
    protected String getDescription(MBeanConstructorInfo cstr) {
        int idx = this.getConstructorIndex(cstr);
        if (idx < 1) {
            return "ambiguous constructor";
        }
        return this.getValueFromBundle("cons." + idx);
    }

    @Override
    protected String getDescription(MBeanConstructorInfo cstr, MBeanParameterInfo param, int seq) {
        int idx = this.getConstructorIndex(cstr);
        if (idx < 1) {
            return "parameter for ambiguous constructor";
        }
        return this.getValueFromBundle("cons." + idx + ".param." + (seq + 1));
    }

    @Override
    protected String getParameterName(MBeanConstructorInfo cstr, MBeanParameterInfo param, int seq) {
        int idx = this.getConstructorIndex(cstr);
        String name = null;
        if (idx >= 1) {
            name = this.getValueOrNullFromBundle("cons." + idx + ".paramName." + (seq + 1));
        }
        if (name == null) {
            name = super.getParameterName(cstr, param, seq);
        }
        return name;
    }

    @Override
    protected String getDescription(MBeanAttributeInfo attr) {
        return this.getValueFromBundle("attr." + attr.getName());
    }

    @Override
    protected String getDescription(MBeanOperationInfo op) {
        try {
            return this.getValueFromBundle(this.getOperationKey(op));
        }
        catch (IllegalStateException e) {
            return e.getMessage();
        }
    }

    @Override
    protected String getDescription(MBeanOperationInfo op, MBeanParameterInfo param, int seq) {
        try {
            return this.getValueFromBundle(this.getOperationKey(op) + "." + KEY_PARAM + "." + (seq + 1));
        }
        catch (IllegalStateException e) {
            return "parameter for " + e.getMessage();
        }
    }

    @Override
    protected String getParameterName(MBeanOperationInfo op, MBeanParameterInfo param, int seq) {
        String name = null;
        try {
            name = this.getValueOrNullFromBundle(this.getOperationKey(op) + "." + KEY_PARAM_NAME + "." + (seq + 1));
        }
        catch (IllegalStateException e) {
            // empty catch block
        }
        if (name == null) {
            name = super.getParameterName(op, param, seq);
        }
        return name;
    }

    private int getConstructorIndex(MBeanConstructorInfo cons) {
        Integer idx = (Integer)this.m_mapConstructorToResourceIndex.get(cons);
        if (idx != null) {
            return idx;
        }
        if (this.m_setAmbiguousConstructors.contains(cons)) {
            return -1;
        }
        int nbParams = cons.getSignature().length;
        idx = (Integer)this.m_mapConstructorParamCountToResourceIndex.get(new Integer(nbParams));
        if (idx != null) {
            return idx;
        }
        return 0;
    }

    private String getOperationKey(MBeanOperationInfo op) {
        String operationName = op.getName();
        Map sigMap = this.getOperationSignatureMap(operationName);
        MBeanParameterInfo[] params = op.getSignature();
        String sig = this.makeSignatureString(params);
        Integer idx = (Integer)sigMap.get(sig);
        StringBuffer sbRet = new StringBuffer("op.");
        sbRet.append(operationName);
        if (idx == null) {
            if (this.m_setAmbiguousOperations.contains(op)) {
                throw new IllegalStateException("ambiguous operation");
            }
            Map countMap = this.getOperationParamCountMap(operationName);
            idx = (Integer)countMap.get(new Integer(params.length));
            if (idx != null && idx < 1) {
                throw new IllegalStateException("ambiguous operation");
            }
        }
        if (idx != null) {
            sbRet.append(".");
            sbRet.append(idx);
        }
        return sbRet.toString();
    }

    private void findAmbiguousOperations(MBeanInfo info) {
        MBeanOperationInfo[] ops = info.getOperations();
        HashMap mapNameToArgCountMap = new HashMap();
        for (int i = 0; i < ops.length; ++i) {
            Integer count;
            Object first;
            MBeanOperationInfo op = ops[i];
            String name = op.getName();
            HashMap<Integer, MBeanOperationInfo> argCountToOp = (HashMap<Integer, MBeanOperationInfo>)mapNameToArgCountMap.get(name);
            if (argCountToOp == null) {
                argCountToOp = new HashMap<Integer, MBeanOperationInfo>();
                mapNameToArgCountMap.put(name, argCountToOp);
            }
            if ((first = argCountToOp.get(count = new Integer(op.getSignature().length))) != null) {
                this.m_setAmbiguousOperations.add(first);
                this.m_setAmbiguousOperations.add(op);
                continue;
            }
            argCountToOp.put(count, op);
        }
    }

    private Map getOperationSignatureMap(String operationName) {
        Map m = (Map)this.m_mapOperationNameToSignatures.get(operationName);
        if (m != null) {
            return m;
        }
        m = this.getSignatureMap("op." + operationName);
        this.m_mapOperationNameToSignatures.put(operationName, m);
        return m;
    }

    private Map getOperationParamCountMap(String operationName) {
        Map m = (Map)this.m_mapOperationNameToParamCounts.get(operationName);
        if (m != null) {
            return m;
        }
        m = this.getParamCountMap("op." + operationName);
        this.m_mapOperationNameToParamCounts.put(operationName, m);
        return m;
    }

    private Map getParamCountMap(String prefix) {
        String key;
        String sig;
        HashMap<Integer, Integer> m = new HashMap<Integer, Integer>();
        int i = 1;
        while ((sig = this.getValueOrNullFromBundle(key = prefix + "." + i)) != null) {
            int nb = 0;
            int j = 1;
            while (this.getValueOrNullFromBundle(key = prefix + "." + i + "." + KEY_PARAM + "." + j) != null) {
                nb = j++;
            }
            Integer nbObj = new Integer(nb);
            int idx = m.containsKey(nbObj) ? -1 : i;
            m.put(nbObj, new Integer(idx));
            ++i;
        }
        return m;
    }

    private Map getSignatureMap(String prefix) {
        String key;
        String sig;
        HashMap<String, Integer> m = new HashMap<String, Integer>();
        int i = 1;
        while ((sig = this.getValueOrNullFromBundle(key = prefix + "." + i + "." + KEY_SIG)) != null) {
            m.put(sig, new Integer(i));
            ++i;
        }
        return m;
    }

    private String makeSignatureString(MBeanParameterInfo[] params) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(params[i].getType());
        }
        return sb.toString();
    }

    private String getValueFromBundle(String key) {
        String value;
        try {
            value = this.m_bundle.getString(key);
        }
        catch (MissingResourceException e) {
            value = "??(" + key + ")";
        }
        return value;
    }

    private String getValueOrNullFromBundle(String key) {
        String value = null;
        try {
            value = this.m_bundle.getString(key);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return value;
    }

    private static class NestedResourceBundle
    extends ResourceBundle {
        private ResourceBundle _impl;

        NestedResourceBundle(ResourceBundle impl) {
            this._impl = impl;
        }

        void setParent(NestedResourceBundle parent) {
            super.setParent(parent);
        }

        @Override
        protected Object handleGetObject(String key) {
            try {
                return this._impl.getString(key);
            }
            catch (MissingResourceException e) {
                return null;
            }
        }

        public Enumeration getKeys() {
            HashSet hs = new HashSet();
            this.addEnumeration(hs, this._impl.getKeys());
            if (this.parent != null) {
                this.addEnumeration(hs, this.parent.getKeys());
            }
            return Collections.enumeration(hs);
        }

        private void addEnumeration(Collection col, Enumeration e) {
            while (e.hasMoreElements()) {
                col.add(e.nextElement());
            }
        }
    }
}

