/*
 * Decompiled with CFR 0.152.
 */
package mx4j.log;

import javax.management.ListenerNotFoundException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.log.LoggerBroadcasterMBean;

public class LoggerBroadcaster
extends NotificationBroadcasterSupport
implements MBeanRegistration,
LoggerBroadcasterMBean {
    private long m_sequence;
    private boolean m_registered;
    private int m_recursionLevel;

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) throws Exception {
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
        if (!registrationDone.booleanValue()) {
            return;
        }
        this.m_registered = true;
    }

    @Override
    public void preDeregister() throws Exception {
    }

    @Override
    public void postDeregister() {
        this.m_registered = false;
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        super.removeNotificationListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendNotification(Notification n) {
        int maxRecursionLevel = 1;
        LoggerBroadcaster loggerBroadcaster = this;
        synchronized (loggerBroadcaster) {
            if (this.m_recursionLevel < maxRecursionLevel) {
                ++this.m_recursionLevel;
                super.sendNotification(n);
                --this.m_recursionLevel;
            }
        }
    }

    @Override
    public void start() {
        Logger logger = this.createLoggerPrototype();
        Log.redirectTo(logger);
    }

    @Override
    public void start(String category) {
        Logger logger = this.createLoggerPrototype();
        Log.redirectTo(logger, category);
    }

    @Override
    public void stop() {
        Log.redirectTo(null);
    }

    @Override
    public void stop(String category) {
        Log.redirectTo(null, category);
    }

    private boolean isRegistered() {
        return this.m_registered;
    }

    @Override
    public MBeanNotificationInfo[] getNotificationInfo() {
        String[] types = new String[]{"mx4j.logger.trace", "mx4j.logger.debug", "mx4j.logger.info", "mx4j.logger.warn", "mx4j.logger.error", "mx4j.logger.fatal"};
        MBeanNotificationInfo notifs = new MBeanNotificationInfo(types, "javax.management.Notification", "MX4J Logger MBean notifications");
        return new MBeanNotificationInfo[]{notifs};
    }

    protected Logger createLoggerPrototype() {
        return new LoggerNotifier(this);
    }

    public static class LoggerNotifier
    extends Logger {
        private static LoggerBroadcaster m_loggerBroadcaster;

        private LoggerNotifier(LoggerBroadcaster mbean) {
            m_loggerBroadcaster = mbean;
        }

        public LoggerNotifier() {
        }

        @Override
        protected void log(int priority, Object message, Throwable t) {
            this.notify(priority, message, t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notify(int priority, Object message, Throwable t) {
            if (LoggerNotifier.m_loggerBroadcaster.isRegistered()) {
                long sequence = 0L;
                LoggerNotifier loggerNotifier = this;
                synchronized (loggerNotifier) {
                    sequence = ++m_loggerBroadcaster.m_sequence;
                }
                String type = null;
                switch (priority) {
                    case 0: {
                        type = "mx4j.logger.trace";
                        break;
                    }
                    case 10: {
                        type = "mx4j.logger.debug";
                        break;
                    }
                    case 20: {
                        type = "mx4j.logger.info";
                        break;
                    }
                    case 30: {
                        type = "mx4j.logger.warn";
                        break;
                    }
                    case 40: {
                        type = "mx4j.logger.error";
                        break;
                    }
                    case 50: {
                        type = "mx4j.logger.fatal";
                        break;
                    }
                    default: {
                        type = "mx4j.logger." + priority;
                    }
                }
                String msg = message == null ? "" : message.toString();
                Notification n = new Notification(type, (Object)this, sequence, msg);
                if (t != null) {
                    n.setUserData(t);
                }
                m_loggerBroadcaster.sendNotification(n);
            }
        }
    }
}

