/*
 * Decompiled with CFR 0.152.
 */
package mx4j.monitor;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotCompliantMBeanException;
import javax.management.Notification;
import javax.management.NotificationBroadcasterSupport;
import javax.management.NotificationEmitter;
import javax.management.NotificationFilter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.ReflectionException;
import javax.management.StandardMBean;
import mx4j.log.Log;
import mx4j.log.Logger;
import mx4j.monitor.MX4JMonitorMBean;
import mx4j.monitor.MX4JMonitorNotification;
import mx4j.timer.TimeQueue;
import mx4j.timer.TimeTask;

public abstract class MX4JMonitor
extends StandardMBean
implements MX4JMonitorMBean,
MBeanRegistration,
NotificationEmitter {
    private static TimeQueue queue = new TimeQueue();
    private static int sequenceNumber;
    private NotificationBroadcasterSupport emitter;
    private MBeanServer server;
    private boolean active;
    private List observeds = new ArrayList();
    private volatile String attribute;
    private volatile long granularity = 10000L;
    private boolean errorNotified;
    private final TimeTask task = new MonitorTask();
    private final Map infos = new HashMap();

    protected MX4JMonitor(Class management) throws NotCompliantMBeanException {
        super(management);
    }

    @Override
    public ObjectName preRegister(MBeanServer server, ObjectName name) {
        this.server = server;
        return name;
    }

    @Override
    public void postRegister(Boolean registrationDone) {
    }

    @Override
    public void preDeregister() {
        this.stop();
    }

    @Override
    public void postDeregister() {
        this.server = null;
    }

    protected NotificationBroadcasterSupport createNotificationEmitter() {
        return new NotificationBroadcasterSupport();
    }

    @Override
    public void addNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws IllegalArgumentException {
        this.emitter.addNotificationListener(listener, filter, handback);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener);
    }

    @Override
    public void removeNotificationListener(NotificationListener listener, NotificationFilter filter, Object handback) throws ListenerNotFoundException {
        this.emitter.removeNotificationListener(listener, filter, handback);
    }

    public void sendNotification(Notification notification) {
        this.emitter.sendNotification(notification);
    }

    @Override
    public synchronized void start() {
        if (this.isActive()) {
            return;
        }
        this.active = true;
        this.startMonitor();
    }

    @Override
    public synchronized void stop() {
        if (!this.isActive()) {
            return;
        }
        this.active = false;
        this.stopMonitor();
        for (MonitorInfo info : this.infos.values()) {
            info.clearNotificationStatus();
        }
    }

    @Override
    public synchronized boolean isActive() {
        return this.active;
    }

    @Override
    public synchronized void addObservedObject(ObjectName name) throws IllegalArgumentException {
        if (name == null) {
            throw new IllegalArgumentException("Observed ObjectName cannot be null");
        }
        if (!this.containsObservedObject(name)) {
            this.observeds.add(name);
            this.putMonitorInfo(name, this.createMonitorInfo());
        }
    }

    @Override
    public synchronized void removeObservedObject(ObjectName name) {
        this.observeds.remove(name);
        this.removeMonitorInfo(name);
    }

    @Override
    public synchronized boolean containsObservedObject(ObjectName name) {
        return this.observeds.contains(name);
    }

    @Override
    public synchronized ObjectName[] getObservedObjects() {
        return this.observeds.toArray(new ObjectName[this.observeds.size()]);
    }

    public synchronized void clearObservedObjects() {
        this.observeds.clear();
    }

    @Override
    public synchronized String getObservedAttribute() {
        return this.attribute;
    }

    @Override
    public synchronized void setObservedAttribute(String attribute) {
        this.attribute = attribute;
    }

    @Override
    public synchronized long getGranularityPeriod() {
        return this.granularity;
    }

    @Override
    public synchronized void setGranularityPeriod(long granularity) throws IllegalArgumentException {
        if (granularity <= 0L) {
            throw new IllegalArgumentException("Granularity must be greater than zero");
        }
        this.granularity = granularity;
    }

    protected void startMonitor() {
        if (this.emitter == null) {
            this.emitter = this.createNotificationEmitter();
        }
        queue.schedule(this.task);
    }

    protected void stopMonitor() {
        queue.unschedule(this.task);
    }

    protected Logger getLogger() {
        return Log.getLogger(this.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendNotification(String type, String message, ObjectName name, String attribute, Object gauge, Object trigger) {
        int sequence = 0;
        Class<MX4JMonitor> clazz = MX4JMonitor.class;
        synchronized (MX4JMonitor.class) {
            sequence = ++sequenceNumber;
            // ** MonitorExit[var8_8] (shouldn't be in output)
            Notification notification = this.createMonitorNotification(type, sequence, message, name, attribute, gauge, trigger);
            this.sendNotification(notification);
            return;
        }
    }

    protected Notification createMonitorNotification(String type, long sequence, String message, ObjectName observed, String attribute, Object gauge, Object trigger) {
        return new MX4JMonitorNotification(type, this, sequence, System.currentTimeMillis(), message, observed, attribute, gauge, trigger);
    }

    protected abstract void monitor(ObjectName var1, String var2, Object var3, MonitorInfo var4);

    protected abstract MonitorInfo createMonitorInfo();

    protected synchronized MonitorInfo getMonitorInfo(ObjectName name) {
        return (MonitorInfo)this.infos.get(name);
    }

    protected synchronized void putMonitorInfo(ObjectName name, MonitorInfo info) {
        this.infos.put(name, info);
    }

    protected synchronized void removeMonitorInfo(ObjectName name) {
        this.infos.remove(name);
    }

    protected void sendErrorNotification(MonitorInfo info, String type, String message, ObjectName observed, String attribute) {
        if (!info.isErrorNotified()) {
            info.setErrorNotified(true);
            this.sendNotification(type, message, observed, attribute, null, null);
        }
    }

    static {
        queue.start();
    }

    protected class MonitorInfo {
        private boolean errorNotified;

        protected MonitorInfo() {
        }

        public boolean isErrorNotified() {
            return this.errorNotified;
        }

        public void setErrorNotified(boolean errorNotified) {
            this.errorNotified = errorNotified;
        }

        public String toString() {
            return "errorNotified=" + this.isErrorNotified();
        }

        public void clearNotificationStatus() {
            this.errorNotified = false;
        }
    }

    private class MonitorTask
    extends TimeTask {
        private MonitorTask() {
        }

        @Override
        protected boolean isPeriodic() {
            return true;
        }

        @Override
        protected long getPeriod() {
            return MX4JMonitor.this.getGranularityPeriod();
        }

        @Override
        public boolean getFixedRate() {
            return true;
        }

        @Override
        public void run() {
            if (!MX4JMonitor.this.isActive()) {
                return;
            }
            long start = System.currentTimeMillis();
            String attribute = MX4JMonitor.this.getObservedAttribute();
            if (MX4JMonitor.this.server == null) {
                if (!MX4JMonitor.this.errorNotified) {
                    MX4JMonitor.this.errorNotified = true;
                    MX4JMonitor.this.sendNotification("jmx.monitor.error.runtime", "Monitors must be registered in the MBeanServer", null, attribute, null, null);
                }
            } else {
                MX4JMonitor.this.errorNotified = false;
                if (attribute != null) {
                    ObjectName[] names = MX4JMonitor.this.getObservedObjects();
                    for (int i = 0; i < names.length; ++i) {
                        ObjectName name = names[i];
                        MonitorInfo info = MX4JMonitor.this.getMonitorInfo(name);
                        if (info == null) continue;
                        try {
                            Object value = MX4JMonitor.this.server.getAttribute(name, attribute);
                            if (value == null) continue;
                            MX4JMonitor.this.monitor(name, attribute, value, info);
                            continue;
                        }
                        catch (InstanceNotFoundException x) {
                            MX4JMonitor.this.sendErrorNotification(info, "jmx.monitor.error.mbean", "Could not find observed MBean", name, attribute);
                            continue;
                        }
                        catch (AttributeNotFoundException x) {
                            MX4JMonitor.this.sendErrorNotification(info, "jmx.monitor.error.attribute", "Could not find observed attribute " + attribute, name, attribute);
                            continue;
                        }
                        catch (MBeanException x) {
                            MX4JMonitor.this.sendErrorNotification(info, "jmx.monitor.error.runtime", x.toString(), name, attribute);
                            continue;
                        }
                        catch (ReflectionException x) {
                            MX4JMonitor.this.sendErrorNotification(info, "jmx.monitor.error.runtime", x.toString(), name, attribute);
                        }
                    }
                }
            }
            long end = System.currentTimeMillis();
            long elapsed = end - start;
            Logger logger = MX4JMonitor.this.getLogger();
            if (logger.isEnabledFor(10)) {
                logger.debug("Monitored attribute " + attribute + " in " + elapsed + " ms");
            }
        }
    }
}

