/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.zip.ZipException;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import org.eclipse.jdt.internal.compiler.apt.util.Archive;
import org.eclipse.jdt.internal.compiler.apt.util.EclipseFileObject;
import org.eclipse.jdt.internal.compiler.apt.util.Options;
import org.eclipse.jdt.internal.compiler.batch.FileSystem;
import org.eclipse.jdt.internal.compiler.batch.Main;
import org.eclipse.jdt.internal.compiler.env.AccessRule;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;

public class EclipseFileManager
implements StandardJavaFileManager {
    private static final String NO_EXTENSION = "";
    static final int HAS_EXT_DIRS = 1;
    static final int HAS_BOOTCLASSPATH = 2;
    static final int HAS_ENDORSED_DIRS = 4;
    static final int HAS_PROCESSORPATH = 8;
    Map<File, Archive> archivesCache;
    Charset charset;
    Locale locale;
    Map<String, Iterable<? extends File>> locations;
    int flags;
    public ResourceBundle bundle;

    public EclipseFileManager(Locale locale, Charset charset) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        this.charset = charset == null ? Charset.defaultCharset() : charset;
        this.locations = new HashMap<String, Iterable<? extends File>>();
        this.archivesCache = new HashMap<File, Archive>();
        try {
            this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.getDefaultBootclasspath());
            Iterable<? extends File> iterable = this.getDefaultClasspath();
            this.setLocation(StandardLocation.CLASS_PATH, iterable);
            this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, iterable);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.bundle = Main.ResourceBundleFactory.getBundle(this.locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + "org.eclipse.jdt.internal.compiler.batch.messages".replace('.', '/') + ".properties for locale " + locale);
        }
    }

    private void addFiles(File[][] fileArray, ArrayList<File> arrayList) {
        if (fileArray != null) {
            for (File[] fileArray2 : fileArray) {
                if (fileArray2 == null) continue;
                for (File file : fileArray2) {
                    if (!file.exists()) continue;
                    arrayList.add(file);
                }
            }
        }
    }

    private void addFilesFrom(File file, String string, String string2, ArrayList<File> arrayList) {
        String string3 = System.getProperty(string);
        File[] fileArray = null;
        if (string3 == null) {
            if (file != null) {
                fileArray = new File[]{new File(file, string2)};
            }
        } else {
            StringTokenizer stringTokenizer = new StringTokenizer(string3, File.pathSeparator);
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                arrayList2.add(stringTokenizer.nextToken());
            }
            if (arrayList2.size() != 0) {
                fileArray = new File[arrayList2.size()];
                for (int i = 0; i < fileArray.length; ++i) {
                    fileArray[i] = new File((String)arrayList2.get(i));
                }
            }
        }
        if (fileArray != null) {
            this.addFiles(Main.getLibrariesFiles(fileArray), arrayList);
        }
    }

    @Override
    public void close() throws IOException {
        this.locations = null;
        for (Archive archive : this.archivesCache.values()) {
            archive.close();
        }
    }

    private void collectAllMatchingFiles(File file, String string, Set<JavaFileObject.Kind> set, boolean bl, ArrayList<JavaFileObject> arrayList) {
        block14: {
            block13: {
                String string2;
                if (this.isArchive(file)) break block13;
                File file2 = new File(file, string);
                if (!file2.exists()) {
                    return;
                }
                try {
                    string2 = file2.getCanonicalPath();
                }
                catch (IOException iOException) {
                    return;
                }
                if (File.separatorChar == '/' ? !string2.endsWith(string) : !string2.endsWith(string.replace('/', File.separatorChar))) {
                    return;
                }
                File[] fileArray = file2.listFiles();
                if (fileArray == null) break block14;
                for (File file3 : fileArray) {
                    if (file3.isDirectory() && bl) {
                        this.collectAllMatchingFiles(file, string + '/' + file3.getName(), set, bl, arrayList);
                        continue;
                    }
                    JavaFileObject.Kind kind = this.getKind(file3);
                    if (!set.contains((Object)kind)) continue;
                    arrayList.add(new EclipseFileObject(string + file3.getName(), file3.toURI(), kind, this.charset));
                }
                break block14;
            }
            Archive archive = this.getArchive(file);
            String string3 = string;
            if (!string.endsWith("/")) {
                string3 = string3 + '/';
            }
            if (bl) {
                for (String string4 : archive.allPackages()) {
                    ArrayList<String> arrayList2;
                    if (!string4.startsWith(string3) || (arrayList2 = archive.getTypes(string4)) == null) continue;
                    for (String string5 : arrayList2) {
                        JavaFileObject.Kind kind = this.getKind(this.getExtension(string5));
                        if (!set.contains((Object)kind)) continue;
                        arrayList.add(archive.getArchiveFileObject(string4 + string5, this.charset));
                    }
                }
            } else {
                ArrayList<String> arrayList3 = archive.getTypes(string3);
                if (arrayList3 != null) {
                    for (String string6 : arrayList3) {
                        JavaFileObject.Kind kind = this.getKind(string6);
                        if (!set.contains((Object)kind)) continue;
                        arrayList.add(archive.getArchiveFileObject(string + string6, this.charset));
                    }
                }
            }
        }
    }

    private Iterable<? extends File> concatFiles(Iterable<? extends File> iterable, Iterable<? extends File> iterable2) {
        ArrayList<File> arrayList = new ArrayList<File>();
        if (iterable2 == null) {
            return iterable;
        }
        Iterator<? extends File> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public void flush() throws IOException {
        for (Archive archive : this.archivesCache.values()) {
            archive.flush();
        }
    }

    private Archive getArchive(File file) {
        Archive archive = this.archivesCache.get(file);
        if (archive == null) {
            if (file.exists()) {
                try {
                    archive = new Archive(file);
                }
                catch (ZipException zipException) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                if (archive != null) {
                    this.archivesCache.put(file, archive);
                } else {
                    this.archivesCache.put(file, Archive.UNKNOWN_ARCHIVE);
                }
            } else {
                this.archivesCache.put(file, Archive.UNKNOWN_ARCHIVE);
            }
        }
        return archive;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            return null;
        }
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (File file : iterable) {
            try {
                arrayList.add(file.toURI().toURL());
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        URL[] uRLArray = new URL[arrayList.size()];
        return new URLClassLoader(arrayList.toArray(uRLArray), this.getClass().getClassLoader());
    }

    private Iterable<? extends File> getPathsFrom(String string) {
        ArrayList arrayList = new ArrayList();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        try {
            this.processPathEntries(4, arrayList, string, this.charset.name(), false, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        for (FileSystem.Classpath classpath : arrayList) {
            arrayList2.add(new File(classpath.getPath()));
        }
        return arrayList2;
    }

    Iterable<? extends File> getDefaultBootclasspath() {
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = System.getProperty("java.version");
        if (string != null && !string.startsWith("1.6")) {
            return null;
        }
        String string2 = System.getProperty("java.home");
        File file = null;
        if (string2 != null && !(file = new File(string2)).exists()) {
            file = null;
        }
        this.addFilesFrom(file, "java.endorsed.dirs", "/lib/endorsed", arrayList);
        if (file != null) {
            File[] fileArray = null;
            fileArray = System.getProperty("os.name").startsWith("Mac") ? new File[]{new File(file, "../Classes")} : new File[]{new File(file, "lib")};
            File[][] fileArray2 = Main.getLibrariesFiles(fileArray);
            this.addFiles(fileArray2, arrayList);
        }
        this.addFilesFrom(file, "java.ext.dirs", "/lib/ext", arrayList);
        return arrayList;
    }

    Iterable<? extends File> getDefaultClasspath() {
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = System.getProperty("java.class.path");
        if (string == null || string.length() == 0) {
            return null;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            File file = new File(string2);
            if (!file.exists()) continue;
            arrayList.add(file);
        }
        return arrayList;
    }

    private Iterable<? extends File> getEndorsedDirsFrom(String string) {
        ArrayList arrayList = new ArrayList();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        try {
            this.processPathEntries(4, arrayList, string, this.charset.name(), false, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        for (FileSystem.Classpath classpath : arrayList) {
            arrayList2.add(new File(classpath.getPath()));
        }
        return arrayList2;
    }

    private Iterable<? extends File> getExtdirsFrom(String string) {
        ArrayList arrayList = new ArrayList();
        ArrayList<File> arrayList2 = new ArrayList<File>();
        try {
            this.processPathEntries(4, arrayList, string, this.charset.name(), false, false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
        for (FileSystem.Classpath classpath : arrayList) {
            arrayList2.add(new File(classpath.getPath()));
        }
        return arrayList2;
    }

    private String getExtension(File file) {
        String string = file.getName();
        return this.getExtension(string);
    }

    private String getExtension(String string) {
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return NO_EXTENSION;
        }
        return string.substring(n);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String string, String string2) throws IOException {
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            throw new IllegalArgumentException("Unknown location : " + location);
        }
        String string3 = this.normalized(string) + '/' + string2.replace('\\', '/');
        for (File file : iterable) {
            Object object;
            if (file.isDirectory()) {
                object = new File(file, string3);
                if (!((File)object).exists()) continue;
                return new EclipseFileObject(string + File.separator + string2, ((File)object).toURI(), this.getKind((File)object), this.charset);
            }
            if (!this.isArchive(file) || (object = this.getArchive(file)) == Archive.UNKNOWN_ARCHIVE || !((Archive)object).contains(string3)) continue;
            return ((Archive)object).getArchiveFileObject(string3, this.charset);
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String string, String string2, FileObject fileObject) throws IOException {
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            throw new IllegalArgumentException("Unknown location : " + location);
        }
        Iterator<? extends File> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            File file = iterator.next();
            String string3 = this.normalized(string) + '/' + string2.replace('\\', '/');
            File file2 = new File(file, string3);
            return new EclipseFileObject(string + File.separator + string2, file2.toURI(), this.getKind(file2), this.charset);
        }
        throw new IllegalArgumentException("location is empty : " + location);
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind) throws IOException {
        if (kind != JavaFileObject.Kind.CLASS && kind != JavaFileObject.Kind.SOURCE) {
            throw new IllegalArgumentException("Invalid kind : " + (Object)((Object)kind));
        }
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            throw new IllegalArgumentException("Unknown location : " + location);
        }
        String string2 = this.normalized(string);
        string2 = string2 + kind.extension;
        for (File file : iterable) {
            Object object;
            if (file.isDirectory()) {
                object = new File(file, string2);
                if (!((File)object).exists()) continue;
                return new EclipseFileObject(string, ((File)object).toURI(), kind, this.charset);
            }
            if (!this.isArchive(file) || (object = this.getArchive(file)) == Archive.UNKNOWN_ARCHIVE || !((Archive)object).contains(string2)) continue;
            return ((Archive)object).getArchiveFileObject(string2, this.charset);
        }
        return null;
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String string, JavaFileObject.Kind kind, FileObject fileObject) throws IOException {
        if (kind != JavaFileObject.Kind.CLASS && kind != JavaFileObject.Kind.SOURCE) {
            throw new IllegalArgumentException("Invalid kind : " + (Object)((Object)kind));
        }
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            if (!location.equals(StandardLocation.CLASS_OUTPUT) && !location.equals(StandardLocation.SOURCE_OUTPUT)) {
                throw new IllegalArgumentException("Unknown location : " + location);
            }
            if (fileObject != null) {
                String string2 = this.normalized(string);
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    string2 = string2.substring(n + 1);
                }
                string2 = string2 + kind.extension;
                URI uRI = fileObject.toUri();
                URI uRI2 = null;
                try {
                    String string3 = uRI.getPath();
                    n = string3.lastIndexOf(47);
                    if (n != -1) {
                        string3 = string3.substring(0, n + 1);
                        string3 = string3 + string2;
                    }
                    uRI2 = new URI(uRI.getScheme(), uRI.getHost(), string3, uRI.getFragment());
                }
                catch (URISyntaxException uRISyntaxException) {
                    throw new IllegalArgumentException("invalid sibling");
                }
                return new EclipseFileObject(string, uRI2, kind, this.charset);
            }
            String string4 = this.normalized(string);
            string4 = string4 + kind.extension;
            File file = new File(System.getProperty("user.dir"), string4);
            return new EclipseFileObject(string, file.toURI(), kind, this.charset);
        }
        Iterator<? extends File> iterator = iterable.iterator();
        if (iterator.hasNext()) {
            File file = iterator.next();
            String string5 = this.normalized(string);
            string5 = string5 + kind.extension;
            File file2 = new File(file, string5);
            return new EclipseFileObject(string, file2.toURI(), kind, this.charset);
        }
        throw new IllegalArgumentException("location is empty : " + location);
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(File ... fileArray) {
        return this.getJavaFileObjectsFromFiles(Arrays.asList(fileArray));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjects(String ... stringArray) {
        return this.getJavaFileObjectsFromStrings(Arrays.asList(stringArray));
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromFiles(Iterable<? extends File> iterable) {
        ArrayList<EclipseFileObject> arrayList = new ArrayList<EclipseFileObject>();
        for (File file : iterable) {
            arrayList.add(new EclipseFileObject(file.getAbsolutePath(), file.toURI(), this.getKind(file), this.charset));
        }
        return arrayList;
    }

    @Override
    public Iterable<? extends JavaFileObject> getJavaFileObjectsFromStrings(Iterable<String> iterable) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (String string : iterable) {
            arrayList.add(new File(string));
        }
        return this.getJavaFileObjectsFromFiles(arrayList);
    }

    public JavaFileObject.Kind getKind(File file) {
        return this.getKind(this.getExtension(file));
    }

    private JavaFileObject.Kind getKind(String string) {
        if (JavaFileObject.Kind.CLASS.extension.equals(string)) {
            return JavaFileObject.Kind.CLASS;
        }
        if (JavaFileObject.Kind.SOURCE.extension.equals(string)) {
            return JavaFileObject.Kind.SOURCE;
        }
        if (JavaFileObject.Kind.HTML.extension.equals(string)) {
            return JavaFileObject.Kind.HTML;
        }
        return JavaFileObject.Kind.OTHER;
    }

    @Override
    public Iterable<? extends File> getLocation(JavaFileManager.Location location) {
        if (this.locations == null) {
            return null;
        }
        return this.locations.get(location.getName());
    }

    private Iterable<? extends File> getOutputDir(String string) {
        if ("none".equals(string)) {
            return null;
        }
        File file = new File(string);
        if (file.exists() && !file.isDirectory()) {
            throw new IllegalArgumentException("file : " + file.getAbsolutePath() + " is not a directory");
        }
        ArrayList<File> arrayList = new ArrayList<File>(1);
        arrayList.add(file);
        return arrayList;
    }

    @Override
    public boolean handleOption(String string, Iterator<String> iterator) {
        try {
            if ("-bootclasspath".equals(string)) {
                iterator.remove();
                if (iterator.hasNext()) {
                    Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                    if (iterable != null) {
                        Iterable<? extends File> iterable2 = this.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
                        if ((this.flags & 4) == 0 && (this.flags & 1) == 0) {
                            this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, iterable);
                        } else if ((this.flags & 4) != 0) {
                            this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.concatFiles(iterable2, iterable));
                        } else {
                            this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.prependFiles(iterable2, iterable));
                        }
                    }
                    iterator.remove();
                    this.flags |= 2;
                    return true;
                }
                throw new IllegalArgumentException();
            }
            if ("-classpath".equals(string) || "-cp".equals(string)) {
                iterator.remove();
                if (iterator.hasNext()) {
                    Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                    if (iterable != null) {
                        Iterable<? extends File> iterable3 = this.getLocation(StandardLocation.CLASS_PATH);
                        if (iterable3 != null) {
                            this.setLocation(StandardLocation.CLASS_PATH, this.concatFiles(iterable3, iterable));
                        } else {
                            this.setLocation(StandardLocation.CLASS_PATH, iterable);
                        }
                        if ((this.flags & 8) == 0) {
                            this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, iterable);
                        }
                    }
                    iterator.remove();
                    return true;
                }
                throw new IllegalArgumentException();
            }
            if ("-encoding".equals(string)) {
                iterator.remove();
                if (iterator.hasNext()) {
                    this.charset = Charset.forName(iterator.next());
                    iterator.remove();
                    return true;
                }
                throw new IllegalArgumentException();
            }
            if ("-sourcepath".equals(string)) {
                iterator.remove();
                if (iterator.hasNext()) {
                    Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                    if (iterable != null) {
                        this.setLocation(StandardLocation.SOURCE_PATH, iterable);
                    }
                    iterator.remove();
                    return true;
                }
                throw new IllegalArgumentException();
            }
            if ("-extdirs".equals(string)) {
                iterator.remove();
                if (iterator.hasNext()) {
                    Iterable<? extends File> iterable = this.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
                    this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.concatFiles(iterable, this.getExtdirsFrom(iterator.next())));
                    iterator.remove();
                    this.flags |= 1;
                    return true;
                }
                throw new IllegalArgumentException();
            }
            if ("-endorseddirs".equals(string)) {
                iterator.remove();
                if (iterator.hasNext()) {
                    Iterable<? extends File> iterable = this.getLocation(StandardLocation.PLATFORM_CLASS_PATH);
                    this.setLocation(StandardLocation.PLATFORM_CLASS_PATH, this.prependFiles(iterable, this.getEndorsedDirsFrom(iterator.next())));
                    iterator.remove();
                    this.flags |= 4;
                    return true;
                }
                throw new IllegalArgumentException();
            }
            if ("-d".equals(string)) {
                iterator.remove();
                if (iterator.hasNext()) {
                    Iterable<? extends File> iterable = this.getOutputDir(iterator.next());
                    if (iterable != null) {
                        this.setLocation(StandardLocation.CLASS_OUTPUT, iterable);
                    }
                    iterator.remove();
                    return true;
                }
                throw new IllegalArgumentException();
            }
            if ("-s".equals(string)) {
                iterator.remove();
                if (iterator.hasNext()) {
                    Iterable<? extends File> iterable = this.getOutputDir(iterator.next());
                    if (iterable != null) {
                        this.setLocation(StandardLocation.SOURCE_OUTPUT, iterable);
                    }
                    iterator.remove();
                    return true;
                }
                throw new IllegalArgumentException();
            }
            if ("-processorpath".equals(string)) {
                iterator.remove();
                if (iterator.hasNext()) {
                    Iterable<? extends File> iterable = this.getPathsFrom(iterator.next());
                    if (iterable != null) {
                        this.setLocation(StandardLocation.ANNOTATION_PROCESSOR_PATH, iterable);
                    }
                    iterator.remove();
                    this.flags |= 8;
                    return true;
                }
                throw new IllegalArgumentException();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return this.locations != null && this.locations.containsKey(location.getName());
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject javaFileObject) {
        String string = javaFileObject.getName();
        JavaFileObject javaFileObject2 = null;
        int n = string.lastIndexOf(46);
        if (n != -1) {
            string = string.substring(0, n);
        }
        try {
            javaFileObject2 = this.getJavaFileForInput(location, string, javaFileObject.getKind());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (javaFileObject2 == null) {
            return null;
        }
        return this.normalized(string);
    }

    private boolean isArchive(File file) {
        String string = this.getExtension(file);
        return string.equalsIgnoreCase(".jar") || string.equalsIgnoreCase(".zip");
    }

    @Override
    public boolean isSameFile(FileObject fileObject, FileObject fileObject2) {
        if (!(fileObject instanceof EclipseFileObject)) {
            throw new IllegalArgumentException("Unsupported file object class : " + fileObject.getClass());
        }
        if (!(fileObject2 instanceof EclipseFileObject)) {
            throw new IllegalArgumentException("Unsupported file object class : " + fileObject2.getClass());
        }
        return fileObject.equals(fileObject2);
    }

    @Override
    public int isSupportedOption(String string) {
        return Options.processOptionsFileManager(string);
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String string, Set<JavaFileObject.Kind> set, boolean bl) throws IOException {
        Iterable<? extends File> iterable = this.getLocation(location);
        if (iterable == null) {
            throw new IllegalArgumentException("Unknown location : " + location);
        }
        ArrayList<JavaFileObject> arrayList = new ArrayList<JavaFileObject>();
        String string2 = this.normalized(string);
        for (File file : iterable) {
            this.collectAllMatchingFiles(file, string2, set, bl, arrayList);
        }
        return arrayList;
    }

    private String normalized(String string) {
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        block4: for (int i = 0; i < n; ++i) {
            switch (cArray[i]) {
                case '\\': {
                    cArray[i] = 47;
                    continue block4;
                }
                case '.': {
                    cArray[i] = 47;
                }
            }
        }
        return new String(cArray);
    }

    private Iterable<? extends File> prependFiles(Iterable<? extends File> iterable, Iterable<? extends File> iterable2) {
        if (iterable2 == null) {
            return iterable;
        }
        ArrayList<File> arrayList = new ArrayList<File>();
        Iterator<? extends File> iterator = iterable2.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        iterator = iterable.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next());
        }
        return arrayList;
    }

    @Override
    public void setLocation(JavaFileManager.Location location, Iterable<? extends File> iterable) throws IOException {
        if (iterable != null) {
            if (location.isOutputLocation()) {
                int n = 0;
                Iterator<? extends File> iterator = iterable.iterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    ++n;
                }
                if (n != 1) {
                    throw new IllegalArgumentException("output location can only have one path");
                }
            }
            this.locations.put(location.getName(), iterable);
        }
    }

    public void setLocale(Locale locale) {
        this.locale = locale == null ? Locale.getDefault() : locale;
        try {
            this.bundle = Main.ResourceBundleFactory.getBundle(this.locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + "org.eclipse.jdt.internal.compiler.batch.messages".replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
    }

    public void processPathEntries(int n, ArrayList arrayList, String string, String string2, boolean bl, boolean bl2) {
        String string3 = null;
        String string4 = null;
        ArrayList<String> arrayList2 = new ArrayList<String>(n);
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator + "[]", true);
        ArrayList<String> arrayList3 = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            arrayList3.add(stringTokenizer.nextToken());
        }
        int n2 = 0;
        String string5 = null;
        int n3 = 0;
        int n4 = arrayList3.size();
        int n5 = -1;
        while (n3 < n4 && n2 != 99) {
            if ((string5 = (String)arrayList3.get(n3++)).equals(File.pathSeparator)) {
                switch (n2) {
                    case 0: 
                    case 3: 
                    case 10: {
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 8: {
                        n2 = 3;
                        this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                        arrayList2.clear();
                        break;
                    }
                    case 6: {
                        n2 = 4;
                        break;
                    }
                    case 7: {
                        throw new IllegalArgumentException(this.bind("configure.incorrectDestinationPathEntry", string));
                    }
                    case 11: {
                        n3 = n5 + 1;
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("[")) {
                switch (n2) {
                    case 0: {
                        string3 = NO_EXTENSION;
                    }
                    case 1: {
                        n5 = n3 - 1;
                    }
                    case 11: {
                        n2 = 10;
                        break;
                    }
                    case 2: {
                        n2 = 9;
                        break;
                    }
                    case 8: {
                        n2 = 5;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else if (string5.equals("]")) {
                switch (n2) {
                    case 6: {
                        n2 = 2;
                        break;
                    }
                    case 7: {
                        n2 = 8;
                        break;
                    }
                    case 10: {
                        n2 = 11;
                        break;
                    }
                    default: {
                        n2 = 99;
                        break;
                    }
                }
            } else {
                switch (n2) {
                    case 0: 
                    case 3: {
                        n2 = 1;
                        string3 = string5;
                        break;
                    }
                    case 5: {
                        if (string5.startsWith("-d ")) {
                            if (string4 != null) {
                                throw new IllegalArgumentException(this.bind("configure.duplicateDestinationPathEntry", string));
                            }
                            string4 = string5.substring(3).trim();
                            n2 = 7;
                            break;
                        }
                    }
                    case 4: {
                        if (string4 != null) {
                            throw new IllegalArgumentException(this.bind("configure.accessRuleAfterDestinationPath", string));
                        }
                        n2 = 6;
                        arrayList2.add(string5);
                        break;
                    }
                    case 9: {
                        if (!string5.startsWith("-d ")) {
                            n2 = 99;
                            break;
                        }
                        string4 = string5.substring(3).trim();
                        n2 = 7;
                        break;
                    }
                    case 11: {
                        for (int i = n5; i < n3; ++i) {
                            string3 = string3 + (String)arrayList3.get(i);
                        }
                        n2 = 1;
                        break;
                    }
                    case 10: {
                        break;
                    }
                    default: {
                        n2 = 99;
                    }
                }
            }
            if (n2 != 11 || n3 != n4) continue;
            n3 = n5 + 1;
            n2 = 5;
        }
        switch (n2) {
            case 3: {
                break;
            }
            case 1: 
            case 2: 
            case 8: {
                this.addNewEntry(arrayList, string3, arrayList2, string2, string4, bl, bl2);
                break;
            }
        }
    }

    protected void addNewEntry(ArrayList arrayList, String string, ArrayList arrayList2, String string2, String string3, boolean bl, boolean bl2) {
        Object object;
        int n = arrayList2.size();
        AccessRuleSet accessRuleSet = null;
        if (n != 0) {
            object = new AccessRule[arrayList2.size()];
            boolean bl3 = true;
            Iterator iterator = arrayList2.iterator();
            int n2 = 0;
            block6: while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                char c = string4.charAt(0);
                String string5 = string4.substring(1);
                if (string5.length() > 0) {
                    switch (c) {
                        case '+': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0);
                            continue block6;
                        }
                        case '~': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000118);
                            continue block6;
                        }
                        case '-': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133);
                            continue block6;
                        }
                        case '?': {
                            object[n2++] = new AccessRule(string5.toCharArray(), 0x1000133, true);
                            continue block6;
                        }
                    }
                    bl3 = false;
                    continue;
                }
                bl3 = false;
            }
            if (bl3) {
                accessRuleSet = new AccessRuleSet((AccessRule[])object, 0, string);
            } else {
                return;
            }
        }
        if ("none".equals(string3)) {
            string3 = "none";
        }
        if (bl2 && string3 != null && (string.endsWith(".jar") || string.endsWith(".zip"))) {
            throw new IllegalArgumentException(this.bind("configure.unexpectedDestinationPathEntryFile", string));
        }
        object = FileSystem.getClasspath(string, string2, bl, accessRuleSet, string3);
        if (object != null) {
            arrayList.add(object);
        }
    }

    private String bind(String string, String string2) {
        return this.bind(string, new String[]{string2});
    }

    private String bind(String string, String[] stringArray) {
        if (string == null) {
            return "No message available";
        }
        String string2 = null;
        try {
            string2 = this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Missing message: " + string + " in: " + "org.eclipse.jdt.internal.compiler.batch.messages";
        }
        return MessageFormat.format(string2, stringArray);
    }
}

