/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.apt.model;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.ErrorType;
import javax.lang.model.type.NoType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.eclipse.jdt.internal.compiler.apt.dispatch.BaseProcessingEnvImpl;
import org.eclipse.jdt.internal.compiler.apt.model.AnnotationMirrorImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ArrayTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.DeclaredTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ErrorTypeElement;
import org.eclipse.jdt.internal.compiler.apt.model.ErrorTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.ExecutableTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.NoTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.PackageElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.PrimitiveTypeImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeParameterElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.TypeVariableImpl;
import org.eclipse.jdt.internal.compiler.apt.model.VariableElementImpl;
import org.eclipse.jdt.internal.compiler.apt.model.WildcardTypeImpl;
import org.eclipse.jdt.internal.compiler.lookup.AnnotationBinding;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class Factory {
    public static final Byte DUMMY_BYTE = 0;
    public static final Character DUMMY_CHAR = Character.valueOf('0');
    public static final Double DUMMY_DOUBLE = 0.0;
    public static final Float DUMMY_FLOAT = Float.valueOf(0.0f);
    public static final Integer DUMMY_INTEGER = 0;
    public static final Long DUMMY_LONG = 0L;
    public static final Short DUMMY_SHORT = 0;
    private final BaseProcessingEnvImpl _env;

    public Factory(BaseProcessingEnvImpl baseProcessingEnvImpl) {
        this._env = baseProcessingEnvImpl;
    }

    public List<? extends AnnotationMirror> getAnnotationMirrors(AnnotationBinding[] annotationBindingArray) {
        if (null == annotationBindingArray || 0 == annotationBindingArray.length) {
            return Collections.emptyList();
        }
        ArrayList<AnnotationMirror> arrayList = new ArrayList<AnnotationMirror>(annotationBindingArray.length);
        for (AnnotationBinding annotationBinding : annotationBindingArray) {
            if (annotationBinding == null) continue;
            arrayList.add(this.newAnnotationMirror(annotationBinding));
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static void appendModifier(Set<Modifier> set, int n, int n2, Modifier modifier) {
        if ((n & n2) != 0) {
            set.add(modifier);
        }
    }

    private static void decodeModifiers(Set<Modifier> set, int n, int[] nArray) {
        if (nArray == null) {
            return;
        }
        int n2 = nArray.length;
        block13: for (int i = 0; i < n2; ++i) {
            switch (nArray[i]) {
                case 1: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.PUBLIC);
                    continue block13;
                }
                case 4: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.PROTECTED);
                    continue block13;
                }
                case 2: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.PRIVATE);
                    continue block13;
                }
                case 1024: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.ABSTRACT);
                    continue block13;
                }
                case 8: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.STATIC);
                    continue block13;
                }
                case 16: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.FINAL);
                    continue block13;
                }
                case 32: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.SYNCHRONIZED);
                    continue block13;
                }
                case 256: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.NATIVE);
                    continue block13;
                }
                case 2048: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.STRICTFP);
                    continue block13;
                }
                case 128: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.TRANSIENT);
                    continue block13;
                }
                case 64: {
                    Factory.appendModifier(set, n, nArray[i], Modifier.VOLATILE);
                }
            }
        }
    }

    public static Object getMatchingDummyValue(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            if (clazz == Boolean.TYPE) {
                return Boolean.FALSE;
            }
            if (clazz == Byte.TYPE) {
                return DUMMY_BYTE;
            }
            if (clazz == Character.TYPE) {
                return DUMMY_CHAR;
            }
            if (clazz == Double.TYPE) {
                return DUMMY_DOUBLE;
            }
            if (clazz == Float.TYPE) {
                return DUMMY_FLOAT;
            }
            if (clazz == Integer.TYPE) {
                return DUMMY_INTEGER;
            }
            if (clazz == Long.TYPE) {
                return DUMMY_LONG;
            }
            if (clazz == Short.TYPE) {
                return DUMMY_SHORT;
            }
            return DUMMY_INTEGER;
        }
        return null;
    }

    public static Set<Modifier> getModifiers(int n, ElementKind elementKind) {
        return Factory.getModifiers(n, elementKind, false);
    }

    public static Set<Modifier> getModifiers(int n, ElementKind elementKind, boolean bl) {
        EnumSet<Modifier> enumSet = EnumSet.noneOf(Modifier.class);
        switch (elementKind) {
            case CONSTRUCTOR: 
            case METHOD: {
                Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 2, 1024, 8, 16, 32, 256, 2048});
                break;
            }
            case FIELD: 
            case ENUM_CONSTANT: {
                Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 2, 8, 16, 128, 64});
                break;
            }
            case ENUM: {
                if (bl) {
                    Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 16, 2, 1024, 8, 2048});
                    break;
                }
                Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 16, 2, 8, 2048});
                break;
            }
            case ANNOTATION_TYPE: 
            case INTERFACE: 
            case CLASS: {
                Factory.decodeModifiers(enumSet, n, new int[]{1, 4, 1024, 16, 2, 8, 2048});
            }
        }
        return Collections.unmodifiableSet(enumSet);
    }

    public AnnotationMirror newAnnotationMirror(AnnotationBinding annotationBinding) {
        return new AnnotationMirrorImpl(this._env, annotationBinding);
    }

    public Element newElement(Binding binding, ElementKind elementKind) {
        switch (binding.kind()) {
            case 1: 
            case 2: 
            case 3: {
                return new VariableElementImpl(this._env, (VariableBinding)binding);
            }
            case 4: 
            case 2052: {
                ReferenceBinding referenceBinding = (ReferenceBinding)binding;
                if ((referenceBinding.tagBits & 0x80L) != 0L) {
                    return new ErrorTypeElement(this._env, referenceBinding);
                }
                if (referenceBinding.sourceName == TypeConstants.PACKAGE_INFO_NAME) {
                    return new PackageElementImpl(this._env, referenceBinding.fPackage);
                }
                return new TypeElementImpl(this._env, referenceBinding, elementKind);
            }
            case 8: {
                return new ExecutableElementImpl(this._env, (MethodBinding)binding);
            }
            case 260: 
            case 1028: {
                return new TypeElementImpl(this._env, ((ParameterizedTypeBinding)binding).genericType(), elementKind);
            }
            case 16: {
                return new PackageElementImpl(this._env, (PackageBinding)binding);
            }
            case 4100: {
                return new TypeParameterElementImpl(this._env, (TypeVariableBinding)binding);
            }
            case 32: 
            case 68: 
            case 132: 
            case 516: 
            case 8196: {
                throw new UnsupportedOperationException("NYI: binding type " + binding.kind());
            }
        }
        return null;
    }

    public Element newElement(Binding binding) {
        return this.newElement(binding, null);
    }

    public PackageElement newPackageElement(PackageBinding packageBinding) {
        return new PackageElementImpl(this._env, packageBinding);
    }

    public NullType getNullType() {
        return NoTypeImpl.NULL_TYPE;
    }

    public NoType getNoType(TypeKind typeKind) {
        switch (typeKind) {
            case NONE: {
                return NoTypeImpl.NO_TYPE_NONE;
            }
            case VOID: {
                return NoTypeImpl.NO_TYPE_VOID;
            }
            case PACKAGE: {
                return NoTypeImpl.NO_TYPE_PACKAGE;
            }
        }
        throw new IllegalArgumentException();
    }

    public PrimitiveTypeImpl getPrimitiveType(TypeKind typeKind) {
        switch (typeKind) {
            case BOOLEAN: {
                return PrimitiveTypeImpl.BOOLEAN;
            }
            case BYTE: {
                return PrimitiveTypeImpl.BYTE;
            }
            case CHAR: {
                return PrimitiveTypeImpl.CHAR;
            }
            case DOUBLE: {
                return PrimitiveTypeImpl.DOUBLE;
            }
            case FLOAT: {
                return PrimitiveTypeImpl.FLOAT;
            }
            case INT: {
                return PrimitiveTypeImpl.INT;
            }
            case LONG: {
                return PrimitiveTypeImpl.LONG;
            }
            case SHORT: {
                return PrimitiveTypeImpl.SHORT;
            }
        }
        throw new IllegalStateException();
    }

    public TypeMirror newTypeMirror(Binding binding) {
        switch (binding.kind()) {
            case 1: 
            case 2: 
            case 3: {
                return this.newTypeMirror(((VariableBinding)binding).type);
            }
            case 16: {
                return this.getNoType(TypeKind.PACKAGE);
            }
            case 32: {
                throw new UnsupportedOperationException("NYI: import type " + binding.kind());
            }
            case 8: {
                return new ExecutableTypeImpl(this._env, (MethodBinding)binding);
            }
            case 4: 
            case 260: 
            case 1028: 
            case 2052: {
                ReferenceBinding referenceBinding = (ReferenceBinding)binding;
                if ((referenceBinding.tagBits & 0x80L) != 0L) {
                    return this.getErrorType(referenceBinding);
                }
                return new DeclaredTypeImpl(this._env, (ReferenceBinding)binding);
            }
            case 68: {
                return new ArrayTypeImpl(this._env, (ArrayBinding)binding);
            }
            case 132: {
                BaseTypeBinding baseTypeBinding = (BaseTypeBinding)binding;
                switch (baseTypeBinding.id) {
                    case 6: {
                        return this.getNoType(TypeKind.VOID);
                    }
                    case 12: {
                        return this.getNullType();
                    }
                }
                return this.getPrimitiveType(PrimitiveTypeImpl.getKind((BaseTypeBinding)binding));
            }
            case 516: 
            case 8196: {
                return new WildcardTypeImpl(this._env, (WildcardBinding)binding);
            }
            case 4100: {
                return new TypeVariableImpl(this._env, (TypeVariableBinding)binding);
            }
        }
        return null;
    }

    public TypeParameterElement newTypeParameterElement(TypeVariableBinding typeVariableBinding, Element element) {
        return new TypeParameterElementImpl(this._env, typeVariableBinding, element);
    }

    public ErrorType getErrorType(ReferenceBinding referenceBinding) {
        return new ErrorTypeImpl(this._env, referenceBinding);
    }

    public static Object performNecessaryPrimitiveTypeConversion(Class<?> clazz, Object object, boolean bl) {
        assert (clazz.isPrimitive()) : "expectedType is not a primitive type: " + clazz.getName();
        if (object == null) {
            return bl ? Factory.getMatchingDummyValue(clazz) : null;
        }
        String string = clazz.getName();
        char c = string.charAt(0);
        int n = string.length();
        if (object instanceof Byte) {
            byte by = (Byte)object;
            switch (c) {
                case 'b': {
                    if (n == 4) {
                        return object;
                    }
                    return bl ? Boolean.FALSE : object;
                }
                case 'c': {
                    return new Character((char)by);
                }
                case 'd': {
                    return new Double(by);
                }
                case 'f': {
                    return new Float(by);
                }
                case 'i': {
                    return new Integer(by);
                }
                case 'l': {
                    return new Long(by);
                }
                case 's': {
                    return new Short(by);
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Short) {
            short s = (Short)object;
            switch (c) {
                case 'b': {
                    if (n == 4) {
                        return new Byte((byte)s);
                    }
                    return bl ? Boolean.FALSE : object;
                }
                case 'c': {
                    return new Character((char)s);
                }
                case 'd': {
                    return new Double(s);
                }
                case 'f': {
                    return new Float(s);
                }
                case 'i': {
                    return new Integer(s);
                }
                case 'l': {
                    return new Long(s);
                }
                case 's': {
                    return object;
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Character) {
            char c2 = ((Character)object).charValue();
            switch (c) {
                case 'b': {
                    if (n == 4) {
                        return new Byte((byte)c2);
                    }
                    return bl ? Boolean.FALSE : object;
                }
                case 'c': {
                    return object;
                }
                case 'd': {
                    return new Double(c2);
                }
                case 'f': {
                    return new Float(c2);
                }
                case 'i': {
                    return new Integer(c2);
                }
                case 'l': {
                    return new Long(c2);
                }
                case 's': {
                    return new Short((short)c2);
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Integer) {
            int n2 = (Integer)object;
            switch (c) {
                case 'b': {
                    if (n == 4) {
                        return new Byte((byte)n2);
                    }
                    return bl ? Boolean.FALSE : object;
                }
                case 'c': {
                    return new Character((char)n2);
                }
                case 'd': {
                    return new Double(n2);
                }
                case 'f': {
                    return new Float(n2);
                }
                case 'i': {
                    return object;
                }
                case 'l': {
                    return new Long(n2);
                }
                case 's': {
                    return new Short((short)n2);
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Long) {
            long l = (Long)object;
            switch (c) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 's': {
                    return bl ? Factory.getMatchingDummyValue(clazz) : object;
                }
                case 'd': {
                    return new Double(l);
                }
                case 'f': {
                    return new Float(l);
                }
                case 'l': {
                    return object;
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Float) {
            float f = ((Float)object).floatValue();
            switch (c) {
                case 'b': 
                case 'c': 
                case 'i': 
                case 'l': 
                case 's': {
                    return bl ? Factory.getMatchingDummyValue(clazz) : object;
                }
                case 'd': {
                    return new Double(f);
                }
                case 'f': {
                    return object;
                }
            }
            throw new IllegalStateException("unknown type " + c);
        }
        if (object instanceof Double) {
            if (c == 'd') {
                return object;
            }
            return bl ? Factory.getMatchingDummyValue(clazz) : object;
        }
        if (object instanceof Boolean) {
            if (c == 'b' && n == 7) {
                return object;
            }
            return bl ? Factory.getMatchingDummyValue(clazz) : object;
        }
        return bl ? Factory.getMatchingDummyValue(clazz) : object;
    }

    public static void setArrayMatchingDummyValue(Object object, int n, Class<?> clazz) {
        if (Boolean.TYPE.equals(clazz)) {
            Array.setBoolean(object, n, false);
        } else if (Byte.TYPE.equals(clazz)) {
            Array.setByte(object, n, DUMMY_BYTE);
        } else if (Character.TYPE.equals(clazz)) {
            Array.setChar(object, n, DUMMY_CHAR.charValue());
        } else if (Double.TYPE.equals(clazz)) {
            Array.setDouble(object, n, DUMMY_DOUBLE);
        } else if (Float.TYPE.equals(clazz)) {
            Array.setFloat(object, n, DUMMY_FLOAT.floatValue());
        } else if (Integer.TYPE.equals(clazz)) {
            Array.setInt(object, n, DUMMY_INTEGER);
        } else if (Long.TYPE.equals(clazz)) {
            Array.setLong(object, n, DUMMY_LONG);
        } else if (Short.TYPE.equals(clazz)) {
            Array.setShort(object, n, DUMMY_SHORT);
        } else {
            Array.set(object, n, null);
        }
    }
}

