/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedNameReference;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SwitchStatement;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CaseStatement
extends Statement {
    public Expression constantExpression;
    public BranchLabel targetLabel;

    public CaseStatement(Expression expression, int n, int n2) {
        this.constantExpression = expression;
        this.sourceEnd = n;
        this.sourceStart = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.constantExpression != null) {
            if (this.constantExpression.constant == Constant.NotAConstant && !this.constantExpression.resolvedType.isEnum()) {
                blockScope.problemReporter().caseExpressionMustBeConstant(this.constantExpression);
            }
            this.constantExpression.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        CaseStatement.printIndent(n, stringBuffer);
        if (this.constantExpression == null) {
            stringBuffer.append("default :");
        } else {
            stringBuffer.append("case ");
            this.constantExpression.printExpression(0, stringBuffer).append(" :");
        }
        return stringBuffer;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n = codeStream.position;
        this.targetLabel.place();
        codeStream.recordPositionsFrom(n, this.sourceStart);
    }

    public void resolve(BlockScope blockScope) {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constant resolveCase(BlockScope blockScope, TypeBinding typeBinding, SwitchStatement switchStatement) {
        TypeBinding typeBinding2;
        blockScope.enclosingCase = this;
        if (this.constantExpression == null) {
            if (switchStatement.defaultCase != null) {
                blockScope.problemReporter().duplicateDefaultCase(this);
            }
            switchStatement.defaultCase = this;
            return Constant.NotAConstant;
        }
        switchStatement.cases[switchStatement.caseCount++] = this;
        if (typeBinding != null && typeBinding.isEnum() && this.constantExpression instanceof SingleNameReference) {
            ((SingleNameReference)this.constantExpression).setActualReceiverType((ReferenceBinding)typeBinding);
        }
        if ((typeBinding2 = this.constantExpression.resolveType(blockScope)) == null || typeBinding == null) {
            return Constant.NotAConstant;
        }
        if (this.constantExpression.isConstantValueOfTypeAssignableToType(typeBinding2, typeBinding) || typeBinding2.isCompatibleWith(typeBinding)) {
            if (!typeBinding2.isEnum()) return this.constantExpression.constant;
            if ((this.constantExpression.bits & 0x1FE00000) >> 21 != 0) {
                blockScope.problemReporter().enumConstantsCannotBeSurroundedByParenthesis(this.constantExpression);
            }
            if (this.constantExpression instanceof NameReference && (this.constantExpression.bits & 7) == 1) {
                NameReference nameReference = (NameReference)this.constantExpression;
                FieldBinding fieldBinding = nameReference.fieldBinding();
                if ((fieldBinding.modifiers & 0x4000) == 0) {
                    blockScope.problemReporter().enumSwitchCannotTargetField(nameReference, fieldBinding);
                    return IntConstant.fromValue(fieldBinding.original().id + 1);
                } else {
                    if (!(nameReference instanceof QualifiedNameReference)) return IntConstant.fromValue(fieldBinding.original().id + 1);
                    blockScope.problemReporter().cannotUseQualifiedEnumConstantInCaseLabel(nameReference, fieldBinding);
                }
                return IntConstant.fromValue(fieldBinding.original().id + 1);
            }
        } else if (this.isBoxingCompatible(typeBinding2, typeBinding, this.constantExpression, blockScope)) {
            return this.constantExpression.constant;
        }
        blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this.constantExpression, (ASTNode)switchStatement.expression);
        return Constant.NotAConstant;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.constantExpression != null) {
            this.constantExpression.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

