/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.flow;

import java.util.ArrayList;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.codegen.BranchLabel;
import org.eclipse.jdt.internal.compiler.flow.ExceptionHandlingFlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LabelFlowContext;
import org.eclipse.jdt.internal.compiler.flow.SwitchFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class LoopingFlowContext
extends SwitchFlowContext {
    public BranchLabel continueLabel;
    public UnconditionalFlowInfo initsOnContinue = FlowInfo.DEAD_END;
    private UnconditionalFlowInfo upstreamNullFlowInfo;
    private LoopingFlowContext[] innerFlowContexts = null;
    private UnconditionalFlowInfo[] innerFlowInfos = null;
    private int innerFlowContextsCount = 0;
    private LabelFlowContext[] breakTargetContexts = null;
    private int breakTargetsCount = 0;
    Reference[] finalAssignments;
    VariableBinding[] finalVariables;
    int assignCount = 0;
    LocalVariableBinding[] nullLocals;
    Expression[] nullReferences;
    int[] nullCheckTypes;
    int nullCount;
    private ArrayList escapingExceptionCatchSites = null;
    Scope associatedScope;

    public LoopingFlowContext(FlowContext flowContext, FlowInfo flowInfo, ASTNode aSTNode, BranchLabel branchLabel, BranchLabel branchLabel2, Scope scope) {
        super(flowContext, aSTNode, branchLabel);
        this.tagBits |= 2;
        this.continueLabel = branchLabel2;
        this.associatedScope = scope;
        this.upstreamNullFlowInfo = flowInfo.unconditionalCopy();
    }

    public void complainOnDeferredFinalChecks(BlockScope blockScope, FlowInfo flowInfo) {
        for (int i = 0; i < this.assignCount; ++i) {
            VariableBinding variableBinding = this.finalVariables[i];
            if (variableBinding == null) continue;
            boolean bl = false;
            if (variableBinding instanceof FieldBinding) {
                if (flowInfo.isPotentiallyAssigned((FieldBinding)variableBinding)) {
                    bl = true;
                    blockScope.problemReporter().duplicateInitializationOfBlankFinalField((FieldBinding)variableBinding, this.finalAssignments[i]);
                }
            } else if (flowInfo.isPotentiallyAssigned((LocalVariableBinding)variableBinding)) {
                bl = true;
                blockScope.problemReporter().duplicateInitializationOfFinalLocal((LocalVariableBinding)variableBinding, this.finalAssignments[i]);
            }
            if (!bl) continue;
            FlowContext flowContext = this.parent;
            while (flowContext != null) {
                flowContext.removeFinalAssignmentIfAny(this.finalAssignments[i]);
                flowContext = flowContext.parent;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void complainOnDeferredNullChecks(BlockScope blockScope, FlowInfo flowInfo) {
        Object object;
        Object object2;
        int n;
        for (int i = 0; i < this.innerFlowContextsCount; ++i) {
            this.upstreamNullFlowInfo.addPotentialNullInfoFrom(this.innerFlowContexts[i].upstreamNullFlowInfo).addPotentialNullInfoFrom(this.innerFlowInfos[i]);
        }
        this.innerFlowContextsCount = 0;
        UnconditionalFlowInfo unconditionalFlowInfo = this.upstreamNullFlowInfo.addPotentialNullInfoFrom(flowInfo.unconditionalInitsWithoutSideEffect());
        if ((this.tagBits & 1) != 0) {
            block32: for (n = 0; n < this.nullCount; ++n) {
                object2 = this.nullLocals[n];
                object = this.nullReferences[n];
                block0 : switch (this.nullCheckTypes[n]) {
                    case 258: 
                    case 514: {
                        if (!unconditionalFlowInfo.isDefinitelyNonNull((LocalVariableBinding)object2)) break;
                        this.nullReferences[n] = null;
                        if (this.nullCheckTypes[n] == 514) {
                            if ((this.tagBits & 4) != 0) continue block32;
                            blockScope.problemReporter().localVariableRedundantCheckOnNonNull((LocalVariableBinding)object2, (ASTNode)object);
                            continue block32;
                        }
                        if ((this.tagBits & 4) != 0) continue block32;
                        blockScope.problemReporter().localVariableNonNullComparedToNull((LocalVariableBinding)object2, (ASTNode)object);
                        continue block32;
                    }
                    case 256: 
                    case 512: {
                        if (unconditionalFlowInfo.isDefinitelyNonNull((LocalVariableBinding)object2)) {
                            this.nullReferences[n] = null;
                            if (this.nullCheckTypes[n] == 512) {
                                if ((this.tagBits & 4) != 0) continue block32;
                                blockScope.problemReporter().localVariableRedundantCheckOnNonNull((LocalVariableBinding)object2, (ASTNode)object);
                                continue block32;
                            }
                            if ((this.tagBits & 4) != 0) continue block32;
                            blockScope.problemReporter().localVariableNonNullComparedToNull((LocalVariableBinding)object2, (ASTNode)object);
                            continue block32;
                        }
                        if (!unconditionalFlowInfo.isDefinitelyNull((LocalVariableBinding)object2)) break;
                        this.nullReferences[n] = null;
                        if (this.nullCheckTypes[n] == 256) {
                            if ((this.tagBits & 4) != 0) continue block32;
                            blockScope.problemReporter().localVariableRedundantCheckOnNull((LocalVariableBinding)object2, (ASTNode)object);
                            continue block32;
                        }
                        if ((this.tagBits & 4) != 0) continue block32;
                        blockScope.problemReporter().localVariableNullComparedToNonNull((LocalVariableBinding)object2, (ASTNode)object);
                        continue block32;
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        if (unconditionalFlowInfo.isDefinitelyNull((LocalVariableBinding)object2)) {
                            this.nullReferences[n] = null;
                            switch (this.nullCheckTypes[n] & 0xFFFFFF00) {
                                case 256: {
                                    if ((this.nullCheckTypes[n] & 0xFF) == 1 && (((Expression)object).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object2, (ASTNode)object);
                                        continue block32;
                                    }
                                    if ((this.tagBits & 4) != 0) continue block32;
                                    blockScope.problemReporter().localVariableRedundantCheckOnNull((LocalVariableBinding)object2, (ASTNode)object);
                                    continue block32;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[n] & 0xFF) == 1 && (((Expression)object).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object2, (ASTNode)object);
                                        continue block32;
                                    }
                                    if ((this.tagBits & 4) != 0) continue block32;
                                    blockScope.problemReporter().localVariableNullComparedToNonNull((LocalVariableBinding)object2, (ASTNode)object);
                                    continue block32;
                                }
                                case 768: {
                                    blockScope.problemReporter().localVariableRedundantNullAssignment((LocalVariableBinding)object2, (ASTNode)object);
                                    continue block32;
                                }
                                case 1024: {
                                    blockScope.problemReporter().localVariableNullInstanceof((LocalVariableBinding)object2, (ASTNode)object);
                                    continue block32;
                                }
                            }
                            break;
                        }
                        if (!unconditionalFlowInfo.isPotentiallyNull((LocalVariableBinding)object2)) break;
                        switch (this.nullCheckTypes[n] & 0xFFFFFF00) {
                            case 256: {
                                this.nullReferences[n] = null;
                                if ((this.nullCheckTypes[n] & 0xFF) == 1 && (((Expression)object).implicitConversion & 0x400) != 0) {
                                    blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object2, (ASTNode)object);
                                    continue block32;
                                }
                                break block0;
                            }
                            case 512: {
                                this.nullReferences[n] = null;
                                if ((this.nullCheckTypes[n] & 0xFF) == 1 && (((Expression)object).implicitConversion & 0x400) != 0) {
                                    blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object2, (ASTNode)object);
                                    continue block32;
                                }
                                break block0;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if (!unconditionalFlowInfo.isDefinitelyNull((LocalVariableBinding)object2)) break;
                        this.nullReferences[n] = null;
                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object2, (ASTNode)object);
                        continue block32;
                    }
                }
                this.parent.recordUsingNullReference(blockScope, (LocalVariableBinding)object2, (Expression)object, this.nullCheckTypes[n], unconditionalFlowInfo);
            }
        } else {
            block33: for (n = 0; n < this.nullCount; ++n) {
                object2 = this.nullReferences[n];
                object = this.nullLocals[n];
                switch (this.nullCheckTypes[n]) {
                    case 256: 
                    case 512: {
                        if (unconditionalFlowInfo.isDefinitelyNonNull((LocalVariableBinding)object)) {
                            this.nullReferences[n] = null;
                            if (this.nullCheckTypes[n] == 512) {
                                if ((this.tagBits & 4) != 0) continue block33;
                                blockScope.problemReporter().localVariableRedundantCheckOnNonNull((LocalVariableBinding)object, (ASTNode)object2);
                                continue block33;
                            }
                            if ((this.tagBits & 4) != 0) continue block33;
                            blockScope.problemReporter().localVariableNonNullComparedToNull((LocalVariableBinding)object, (ASTNode)object2);
                            continue block33;
                        }
                    }
                    case 257: 
                    case 513: 
                    case 769: 
                    case 1025: {
                        if (unconditionalFlowInfo.isDefinitelyNull((LocalVariableBinding)object)) {
                            this.nullReferences[n] = null;
                            switch (this.nullCheckTypes[n] & 0xFFFFFF00) {
                                case 256: {
                                    if ((this.nullCheckTypes[n] & 0xFF) == 1 && (((Expression)object2).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object, (ASTNode)object2);
                                        break;
                                    }
                                    if ((this.tagBits & 4) != 0) break;
                                    blockScope.problemReporter().localVariableRedundantCheckOnNull((LocalVariableBinding)object, (ASTNode)object2);
                                    break;
                                }
                                case 512: {
                                    if ((this.nullCheckTypes[n] & 0xFF) == 1 && (((Expression)object2).implicitConversion & 0x400) != 0) {
                                        blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object, (ASTNode)object2);
                                        break;
                                    }
                                    if ((this.tagBits & 4) != 0) break;
                                    blockScope.problemReporter().localVariableNullComparedToNonNull((LocalVariableBinding)object, (ASTNode)object2);
                                    break;
                                }
                                case 768: {
                                    blockScope.problemReporter().localVariableRedundantNullAssignment((LocalVariableBinding)object, (ASTNode)object2);
                                    break;
                                }
                                case 1024: {
                                    blockScope.problemReporter().localVariableNullInstanceof((LocalVariableBinding)object, (ASTNode)object2);
                                    break;
                                }
                            }
                            continue block33;
                        }
                        if (!unconditionalFlowInfo.isPotentiallyNull((LocalVariableBinding)object)) continue block33;
                        switch (this.nullCheckTypes[n] & 0xFFFFFF00) {
                            case 256: {
                                this.nullReferences[n] = null;
                                if ((this.nullCheckTypes[n] & 0xFF) != 1 || (((Expression)object2).implicitConversion & 0x400) == 0) break;
                                blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object, (ASTNode)object2);
                                break;
                            }
                            case 512: {
                                this.nullReferences[n] = null;
                                if ((this.nullCheckTypes[n] & 0xFF) != 1 || (((Expression)object2).implicitConversion & 0x400) == 0) break;
                                blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object, (ASTNode)object2);
                                break;
                            }
                        }
                        continue block33;
                    }
                    case 3: {
                        if (unconditionalFlowInfo.isDefinitelyNull((LocalVariableBinding)object)) {
                            this.nullReferences[n] = null;
                            blockScope.problemReporter().localVariableNullReference((LocalVariableBinding)object, (ASTNode)object2);
                            continue block33;
                        }
                        if (!unconditionalFlowInfo.isPotentiallyNull((LocalVariableBinding)object)) continue block33;
                        this.nullReferences[n] = null;
                        blockScope.problemReporter().localVariablePotentialNullReference((LocalVariableBinding)object, (ASTNode)object2);
                        continue block33;
                    }
                }
            }
        }
        this.initsOnBreak.addPotentialNullInfoFrom(unconditionalFlowInfo);
        n = 0;
        while (n < this.breakTargetsCount) {
            this.breakTargetContexts[n].initsOnBreak.addPotentialNullInfoFrom(unconditionalFlowInfo);
            ++n;
        }
        return;
    }

    public BranchLabel continueLabel() {
        return this.continueLabel;
    }

    public String individualToString() {
        StringBuffer stringBuffer = new StringBuffer("Looping flow context");
        stringBuffer.append("[initsOnBreak - ").append(this.initsOnBreak.toString()).append(']');
        stringBuffer.append("[initsOnContinue - ").append(this.initsOnContinue.toString()).append(']');
        stringBuffer.append("[finalAssignments count - ").append(this.assignCount).append(']');
        stringBuffer.append("[nullReferences count - ").append(this.nullCount).append(']');
        return stringBuffer.toString();
    }

    public boolean isContinuable() {
        return true;
    }

    public boolean isContinuedTo() {
        return this.initsOnContinue != FlowInfo.DEAD_END;
    }

    public void recordBreakTo(FlowContext flowContext) {
        if (flowContext instanceof LabelFlowContext) {
            int n;
            if ((n = this.breakTargetsCount++) == 0) {
                this.breakTargetContexts = new LabelFlowContext[2];
            } else if (n == this.breakTargetContexts.length) {
                this.breakTargetContexts = new LabelFlowContext[n + 2];
                System.arraycopy(this.breakTargetContexts, 0, this.breakTargetContexts, 0, n);
            }
            this.breakTargetContexts[n] = (LabelFlowContext)flowContext;
        }
    }

    public void recordContinueFrom(FlowContext flowContext, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 1) == 0) {
            this.initsOnContinue = (this.initsOnContinue.tagBits & 1) == 0 ? this.initsOnContinue.mergedWith(flowInfo.unconditionalInitsWithoutSideEffect()) : flowInfo.unconditionalCopy();
            FlowContext flowContext2 = flowContext;
            while (flowContext2 != this && !(flowContext2 instanceof LoopingFlowContext)) {
                flowContext2 = flowContext2.parent;
            }
            if (flowContext2 == this) {
                this.upstreamNullFlowInfo.addPotentialNullInfoFrom(flowInfo.unconditionalInitsWithoutSideEffect());
            } else {
                int n = 0;
                if (this.innerFlowContexts == null) {
                    this.innerFlowContexts = new LoopingFlowContext[5];
                    this.innerFlowInfos = new UnconditionalFlowInfo[5];
                } else {
                    n = this.innerFlowContexts.length;
                    if (this.innerFlowContextsCount == n - 1) {
                        this.innerFlowContexts = new LoopingFlowContext[n + 5];
                        System.arraycopy(this.innerFlowContexts, 0, this.innerFlowContexts, 0, n);
                        this.innerFlowInfos = new UnconditionalFlowInfo[n + 5];
                        System.arraycopy(this.innerFlowInfos, 0, this.innerFlowInfos, 0, n);
                    }
                }
                this.innerFlowContexts[this.innerFlowContextsCount] = (LoopingFlowContext)flowContext2;
                this.innerFlowInfos[this.innerFlowContextsCount++] = flowInfo.unconditionalInitsWithoutSideEffect();
            }
        }
    }

    protected boolean recordFinalAssignment(VariableBinding variableBinding, Reference reference) {
        if (variableBinding instanceof LocalVariableBinding) {
            Scope scope = ((LocalVariableBinding)variableBinding).declaringScope;
            while ((scope = scope.parent) != null) {
                if (scope != this.associatedScope) continue;
                return false;
            }
        }
        if (this.assignCount == 0) {
            this.finalAssignments = new Reference[5];
            this.finalVariables = new VariableBinding[5];
        } else {
            if (this.assignCount == this.finalAssignments.length) {
                this.finalAssignments = new Reference[this.assignCount * 2];
                System.arraycopy(this.finalAssignments, 0, this.finalAssignments, 0, this.assignCount);
            }
            this.finalVariables = new VariableBinding[this.assignCount * 2];
            System.arraycopy(this.finalVariables, 0, this.finalVariables, 0, this.assignCount);
        }
        this.finalAssignments[this.assignCount] = reference;
        this.finalVariables[this.assignCount++] = variableBinding;
        return true;
    }

    protected void recordNullReference(LocalVariableBinding localVariableBinding, Expression expression, int n) {
        if (this.nullCount == 0) {
            this.nullLocals = new LocalVariableBinding[5];
            this.nullReferences = new Expression[5];
            this.nullCheckTypes = new int[5];
        } else if (this.nullCount == this.nullLocals.length) {
            this.nullLocals = new LocalVariableBinding[this.nullCount * 2];
            System.arraycopy(this.nullLocals, 0, this.nullLocals, 0, this.nullCount);
            this.nullReferences = new Expression[this.nullCount * 2];
            System.arraycopy(this.nullReferences, 0, this.nullReferences, 0, this.nullCount);
            this.nullCheckTypes = new int[this.nullCount * 2];
            System.arraycopy(this.nullCheckTypes, 0, this.nullCheckTypes, 0, this.nullCount);
        }
        this.nullLocals[this.nullCount] = localVariableBinding;
        this.nullReferences[this.nullCount] = expression;
        this.nullCheckTypes[this.nullCount++] = n;
    }

    public void recordUsingNullReference(Scope scope, LocalVariableBinding localVariableBinding, Expression expression, int n, FlowInfo flowInfo) {
        if ((flowInfo.tagBits & 3) != 0 || flowInfo.isDefinitelyUnknown(localVariableBinding)) {
            return;
        }
        switch (n) {
            case 256: 
            case 512: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    if (n == 512) {
                        if ((this.tagBits & 4) == 0) {
                            scope.problemReporter().localVariableRedundantCheckOnNonNull(localVariableBinding, expression);
                        }
                        if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                            flowInfo.initsWhenFalse().setReachMode(2);
                        }
                    } else {
                        if ((this.tagBits & 4) == 0) {
                            scope.problemReporter().localVariableNonNullComparedToNull(localVariableBinding, expression);
                        }
                        if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                            flowInfo.initsWhenTrue().setReachMode(2);
                        }
                    }
                } else if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    if (n == 256) {
                        if ((this.tagBits & 4) == 0) {
                            scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                        }
                        if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                            flowInfo.initsWhenFalse().setReachMode(2);
                        }
                    } else {
                        if ((this.tagBits & 4) == 0) {
                            scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                        }
                        if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                            flowInfo.initsWhenTrue().setReachMode(2);
                        }
                    }
                } else if (this.upstreamNullFlowInfo.isDefinitelyNonNull(localVariableBinding) && !flowInfo.isPotentiallyNull(localVariableBinding) && !flowInfo.isPotentiallyUnknown(localVariableBinding)) {
                    flowInfo.markAsDefinitelyNonNull(localVariableBinding);
                    if ((this.tagBits & 4) == 0) {
                        this.recordNullReference(localVariableBinding, expression, n);
                    }
                } else {
                    if (flowInfo.cannotBeDefinitelyNullOrNonNull(localVariableBinding)) {
                        return;
                    }
                    if ((this.tagBits & 4) == 0) {
                        if (flowInfo.isPotentiallyNonNull(localVariableBinding)) {
                            this.recordNullReference(localVariableBinding, expression, 2 | n & 0xFFFFFF00);
                        } else if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                            this.recordNullReference(localVariableBinding, expression, 1 | n & 0xFFFFFF00);
                        } else {
                            this.recordNullReference(localVariableBinding, expression, n);
                        }
                    }
                }
                return;
            }
            case 257: 
            case 513: 
            case 769: 
            case 1025: {
                if (flowInfo.isPotentiallyNonNull(localVariableBinding) || flowInfo.isPotentiallyUnknown(localVariableBinding) || flowInfo.isProtectedNonNull(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    switch (n & 0xFFFFFF00) {
                        case 256: {
                            if ((n & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            if ((this.tagBits & 4) == 0) {
                                scope.problemReporter().localVariableRedundantCheckOnNull(localVariableBinding, expression);
                            }
                            if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                flowInfo.initsWhenFalse().setReachMode(2);
                            }
                            return;
                        }
                        case 512: {
                            if ((n & 0xFF) == 1 && (expression.implicitConversion & 0x400) != 0) {
                                scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                                return;
                            }
                            if ((this.tagBits & 4) == 0) {
                                scope.problemReporter().localVariableNullComparedToNonNull(localVariableBinding, expression);
                            }
                            if (!flowInfo.isMarkedAsNullOrNonNullInAssertExpression(localVariableBinding)) {
                                flowInfo.initsWhenTrue().setReachMode(2);
                            }
                            return;
                        }
                        case 768: {
                            scope.problemReporter().localVariableRedundantNullAssignment(localVariableBinding, expression);
                            return;
                        }
                        case 1024: {
                            scope.problemReporter().localVariableNullInstanceof(localVariableBinding, expression);
                            return;
                        }
                    }
                } else if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    switch (n & 0xFFFFFF00) {
                        case 256: {
                            if ((n & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                        case 512: {
                            if ((n & 0xFF) != 1 || (expression.implicitConversion & 0x400) == 0) break;
                            scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                            return;
                        }
                    }
                }
                if ((this.tagBits & 4) == 0 || (n & 0xFFFFFF00) == 768 || (n & 0xFFFFFF00) == 1024) {
                    this.recordNullReference(localVariableBinding, expression, n);
                }
                return;
            }
            case 3: {
                if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                    return;
                }
                if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                    scope.problemReporter().localVariableNullReference(localVariableBinding, expression);
                    return;
                }
                if (flowInfo.isPotentiallyNull(localVariableBinding)) {
                    scope.problemReporter().localVariablePotentialNullReference(localVariableBinding, expression);
                    return;
                }
                this.recordNullReference(localVariableBinding, expression, n);
                return;
            }
        }
    }

    void removeFinalAssignmentIfAny(Reference reference) {
        for (int i = 0; i < this.assignCount; ++i) {
            if (this.finalAssignments[i] != reference) continue;
            this.finalAssignments[i] = null;
            this.finalVariables[i] = null;
            return;
        }
    }

    public void simulateThrowAfterLoopBack(FlowInfo flowInfo) {
        if (this.escapingExceptionCatchSites != null) {
            int n = this.escapingExceptionCatchSites.size();
            for (int i = 0; i < n; ++i) {
                ((EscapingExceptionCatchSite)this.escapingExceptionCatchSites.get(i)).simulateThrowAfterLoopBack(flowInfo);
            }
            this.escapingExceptionCatchSites = null;
        }
    }

    public void recordCatchContextOfEscapingException(ExceptionHandlingFlowContext exceptionHandlingFlowContext, ReferenceBinding referenceBinding) {
        if (this.escapingExceptionCatchSites == null) {
            this.escapingExceptionCatchSites = new ArrayList(5);
        }
        this.escapingExceptionCatchSites.add(new EscapingExceptionCatchSite(exceptionHandlingFlowContext, referenceBinding));
    }

    public boolean hasEscapingExceptions() {
        return this.escapingExceptionCatchSites != null;
    }

    private static class EscapingExceptionCatchSite {
        final ReferenceBinding caughtException;
        final ExceptionHandlingFlowContext catchingContext;

        public EscapingExceptionCatchSite(ExceptionHandlingFlowContext exceptionHandlingFlowContext, ReferenceBinding referenceBinding) {
            this.catchingContext = exceptionHandlingFlowContext;
            this.caughtException = referenceBinding;
        }

        void simulateThrowAfterLoopBack(FlowInfo flowInfo) {
            this.catchingContext.recordHandlingException(this.caughtException, flowInfo.unconditionalInits(), null, null, null, true);
        }
    }
}

