/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CatchParameterBinding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class Argument
extends LocalDeclaration {
    private static final char[] SET = "set".toCharArray();

    public Argument(char[] cArray, long l, TypeReference typeReference, int n) {
        super(cArray, (int)(l >>> 32), (int)l);
        this.declarationSourceEnd = (int)l;
        this.modifiers = n;
        this.type = typeReference;
        this.bits |= 0x40000004;
    }

    public void bind(MethodScope methodScope, TypeBinding typeBinding, boolean bl) {
        AbstractMethodDeclaration abstractMethodDeclaration;
        Object object;
        Binding binding = methodScope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (binding != null && binding.isValidBinding()) {
            if (binding instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                methodScope.problemReporter().redefineArgument(this);
            } else {
                boolean bl2 = false;
                if (binding instanceof FieldBinding) {
                    if (methodScope.isInsideConstructor()) {
                        bl2 = true;
                    } else {
                        object = methodScope.referenceMethod();
                        if (object != null && CharOperation.prefixEquals(SET, ((AbstractMethodDeclaration)object).selector)) {
                            bl2 = true;
                        }
                    }
                }
                methodScope.problemReporter().localVariableHiding(this, binding, bl2);
            }
        }
        if (this.binding == null) {
            this.binding = new LocalVariableBinding(this, typeBinding, this.modifiers, true);
        } else if (!this.binding.type.isValidBinding() && (abstractMethodDeclaration = methodScope.referenceMethod()) != null && (object = abstractMethodDeclaration.binding) != null) {
            ((MethodBinding)object).tagBits |= 0x200L;
        }
        methodScope.addLocalVariable(this.binding);
        Argument.resolveAnnotations(methodScope, this.annotations, this.binding);
        this.binding.declaration = this;
        this.binding.useFlag = bl ? 1 : 0;
    }

    public int getKind() {
        return (this.bits & 4) != 0 ? 5 : 4;
    }

    public boolean isVarArgs() {
        return this.type != null && (this.type.bits & 0x4000) != 0;
    }

    public StringBuffer print(int n, StringBuffer stringBuffer) {
        Argument.printIndent(n, stringBuffer);
        Argument.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            Argument.printAnnotations(this.annotations, stringBuffer);
        }
        if (this.type == null) {
            stringBuffer.append("<no type> ");
        } else {
            this.type.print(0, stringBuffer).append(' ');
        }
        return stringBuffer.append(this.name);
    }

    public StringBuffer printStatement(int n, StringBuffer stringBuffer) {
        return this.print(n, stringBuffer).append(';');
    }

    public TypeBinding resolveForCatch(BlockScope blockScope) {
        boolean bl;
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        if (typeBinding == null) {
            bl = true;
        } else {
            bl = false;
            switch (typeBinding.kind()) {
                case 260: {
                    if (!typeBinding.isBoundParameterizedType()) break;
                    bl = true;
                    blockScope.problemReporter().invalidParameterizedExceptionType(typeBinding, this);
                    break;
                }
                case 4100: {
                    blockScope.problemReporter().invalidTypeVariableAsException(typeBinding, this);
                    bl = true;
                }
            }
            if (typeBinding.findSuperTypeOriginatingFrom(21, true) == null && typeBinding.isValidBinding()) {
                blockScope.problemReporter().cannotThrowType(this.type, typeBinding);
                bl = true;
            }
        }
        Binding binding = blockScope.getBinding(this.name, 3, (InvocationSite)this, false);
        if (binding != null && binding.isValidBinding()) {
            if (binding instanceof LocalVariableBinding && this.hiddenVariableDepth == 0) {
                blockScope.problemReporter().redefineArgument(this);
            } else {
                blockScope.problemReporter().localVariableHiding(this, binding, false);
            }
        }
        if ((this.type.bits & 0x20000000) != 0) {
            this.binding = new CatchParameterBinding(this, typeBinding, this.modifiers | 0x10, false);
            this.binding.tagBits |= 0x1000L;
        } else {
            this.binding = new CatchParameterBinding(this, typeBinding, this.modifiers, false);
        }
        Argument.resolveAnnotations(blockScope, this.annotations, this.binding);
        blockScope.addLocalVariable(this.binding);
        this.binding.setConstant(Constant.NotAConstant);
        if (bl) {
            return null;
        }
        return typeBinding;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, blockScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (aSTVisitor.visit(this, classScope)) {
            if (this.annotations != null) {
                int n = this.annotations.length;
                for (int i = 0; i < n; ++i) {
                    this.annotations[i].traverse(aSTVisitor, classScope);
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, classScope);
            }
        }
        aSTVisitor.endVisit(this, classScope);
    }
}

