/*
 * $Id: www-mib-services.c 8676 2008-01-17 23:11:17Z ispringer $
 */
/* Apache includes */
#include <httpd.h>
#include <http_log.h>
#include <http_config.h>
#include <scoreboard.h>
#include <apr_strings.h>
#include <apr_time.h>
#include <apr_optional.h>

/* SNMP includes */
#include "ucd-snmp-config.h"
#include "asn1.h"
#include "snmp.h"
#include "snmp_api.h"
#include "snmp_impl.h"
#include "snmp_debug.h"
#include "snmp_vars.h"
#include "var_struct.h"
#include <mibgroup/mibII/sysORTable.h>

/* includes */
#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#include "snmpcommon/snmpv2-tc.h"
#include "www-mib/www-mib.h"
#include "www-mib/www-mib-services.h"
#include "www-mib/www-mib-document.h"

#ifndef SNMP_MIN
#define SNMP_MIN(a,b)   (((a)<(b)) ? (a) : (b))
#endif

#define NEXT	FALSE
#define EXACT	TRUE
#define INDEX	2

#ifdef WWW_MIB
FindVarMethod read_wwwServiceEntry;

server_rec *
get_admin_wwwService_row(struct variable *vp,
	oid *name, size_t *namelength,
	oid *newname, size_t *newname_length,
	int exact, server_rec *server)
{
oid *ptr;

    *newname_length = vp->namelen;
    memcpy((char *)newname, (char *)vp->name, *newname_length * sizeof(oid));
    ptr = &(newname[ (*newname_length)++ ]);
    *ptr = 1;
    while (server) {
        switch (exact) {
            case NEXT:
                if ( 0 > snmp_oid_compare(name, *namelength,
                                          newname, *newname_length)) {
                    return(server);
                }
                break;
            case EXACT:
                if ( 0 == snmp_oid_compare(name, *namelength,
                                           newname, *newname_length)) {
                    return(server);
                }
                break;
        }
	(*ptr)++;
        server = server->next;
    }
    return(NULL);
}

unsigned char *
read_wwwServiceEntry(
    struct variable *vp,
    oid     *name,
    size_t  *length,
    int     exact,
    size_t  *var_len,
    WriteMethod **write_method)
{
static oid protocol_oid[] = { 1, 3, 6, 1, 2, 1, 6, 80 };
oid newname[ MAX_OID_LEN ];
size_t newname_length;
server_rec *service;

    service = get_admin_wwwService_row(vp, name, length,
                                        newname, &newname_length, exact,
                                        get_www_service_root());
    if (!service) {
	return NULL; 
    }

    *length = newname_length;
    memcpy( (char *)name,(char *)newname, *length * sizeof(oid));
    *write_method = 0;
    *var_len = sizeof(long);

    switch (vp->magic) {
	case WWWSERVICEDESCRIPTION:
	    *var_len = strlen(ap_get_server_version());
	    return (unsigned char *) ap_get_server_version();
	case WWWSERVICECONTACT:
	    *var_len = strlen(service->server_admin);
	    return (unsigned char *) service->server_admin;
	case WWWSERVICEPROTOCOL:
            protocol_oid[ 7 ] = service->port;
	    *var_len = sizeof(protocol_oid);
	    return (unsigned char *) protocol_oid;
	case WWWSERVICENAME:
	    *var_len = strlen(service->server_hostname);
	    return (unsigned char *) service->server_hostname;
	case WWWSERVICETYPE:
	    long_return = 2; /* server only */
	    return (unsigned char *) &long_return;
	case WWWSERVICESTARTTIME:
	    *var_len = snmp_time2DateAndTime(ap_scoreboard_image->global
                                                   ->restart_time, return_buf);
	    return (unsigned char *) return_buf;
	case WWWSERVICEOPERSTATUS:
	    long_return = OPERSTATUS_RUNNING;
	    return (unsigned char *) &long_return;
	case WWWSERVICELASTCHANGE:
	    *var_len = snmp_time2DateAndTime(ap_scoreboard_image->global
                                                   ->restart_time, return_buf);
	    return (unsigned char *) return_buf;
        default:
            return NULL;
    }
}

oid wwwServiceEntry_oid[] = { 1, 3, 6, 1, 2, 1, 65, 1, 1, 1, 1 };
struct variable2 wwwServiceEntry_variables[] = {
    { WWWSERVICEDESCRIPTION, ASN_OCTET_STR, RONLY, read_wwwServiceEntry, 1, { 2 }},
    { WWWSERVICECONTACT, ASN_OCTET_STR, RONLY, read_wwwServiceEntry, 1, { 3 }},
    { WWWSERVICEPROTOCOL, ASN_OBJECT_ID, RONLY, read_wwwServiceEntry, 1, { 4 }},
    { WWWSERVICENAME, ASN_OCTET_STR, RONLY, read_wwwServiceEntry, 1, { 5 }},
    { WWWSERVICETYPE, ASN_INTEGER, RONLY, read_wwwServiceEntry, 1, { 6 }},
    { WWWSERVICESTARTTIME, ASN_OCTET_STR, RONLY, read_wwwServiceEntry, 1, { 7 }},
    { WWWSERVICEOPERSTATUS, ASN_INTEGER, RONLY, read_wwwServiceEntry, 1, { 8 }},
    { WWWSERVICELASTCHANGE, ASN_OCTET_STR, RONLY, read_wwwServiceEntry, 1, { 9 }}
};

void init_www_mib_services()
{
    REGISTER_MIB("www-mib/wwwServiceTable", wwwServiceEntry_variables, variable2, wwwServiceEntry_oid);
    /* insert the Object Resource in sysORTable */
#ifdef USING_MIBII_SYSORTABLE_MODULE
  register_sysORTable(wwwServiceEntry_oid, 9, "WWW Service Group of the WWW-MIB module");
#endif
}
#endif /* WWW_MIB */



