# Copyright (c) 2000-2009, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define jspspec 2.1
%define major_version 6
%define minor_version 0
%define micro_version 37
%define packdname apache-tomcat-%{version}-src
%define servletspec 2.5
%define elspec 1.0
%define tcuid 91

%define with_signing 1
%define patchnumber 01
%define patchlevel -patch-%{patchnumber}
%define release_patchlevel _patch_%{patchnumber}

# Sync with the RHEL release version
%define brew_arch noarch
%define brew_release 10_patch_01.ep6.el6


Name: tomcat6
Epoch: 0
Version: %{major_version}.%{minor_version}.%{micro_version}
Release: 10%{release_patchlevel}%{?dist}
Summary: Apache Servlet/JSP Engine, RI for Servlet %{servletspec}/JSP %{jspspec} API
Group: Networking/Daemons
License: ASL 2.0
URL: http://tomcat.apache.org/
#http://apache.mirror.rafal.ca/tomcat/tomcat-6/v6.0.32/src/apache-tomcat-6.0.32-src.tar.gz
Source0: http://www.apache.org/dist/tomcat/tomcat-6/v%{version}/src/%{packdname}.tar.gz
Source1: %{name}-%{major_version}.%{minor_version}.conf
Source2: %{name}-%{major_version}.%{minor_version}.init
Source3: %{name}-%{major_version}.%{minor_version}.wrapper
Source4: %{name}-%{major_version}.%{minor_version}.logrotate
# The jsvc.tar.gz is only availble in the binary zip from apache.org
# wget http://www.apache.org/dist/tomcat/tomcat-6/v6.0.24/bin/apache-tomcat-6.0.24.zip
# unzip apache-tomcat-6.0.24.zip apache-tomcat-6.0.24/bin/jsvc.tar.gz
# mv apache-tomcat-6.0.24/bin/jsvc.tar.gz tomcat6-6.0.24-jsvc.tar.gz
Source5: %{name}-%{major_version}.%{minor_version}-log4j.properties
Source6: %{name}-component-info.xml
Source7: %{name}-6.0.policy
Source8: %{name}-6.0.JBossPublicKey.RSA

# EWS scripts
Source20: %{name}-6.0.catalina.script
Source21: %{name}-6.0.service
Source22: %{name}-6.0.winscripts.tar
Source99: sign-unsigned-jars

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildArch: noarch
BuildRequires: zip

#win-buildrequires: xbuild
#win-buildrequires: jakarta-commons-daemon
#rpm-buildrequires: tomcat6-zip
#rpm-buildrequires: tomcat6-docs-webapp
#rpm-buildrequires: tomcat6-javadoc
#rpm-buildrequires: tomcat6-src-zip

%description
Tomcat is the servlet container that is used in the official Reference
Implementation for the Java Servlet and JavaServer Pages technologies.
The Java Servlet and JavaServer Pages specifications are developed by
Sun under the Java Community Process.

Tomcat is developed in an open and participatory environment and
released under the Apache Software License version 2.0. Tomcat is intended
to be a collaboration of the best-of-breed developers from around the world.

%build

%install
rm -rf $RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc


%changelog
* Fri Jun 21 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-10_patch_01
- Sync with upstream build.

* Thu Jun 20 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-8_patch_01
- Sync with upstream build.

* Tue Jun 18 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-7_patch_01
- Sync with upstream build.

* Tue Jun 18 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-6_patch_01
- Sync with upstream build.

* Wed Jun  5 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-3_patch_01
- Sync with upstream build.

* Mon Jun  3 2013 Mladen Turk <mturk@redhat.com> 0:6.0.37-1_patch_01
- Sync with upstream build.

* Tue May 21 2013 Mladen Turk <mturk@redhat.com> 0:6.0.35-33_patch_07
- Sync with upstream build.

* Mon May  6 2013 Mladen Turk <mturk@redhat.com> 0:6.0.35-30_patch_08
- Fix BZ959871.
  Ensure commons-daemon.jar is correctly linked in postinstall.

* Thu May  2 2013 Mladen Turk <mturk@redhat.com> 0:6.0.35-30_patch_07
- Sync with upstream build.

* Thu May  2 2013 Mladen Turk <mturk@redhat.com> 0:6.0.35-30_patch_06
- Sync with upstream build.

* Thu Dec 13 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-25_patch_01
- Sync with upstream build.

* Wed Oct 24 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-24_patch_01
- Sync with upstream build.

* Mon Oct 15 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-23_patch_02
- Rebuild.

* Fri Oct 12 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-23_patch_01
- Sync with upstream build.

*  Tue Oct  9 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-22_patch_01
- Sync with upstream build.

*  Thu Oct  4 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-21_patch_02
- Fix JBPAPP-9733.
- Fix JBPAPP-10087.
- Fix JBPAPP-10012.

*  Wed Sep 26 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-21_patch_01
- Sync with upstream build.

*  Fri Sep 14 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_05
- Fix typo in service.bat

*  Thu Sep  6 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_04
- Rebuild

*  Tue Sep  4 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_03
- Fix JBPAPP-9714

*  Mon Sep  3 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_02
- Rebuild.

*  Mon Sep  3 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-18_patch_01
- Rebuild with modified source packages.
- Sync with upstream build.

*  Mon Aug 20 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-17_patch_01
- Fix JBPAPP-9714.
- Sync with upstream build.

*  Mon Aug 06 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-16_patch_02
- Fix service library path.

*  Mon Aug 06 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-16_patch_01
- Fix JBPAPP-9568.
- Sync with upstream build.

* Tue Jul 24 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-14_patch_01
- Sync with upstream build.

* Mon Jul 23 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-13_patch_01
- Rebuild with latest upstream.

* Wed Jun 27 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-11_patch_02
- Fix windows symbolic links.

* Wed Jun 27 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-11_patch_01
- Sync with upstream build.

* Tue Jun 26 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-10_patch_01
- Sync with upstream build.

* Thu Jun 21 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-8_patch_01
- Sync with upstream build.

* Tue Jun 19 2012 Mladen Turk <mturk@redhat.com> 0:6.0.35-6_patch_01
- Sync with upstream build.
- Use mod_cluster and jboss-logging as dependencies.

* Sat Apr 28 2012 David Knox <dknox@redhat.com> 0:6.0.35-3_patch_01
- Jar signing turned off. Remove RSA and JBoss policy file.

* Tue Feb 07 2012 David Knox <dknox@redhat.com> 0:6.0.35-2_patch_01
- Added jboss-parent package to BuildRequires. Required for ep-6 and 
- forward.

* Mon Jan 17 2012 David Knox <dknox@redhat.com> 0:6.0.35-1_patch_01
- Update to 6.0.35 

* Wed Jan 04 2012 Permaine Cheung <pcheung@redhat.com> 0:6.0.32-25_patch_06
- Add artifacts juli and annotations-api

* Wed Jan 04 2012 Permaine Cheung <pcheung@redhat.com> 0:6.0.32-24_patch_06
- Fix version in poms for proper uploading to MEAD

* Wed Jan 04 2012 Permaine Cheung <pcheung@redhat.com> 0:6.0.32-23_patch_06
- Rebuild

* Wed Jan 04 2012 Permaine Cheung <pcheung@redhat.com> 0:6.0.32-22_patch_06
- Move maven2-brew content to java-signed so that they get uploaded to MEAD

* Fri Dec 09 2011 Permaine Cheung <pcheung@redhat.com> 0:6.0.32-21_patch_06
- Fix artifactId

* Wed Dec 07 2011 Permaine Cheung <pcheung@redhat.com> 0:6.0.32-20_patch_06
- Add maven2-brew content to repolib

* Wed Oct 26 2011 David Knox <dknox@redhat.com> 0:6.6.32-19_patch_06
- Resolves cve-2011-3190

* Wed Oct 26 2011 David Knox <dknox@redhat.com> 0:6.6.32-18_patch_05
- Resolves cve-2011-1184

* Thu Sep 15 2011 David Knox <dknox@redhat.com> 0:6.0.32-17_patch_04
- Resolves: JBPAPP-4873, JBPAPP-6133, JBPAPP-3630 mulitple security manager
- issues
- Resolves: JBPAPP-6852 - tomcat6.conf read twice

* Tue Jul 26 2011 David Knox <dknox@redhat.com> 0:6.0.32-16_patch_04
- Resolves: CVE-2011-2526
- Resolves: CVE-2011-2204

* Mon Jun 21 2011 David Knox <dknox@redhat.com> 0:6.0.32-15_patch_03
- jbpapp-3900 tomcat library organization

* Mon Jun 13 2011 David Knox <dknox@redhat.com> 0:6.0.32-14_patch_03
- jbpapp-6698 unsigned commons-daemon

* Wed May 25 2011 David Knox <dknox@redhat.com> 0:6.0.32-13_patch_03
- Resolves jbpapp-3749 - cannot resolve user database

* Tue May 10 2011 David Knox <dknox@redhat.com> 0:6.0.32-12_patch_03
- Resolves jbpapp-3669 stabilize initscript log name 
- Resolves jbpapp-3654 orig files in distro
- Resolves jbpapp-3749 cannot resolve user database reference
- Change default log levels in log4j.properties from DEBUG to INFO
- Resolves jbpapp-2955 EWS displays wrong version spec

* Tue Apr 05 2011 David Knox <dknox@redhat.com> 0:6.0.32-11_patch_03
- Fix permission issues

* Mon Apr 04 2011 David Knox <dknox@redhat.com> 0:6.0.32-10_patch_03
- Fix permission issues

* Mon Apr 04 2011 Permaine Cheung <pcheung@redhat.com> 0:6.0.32-9.1_patch_03
- Default to use signed jars

* Wed Mar 30 2011 David Knox <dknox@redhat.com> 0:6.0.32-9_patch_03
- catalina.sh uses start -security, init scripts use start-security

* Tue Mar 29 2011 David Knox <dknox@redhat.com> 0:6.0.32-8_patch_03
- JBPAPP-6122 config hints for JON

* Tue Mar 29 2011 David Knox <dknox@redhat.com> 0:6.0.32-7_patch_02
- JBPAPP-6037 manager role added to tomcat-users.xml

* Thu Mar 24 2011 David Knox <dknox@redhat.com> 0:6.0.32-6_patch_02
- JBPAPP-3669 initd scripts ouput to catalina.out
- JBPAPP-3654 remove orig files from distribution

* Wed Mar 23 2011 David Knox <dknox@redhat.com> 0:6.0.32-5.patch02
- resolves: jbpapp-3644 tomcat enable security manager. Typo in 
- init script.

* Thu Mar 17 2011 David Knox <dknox@redhat.com> 0:6.0.32-4.patch02
- resolves: jbpapp-6036/3749 - can't resolve user database,
- naming-factory-dbcp. Fix for zip install is in catalina.sh 
- Fix for rpm install is in tomcat6.conf

* Tue Mar 08 2011 David Knox <dknox@redhat.com> 0:6.0.32-3.patch01
- Updated R: with first bit of package revision number
- Add sign-unsigned-jars to build before zips are created

* Wed Mar 02 2011 David Knox <dknox@redhat.com> 0:6.0.32-2.patch01
- Update dependency versions

* Mon Feb 23 2011 David Knox <dknox@redhat.com> 0:6.0.32-1.patch01
- Rebase on tomcat 6.0.32. Removed patches 6,7,8 which are already
- in 6.0.32

* Tue Feb 07 2011 David Knox <dknox@redhat.com> 0:6.0.24-11.patch03
- Resolves: CVE-2011-0534

* Thu Feb 03 2011 David Knox <dknox@redhat.com? 0:6.0.24-10.patch02
- Run the new patch 

* Wed Feb 02 2011 David Knox <pcheung@redhat.com> 0:6.0.24-9.patch02
- Resolves rhbz 674601 JDK Double.parseDouble DoS

* Wed Nov 03 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.24-8.patch01
- Remove tribes javadocs
- Fix end of line in zip

* Tue Jul 13 2010 David Knox <dknox@redhat.com> 0:6.0.24-7
- Resolved issue with patchlevel macro not expanding. Moved define
- to the front of the list

* Tue Jul 13 2010 David Knox <dknox@redhat.com> 0:6.0.24-6
- Add patch for CVE-2010-2227
- Resolves: #rhbz613945  
- JBPAPP-4607 JBPAPP-4532
- Completed patchlevel macro and added this patch to repolib install

* Mon Jun 21 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.24-5
- Rebuild with signatures

* Tue May 18 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.24-3.3.JBPAPP4221
- Add patch for JBPAPP-4221 for a one off

* Thu May 13 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.24-3.2.JBPAPP4188
- Add patch for JBPAPP-4188 for a one off

* Fri Mar 05 2010 Yong Yang <yyang@redhat.com> 0:6.0.24-3.1
- Merge with RHEL-4-EP-5 branch, add repolib

* Thu Feb 11 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.24-2.1
- Merge with RHEL-4-EP-5 branch

* Thu Feb 11 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.24-2
- Add R: jakarta-commons-logging-tomcat6

* Fri Jan 22 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.24-1.1
- Merge with RHEL-4-EP-5 branch

* Thu Jan 21 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.24-1
- Upgrade to 6.0.24
- Update patches
- Do not build windows zip

* Tue Jan 19 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.20-1.3
- Copy jars instead of creating symlink for packages that exist in base RHEL

* Fri Jan 15 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.20-1.2
- Rebuild

* Mon Jan 11 2010 Permaine Cheung <pcheung@redhat.com> 0:6.0.20-1.1
- Merge with RHEL-4-EP-5 branch

* Wed Sep 18 2009 Dave Knox <dknox@redhat.com> 0:6.0.18-12.0
- Respin for CVE-2208-5515 which was believed to have been applied
  in tomcat6.0.18 but was not present.

* Wed Sep 09 2009 Dave Knox <dknox@redhat.com> 0:6.0.18-11.0
- Errata respin for el-api. 

* Tue Jul 21 2009 Dave Knox <dknox@redhat.com> 0:6.0.18-10.2
- Xalan-j2 test was successful. Adding CVE-2009-0033, CVE-2009-0580, CVE-2009-0783. CVE-2008-5515 not applied, it is already present in 6.0.18.

* Tue Jul 21 2009 Dave Knox <dknox@redhat.com> 0:6.0.18-10.1t
- Adding xalan-j2 to fix build problem - java.lang.NoClassDefFoundError: org/apache/xml/serializer/SerializerTrace

* Tue May 12 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-9.1.1
- Merge with RHEL-4-EP-5 branch

* Wed Mar 25 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.18.1
- Merge with RHEL-4-EP-5 branch

* Wed Mar 18 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.16.1
- Merge with RHEL-4-EP-5 branch

* Mon Mar 16 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.15.1
- Merge with RHEL-4-EP-5 branch

* Mon Mar 16 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.15
- Add Requires: jakarta-commons-logging-tomcat6 for log4j subpackage

* Thu Mar 12 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.14.1
- Merge with RHEL-4-EP-5 branch

* Sat Feb 28 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.12.1
- Merge with RHEL-4-EP-5 branch

* Tue Feb 24 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.11.1
- Merge with RHEL-4-EP-5 branch

* Mon Feb 23 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.11
- Modify zip

* Tue Feb 17 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.10.1
- Merge with RHEL-4-EP-5 branch

* Tue Feb 17 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.10
- Do not build with ws by default

* Mon Feb 09 2009 David Walluck <dwalluck@redhat.com> 0:6.0.18-8.9
- add optional ws subpackage
- add log4j subpackage

* Mon Jan 26 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.8
- Remove examples

* Fri Jan 23 2009 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.7.1
- Merge with RHEL-4-EP-5 version
- Add jsvc.tar.gz

* Wed Jan 21 2009 David Walluck <dwalluck@redhat.com> 0:6.0.18-8.6
- don't apply MANIFEST.MF patch for bootstrap.jar
- remove .pdf files in %%prep
- don't bother making scripts +x since zip task doesn't store perms
- correctly set OPT_JAR_LIST

* Wed Jan 21 2009 David Walluck <dwalluck@redhat.com> 0:6.0.18-8.5
- disable copy of tomcat-native.tar.gz and commons-daemon.jsvc.tar.gz
- create monolithic tomcat-dbcp.jar for build
- BuildRequires: jakarta-taglibs-standard for sample webapp
- use included build.xml to generate sample.war
- try to match upstream jar names for bundled jars
- make .sh scripts executable
- remove incorrect use of build-jar-repository from %%post
- own alternatives symlinks as %%ghost

* Fri Jan 16 2009 David Walluck <dwalluck@redhat.com> 0:6.0.18-8.4
- produce zips from included dist.xml
- own directories in zip package
- add additional documentation to main package

* Thu Dec 04 2008 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-6.1
- Use ecj3 instead of ecj

* Tue Nov 25 2008 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.3
- Add back the binary zip

* Tue Nov 25 2008 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.2
- Do not produce the binary zip

* Fri Nov 14 2008 Permaine Cheung <pcheung@redhat.com> 0:6.0.18-8.1
- Add optional -zip and -src-zip subpackage

* Tue Nov 04 2008 Yong Yang <yyang@redhat.com> 0:6.0.18-8
- force BR java-devel = 1.5.0,so that can run on JDK5 and JDK6

* Tue Nov 04 2008 Yong Yang <yyang@redhat.com> 0:6.0.18-7
- fix "log_*_msg command not found"(only modified tomcat6-6.0.init)

* Tue Oct 07 2008 David Walluck <dwalluck@redhat.com> 0:6.0.18-6
- use lsb_release instead of lsb-release to get the distributor

* Tue Oct 07 2008 David Walluck <dwalluck@redhat.com> 0:6.0.18-5
- fix initscript messages on Mandriva Linux
- fix help message in initscript

* Wed Oct 01 2008 David Walluck <dwalluck@redhat.com> 0:6.0.18-4
- redefine %%_initrddir for FHS-compliance
- make initscript LSB-complaint

* Fri Sep 26 2008 David Walluck <dwalluck@redhat.com> 0:6.0.18-3
- fix status in initscript

* Thu Sep 25 2008 David Walluck <dwalluck@redhat.com> 0:6.0.18-2
- remove initscripts and /sbin/service requirement
- call initscript directly without using /sbin/service
- require /sbin/chkconfig instead of chkconfig
- remove chkconfig requirement from packages that don't require it

* Tue Aug 26 2008 David Walluck <dwalluck@redhat.com> 0:6.0.18-1
- 6.0.18
- Resolves: CVE-2008-1232, CVE-2008-1947, CVE-2008-2370, CVE-2008-2938
- fix definition of java.security.policy with d%%{name} start-security
- don't pass $CATALINA_OPTS with d%%{name} stop
- redefine tempdir and workdir for tmpwatch workaround
- change eclipse-ecj references to ecj

* Thu Jul 10 2008 Tom "spot" Callaway <tcallawa@redhat.com> - 0:6.0.16-1.8
- drop repotag

* Fri Apr 04 2008 David Walluck <dwalluck@redhat.com> 0:6.0.16-1jpp.7.fc9
- version jsp and servlet Provides with their spec versions
- remove Obsoletes/Provides for servletapi6 package as it can co-exist
- check for java-functions existence in wrapper script
- move d%%{name} to %%{name} and create symlink for d%%{name}
- improve status function in initscript
- change license to ASL 2.0 again as per Fedora guidelines

* Mon Mar 24 2008 David Walluck <dwalluck@redhat.com> 0:6.0.16-1jpp.6.fc9
- remove Requires: tomcat-native
- put back original JPackage Group (except javadoc) and License tags
- add Provides for jsp and servlet
- use ant macro
- build and install sample webapp
- call /sbin/service to stop service on uninstall
- remove references to $RPM_BUILD_DIR
- use copy instead of move to fix short-circuit install build
- remove prebuilt sample.war
- remove Thumbs.db files
- add Requires: java >= 0:1.6.0

* Wed Mar 19 2008 David Walluck <dwalluck@redhat.com> 0:6.0.16-1jpp.5.fc9
- explicitly unset CLASSPATH
- explicitly set OPT_JAR_LIST to include ant/ant-trax

* Tue Mar 18 2008 David Walluck <dwalluck@redhat.com> 0:6.0.16-1jpp.4.fc9
- remove BuildRequires: sed
- remove specific references to icedtea

* Mon Mar 17 2008 David Walluck <dwalluck@redhat.com> 0:6.0.16-1jpp.3.fc9
- add digest and tool-wrapper scripts
- Requires: tomcat-native

* Fri Mar 7 2008 David Walluck <dwalluck@redhat.com> 0:6.0.16-1jpp.2.fc9
- use %%{_var} for appdir instead of /srv
- use ${JAVACMD} for java executable in wrapper script
- use built-in status function in initscript where possible
- add missing require on procps for status function
- fix java.library.path setting in %%{_sysconfdir}/sysconfig/%%{name}
- add patch to document webapps in %%{_sysconfdir}/%%{name}/tomcat-users.xml
- remove %%{appdir}/ROOT/admin
- move %%{_bindir}/d%%{name} to %%{_sbindir}/d%%{name}

* Mon Mar 3 2008 David Walluck <dwalluck@redhat.com> 0:6.0.16-1jpp.1.fc9
- use %%{_initrddir} macro instead of %%{_sysconfdir}/init.d (rhbz #153187)
- fix java.library.path setting in %%{name}.conf (rhbz #253605)
- fix incorrect initscript output (rhbz #380921)
- update initscript (rhbz #247077)
- add logrotate support
- fix strange-permission
- fix %%prep
- replace /var with %%{_var}
- replace %%{_localstatedir} with %%{_var}
- use %%{logdir} where possible
- call build-jar-repository with full path in scriptlets
- remove file-based requires
- build with icedtea and set as the default JAVA_HOME in %%{name}.conf
- fix non-standard-group
- change ecj references to eclipse-ecj
- change Apache Software License 2.0 to ASL 2.0 for rpmlint

* Fri Feb  8 2008 Jason Corley <jason.corley@gmail.com> - 0:6.0.16-1jpp
- update to 6.0.16

* Sun Dec  2 2007 Jason Corley <jason.corley@gmail.com> - 0:6.0.14-2jpp
- add /etc/tomcat6/Catalina/localhost (Alexander Kurtakov)

* Tue Aug 14 2007 Jason Corley <jason.corley@gmail.com> 0:6.0.14-1jpp
- first JPackage release
