# Copyright (c) 2000-2009, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

%define jspspec 2.2
%define major_version 7
%define minor_version 0
%define micro_version 40
%define packdname apache-tomcat-%{version}-src
%define servletspec 3.0
%define elspec 1.0
%define tcuid 91

%define patchnumber 01
%define patchlevel -patch-%{patchnumber}
%define release_patchlevel _patch_%{patchnumber}

# Sync with the RHEL release version
%define brew_arch noarch
%define brew_release 5_patch_01.ep6.el6

Name: tomcat7
Epoch: 0
Version: %{major_version}.%{minor_version}.%{micro_version}
Release: 5%{release_patchlevel}%{?dist}
Summary: Apache Servlet/JSP Engine, RI for Servlet %{servletspec}/JSP %{jspspec} API
Group: Networking/Daemons
License: ASL 2.0
URL: http://tomcat.apache.org/
#http://apache.mirror.rafal.ca/tomcat/tomcat-6/v6.0.32/src/apache-tomcat-6.0.32-src.tar.gz
Source0: http://www.apache.org/dist/tomcat/tomcat-7/v%{version}/src/%{packdname}.tar.gz
Source1: %{name}-%{major_version}.%{minor_version}.conf
Source2: %{name}-%{major_version}.%{minor_version}.init
Source3: %{name}-%{major_version}.%{minor_version}.wrapper
Source4: %{name}-%{major_version}.%{minor_version}.logrotate
# The jsvc.tar.gz is only availble in the binary zip from apache.org
# wget http://www.apache.org/dist/tomcat/tomcat-6/v6.0.24/bin/apache-tomcat-6.0.24.zip
# unzip apache-tomcat-6.0.24.zip apache-tomcat-6.0.24/bin/jsvc.tar.gz
# mv apache-tomcat-6.0.24/bin/jsvc.tar.gz tomcat6-6.0.24-jsvc.tar.gz
Source5: %{name}-%{major_version}.%{minor_version}-log4j.properties
Source6: %{name}-component-info.xml
Source7: %{name}-7.0.policy
Source8: %{name}-7.0.JBossPublicKey.RSA

# EWS scripts
Source20: %{name}-7.0.catalina.script
Source21: %{name}-7.0.service
Source22: %{name}-7.0.winscripts.tar

Source99: sign-unsigned-jars

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root
BuildArch: noarch
BuildRequires: zip

#win-buildrequires: xbuild
#win-buildrequires: jakarta-commons-daemon
#rpm-buildrequires: tomcat7-zip
#rpm-buildrequires: tomcat7-docs-webapp
#rpm-buildrequires: tomcat7-javadoc
#rpm-buildrequires: tomcat7-src-zip

%description
Tomcat is the servlet container that is used in the official Reference
Implementation for the Java Servlet and JavaServer Pages technologies.
The Java Servlet and JavaServer Pages specifications are developed by
Sun under the Java Community Process.

Tomcat is developed in an open and participatory environment and
released under the Apache Software License version 2.0. Tomcat is intended
to be a collaboration of the best-of-breed developers from around the world.


%prep
%setup -q -c -T -a 0

%build

%install
rm -rf $RPM_BUILD_ROOT

%clean
rm -rf $RPM_BUILD_ROOT


%files
%defattr(-,root,root,-)
%doc

%changelog
* Fri Jun 21 2013 Mladen Turk <mturk@redhat.com> 0:7.0.40-5_patch_01
- Sync with upstream build.

* Thu Jun 20 2013 Mladen Turk <mturk@redhat.com> 0:7.0.40-4_patch_01
- Sync with upstream build.

* Tue Jun 18 2013 Mladen Turk <mturk@redhat.com> 0:7.0.40-3_patch_01
- Sync with upstream build.

* Mon Jun  3 2013 Mladen Turk <mturk@redhat.com> 0:7.0.40-1_patch_01
- Sync with upstream build.

* Tue May 21 2013 Mladen Turk <mturk@redhat.com> 0:7.0.30-7_patch_03
- Sync with upstream build.

* Mon May  6 2013 Mladen Turk <mturk@redhat.com> 0:7.0.30-5_patch_04
- Fix BZ959871.
  Ensure commons-daemon.jar is correctly linked in postinstall.

* Thu May  2 2013 Mladen Turk <mturk@redhat.com> 0:7.0.30-5_patch_03
- Sync with upstream build.

* Thu May  2 2013 Mladen Turk <mturk@redhat.com> 0:7.0.30-5_patch_02
- Sync with upstream build.

* Wed Oct 24 2012 Mladen Turk <mturk@redhat.com> 0:7.0.30-3_patch_01
- Sync with upstream build.

*  Thu Oct  4 2012 Mladen Turk <mturk@redhat.com> 0:7.0.30-1_patch_02
- Fix JBPAPP-9733.
- Fix JBPAPP-10087.
- Fix JBPAPP-10012.

*  Wed Sep 26 2012 Mladen Turk <mturk@redhat.com> 0:7.0.30-1_patch_01
- Sync with upstream build.

*  Fri Sep 21 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-1_patch_06
- Fix JBPAPP-9802

*  Fri Sep 15 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-1_patch_05
- Fix typo in service.bat

*  Thu Sep  6 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-1_patch_04
- Fix JBPAPP-9840

*  Tue Sep  4 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-1_patch_03
- Fix JBPAPP-9814
- Fix JBPAPP-9714

*  Mon Sep  3 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-1_patch_02
- Rebuild.

*  Mon Sep  3 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-1_patch_01
- Rebuild with modified source packages.
- Sync with upstream build.

*  Mon Aug 20 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-5_patch_01
- Fix JBPAPP-9714.
- Sync with upstream build.

* Mon Aug 06 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-2_patch_03
- Fix service library path.

* Mon Aug 06 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-2_patch_02
- Fix JBPAPP-9568.

* Tue Jul 24 2012 Mladen Turk <mturk@redhat.com> 0:7.0.29-2_patch_01
- Rebase to 7.0.29
- Sync with upstream build.

* Mon Jul 23 2012 Mladen Turk <mturk@redhat.com> 0:7.0.28-7_patch_01
- Sync with upstream build.

* Wed Jun 27 2012 Mladen Turk <mturk@redhat.com> 0:7.0.28-4_patch_02
- Fix windows symbolic links.

* Wed Jun 27 2012 Mladen Turk <mturk@redhat.com> 0:7.0.28-4_patch_01
- Sync with upstream build.

* Tue Jun 26 2012 Mladen Turk <mturk@redhat.com> 0:7.0.28-3_patch_01
- Sync with upstream build.

* Thu Jun 21 2012 Mladen Turk <mturk@redhat.com> 0:7.0.28-1_patch_01
- Sync with upstream build.

* Sat Apr 28 2012 David Knox <dknox@redhat.com> 0:7.0.27-5_patch_01
- Remove RSA and JBoss policy. No longer needed since jars are not signed

* Fri Apr 27 2012 Permaine Cheung <pcheung@redhat.com. 0:7.0.27-4_patch_01
- Unsign jars, except for the ones in repolib for MEAD upload

* Fri Apr 27 2012 David Knox <dknox@redhat.com. 0:7.0.27-3_patch_01
- WIP - need to turn jar signing off

* Mon Apr 23 2012 David Knox <dknox@redhat.com> 0:7.0.27-2_patch_01
- Fixed pom artifactIDs

* Tue Apr 17 2012 David Knox <dknox@redhat.com> 0:7.0.27-1_patch_01
- Update to 7.0.27

* Thu Apr 12 2012 David Knox <dknox@redhat.com> 0:7.0.25-2_patch_01
- After WIP commit and push of -1_patch_01. Build works.

* Tue Feb 14 2012 David Knox <dknox@redhat.com> 0:7.0.25-1_patch_01
- Import from jb-eap-6-rhel-6

