<?xml version="1.0" encoding="ISO-8859-1"?>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Strict//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" lang="fr" xml:lang="fr"><head><!--
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
              This file is generated from xml source: DO NOT EDIT
        XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX
      -->
<title>Guide de la mise en cache - Serveur Apache HTTP</title>
<link href="./style/css/manual.css" rel="stylesheet" media="all" type="text/css" title="Main stylesheet" />
<link href="./style/css/manual-loose-100pc.css" rel="alternate stylesheet" media="all" type="text/css" title="No Sidebar - Default font size" />
<link href="./style/css/manual-print.css" rel="stylesheet" media="print" type="text/css" />
<link href="./images/favicon.ico" rel="shortcut icon" /></head>
<body id="manual-page"><div id="page-header">
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p>
<p class="apache">Serveur Apache HTTP Version 2.2</p>
<img alt="" src="./images/feather.gif" /></div>
<div class="up"><a href="./"><img title="&lt;-" alt="&lt;-" src="./images/left.gif" /></a></div>
<div id="path">
<a href="http://www.apache.org/">Apache</a> &gt; <a href="http://httpd.apache.org/">Serveur HTTP</a> &gt; <a href="http://httpd.apache.org/docs/">Documentation</a> &gt; <a href="./">Version 2.2</a></div><div id="page-content"><div id="preamble"><h1>Guide de la mise en cache</h1>
<div class="toplang">
<p><span>Langues Disponibles: </span><a href="./en/caching.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/caching.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./tr/caching.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div>
<div class="outofdate">Cette traduction peut tre prime. Vrifiez la version
            anglaise pour les changements rcents.</div>

    <p>Ce document complte la documentation de rfrence des modules
    <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>,
    <code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code>, <code class="module"><a href="./mod/mod_mem_cache.html">mod_mem_cache</a></code>,
    <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> et du programme <a href="programs/htcacheclean.html">htcacheclean</a>.
    Il dcrit l'utilisation des fonctionnalits de mise en cache d'Apache
    pour acclrer les services web et proxy, tout en vitant les problmes
    courants et les erreurs de configuration.</p>
  </div>
<div id="quickview"><ul id="toc"><li><img alt="" src="./images/down.gif" /> <a href="#introduction">Introduction</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#overview">Vue d'ensemble de la mise en cache</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#security">Considrations sur la scurit</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#filehandle">Mise en cache de la gestion de fichier</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#inmemory">Mise en cache en mmoire</a></li>
<li><img alt="" src="./images/down.gif" /> <a href="#disk">Mise en cache sur disque</a></li>
</ul></div>
<div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="introduction" id="introduction">Introduction</a></h2>
    

    <p>Depuis la version 2.2 du serveur HTTP Apache, les modules
    <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>
    et <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> ne sont plus jugs exprimentaux
    et on considre qu'ils peuvent tre utiliss en production. Ces
    architectures de mise en cache constituent un puissant concept
    d'acclration de la gestion HTTP, tant comme serveur web originel
    que comme mandataire.</p>

    <p>Le module <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> et ses modules de soutien
    <code class="module"><a href="./mod/mod_mem_cache.html">mod_mem_cache</a></code> et <code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code>
    permettent une mise en cache intelligente du point de vue HTTP.
    Le contenu proprement dit est stock dans le cache,
    et mod_cache tente d'honorer tous les en-ttes HTTP et les options
    qui dfinissent la possibilit de mise en cache du contenu. Il gre non
    seulement le contenu local, mais aussi le contenu mandat.
    <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>
    est conu pour des configurations de mise en cache simples ou complexes,
    dans lesquels vous traitez de contenu mandat, de contenu local dynamique
    ou avez besoin d'acclrer l'accs  des fichiers locaux qui sont modifis
    au cours du temps.</p>

    <p>Le module <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> quant  lui, constitue une
    forme de mise en cache plus basique, mais quelques fois intressante.
    Plutt que de grer la complexit de s'assurer de manire active de la
    possibilit de mise en cache d'URLs,
    <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> fournit des mthodes pour la gestion
    et l'dition de fichiers en mmoire afin de maintenir un cache de fichiers
    dans l'tat o ils taient la dernire fois qu'Apache a dmarr.
    En tant que tel, <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> a t conu pour amliorer
    le temps d'accs  des fichiers locaux statiques qui ne sont modifis
    que rarement.</p>

    <p>Etant donn que <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> constitue une
    implmentation de mise en cache relativement simple, mises  part les
    sections spcifiques sur les directives <code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code> et <code class="directive"><a href="./mod/mod_file_cache.html#mmapfile">MMapFile</a></code>, les explications fournies
    dans ce guide concernent l'architecture de mise en cache du
    module <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>.</p>

    <p>Pour tirer parti efficacement de ce document, les bases de HTTP doivent
    vous tre familires, et vous devez avoir lu les sections
    <a href="urlmapping.html">Mise en correspondance des
    URLs avec le systme de fichiers</a> et
    <a href="content-negotiation.html">Ngociation sur le contenu</a>
    du guide de l'utilisateur.</p>

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="overview" id="overview">Vue d'ensemble de la mise en cache</a></h2>

    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code></li><li><code class="module"><a href="./mod/mod_mem_cache.html">mod_mem_cache</a></code></li><li><code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code></li><li><code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_cache.html#cacheenable">CacheEnable</a></code></li><li><code class="directive"><a href="./mod/mod_cache.html#cachedisable">CacheDisable</a></code></li><li><code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code></li><li><code class="directive"><a href="./mod/mod_file_cache.html#mmapfile">MMapFile</a></code></li><li><code class="directive"><a href="./mod/core.html#usecanonicalname">UseCanonicalName</a></code></li><li><code class="directive"><a href="./mod/mod_negotiation.html#cachenegotiateddocs">CacheNegotiatedDocs</a></code></li></ul></td></tr></table>

    <p><code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> peut faire intervenir deux phases
    principales pendant la dure de vie d'une requte.
    En premier lieu, <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>
    est un module de mise en correspondance d'URLs, ce qui signifie que si
    une URL a t mise en cache, et que la version du cache de cette URL n'est
    pas arrive  expiration, la requte sera traite directement par
    <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>.</p>

    <p>Ceci entrane que toutes autres actions qui se drouleraient normalement
    au cours du processus de traitement d'une requte -- par exemple un
    traitement effectu par <code class="module"><a href="./mod/mod_proxy.html">mod_proxy</a></code>, ou
    <code class="module"><a href="./mod/mod_rewrite.html">mod_rewrite</a></code> --
    ne seront pas effectues. Mais c'est justement l'intrt
    de la mise en cache pralable du contenu.</p>

    <p>Si l'URL ne se trouve pas dans le cache, <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>
    va ajouter un <a href="filter.html">filtre</a> au traitement de la requte.
    Une fois le contenu de la rponse HTTP trouv par Apache de manire classique, le
    filtre sera excut en mme temps que le contenu sera transmis au client.
    S'il est dtermin que le contenu peut tre mis en cache,
    il sera sauvegard dans le cache pour une utilisation future.</p>

    <p>Si l'URL se trouve dans le cache, mais est arrive  expiration,
    le filtre est quand-mme ajout, mais <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> va crer
    une requte conditionnelle en arrire-plan, pour dterminer si la version
    du cache est encore  jour. Si la version du cache est encore  jour, ses
    meta-informations seront mises  jour et la requte sera servie  partir du
    cache. Si la version du contenu n'est plus  jour, elle sera supprime et le
    filtre va sauvegarder le contenu mis  jour dans le cache
    au moment o il sera servi.</p>

    <h3>Amlioration du taux de prsence dans le cache</h3>
      

      <p>Lors de la mise en cache de contenu gnr localement, le
      positionnement de la directive
      <code class="directive"><a href="./mod/core.html#usecanonicalname">UseCanonicalName</a></code> 
      <code>On</code> peut amliorer de manire spectaculaire le taux de
      prsence dans le cache. Ceci est du au fait que le nom d'hte de l'hte
      virtuel qui sert le contenu constitue une partie de la cl de cache.
      Avec <code class="directive"><a href="./mod/core.html#usecanonicalname">UseCanonicalName</a></code> positionne
       <code>On</code>,
      les htes virtuels possdant plusieurs noms de serveur ou alias ne
      gnreront pas d'entits de cache diffrentes, et le contenu sera mis en
      cache en faisant rfrence au nom d'hte canonique.</p>

      <p>Les documents mis en cache ne seront servis qu'en rponse  des
      requtes de type URL, car la mise en cache est effectue lors de la phase
      de traduction de l'URL en nom de fichier.
      En gnral, cela n'a que peu d'effet,  moins que vous n'utilisiez les
      <a href="howto/ssi.html">Inclusions Ct Serveur (SSI)</a>;</p>

      <div class="example"><pre>
&lt;!-- L'inclusion suivante peut tre mise en cache --&gt;
&lt;!--#include virtual="/footer.html" --&gt;

&lt;!-- L'inclusion suivante ne peut pas tre mise en cache --&gt;
&lt;!--#include file="/path/to/footer.html" --&gt;</pre></div>

      <p>Si vous utilisez les SSI, et voulez bnficier de la vitesse de
      service depuis le cache, vous devez utiliser des inclusions de type
      <code>virtual</code>.</p>
    

    <h3>Priodes d'expiration</h3>
      

      <p>La priode d'expiration par dfaut pour les entits du cache est
      d'une heure; elle peut cependant tre facilement modifie  l'aide de
      la directive <code class="directive"><a href="./mod/mod_cache.html#cachedefaultexpire">CacheDefaultExpire</a></code>. Cette valeur par
      dfaut n'est utilise que lorsque la source originale du contenu ne
      prcise pas de priode d'expiration ou d'heure de dernire
      modification.</p>

      <p>Si une rponse ne contient pas d'en-tte <code>Expires</code> mais
      inclut un en-tte <code>Last-Modified</code>, <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>
      peut dduire une priode d'expiration en se basant sur la valeur de la
      directive <code class="directive"><a href="./mod/mod_cache.html#cachelastmodifiedfactor">CacheLastModifiedFactor</a></code>.</p>

      <p>La priode d'expiration des contenus locaux peut tre ajuste finement
      en utilisant le module <code class="module"><a href="./mod/mod_expires.html">mod_expires</a></code>.</p>

      <p>On peut aussi contrler la priode d'expiration maximale en utilisant
      la directive <code class="directive"><a href="./mod/mod_cache.html#cachemaxexpire">CacheMaxExpire</a></code>.</p>

    

    <h3>Guide succinct des requtes conditionnelles</h3>
      

      <p>Lorsqu'un contenu est arriv  expiration dans le cache et fait
      l'objet d'une nouvelle demande d'accs, plutt que traiter directement
      la requte originale, Apache prfre utiliser une
      requte conditionnelle.</p>

      <p>HTTP propose toute une panoplie d'en-ttes qui permettent  un client,
      ou au cache de distinguer les diffrentes versions d'un mme contenu. Par
      exemple, si une ressource a t servie avec un en-tte "Etag:", il est
      possible de crer une requte conditionnelle contenant un en-tte
      "If-None-Match:". Si une ressource a t servie avec un en-tte
      "Last-Modified:", il est possible de crer une requte conditionnelle
      contenant un en-tte "If-Modified-Since:", etc....</p>

      <p>Lorsqu'une telle requte conditionnelle est cre, la reponse diffre
      selon que le contenu satisfait ou non aux conditions. Si une requte est
      cre avec un en-tte "If-Modified-Since:", et le contenu n'a pas t
      modifi depuis le moment indiqu dans la requte, alors un laconique
      "304 Not Modified" est retourn.</p>

      <p>Si le contenu a t modifi, il est servi comme si la requte n'avait
      pas t conditionnelle  l'origine.</p>

      <p>Les bnfices des requtes conditionnelles pour ce qui concerne la
      mise en cache sont de deux sortes. Premirement, quand une telle requte
      est envoye au processus en arrire-plan, il sera ais de dterminer
      si le contenu que devra servir le processus en arrire-plan correspond
      au contenu stock dans le cache, sans tre oblig de transmettre la
      totalit de la ressource.</p>

      <p>Deuximement, les requtes conditionnelles sont en gnral moins
      coteuses en ressources pour le processus en arrire-plan.
      Pour ce qui est des fichiers
      statiques, l'action type est un appel  <code>stat()</code> ou un appel
      systme similaire, pour dterminer si la taille du fichier ou sa date de
      modification ont chang. Ainsi, mme si Apache met en cache le contenu
      local, un contenu arriv  expiration pourra tre servi plus rapidement
      depuis le cache s'il n'a pas t modifi, parce que la lecture depuis le
      cache est plus rapide que la lecture depuis le processus en arrire-plan
      ( comparer  la diffrence de vitesse entre la lecture depuis un cache en
      mmoire et la lecture depuis un disque).</p>
    

    <h3>Que peut-on mettre en cache ?</h3>
      

      <p>Comme mentionn plus haut, les deux styles de mise en cache d'Apache
      fonctionnent diffremment; la mise en cache de
      <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> conserve les contenus des fichiers
      tels qu'ils taient au dmarrage d'Apache. Quand une requte pour un
      fichier mis en cache par ce module est envoye, elle est intercepte
      et le fichier mis en cache est servi.</p>

      <p>La mise en cache de <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>, quant  elle, est
      plus complexe. Lors du traitement d'une requte, le module de mise en
      cache dterminera si le contenu peut tre mis en cache, s'il ne l'a
      pas dj t auparavant. Les conditions qui permettent de dterminer
      la possibilit de mise en cache d'une rponse sont :</p>

      <ol>
        <li>La mise en cache doit tre active pour cette URL. Voir les
	directives <code class="directive"><a href="./mod/mod_cache.html#cacheenable">CacheEnable</a></code> et <code class="directive"><a href="./mod/mod_cache.html#cachedisable">CacheDisable</a></code>.</li>

        <li>La reponse doit avoir un code de statut HTTP de 200, 203, 300, 301
	ou 410.</li>

        <li>La requte doit tre de type HTTP GET.</li>

        <li>Si la requte contient un en-tte "Authorization:", la rponse ne
	sera pas mise en cache.</li>

        <li>Si la rponse contient un en-tte "Authorization:", elle doit aussi
	contenir une option "s-maxage", "must-revalidate" ou "public"
	dans l'en-tte "Cache-Control:".</li>

        <li>Si l'URL contenait une requte sous forme de chane de caractres
	(provenant par exemple d'une mthode GET de formulaire HTML), elle ne
	sera pas mise en cache  moins que la rponse ne contienne un en-tte
        "Expires:", comme prcis dans la RFC2616 section 13.9.</li>

        <li>Si la rponse a un statut de 200 (OK), elle doit aussi contenir
	au moins un des en-ttes "Etag", "Last-Modified" ou
        "Expires",  moins que la directive
        <code class="directive"><a href="./mod/mod_cache.html#cacheignorenolastmod">CacheIgnoreNoLastMod</a></code>
        ne prcise d'autres contraintes.</li>

        <li>Si la rponse contient l'option "private" dans un en-tte
	"Cache-Control:", elle ne sera pas mise en cache  moins que la
	directive
        <code class="directive"><a href="./mod/mod_cache.html#cachestoreprivate">CacheStorePrivate</a></code>
	ne prcise d'autres contraintes.</li>

        <li>De mme, si la rponse contient l'option "no-store" dans un en-tte
        "Cache-Control:", elle ne sera pas mise en cache  moins que la
	directive
        <code class="directive"><a href="./mod/mod_cache.html#cachestorenostore">CacheStoreNoStore</a></code>
	n'ait t utilise.</li>

        <li>Une rponse ne sera pas mise en cache si elle comporte un en-tte
	"Vary:" contenant le caractre "*" qui correspond  toute
	chane de caractres.</li>
      </ol>
    

    <h3>Qu'est ce qui ne doit pas tre mis en cache ?</h3>
      

      <p>En bref, tout contenu qui varie beaucoup avec le temps, ou en fonction
      de particularits de la requte qui ne sont pas couvertes par la
      ngociation HTTP, ne doit pas tre mis en cache.</p>

      <p>Un contenu dynamique qui varie en fonction de l'adresse IP du
      demandeur, ou qui est modifi toutes les 5 minutes, ne devra en gnral
      pas tre mis en cache.</p>

      <p>Si par contre le contenu servi diffre en fonction de la valeur de
      divers en-ttes HTTP, il se peut que l'on puisse le mettre en cache
      intelligemment en utilisant un en-tte "Vary".</p>
    

    <h3>Contenu variable et/ou ngoci</h3>
      

      <p>Si <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> reoit une rponse contenant un en-tte
      "Vary", lorsqu'un contenu a t demand par un processus d'arrire-plan,
      il va s'efforcer de la traiter intelligemment. Si possible,
      <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> va dtecter les en-ttes attribus dans la
      rponse "Vary"  l'occasion des futures demandes, et servir une rponse
      correcte  partir du cache.</p>

      <p>Si par exemple, une rponse est reue avec l'en-tte Vary suivant,</p>

      <div class="example"><p><code>
Vary: negotiate,accept-language,accept-charset
      </code></p></div>

      <p><code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> ne servira aux demandeurs que le contenu
      mis en cache qui correspond au contenu des en-ttes accept-language et
      accept-charset de la requte originale.</p>
    

  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="security" id="security">Considrations sur la scurit</a></h2>
    

    <h3>Autorisation et contrle d'accs</h3>
      

      <p>Utiliser <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> revient sensiblement  la mme
      chose qu'avoir un mandataire inverse intgr (reverse-proxy). Les requtes
      seront servies par le module de mise en cache sauf si ce dernier
      dtermine qu'un processus d'arrire-plan doit tre appel. La mise en
      cache de ressources locales modifie considrablement le modle de
      scurit d'Apache.</p>

      <p>Comme le parcours de la hirarchie d'un systme de fichiers pour
      examiner le contenu d'ventuels fichiers
      <code>.htaccess</code> serait une opration trs coteuse en ressources,
      annulant partiellement de ce fait l'intrt de la mise en cache
      (acclrer le traitement des requtes),
      <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> ne se proccupe pas de savoir s'il a
      l'autorisation de servir une entit mise en cache. En d'autres termes,
      si <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> a mis en cache un certain contenu, ce
      dernier sera servi  partir du cache tant qu'il ne sera pas arriv 
      expiration.</p>

      <p>Si par exemple, votre configuration autorise l'accs  une ressource
      en fonction de l'adresse IP, vous devez vous assurer que ce contenu n'est
      pas mis en cache. Ceci est possible en utilisant la directive
      <code class="directive"><a href="./mod/mod_cache.html#cachedisable">CacheDisable</a></code>, ou le module
      <code class="module"><a href="./mod/mod_expires.html">mod_expires</a></code>. Livr  lui-mme,
      <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code> - pratiquement comme un mandataire inverse -
      mettrait en cache le contenu lors de son service, et le servirait ensuite
       tout client, vers n'importe quelle adresse IP.</p>
    

    <h3>Piratages locaux</h3>
      

      <p>Etant donn que les requtes des utilisateurs finaux peuvent tre
      servies depuis le cache, ce dernier est une cible potentielle pour ceux
      qui veulent dfigurer un contenu ou interfrer avec lui. Il est important
      de garder  l'esprit que l'utilisateur sous lequel tourne Apache doit
      toujours avoir l'accs en criture dans le cache. Ceci est en contraste
      total avec la recommandation usuelle d'interdire  l'utilisateur sous
      lequel tourne Apache
      l'accs en criture  tout contenu.</p>

      <p>Si l'utilisateur sous lequel tourne Apache est compromis,
      par exemple  cause d'une
      faille de scurit dans un processus CGI, il est possible que le cache
      fasse l'objet d'une attaque. Il est relativement ais d'insrer ou de
      modifier une entit dans le cache en utilisant le module
      <code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code>.</p>

      <p>Cela reprsente un risque relativement lv par rapport aux autres
      types d'attaques qu'il est possible de mener sous l'utilisateur apache.
      Si vous utilisez <code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code>, vous devez garder ceci
       l'esprit : effectuez toujours les mises  jour d'Apache quand des
      correctifs de scurit sont annoncs et excutez les processus CGI sous
      un utilisateur autre qu'apache en utilisant
      <a href="suexec.html">suEXEC</a> dans la mesure du possible.</p>

    

    <h3>Empoisonnement du cache (Cache Poisoning)</h3>
      

      <p>Si vous utilisez Apache comme serveur mandataire avec mise en cache,
      vous vous exposez aussi  un ventuel "Empoisonnement du
      cache" (Cache poisoning). L'empoisonnement du cache est un terme gnral
      pour dsigner les attaques au cours desquelles l'attaquant fait en sorte
      que le serveur mandataire renvoie un contenu incorrect (et souvent
      indsirable) en provenance du serveur d'arrire plan.
      </p>

      <p>Par exemple, si les serveur DNS qu'utilise votre systme o tourne
      Apache sont vulnrables  l'empoisonnement du cache des DNS, un attaquant
      pourra contrler vers o Apache se connecte lorsqu'il demande un contenu
      depuis le serveur d'origine.
      Un autre exemple est constitu par les attaques ainsi nommes
      "Dissimulation de requtes HTTP" (HTTP request-smuggling).</p>

      <p>Ce document n'est pas le bon endroit pour une discussion approfondie
       propos de la Dissimulation de requtes HTTP (utilisez plutt votre
      moteur de recherche favori); il est cependant important de savoir qu'il
      est possible d'laborer une srie de requtes, et d'exploiter une
      vulnrabilit d'un serveur web d'origine de telle faon que l'attaquant
      puisse contrler entirement le contenu renvoy par le mandataire.</p>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="filehandle" id="filehandle">Mise en cache de la gestion de fichier</a></h2>
    

    <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code></li><li><code class="module"><a href="./mod/mod_mem_cache.html">mod_mem_cache</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code></li><li><code class="directive"><a href="./mod/mod_cache.html#cacheenable">CacheEnable</a></code></li><li><code class="directive"><a href="./mod/mod_cache.html#cachedisable">CacheDisable</a></code></li></ul></td></tr></table>

    <p>Le fait d'ouvrir un fichier peut en lui-mme introduire un dlai,
    en particulier dans les systmes de fichiers rpartis sur le rseau. Apache
    peut s'affranchir de ce dlai en maintenant
    un cache des descripteurs de fichiers
    ouverts pour ce qui concerne les fichiers souvent accds. Apache propose
    actuellement deux implmentations diffrentes de mise en cache de la
    gestion de fichier.</p>

    <h3>Directive CacheFile</h3>
      

      <p>La forme la plus lmentaire de mise en cache que propose Apache est
      fournie par le module <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code>.
      Plutt que de mettre en cache le contenu des fichiers, ce cache maintient
      une table des descripteurs de fichiers ouverts. Les fichiers  mettre en
      cache de cette manire sont spcifis dans le fichier de configuration
      en utilisant la directive
      <code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code>.</p>

      <p>La directive
      <code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code> demande  Apache
      d'ouvrir le fichier lors de son dmarrage et de rutiliser le descripteur
      de fichier labor  cette occasion pour tous les
      accs ultrieurs  ce fichier.</p>

      <div class="example"><pre>CacheFile /usr/local/apache2/htdocs/index.html</pre></div>

      <p>Si vous avez l'intention de mettre en cache un grand nombre de
      fichiers de cette manire, vous devez vous assurer que le nombre maximum
      de fichiers ouverts par votre systme d'exploitation est correctement
      dfini.</p>

      <p>Bien que l'utilisation de la directive
      <code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code>
      n'entrane pas la mise en cache du contenu du fichier, cela ne signifie
      pas qu'en cas de modification du fichier pendant l'excution d'Apache,
      ces changements seront pris en compte. Le fichier sera toujours servi
      dans l'tat o il tait quand Apache a dmarr.</p>

      <p>Si le fichier est supprim pendant l'excution d'Apache, ce dernier
      continuera  maintenir un descripteur de fichier ouvert et  servir le
      fichier dans l'tat o il tait quand Apache a dmarr. Cela signifie
      aussi habituellement que malgr le fait que le fichier ait t supprim,
      et ne soit
      plus accessible par le systme de fichiers, l'espace libr ne sera
      restitu qu' l'arrt d'Apache quand le
      descripteur de fichier sera ferm.</p>
    

    <h3>Directive CacheEnable</h3>
      

      <p>Le module <code class="module"><a href="./mod/mod_mem_cache.html">mod_mem_cache</a></code> propose aussi son propre
      schma de mise en cache de la gestion de fichier, qui peut tre activ
       l'aide de la directive
      <code class="directive"><a href="./mod/mod_cache.html#cacheenable">CacheEnable</a></code>.</p>

      <div class="example"><pre>CacheEnable fd /</pre></div>

      <p>A l'instar de tout ce qui concerne le module
      <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>, ce mode de mise en cache de la gestion de
      fichier est intelligent, et les descripteurs ne seront plus maintenus
      lorsque le contenu mis en cache sera arriv  expiration.</p>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="inmemory" id="inmemory">Mise en cache en mmoire</a></h2>
    

     <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_mem_cache.html">mod_mem_cache</a></code></li><li><code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_cache.html#cacheenable">CacheEnable</a></code></li><li><code class="directive"><a href="./mod/mod_cache.html#cachedisable">CacheDisable</a></code></li><li><code class="directive"><a href="./mod/mod_file_cache.html#mmapfile">MMapFile</a></code></li></ul></td></tr></table>

    <p>Servir un contenu directement depuis la mmoire systme est
    universellement reconnu comme la mthode la plus rapide. Lire des fichiers
    depuis un contrleur de disque ou pire, depuis un rseau distant est plus
    lent de plusieurs ordres de grandeur. Les contrleurs de disque ralisent
    en gnral des oprations mcaniques, et l'accs au rseau est limit par la
    bande passante dont vous disposez. Par contre, les temps d'accs  la
    mmoire sont de l'ordre de la nano-seconde.</p>

    <p>Cependant la mmoire systme n'est pas bon march;  capacit gale,
    c'est de loin le type de stockage le plus coteux et il est important de
    s'assurer qu'elle est utilise efficacement. Le fait de mettre en cache
    des fichiers en mmoire diminue d'autant la quantit de mmoire systme
    disponible. Comme nous le verrons plus loin, ce n'est pas un problme en
    soi dans le cas de la mise en cache par l'intermdiaire du systme
    d'exploitation, mais si l'on utilise la mise en cache en mmoire propre 
    Apache, il faut prendre garde  ne pas allouer trop de mmoire au cache.
    Sinon le systme sera contraint d'utiliser le swap, ce qui dgradera
    sensiblement les performances.</p>

    <h3>Mise en cache par l'intermdiaire du systme d'exploitation</h3>
      

      <p>Dans la plupart des systmes d'exploitation modernes, c'est le noyau
      qui gre directement la mise en cache en mmoire des donnes relatives
      aux fichiers. C'est une fonctionnalit puissante, et les systmes
      d'exploitation s'en acquittent fort bien pour la plus grande partie.
      Considrons par exemple, dans le cas de Linux, la diffrence entre le
      temps ncessaire  la premire lecture d'un fichier et le temps
      ncessaire  sa deuxime lecture;</p>

      <div class="example"><pre>
colm@coroebus:~$ time cat testfile &gt; /dev/null
real    0m0.065s
user    0m0.000s
sys     0m0.001s
colm@coroebus:~$ time cat testfile &gt; /dev/null
real    0m0.003s
user    0m0.003s
sys     0m0.000s</pre></div>

      <p>Mme pour ce petit fichier, il y a une grande diffrence entre les
      temps ncessaires pour lire le fichier. Ceci est du au fait que le
      noyau a mis en cache le contenu du fichier en mmoire.</p>

      <p>Du fait de toujours pouvoir disposer de mmoire systme, vous pouvez
      tre assur qu'il y aura de plus en plus de contenus de fichiers stocks
      dans ce cache. Ceci peut s'avrer une mthode de mise en cache en mmoire
      trs efficace, et ne ncessite aucune configuration supplmentaire
      d'Apache.</p>

      <p>De plus, comme le systme d'exploitation sait si des fichiers
      ont t
      supprims ou modifis, il peut effacer automatiquement des contenus de
      fichiers du cache lorsque cela s'avre ncessaire. Ceci constitue un gros
      avantage par rapport  la mise en cache en mmoire d'Apache qui n'a
      aucune possibilit de savoir si un fichier a t modifi.</p>
    

    <p>En dpit des performances et des avantages de la mise en cache
    automatique par le systme d'exploitation, la mise en cache en mmoire
    peut tre effectue plus efficacement par Apache dans certaines
    circonstances.</p>

    <p>En premier lieu, un systme d'exploitation ne peut mettre en cache que
    les fichiers dont il a connaissance. Si vous excutez Apache en tant que
    serveur mandataire, les fichiers que vous mettez en cache ne sont pas
    stocks en local mais sur un serveur distant. Si vous voulez tout de mme
    bnficier de la vitesse incomparable procure par la mise en cache en
    mmoire, la mise en cache propre  Apache sera ncessaire.</p>

    <h3>Mise en cache  l'aide de la directive MMapFile</h3>
      

      <p>La directive <code class="directive"><a href="./mod/mod_file_cache.html#mmapfile">MMapFile</a></code>
      fournie par le module <code class="module"><a href="./mod/mod_file_cache.html">mod_file_cache</a></code> vous permet de
      demander  Apache de charger un contenu de fichier statique en mmoire
      lors de son dmarrage ( l'aide de l'appel systme mmap). Apache
      utilisera le contenu charg en mmoire pour satisfaire ultrieurement
      toutes les demandes d'accs  ce fichier.</p>

      <div class="example"><pre>MMapFile /usr/local/apache2/htdocs/index.html</pre></div>

      <p>Comme dans le cas de la directive
      <code class="directive"><a href="./mod/mod_file_cache.html#cachefile">CacheFile</a></code>, toute
      modification du fichier ne sera plus prise en compte par Apache une fois
      ce dernier dmarr.</p>

      <p> La directive
      <code class="directive"><a href="./mod/mod_file_cache.html#mmapfile">MMapFile</a></code> ne gardant
      pas la trace de la quantit de mmoire qu'elle alloue, vous devez prendre
      garde de ne pas en abuser. Chaque processus enfant d'Apache utilisant
      sa propre rplique de la mmoire alloue, il est donc d'une importance
      critique de s'assurer que les fichiers chargs ne sont pas d'une taille
      trop importante afin d'pargner au systme l'utilisation du swap.</p>
    

    <h3>Mise en cache  l'aide du module mod_mem_cache</h3>
      

      <p>Le module <code class="module"><a href="./mod/mod_mem_cache.html">mod_mem_cache</a></code> propose une mise en cache en
      mmoire intelligente du point de vue du protocole HTTP. Il utilise aussi
      directement le "tas" de la mmoire, ce qui signifie que mme si
      <var>MMap</var> n'est pas support par votre systme,
      <code class="module"><a href="./mod/mod_mem_cache.html">mod_mem_cache</a></code> pourra quand-mme effectuer
      la mise en cache.</p>

      <p>La mise en cache selon cette mthode est active comme suit :</p>

      <div class="example"><pre>
# Activation de la mise en cache en mmoire
CacheEnable mem /

# Limite la taille du cache  1 Mgaoctet
MCacheSize 1024</pre></div>
    
  </div><div class="top"><a href="#page-header"><img alt="top" src="./images/up.gif" /></a></div>
<div class="section">
<h2><a name="disk" id="disk">Mise en cache sur disque</a></h2>
    

     <table class="related"><tr><th>Modules Apparents</th><th>Directives Apparentes</th></tr><tr><td><ul><li><code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code></li></ul></td><td><ul><li><code class="directive"><a href="./mod/mod_cache.html#cacheenable">CacheEnable</a></code></li><li><code class="directive"><a href="./mod/mod_cache.html#cachedisable">CacheDisable</a></code></li></ul></td></tr></table>

    <p>Le module <code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code> fournit un mcanisme de mise
    en cache sur disque au module <code class="module"><a href="./mod/mod_cache.html">mod_cache</a></code>. Comme dans le cas
    du module <code class="module"><a href="./mod/mod_mem_cache.html">mod_mem_cache</a></code>, cette mise en cache est
    intelligente et le contenu ne sera servi qu' partir du cache tant qu'il
    sera considr comme valide.</p>

    <p>Typiquement, le module sera configur comme suit :</p>

    <div class="example"><pre>
CacheRoot   /var/cache/apache/
CacheEnable disk /
CacheDirLevels 2
CacheDirLength 1</pre></div>

    <p>Il est important de savoir que, les fichiers mis en cache tant stocks
    localement, la mise en cache par l'intermdiaire du systme d'exploitation
    sera en gnral aussi applique  leurs accs. Si bien que mme si les
    fichiers sont stocks sur disque, s'il font l'objet d'accs frquents,
    il est probable que le systme d'exploitation s'appliquera  ce qu'ils
    soient servis  partir de la mmoire.</p>

    <h3>Comprendre le stockage dans le cache</h3>
      

      <p>Pour stocker des entits dans le cache,
      le module <code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code> cre une empreinte (hash) de 22
      caractres de l'URL qui a fait l'objet d'une requte. Cette empreinte
      comprend le nom d'hte, le protocole, le port, le chemin et tout argument
      de type CGI associ  l'URL, afin d'tre sur que plusieurs URLs
      n'interfrent pas entre elles.</p>

      <p>Chaque position de l'empreinte peut contenir un caractre
      choisi parmi 64 caractres diffrents, il y a donc
      64^22 possibilits pour une empreinte. Par exemple, une URL peut possder
      l'empreinte <code>xyTGxSMO2b68mBCykqkp1w</code>. Cette empreinte est
      utilise pour prfixer les noms de fichiers spcifiques  cette URL 
      l'intrieur du cache; cependant, elle est tout d'abord place dans les
      rpertoires du cache selon les directives
      <code class="directive"><a href="./mod/mod_disk_cache.html#cachedirlevels">CacheDirLevels</a></code> et
      <code class="directive"><a href="./mod/mod_disk_cache.html#cachedirlength">CacheDirLength</a></code>.</p>

      <p>La directive
      <code class="directive"><a href="./mod/mod_disk_cache.html#cachedirlevels">CacheDirLevels</a></code>
      dfinit le nombre de niveaux de sous-rpertoires, et
      <code class="directive"><a href="./mod/mod_disk_cache.html#cachedirlength">CacheDirLength</a></code>
      le nombre de caractres composant le nom des sous-rpertoires. Dans
      l'exemple donn plus haut, l'empreinte se trouvera  :
      <code>/var/cache/apache/x/y/TGxSMO2b68mBCykqkp1w</code>.</p>

      <p>Cette technique a pour but principal de rduire le nombre de
      sous-rpertoires ou de fichiers contenus dans un rpertoire particulier,
      car le fonctionnement de la plupart des systmes de fichiers est ralenti
      quand ce nombre augmente. Avec la valeur "1" pour la directive
      <code class="directive"><a href="./mod/mod_disk_cache.html#cachedirlength">CacheDirLength</a></code>,
      il peut y avoir au plus 64 sous-rpertoires  un niveau quelconque.
      Avec la valeur "2", il peut y en avoir 64 * 64, etc...
      A moins d'avoir une bonne raison pour ne pas le faire, l'utilisation de
      la valeur "1" pour la directive
      <code class="directive"><a href="./mod/mod_disk_cache.html#cachedirlength">CacheDirLength</a></code>
      est recommande.</p>

      <p>Le paramtrage de la directive
      <code class="directive"><a href="./mod/mod_disk_cache.html#cachedirlevels">CacheDirLevels</a></code>
      dpend du nombre de fichiers que vous pensez stocker dans le cache.
      Avec une valeur de "2" comme dans l'exemple donn plus haut,
      4096 sous-rpertoires peuvent tre crs au total. Avec 1 million de
      fichiers dans le cache, cela quivaut  environ 245 URLs mises en cache
      dans chaque rpertoire.</p>

      <p>Chaque URL ncessite au moins deux fichiers dans le cache. Ce sont en
      gnral un fichier ".header", qui contient des meta-informations  propos
      de l'URL, comme la date de son arrive  expiration,
      et un fichier ".data" qui est la copie exacte du contenu  servir.</p>

      <p>Dans le cas d'un contenu ngoci via l'en-tte "Vary", un rpertoire
      ".vary" sera cr pour l'URL en question. Ce rpertoire contiendra de
      multiples fichiers ".data" correspondant aux diffrents contenus
      ngocis.</p>
    

    <h3>Maintenance du cache sur disque</h3>
      

      <p>Bien que le module <code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code> supprime un contenu
      du cache lorsqu'il est arriv  expiration, il ne maintient aucune
      information  propos de la taille totale du cache ou de l'espace restant
      disponible.</p>

      <p>Par contre l'utilitaire
      <a href="programs/htcacheclean.html">htcacheclean</a> fourni avec Apache
      vous permet, comme son nom l'indique, de nettoyer le cache priodiquement.
      Dterminer la frquence  laquelle lancer <a href="programs/htcacheclean.html">htcacheclean</a> et la taille souhaite
      pour le cache est une tche relativement complexe et il vous faudra de
      nombreux essais et erreurs pour arriver  slectionner des valeurs
      optimales.</p>

      <p><a href="programs/htcacheclean.html">htcacheclean</a> opre selon deux
      modes. Il peut s'excuter comme dmon rsident, ou tre lanc
      priodiquement par cron. <a href="programs/htcacheclean.html">htcacheclean</a> peut mettre une heure
      ou plus pour traiter de trs grands caches (plusieurs dizaines de
      Gigaoctets) et si vous l'excutez  partir de cron, il vous est
      conseill de dterminer la dure typique d'un traitement, afin d'viter
      d'excuter plusieurs instances  la fois.</p>

      <p class="figure">
      <img src="images/caching_fig1.gif" alt="" width="600" height="406" /><br />
      <a id="figure1" name="figure1"><dfn>Figure 1</dfn></a>: Croissance
      typique du cache / squence de nettoyage.</p>

      <p>Comme <code class="module"><a href="./mod/mod_disk_cache.html">mod_disk_cache</a></code> ne tient pas compte de l'espace
      utilis dans le cache, vous devez vous assurer que
      <a href="programs/htcacheclean.html">htcacheclean</a> est configur de
      faon  laisser suffisamment d'"espace de croissance"
       la suite d'un nettoyage.</p>
    

  </div></div>
<div class="bottomlang">
<p><span>Langues Disponibles: </span><a href="./en/caching.html" hreflang="en" rel="alternate" title="English">&nbsp;en&nbsp;</a> |
<a href="./fr/caching.html" title="Franais">&nbsp;fr&nbsp;</a> |
<a href="./tr/caching.html" hreflang="tr" rel="alternate" title="Trke">&nbsp;tr&nbsp;</a></p>
</div><div id="footer">
<p class="apache">Copyright 2012 The Apache Software Foundation.<br />Autoris sous <a href="http://www.apache.org/licenses/LICENSE-2.0">Apache License, Version 2.0</a>.</p>
<p class="menu"><a href="./mod/">Modules</a> | <a href="./mod/directives.html">Directives</a> | <a href="./faq/">FAQ</a> | <a href="./glossary.html">Glossaire</a> | <a href="./sitemap.html">Plan du site</a></p></div>
</body></html>