/* $Id: generic-logging.h 8676 2008-01-17 23:11:17Z ispringer $ */

#ifndef __GENERIC_LOGGING_H__
#define __GENERIC_LOGGING_H__

#ifndef WIN32
/* On UNix we can use ORIGINATOR and RECIPIENT equal. */
#define ORIGINATOR 0
#define RECIPIENT  0
/* Total amount of log pipe end/sides. */
#define PIPEENDS   1
#else /* WIN32 */
#define ORIGINATOR 0
#define RECIPIENT  1
/* Total amount of log pipe end/sides. */
#define PIPEENDS   2
#endif /* WIN32 */

typedef struct {
    int socket[ PIPEENDS ];
#ifdef __socklen_t_defined
    socklen_t address_size[ PIPEENDS ];
#else
    size_t address_size[ PIPEENDS ];
#endif
    struct sockaddr_in address[ PIPEENDS ];
} snmpcommon_logpath_t;

SNMPCOMMON_DECLARE(snmpcommon_logpath_t *) snmpcommon_logpath_open(const int who, char *key, apr_pool_t *p);
SNMPCOMMON_DECLARE(void) snmpcommon_logpath_close(snmpcommon_logpath_t *logpath, const int who);
SNMPCOMMON_DECLARE(int) snmpcommon_logpath_write(snmpcommon_logpath_t *logpath, void *data, int datalen);
SNMPCOMMON_DECLARE(int) snmpcommon_logpath_read(snmpcommon_logpath_t *logpath, void *data, int datalen);
SNMPCOMMON_DECLARE(int) snmpcommon_logpath_socket(snmpcommon_logpath_t *logpath, const int who);
SNMPCOMMON_DECLARE(char *) snmpcommon_logpath_errstr(int err);

#endif /* __GENERIC_LOGGING_H__ */
