/*
 * This file implements the WWW service extensions of the
 * COVALENT-APACHE-SERVER-MIB module.
 * $Id: server-service.c 8676 2008-01-17 23:11:17Z ispringer $
 */
/* General includes */
#include <stdio.h>
#include <sys/types.h>

/* Apache includes */
#include <httpd.h>
#include <mpm.h>

/* SNMP includes */
#include "ucd-snmp-config.h"
#include "asn1.h"
#include "snmp.h"
#include "snmp_api.h"
#include "snmp_impl.h"
#include "snmp_debug.h"
#include "snmp_vars.h"
#include "var_struct.h"
#include "default_store.h"

#include "covalent-snmp-config.h"
#include "snmpcommon/snmpcommon.h"
#include "www-mib/www-mib-services.h"
#include "apache-server-mib.h"

#ifdef COVALENT_APACHE_SERVER_WWW_SERVICE_GROUP
/* objects of the module, columnar objects */
#define CTAPACHEWWWCONNECTIONTIMEOUT   1
#define CTAPACHEWWWKEEPALIVESWITCH     2
#define CTAPACHEWWWKEEPALIVEREQUESTS   3
#define CTAPACHEWWWKEEPALIVETIMEOUT    4
#define CTAPACHEWWWREQLINELIMIT        5
#define CTAPACHEWWWREQHEADERFIELDLIMIT 6
#define CTAPACHEWWWREQHEADERLIMIT      7


FindVarMethod var_ctApacheWwwServiceEntry;

unsigned char *
var_ctApacheWwwServiceEntry(
    struct variable *vp,
    oid     *name,
    size_t  *length,
    int     exact,
    size_t  *var_len,
    WriteMethod **write_method)
{
oid newname[ MAX_OID_LEN ];
size_t newname_length;
server_rec *service;

    service = get_admin_wwwService_row(vp, name, length,
                                newname, &newname_length,
                                exact, get_www_service_root());
    if (!service) {
        return NULL;
    }

    *length = newname_length;
    memcpy( (char *)name,(char *)newname, *length * sizeof(oid));
    /* *write_method = write_configServerEntry; */
    *write_method = NULL;
    *var_len = sizeof(long_return);    /* default to 'long' results */
    switch(vp->magic) {
    case CTAPACHEWWWCONNECTIONTIMEOUT:
        long_return = service->timeout;
        return (unsigned char *) &(long_return);
    case CTAPACHEWWWKEEPALIVESWITCH:
        long_return = service->keep_alive + 1;
        return (unsigned char *) &(long_return);
    case CTAPACHEWWWKEEPALIVEREQUESTS:
        long_return = service->keep_alive_max;
        return (unsigned char *) &(long_return);
    case CTAPACHEWWWKEEPALIVETIMEOUT:
        long_return = service->keep_alive_timeout;
        return (unsigned char *) &(long_return);
    case CTAPACHEWWWREQLINELIMIT:
        long_return = service->limit_req_line;
        return (unsigned char *) &(long_return);
    case CTAPACHEWWWREQHEADERFIELDLIMIT:
        long_return = service->limit_req_fieldsize;
        return (unsigned char *) &(long_return);
    case CTAPACHEWWWREQHEADERLIMIT:
        long_return = service->limit_req_fields;
        return (unsigned char *) &(long_return);
    }
    return(NULL);
}


oid ctApacheWwwServiceEntry_oid[] = { 1, 3, 6, 1, 4, 1, 6100, 9, 1, 2, 1 };
struct variable2 ctApacheWwwServiceEntry_variables[] = {
    { CTAPACHEWWWCONNECTIONTIMEOUT, ASN_INTEGER, RWRITE, var_ctApacheWwwServiceEntry, 1, {1} },
    { CTAPACHEWWWKEEPALIVESWITCH, ASN_INTEGER, RWRITE, var_ctApacheWwwServiceEntry, 1, {2} },
    { CTAPACHEWWWKEEPALIVEREQUESTS, ASN_INTEGER, RWRITE, var_ctApacheWwwServiceEntry, 1, {3} },
    { CTAPACHEWWWKEEPALIVETIMEOUT, ASN_INTEGER, RWRITE, var_ctApacheWwwServiceEntry, 1, {4} },
    { CTAPACHEWWWREQLINELIMIT, ASN_INTEGER, RWRITE, var_ctApacheWwwServiceEntry, 1, {5} },
    { CTAPACHEWWWREQHEADERFIELDLIMIT, ASN_INTEGER, RWRITE, var_ctApacheWwwServiceEntry, 1, {6} },
    { CTAPACHEWWWREQHEADERLIMIT, ASN_INTEGER, RWRITE, var_ctApacheWwwServiceEntry, 1, {7} }
};

void
init_covalent_apache_server_www_service_table()
{
    DEBUGTRACE;
    REGISTER_MIB("config-mib/MIBobjects", ctApacheWwwServiceEntry_variables,
					variable2, ctApacheWwwServiceEntry_oid);
}
#endif /* COVALENT_APACHE_SERVER_WWW_SERVICE_GROUP */
