<?xml version="1.0" encoding="ISO-8859-1" ?>
<!DOCTYPE manualpage SYSTEM "../style/manualpage.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- English Revision : 1411510 -->
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<manualpage metafile="ssl_howto.xml.meta">
<parentdocument href="./">SSL/TLS</parentdocument>

  <title>Chiffrement fort SSL/TLS : Mode d'emploi</title>

<summary>

<p>Ce document doit vous permettre de d&eacute;marrer et de faire fonctionner
une configuration de base. Avant de vous lancer dans l'application de
techniques avanc&eacute;es, il est fortement recommand&eacute; de lire le reste
de la documentation SSL afin d'en comprendre le fonctionnement de
mani&egrave;re plus approfondie.</p>
</summary>

<section id="configexample">
<title>Exemple de configuration basique</title>

<p>Votre configuration SSL doit comporter au moins les directives
suivantes :</p>

<highlight language="config">
LoadModule ssl_module modules/mod_ssl.so

Listen 443
&lt;VirtualHost *:443&gt;
    ServerName www.example.com
    SSLEngine on
    SSLCertificateFile /path/to/www.example.com.cert
    SSLCertificateKeyFile /path/to/www.example.com.key
&lt;/VirtualHost&gt;
</highlight>

</section>

<section id="ciphersuites">
<title>Suites de chiffrement et mise en application de la s&eacute;curit&eacute;
de haut niveau</title>
<ul>
<li><a href="#onlystrong">Comment cr&eacute;er un serveur SSL
qui n'accepte que le chiffrement fort ?</a></li>
<li><a href="#strongurl">Comment cr&eacute;er un serveur qui accepte tous les types de
chiffrement en g&eacute;n&eacute;ral, mais exige un chiffrement fort pour pouvoir
acc&eacute;der &agrave; une URL particuli&egrave;re ?</a></li>
</ul>


<section id="onlystrong">
<title>Comment cr&eacute;er un serveur SSL qui n'accepte
que le chiffrement fort ?</title>
    <p>Les directives suivantes ne permettent que les
    chiffrements de plus haut niveau :</p>
    <highlight language="config">
      SSLCipherSuite HIGH:!aNULL:!MD5
    </highlight>
</section>


 <p>Avec la configuration qui suit, vous indiquez une pr&eacute;f&eacute;rence pour
 des algorityhmes de chiffrement sp&eacute;cifiques optimis&eacute;s en mati&egrave;re de
 rapidit&eacute; (le choix final sera op&eacute;r&eacute; par mod_ssl, dans la mesure ou le
 client les supporte) :</p>

    <highlight language="config">
SSLCipherSuite RC4-SHA:AES128-SHA:HIGH:!aNULL:!MD5
SSLHonorCipherOrder on
    </highlight>
</section>

<section id="strongurl">
<title>Comment cr&eacute;er un serveur qui accepte tous les types de
chiffrement en g&eacute;n&eacute;ral, mais exige un chiffrement fort pour pouvoir
acc&eacute;der &agrave; une URL particuli&egrave;re ?</title>
    <p>Dans ce cas bien &eacute;videmment, une directive <directive
    module="mod_ssl">SSLCipherSuite</directive> au niveau du serveur principal
    qui restreint le choix des suites de chiffrement aux versions les plus
    fortes ne conviendra pas. <module>mod_ssl</module> peut cependant &ecirc;tre
    reconfigur&eacute; au sein de blocs <code>Location</code> qui permettent
    d'adapter la configuration g&eacute;n&eacute;rale &agrave; un r&eacute;pertoire sp&eacute;cifique ;
    <module>mod_ssl</module> peut alors forcer automatiquement une
    ren&eacute;gociation des param&egrave;tres SSL pour parvenir au but recherch&eacute;.
    Cette configuration peut se pr&eacute;senter comme suit :</p>
    <highlight language="config">
# soyons tr&egrave;s tol&eacute;rant a priori
SSLCipherSuite ALL:!aNULL:RC4+RSA:+HIGH:+MEDIUM:+LOW:+EXP:+eNULL

&lt;Location /strong/area&gt;
# sauf pour https://hostname/strong/area/ et ses sous-r&eacute;pertoires
# qui exigent des chiffrements forts
SSLCipherSuite HIGH:!aNULL:!MD5
&lt;/Location&gt;
    </highlight>
</section>
<!-- /ciphersuites -->

<section id="accesscontrol">
<title>Authentification du client et contr&ocirc;le d'acc&egrave;s</title>
<ul>
<li><a href="#allclients">Comment forcer les clients
&agrave; s'authentifier &agrave; l'aide de certificats ?</a></li>
<li><a href="#arbitraryclients">Comment forcer les clients
&agrave; s'authentifier &agrave; l'aide de certificats pour une URL particuli&egrave;re,
mais autoriser quand-m&ecirc;me tout client anonyme
&agrave; acc&eacute;der au reste du serveur ?</a></li>
<li><a href="#certauthenticate">Comment n'autoriser l'acc&egrave;s &agrave; une URL
particuli&egrave;re qu'aux clients qui poss&egrave;dent des certificats, mais autoriser
l'acc&egrave;s au reste du serveur &agrave; tous les clients ?</a></li>
<li><a href="#intranet">Comment imposer HTTPS avec chiffrements forts,
et soit authentification de base, soit possession de certificats clients,
pour l'acc&egrave;s &agrave; une partie de l'Intranet, pour les clients en
provenance de l'Internet ?</a></li>
</ul>

<section id="allclients">
<title>Comment forcer les clients
&agrave; s'authentifier &agrave; l'aide de certificats ?
</title>

    <p>Lorsque vous connaissez tous vos clients (comme c'est en g&eacute;n&eacute;ral le cas
    au sein d'un intranet d'entreprise), vous pouvez imposer une
    authentification bas&eacute;e uniquement sur les certificats. Tout ce dont vous
    avez besoin pour y parvenir est de cr&eacute;er des certificats clients sign&eacute;s par
    le certificat de votre propre autorit&eacute; de certification
    (<code>ca.crt</code>), et d'authentifier les clients &agrave; l'aide de ces
    certificats.</p>
    <highlight language="config">
# exige un certificat client sign&eacute; par le certificat de votre CA
# contenu dans ca.crt
SSLVerifyClient require
SSLVerifyDepth 1
SSLCACertificateFile conf/ssl.crt/ca.crt
    </highlight>
</section>

<section id="arbitraryclients">
<title>Comment forcer les clients
&agrave; s'authentifier &agrave; l'aide de certificats pour une URL particuli&egrave;re,
mais autoriser quand-m&ecirc;me tout client anonyme
&agrave; acc&eacute;der au reste du serveur ?</title>

<p>Pour forcer les clients &agrave; s'authentifier &agrave; l'aide de certificats pour une
URL particuli&egrave;re, vous pouvez utiliser les fonctionnalit&eacute;s de reconfiguration
de <module>mod_ssl</module> en fonction du r&eacute;pertoire :</p>

    <highlight language="config">
SSLVerifyClient none
SSLCACertificateFile conf/ssl.crt/ca.crt

&lt;Location /secure/area&gt;
SSLVerifyClient require
SSLVerifyDepth 1
&lt;/Location&gt;
    </highlight>
</section>

<section id="certauthenticate">
<title>Comment n'autoriser l'acc&egrave;s &agrave; une URL
particuli&egrave;re qu'aux clients qui poss&egrave;dent des certificats, mais autoriser
l'acc&egrave;s au reste du serveur &agrave; tous les clients ?</title>

    <p>La cl&eacute; du probl&egrave;me consiste &agrave; v&eacute;rifier si une partie du certificat
    client correspond &agrave; ce que vous attendez. Cela signifie en g&eacute;n&eacute;ral
    consulter tout ou partie du nom distinctif (DN), afin de v&eacute;rifier s'il
    contient une cha&icirc;ne connue. Il existe deux m&eacute;thodes pour y parvenir ;
    on utilise soit le module <module>mod_auth_basic</module>, soit la
    directive <directive module="mod_ssl">SSLRequire</directive>.</p>

    <p>La m&eacute;thode du module <module>mod_auth_basic</module> est en g&eacute;n&eacute;ral
    incontournable lorsque les certificats ont un contenu arbitraire, ou
    lorsque leur DN ne contient aucun champ connu
    (comme l'organisation, etc...). Dans ce cas, vous devez construire une base
    de donn&eacute;es de mots de passe contenant <em>tous</em> les clients
    autoris&eacute;s, comme suit :</p>

    <highlight language="config">
SSLVerifyClient      none
SSLCACertificateFile conf/ssl.crt/ca.crt
SSLCACertificatePath conf/ssl.crt

&lt;Directory /usr/local/apache2/htdocs/secure/area&gt;
SSLVerifyClient      require
    SSLVerifyDepth       5
    SSLOptions           +FakeBasicAuth
    SSLRequireSSL
    AuthName             "Snake Oil Authentication"
    AuthType             Basic
    AuthBasicProvider    file
    AuthUserFile         /usr/local/apache2/conf/httpd.passwd
    Require              valid-user
&lt;/Directory&gt;
    </highlight>
    

    <p>Le mot de passe utilis&eacute; dans cet exemple correspond &agrave; la cha&icirc;ne de
    caract&egrave;res "password" chiffr&eacute;e en DES. Voir la documentation de la
    directive <directive module="mod_ssl">SSLOptions</directive> pour
    plus de d&eacute;tails.</p>

    <example><title>httpd.passwd</title><pre>
/C=DE/L=Munich/O=Snake Oil, Ltd./OU=Staff/CN=Foo:xxj31ZMTZzkVA
/C=US/L=S.F./O=Snake Oil, Ltd./OU=CA/CN=Bar:xxj31ZMTZzkVA
/C=US/L=L.A./O=Snake Oil, Ltd./OU=Dev/CN=Quux:xxj31ZMTZzkVA</pre>
    </example>

    <p>Lorsque vos clients font tous partie d'une m&ecirc;me hi&eacute;rarchie, ce qui
    appara&icirc;t dans le DN, vous pouvez les authentifier plus facilement en
    utilisant la directive <directive module="mod_ssl"
    >SSLRequire</directive>, comme suit :</p>


    <highlight language="config">
SSLVerifyClient      none
SSLCACertificateFile conf/ssl.crt/ca.crt
SSLCACertificatePath conf/ssl.crt

&lt;Directory /usr/local/apache2/htdocs/secure/area&gt;
  SSLVerifyClient      require
  SSLVerifyDepth       5
  SSLOptions           +FakeBasicAuth
  SSLRequireSSL
  SSLRequire       %{SSL_CLIENT_S_DN_O}  eq "Snake Oil, Ltd." \
               and %{SSL_CLIENT_S_DN_OU} in {"Staff", "CA", "Dev"}
&lt;/Directory&gt;
    </highlight>
</section>

<section id="intranet">
<title>Comment imposer HTTPS avec chiffrements forts,
et soit authentification de base, soit possession de certificats clients,
pour l'acc&egrave;s &agrave; une partie de l'Intranet, pour les clients en
provenance de l'Internet ? Je souhaite quand-m&ecirc;me autoriser l'acc&egrave;s en HTTP
aux clients de l'intranet.</title>

   <p>On suppose dans ces exemples que les clients de l'intranet ont des
   adresses IP dans la gamme 192.168.1.0/24, et que la partie de l'intranet
   &agrave; laquelle vous voulez autoriser l'acc&egrave;s depuis l'Internet est
   <code>/usr/local/apache2/htdocs/subarea</code>. Ces lignes de configuration
   doivent se trouver en dehors de votre h&ocirc;te virtuel HTTPS, afin qu'elles
   s'appliquent &agrave; la fois &agrave; HTTP et HTTPS.</p>

    <highlight language="config">
SSLCACertificateFile conf/ssl.crt/company-ca.crt

&lt;Directory /usr/local/apache2/htdocs&gt;
#   En dehors de subarea, seul l'acc&egrave;s depuis l'intranet est
#   autoris&eacute;
    Require              ip 192.168.1.0/24
&lt;/Directory&gt;

&lt;Directory /usr/local/apache2/htdocs/subarea&gt;
#   Dans subarea, tout acc&egrave;s depuis l'intranet est autoris&eacute;
#   mais depuis l'Internet, seul l'acc&egrave;s par HTTPS + chiffrement fort + Mot de passe
#   ou HTTPS + chiffrement fort + certificat client n'est autoris&eacute;.

#   Si HTTPS est utilis&eacute;, on s'assure que le niveau de chiffrement est fort.
#   Autorise en plus les certificats clients comme une alternative &agrave;
#   l'authentification basique.
    SSLVerifyClient      optional
    SSLVerifyDepth       1
    SSLOptions           +FakeBasicAuth +StrictRequire
    SSLRequire           %{SSL_CIPHER_USEKEYSIZE} &gt;= 128
    
    #   ON oblige les clients venant d'Internet &agrave; utiliser HTTPS
    RewriteEngine        on
    RewriteCond          %{REMOTE_ADDR} !^192\.168\.1\.[0-9]+$
    RewriteCond          %{HTTPS} !=on
    RewriteRule          . - [F]
    
    #   On permet l'acc&egrave;s soit sur les crit&egrave;res r&eacute;seaux, soit par authentification Basique
    Satisfy              any
    
    #   Contr&ocirc;le d'acc&egrave;s r&eacute;seau
    Require              ip 192.168.1.0/24
    
    #   Configuration de l'authentification HTTP Basique
    AuthType             basic
    AuthName             "Protected Intranet Area"
    AuthBasicProvider    file
    AuthUserFile         conf/protected.passwd
    Require              valid-user
&lt;/Directory&gt;
    </highlight>
</section>
</section>
<!-- /access control -->

<section id="logging">
    <title>Journalisation</title>

    <p><module>mod_ssl</module> peut enregistrer des informations de
    d&eacute;bogage tr&egrave;s verbeuses dans le journal des erreurs, lorsque sa
    directive <directive module="core">LogLevel</directive> est d&eacute;finie
    &agrave; des niveaux de trace &eacute;lev&eacute;s. Par contre, sur un serveur tr&egrave;s
    sollicit&eacute;, le niveau <code>info</code> sera probablement d&eacute;j&agrave; trop
    &eacute;lev&eacute;. Souvenez-vous que vous pouvez configurer la directive
    <directive module="core">LogLevel</directive> par module afin de
    pourvoir &agrave; vos besoins.</p>
</section>

</manualpage>

