# Copyright (c) 2000-2007, JPackage Project
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the
#    distribution.
# 3. Neither the name of the JPackage Project nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
# A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
# OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
# SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
# LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
# DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
# THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#

Name:      mod_jk
Epoch:     0
Version:   1.2.40
Release:   10%{?dist}
Summary:   Tomcat mod_jk connector for Apache

Group:     Internet/WWW/Servers
License:   ASL 2.0
URL:       http://tomcat.apache.org
Source0:   http://www.apache.org/dist/tomcat/tomcat-connectors/jk/tomcat-connectors-%{version}-src.tar.gz
Source1:   %{name}.conf.sample
Source2:   uriworkermap.properties.sample
Source3:   workers.properties.sample
Patch0:    tomcat-connectors-1.2.40-BZ1100602.patch
Patch1:    mod_jk-CVE-2014-8111.patch

BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: httpd24-devel
BuildRequires: libtool
BuildRequires: xalan-j2 >= 2.7.0
BuildRequires: zip

#win-buildrequires: xbuild
#win-buildrequires: httpd
#sun-buildrequires: httpd

%description
Mod_jk is a replacement to the elderly mod_jserv. It is a completely new
Tomcat-Apache plug-in that handles the communication between Tomcat and Apache.

%package ap24
Summary: Tomcat %{name} connector for Apache 2.4.x
Group: Internet/WWW/Servers
Provides: %{name} = %{epoch}:%{version}-%{release}
Obsoletes: tomcat-mod
Obsoletes: %{name}-ap20 < %{epoch}:%{version}
Obsoletes: %{name}-ap22 < %{epoch}:%{version}
Obsoletes: mod_jk-tools < %{epoch}:%{version}-%{release}
Requires: httpd24 >= 2.4.6

%description ap24
Tomcat %{name} connector for Apache 2.4.x.

%package manual
Summary: Tomcat %{name} connector manual
Group: Internet/WWW/Servers

%description manual
Tomcat %{name} connector manual.

%if %with tools
%package tools
Group: Internet/Log Analysis
Summary: Analysis and report tools for %{name}

%description tools
Miscellaneous %{name} analysis and report tools.
%endif

%if %with zips
%package src-zip
Summary:     Container for the sources of the Tomcat %{name} connector.
Group:       Development

%description src-zip
Container for the sources of the Tomcat %{name} connector.
%endif

%prep
%setup -q -n tomcat-connectors-%{version}-src
%patch0 -p1 -b .bz1100602
%patch1 -p0 -b .cve-2014-8111


%changelog
* Mon Jul 13 2015 Mladen Turk <mturk@redhat.com> - 0:1.2.40-10
- ER2 rebuild.

* Wed May 20 2015 Jean-Frederic Clere <jclere@redhat.com> - 0:1.2.40-9
- JWS-24 Add missing patches.

* Wed Mar  4 2015 Mladen Turk <mturk@redhat.com> - 0:1.2.40-8
- JWS-14

* Mon Feb 23 2015 Mladen Turk <mturk@redhat.com> - 0:1.2.40-7
- Rebuild

* Mon Dec 15 2014  Permaine Cheung <pcheung@redhat.com> - 0:1.2.40-6
- Rebuild

* Wed Oct 15 2014  Permaine Cheung <pcheung@redhat.com> - 0:1.2.40-4
- Build against httpd24 on RHEL 6, 7

* Wed Sep 24 2014  Permaine Cheung <pcheung@redhat.com> - 0:1.2.40-3
- JWS 3.0 build
