<?xml version="1.0"?>
<!DOCTYPE modulesynopsis SYSTEM "../style/modulesynopsis.dtd">
<?xml-stylesheet type="text/xsl" href="../style/manual.fr.xsl"?>
<!-- French translation : Lucien GENTIS -->
<!-- Reviewed by : Vincent Deffontaines -->
<!-- English Revision : 1481368 -->

<!--
 Licensed to the Apache Software Foundation (ASF) under one or more
 contributor license agreements.  See the NOTICE file distributed with
 this work for additional information regarding copyright ownership.
 The ASF licenses this file to You under the Apache License, Version 2.0
 (the "License"); you may not use this file except in compliance with
 the License.  You may obtain a copy of the License at

     http://www.apache.org/licenses/LICENSE-2.0

 Unless required by applicable law or agreed to in writing, software
 distributed under the License is distributed on an "AS IS" BASIS,
 WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 See the License for the specific language governing permissions and
 limitations under the License.
-->

<modulesynopsis metafile="mod_authz_core.xml.meta">

<name>mod_authz_core</name>
<description>Autorisation basique</description>
<status>Base</status>
<sourcefile>mod_authz_core.c</sourcefile>
<identifier>authz_core_module</identifier>
<compatibility>Disponible depuis la version 2.3
d'Apache HTTPD</compatibility>

<summary>
    <p>Ce module fournit des fonctionnalit&eacute;s d'autorisation basiques
    permettant d'accorder ou refuser l'acc&egrave;s &agrave; certaines zones du site
    web aux utilisateurs authentifi&eacute;s. <module>mod_authz_core</module>
    donne la possibilit&eacute; d'enregistrer divers fournisseurs
    d'autorisation. Il est en g&eacute;n&eacute;ral utilis&eacute; avec un module fournisseur
    d'authentification comme <module>mod_authn_file</module>, et un
    module d'autorisation comme <module>mod_authz_user</module>. Il
    permet aussi l'application d'une logique &eacute;labor&eacute;e au d&eacute;roulement du
    processus d'autorisation.</p>
</summary>

<section id="authzalias"><title>Cr&eacute;ation des alias du fournisseur
d'autorisation</title>

    <p>Il est possible de cr&eacute;er des fournisseurs d'autorisation &eacute;tendus
    dans le fichier de configuration et de leur assigner un nom d'alias.
    On peut ensuite utiliser ces fournisseurs alias&eacute;s dans une
    directive <directive module="mod_authz_core">Require</directive> de
    la m&ecirc;me mani&egrave;re qu'on le ferait pour des fournisseurs d'autorisation
    de base. En plus de la possibilit&eacute; de cr&eacute;er et d'aliaser un
    fournisseur &eacute;tendu, le m&ecirc;me fournisseur d'autorisation &eacute;tendu peut
    &ecirc;tre r&eacute;f&eacute;renc&eacute; par plusieurs localisations.
    </p>

    <section id="example"><title>Exemple</title>
        <p>Dans l'exemple suivant, on cr&eacute;e deux alias de fournisseur
	d'autorisation ldap diff&eacute;rents bas&eacute;s sur le fournisseur
	d'autorisation ldap-group. Il est ainsi possible pour un seul
	r&eacute;pertoire de v&eacute;rifier l'appartenance &agrave; un groupe dans plusieurs
	serveurs ldap :
        </p>

        <highlight language="config">
&lt;AuthzProviderAlias ldap-group ldap-group-alias1 cn=my-group,o=ctx&gt;
    AuthLDAPBindDN cn=youruser,o=ctx
    AuthLDAPBindPassword yourpassword
    AuthLDAPURL ldap://ldap.host/o=ctx
&lt;/AuthzProviderAlias&gt;

&lt;AuthzProviderAlias ldap-group ldap-group-alias2 cn=my-other-group,o=dev&gt;
    AuthLDAPBindDN cn=yourotheruser,o=dev
    AuthLDAPBindPassword yourotherpassword
    AuthLDAPURL ldap://other.ldap.host/o=dev?cn
&lt;/AuthzProviderAlias&gt;

Alias /secure /webpages/secure
&lt;Directory /webpages/secure&gt;
    Require all granted
    
    AuthBasicProvider file
    
    AuthType Basic
    AuthName LDAP_Protected_Place
    
    #implied OR operation
    Require ldap-group-alias1
    Require ldap-group-alias2
&lt;/Directory&gt;
        </highlight>
    </section>

</section>

<section id="logic"><title>Conteneurs d'autorisation</title>

    <p>Les directives de conteneur d'autorisation <directive
    module="mod_authz_core" type="section">RequireAll</directive>,
    <directive module="mod_authz_core"
    type="section">RequireAny</directive> et <directive
    module="mod_authz_core" type="section">RequireNone</directive>
    peuvent &ecirc;tre combin&eacute;es entre elles et avec la directive <directive
    module="mod_authz_core">Require</directive> pour confectionner une
    logique d'autorisation complexe.</p>

    <p>L'exemple ci-dessous illustre la logique d'autorisation suivante.
    Pour pouvoir acc&eacute;der &agrave; la ressource, l'utilisateur doit &ecirc;tre
    l'utilisateur <code>superadmin</code>, ou appartenir aux deux
    groupes LDAP <code>admins</code> et <code>Administrateurs</code> et
    soit appartenir au groupe <code>ventes</code> ou avoir
    <code>ventes</code> comme valeur de l'attribut LDAP
    <code>dept</code>. De plus, pour pouvoir acc&eacute;der &agrave; la ressource,
    l'utilisateur ne doit appartenir ni au groupe <code>temps</code>, ni
    au groupe LDAP <code>Employ&eacute;s temporaires</code>.</p>

    <highlight language="config">
&lt;Directory /www/mydocs&gt;
    &lt;RequireAll&gt;
        &lt;RequireAny&gt;
            Require user superadmin
            &lt;RequireAll&gt;
            Require group admins
            Require ldap-group cn=Administrators,o=Airius
                &lt;RequireAny&gt;
                Require group sales
                Require ldap-attribute dept="sales"
                &lt;/RequireAny&gt;
            &lt;/RequireAll&gt;
        &lt;/RequireAny&gt;
        &lt;RequireNone&gt;
            Require group temps
            Require ldap-group cn=Temporary Employees,o=Airius
        &lt;/RequireNone&gt;
    &lt;/RequireAll&gt;
&lt;/Directory&gt;
    </highlight>
</section>

<section id="requiredirectives"><title>Les directives Require</title>

  <p>Le module <module>mod_authz_core</module> met &agrave; disposition des
  fournisseurs d'autorisation g&eacute;n&eacute;riques utilisables avec la directive
  <directive module="mod_authz_core">Require</directive>.</p>

  <section id="reqenv"><title>Require env</title>

    <p>Le fournisseur <code>env</code> permet de contr&ocirc;ler l'acc&egrave;s au
    serveur en fonction de l'existence d'une <a
    href="../env.html">variable d'environnement</a>. Lorsque <code>Require
    env <var>env-variable</var></code> est sp&eacute;cifi&eacute;, la requ&ecirc;te se voit
    autoriser l'acc&egrave;s si la variable d'environnement
    <var>env-variable</var> existe. Le serveur permet de d&eacute;finir
    facilement des variables d'environnement en fonction des
    caract&eacute;ristiques de la requ&ecirc;te du client via les directives fournies
    par le module <module>mod_setenvif</module>. Cette directive Require
    env permet donc de contr&ocirc;ler l'acc&egrave;s en fonction des
    valeurs des en-t&ecirc;tes de la requ&ecirc;te HTTP tels que
    <code>User-Agent</code> (type de navigateur), <code>Referer</code>,
    entre autres.</p>

    <highlight language="config">
SetEnvIf User-Agent ^KnockKnock/2\.0 let_me_in
&lt;Directory /docroot&gt;
    Require env let_me_in
&lt;/Directory&gt;
    </highlight>

    <p>Avec cet exemple, les navigateurs dont la cha&icirc;ne user-agent
    commence par <code>KnockKnock/2.0</code> se verront autoriser
    l'acc&egrave;s, alors que tous les autres seront rejet&eacute;s.</p>

  </section>

  <section id="reqall"><title>Require all</title>

    <p>Le fournisseur <code>all</code> reproduit la fonctionnalit&eacute;
    pr&eacute;c&eacute;demment fournie par les directives 'Allow from all' et 'Deny
    from all'. Il accepte un argument dont les deux valeurs possibles
    sont : 'granted' ou 'denied'. Les exemples suivants autorisent ou
    interdisent l'acc&egrave;s &agrave; toutes les requ&ecirc;tes.</p>

    <highlight language="config">
    Require all granted
    </highlight>

    <highlight language="config">
    Require all denied
    </highlight>

  </section>

  <section id="reqmethod"><title>Require method</title>

    <p>Le fournisseur <code>method</code> permet d'utiliser la m&eacute;thode
    HTTP dans le processus d'autorisation. Les m&eacute;thodes GET et HEAD sont
    ici consid&eacute;r&eacute;es comme &eacute;quivalentes. La m&eacute;thode TRACE n'est pas
    support&eacute;e par ce fournisseur ; utilisez &agrave; la place la directive
    <directive module="core">TraceEnable</directive>.</p>

    <p>Dans l'exemple suivant, seules les m&eacute;thodes GET, HEAD, POST, et
    OPTIONS sont autoris&eacute;es :</p>

    <highlight language="config">
        Require method GET POST OPTIONS
    </highlight>

    <p>Dans l'exemple suivant, les m&eacute;thodes GET, HEAD, POST, et OPTIONS
    sont autoris&eacute;es sans authentification, alors que toutes les autres
    m&eacute;thodes n&eacute;cessitent un utilisateur valide :</p>

    <highlight language="config">
&lt;RequireAny&gt;
    &nbsp;Require method GET POST OPTIONS
    &nbsp;Require valid-user
&lt;/RequireAny&gt;
    </highlight>

  </section>
  <section id="reqexpr"><title>Require expr</title>

  <p>Le fournisseur <code>expr</code> permet d'accorder l'autorisation
  d'acc&egrave;s en fonction d'expressions arbitraires.</p>

    <highlight language="config">
         Require expr "%{TIME_HOUR} -ge 9 &amp;&amp; %{TIME_HOUR} -le 17"
    </highlight>

    <p>La syntaxe de l'expression est d&eacute;crite dans la documentation de <a
    href="../expr.html">ap_expr</a>.</p>

    <p>Normalement, l'expression est &eacute;valu&eacute;e avant l'authentification.
    Cependant, si l'expression renvoie false et se r&eacute;f&egrave;re &agrave; la variable
    <code>%{REMOTE_USER}</code>, le processus d'authentification sera
    engag&eacute; et l'expression r&eacute;&eacute;valu&eacute;e.</p>

  </section>

</section>

<directivesynopsis>
<name>Require</name>
<description>V&eacute;rifie si un utilisateur authentifi&eacute; a une
autorisation d'acc&egrave;s accord&eacute;e par un fournisseur
d'autorisation.</description>
<syntax>Require [not] <var>nom-entit&eacute;</var> [<var>nom-entit&eacute;</var>]
...</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Cette directive permet de v&eacute;rifier si un utilisateur authentifi&eacute;
    a l'autorisation d'acc&egrave;s accord&eacute;e pour un certain fournisseur
    d'autorisation et en tenant compte de certaines restrictions.
    <module>mod_authz_core</module> met &agrave; disposition les fournisseurs
    d'autorisation g&eacute;n&eacute;riques suivants :</p>

    <dl>
      <dt><code>Require all granted</code></dt>
      <dd>L'acc&egrave;s est autoris&eacute; sans restriction.</dd>

      <dt><code>Require all denied</code></dt>
      <dd>L'acc&egrave;s est syst&eacute;matiquement refus&eacute;.</dd>

      <dt><code>Require env <var>env-var</var> [<var>env-var</var>]
      ...</code></dt>
      <dd>L'acc&egrave;s n'est autoris&eacute; que si l'une au moins des variables
      d'environnement sp&eacute;cifi&eacute;es est d&eacute;finie.</dd>

      <dt><code>Require method <var>http-method</var> [<var>http-method</var>]
      ...</code></dt>
      <dd>L'acc&egrave;s n'est autoris&eacute; que pour les m&eacute;thodes HTTP sp&eacute;cifi&eacute;es.</dd>

      <dt><code>Require expr <var>expression</var> </code></dt>
      <dd>L'acc&egrave;s est autoris&eacute; si <var>expression</var> est &eacute;valu&eacute; &agrave;
      vrai.</dd>
    </dl>

    <p>Voici quelques exemples de syntaxes autoris&eacute;es par
    <module>mod_authz_user</module>, <module>mod_authz_host</module> et
    <module>mod_authz_groupfile</module> :</p>

    <dl>
      <dt><code>Require user <var>identifiant utilisateur</var>
      [<var>identifiant utilisateur</var>]
      ...</code></dt>
      <dd>Seuls les utilisateurs sp&eacute;cifi&eacute;s auront acc&egrave;s &agrave; la
      ressource.</dd>

      <dt><code>Require group <var>nom groupe</var> [<var>nom
      groupe</var>]
      ...</code></dt>
      <dd>Seuls les utilisateurs appartenant aux groupes sp&eacute;cifi&eacute;s
      auront acc&egrave;s &agrave; la ressource.</dd>

      <dt><code>Require valid-user</code></dt>
      <dd>Tous les utilisateurs valides auront acc&egrave;s &agrave; la
      ressource.</dd>

      <dt><code>Require ip 10 172.20 192.168.2</code></dt>
      <dd>Les clients dont les adresses IP font partie des tranches
      sp&eacute;cifi&eacute;es auront acc&egrave;s &agrave; la ressource.</dd>
    </dl>

    <p>D'autres modules d'autorisation comme
    <module>mod_authnz_ldap</module>, <module>mod_authz_dbm</module>,
    <module>mod_authz_dbd</module>,
    <module>mod_authz_owner</module> et <module>mod_ssl</module>
    impl&eacute;mentent des options de la directive Require.</p>

    <p>Pour qu'une configuration d'authentification et d'autorisation
    fonctionne correctement, la directive <directive>Require</directive>
    doit &ecirc;tre accompagn&eacute;e dans la plupart des cas de directives <directive
    module="mod_authn_core">AuthName</directive>, <directive
    module="mod_authn_core">AuthType</directive> et <directive
    module="mod_auth_basic">AuthBasicProvider</directive> ou <directive
    module="mod_auth_digest">AuthDigestProvider</directive>, ainsi que
    de directives telles que <directive
    module="mod_authn_file">AuthUserFile</directive> et <directive
    module="mod_authz_groupfile">AuthGroupFile</directive> (pour la
    d&eacute;finition des utilisateurs et des groupes). Exemple :</p>

    <highlight language="config">
AuthType Basic
AuthName "Restricted Resource"
AuthBasicProvider file
AuthUserFile /web/users
AuthGroupFile /web/groups
Require group admin
    </highlight>

    <p>Les contr&ocirc;les d'acc&egrave;s appliqu&eacute;s de cette mani&egrave;re sont effectifs
    pour <strong>toutes</strong> les m&eacute;thodes. <strong>C'est d'ailleurs
    ce que l'on souhaite en g&eacute;n&eacute;ral.</strong> Si vous voulez n'appliquer
    les contr&ocirc;les d'acc&egrave;s qu'&agrave; certaines m&eacute;thodes, tout en laissant les
    autres m&eacute;thodes sans protection, placez la directive
    <directive>Require</directive> dans une section <directive
    module="core" type="section">Limit</directive>.</p>

    <p>Le r&eacute;sultat de la directive <directive>Require</directive> peut
    &ecirc;tre invers&eacute; en utilisant l'option <code>not</code>. Comme dans le
    cas de l'autre directive d'autorisation invers&eacute;e <directive
    type="section">RequireNone</directive>, si la directive
    <directive>Require</directive> est invers&eacute;e, elle ne peut qu'&eacute;chouer
    ou produire un r&eacute;sultat neutre ; elle ne peut donc alors pas
    autoriser une requ&ecirc;te de mani&egrave;re ind&eacute;pendante.</p>

    <p>Dans l'exemple suivant, tous les utilisateurs appartenant aux
    groupes <code>alpha</code> et <code>beta</code> ont l'autorisation
    d'acc&egrave;s, &agrave; l'exception de ceux appartenant au groupe
    <code>reject</code>.</p>

    <highlight language="config">
&lt;Directory /www/docs&gt;
    &lt;RequireAll&gt;
        Require group alpha beta
        Require not group reject
    &lt;/RequireAll&gt;
&lt;/Directory&gt;
    </highlight>

    <p>Lorsque plusieurs directives <directive>Require</directive> sont
    plac&eacute;es dans une m&ecirc;me <a href="../sections.html#merging">section de
    configuration</a>, et ne se trouvent pas dans une autre directive
    d'autorisation comme <directive module="mod_authz_core"
    type="section">RequireAll</directive>, elles sont implicitement
    contenues dans une directive <directive module="mod_authz_core"
    type="section">RequireAny</directive>. Ainsi, la premi&egrave;re directive
    <directive>Require</directive> qui autorise l'acc&egrave;s &agrave; un utilisateur
    autorise l'acc&egrave;s pour l'ensemble de la requ&ecirc;te, et les directives
    <directive>Require</directive> suivantes sont ignor&eacute;es.</p>

    <note type="warning"><title>Avertissement &agrave; propos de la s&eacute;curit&eacute;</title>
    <p>Prettez une attention particuli&egrave;re aux directives d'autorisation
    d&eacute;finies
    au sein des sections <directive module="core">Location</directive>
    qui se chevauchent avec des contenus servis depuis le syst&egrave;me de
    fichiers. Par d&eacute;faut, les configurations d&eacute;finies dans ces <a
    href="../sections.html#merging">sections</a> l'emportent sur les
    configurations d'autorisations d&eacute;finies au sein des sections
    <directive module="core">Directory</directive> et <directive
    module="core">Files</directive> sections.</p>
    <p>La directive <directive
    module="mod_authz_core">AuthMerging</directive> permet de contr&ocirc;ler
    la mani&egrave;re selon laquelle les configurations d'autorisations sont
    fusionn&eacute;es au sein des sections pr&eacute;cit&eacute;es.</p>
    </note>
</usage>


<seealso><a href="../howto/access.html">Tutoriel du contr&ocirc;le d'acc&egrave;s</a></seealso>
<seealso><a href="#logic">Conteneurs d'autorisation</a></seealso>
<seealso><module>mod_authn_core</module></seealso>
<seealso><module>mod_authz_host</module></seealso>
</directivesynopsis>

<directivesynopsis type="section">
<name>RequireAll</name>
<description>Regroupe plusieurs directives d'autorisation dont aucune ne
doit &eacute;chouer et dont au moins une doit retourner un r&eacute;sultat positif
pour que la directive globale retourne elle-m&ecirc;me un r&eacute;sultat
positif.</description>
<syntax>&lt;RequireAll&gt; ... &lt;/RequireAll&gt;</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Les balises <directive type="section">RequireAll</directive> et
    <code>&lt;/RequireAll&gt;</code> permettent de regrouper des
    directives d'autorisation dont aucune ne doit &eacute;chouer, et dont au
    moins une doit retourner un r&eacute;sultat positif pour que la directive
    <directive type="section">RequireAll</directive> retourne elle-m&ecirc;me
    un r&eacute;sultat positif.</p>

    <p>Si aucune des directives contenues dans la directive <directive
    type="section">RequireAll</directive> n'&eacute;choue, et si au moins une
    retourne un r&eacute;sultat positif, alors la directive <directive
    type="section">RequireAll</directive> retourne elle-m&ecirc;me un r&eacute;sultat
    positif. Si aucune ne retourne un r&eacute;sultat positif, et si aucune
    n'&eacute;choue, la directive globale retourne un r&eacute;sultat neutre. Dans
    tous les autres cas, elle &eacute;choue.</p>
</usage>

<seealso><a href="#logic">Conteneurs d'autorisation</a></seealso>
<seealso><a href="../howto/auth.html">Authentification, autorisation et
contr&ocirc;le d'acc&egrave;s</a></seealso>

</directivesynopsis>

<directivesynopsis type="section">
<name>RequireAny</name>
<description>Regroupe des directives d'autorisation dont au moins une
doit retourner un r&eacute;sultat positif pour que la directive globale
retourne elle-m&ecirc;me un r&eacute;sultat positif.</description>
<syntax>&lt;RequireAny&gt; ... &lt;/RequireAny&gt;</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Les balises <directive type="section">RequireAny</directive> et
    <code>&lt;/RequireAny&gt;</code> permettent de regrouper des
    directives d'autorisation dont au moins une doit retourner un
    r&eacute;sultat positif pour que la directive <directive
    type="section">RequireAny</directive> retourne elle-m&ecirc;me un r&eacute;sultat
    positif.</p>

    <p>Si une ou plusieurs directives contenues dans la directive
    <directive type="section">RequireAny</directive> retournent un
    r&eacute;sultat positif, alors la directive <directive
    type="section">RequireAny</directive> retourne elle-m&ecirc;me un r&eacute;sultat
    positif. Si aucune ne retourne un r&eacute;sultat positif et aucune
    n'&eacute;choue, la directive globale retourne un r&eacute;sultat neutre. Dans
    tous les autres cas, elle &eacute;choue.</p>

    <note>Comme les directives d'autorisation invers&eacute;es sont incapables
    de retourner un r&eacute;sultat positif, elles ne peuvent pas impacter de
    mani&egrave;re significative le r&eacute;sultat d'une directive <directive
    type="section">RequireAny</directive> (elles pourraient tout au plus
    faire &eacute;chouer la directive dans le cas o&ugrave; elles &eacute;choueraient
    elles-m&ecirc;mes, et o&ugrave;
    toutes les autres directives retourneraient un r&eacute;sultat neutre).
    C'est pourquoi il n'est pas permis d'utiliser les directives
    d'autorisation invers&eacute;es dans une directive <directive
    type="section">RequireAny</directive>.</note>
</usage>

<seealso><a href="#logic">Conteneurs d'autorisation</a></seealso>
<seealso><a href="../howto/auth.html">Authentification, autorisation et
contr&ocirc;le d'acc&egrave;s</a></seealso>

</directivesynopsis>

<directivesynopsis type="section">
<name>RequireNone</name>
<description>Regroupe des directives d'autorisation dont aucune ne doit
retourner un r&eacute;sultat positif pour que la directive globale n'&eacute;choue
pas.</description>
<syntax>&lt;RequireNone&gt; ... &lt;/RequireNone&gt;</syntax>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Les balises <directive type="section">RequireNone</directive> et
    <code>&lt;/RequireNone&gt;</code> permettent de regrouper des
    directives d'autorisation dont aucune ne doit retourner un r&eacute;sultat
    positif pour que la directive <directive
    type="section">RequireNone</directive> n'&eacute;choue pas.</p>

    <p>Si une ou plusieurs directives contenues dans la directive
    <directive type="section">RequireNone</directive> retournent un
    r&eacute;sultat positif, la directive <directive
    type="section">RequireNone</directive> &eacute;chouera. Dans tous les
    autres cas, cette derni&egrave;re retournera un r&eacute;sultat neutre. Ainsi,
    comme pour la directive d'autorisation invers&eacute;e <code>Require
    not</code>, elle ne peut jamais autoriser une requ&ecirc;te de mani&egrave;re
    ind&eacute;pendante car elle ne pourra jamais retourner un r&eacute;sultat
    positif. Par contre, on peut l'utiliser pour restreindre l'ensemble
    des utilisateurs autoris&eacute;s &agrave; acc&eacute;der &agrave; une ressource.</p>

    <note>Comme les directives d'autorisation invers&eacute;es sont incapables
    de retourner un r&eacute;sultat positif, elles ne peuvent pas impacter de
    mani&egrave;re significative le r&eacute;sultat d'une directive <directive
    type="section">RequireNone</directive>.
    C'est pourquoi il n'est pas permis d'utiliser les directives
    d'autorisation invers&eacute;es dans une directive <directive
    type="section">RequireNone</directive>.</note>
</usage>

<seealso><a href="#logic">Conteneurs d'autorisation</a></seealso>
<seealso><a href="../howto/auth.html">Authentification, autorisation et
contr&ocirc;le d'acc&egrave;s</a></seealso>

</directivesynopsis>

<directivesynopsis>
<name>AuthMerging</name>
<description>D&eacute;finit la mani&egrave;re dont chaque logique d'autorisation des
sections de configuration se combine avec celles des sections de
configuration pr&eacute;c&eacute;dentes.</description>
<syntax>AuthMerging Off | And | Or</syntax>
<default>AuthMerging Off</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<override>AuthConfig</override>

<usage>
    <p>Lorsque l'autorisation est activ&eacute;e, elle est normalement h&eacute;rit&eacute;e
    par chaque <a href="../sections.html#merging">section de
    configuration</a> suivante, &agrave; moins qu'un jeu de directives
    d'autorisations diff&eacute;rent ne soit sp&eacute;cifi&eacute;. Il s'agit du
    comportement par d&eacute;faut, qui correspond &agrave; la d&eacute;finition explicite
    <code>AuthMerging Off</code>.</p>

    <p>Dans certaines situations cependant, il peut &ecirc;tre souhaitable de
    combiner la logique d'autorisation d'une section de configuration
    avec celle de la section pr&eacute;c&eacute;dente lorsque les sections de
    configuration se combinent entre elles. Dans ce cas, deux options
    sont disponibles, <code>And</code> et <code>Or</code>.</p>

    <p>Lorsqu'une section de configuration contient <code>AuthMerging
    And</code> ou <code>AuthMerging Or</code>, sa logique d'autorisation
    se combine avec celle de la section de configuration qui la pr&eacute;c&egrave;de
    (selon l'ordre g&eacute;n&eacute;ral des sections de configuration), et qui
    contient aussi une logique d'autorisation, comme si les deux
    sections &eacute;taient concat&eacute;n&eacute;es respectivement dans une directive
    <directive module="mod_authz_core"
    type="section">RequireAll</directive> ou <directive
    module="mod_authz_core" type="section">RequireAny</directive>.</p>

    <note>La d&eacute;finition de la directive
    <directive>AuthMerging</directive> ne concerne que la section de
    configuration dans laquelle elle appara&icirc;t. Dans l'exemple suivant,
    seuls les utilisateurs appartenant au groupe <code>alpha</code> sont
    autoris&eacute;s &agrave; acc&eacute;der &agrave; <code>/www/docs</code>. Les utilisateurs
    appartenant au groupe <code>alpha</code> ou au groupe
    <code>beta</code> sont autoris&eacute;s &agrave; acc&eacute;der &agrave;
    <code>/www/docs/ab</code>. Cependant, la d&eacute;finition implicite &agrave;
    <code>Off</code> de la directive <directive>AuthMerging</directive>
    s'applique &agrave; la section de configuration <directive type="section"
    module="core">Directory</directive> concernant le r&eacute;pertoire
    <code>/www/docs/ab/gamma</code>, ce qui implique que les directives
    d'autorisation de cette section l'emportent sur celles des sections
    pr&eacute;c&eacute;dentes. Par voie de cons&eacute;quence, seuls les utilisateurs
    appartenant au groupe <code>gamma</code> sont autoris&eacute;s &agrave; acc&eacute;der &agrave;
    <code>/www/docs/ab/gamma</code>.</note>

    <highlight language="config">
&lt;Directory /www/docs&gt;
    AuthType Basic
    AuthName Documents
    AuthBasicProvider file
    AuthUserFile /usr/local/apache/passwd/passwords
    Require group alpha
&lt;/Directory&gt;

&lt;Directory /www/docs/ab&gt;
    AuthMerging Or
    Require group beta
&lt;/Directory&gt;

&lt;Directory /www/docs/ab/gamma&gt;
    Require group gamma
&lt;/Directory&gt;
    </highlight>
</usage>

</directivesynopsis>

<directivesynopsis type="section">
<name>AuthzProviderAlias</name>
<description>Regroupe des directives repr&eacute;sentant une extension d'un
fournisseur d'autorisation de base qui pourra &ecirc;tre r&eacute;f&eacute;renc&eacute;e &agrave; l'aide
de l'alias sp&eacute;cifi&eacute;</description>
<syntax>&lt;AuthzProviderAlias <var>fournisseur-de-base Alias
Param&egrave;tres-Require</var>&gt;
... &lt;/AuthzProviderAlias&gt;
</syntax>
<contextlist><context>server config</context>
</contextlist>

<usage>
    <p>Les balises <directive
    type="section">AuthzProviderAlias</directive> et
    <code>&lt;/AuthzProviderAlias&gt;</code> permettent de regrouper des
    directives d'autorisation auxquelles on pourra faire r&eacute;f&eacute;rence &agrave;
    l'aide de l'alias sp&eacute;cifi&eacute; dans une directive <directive
    module="mod_authz_core">Require</directive>.</p>

</usage>
</directivesynopsis>

<directivesynopsis>
<name>AuthzSendForbiddenOnFailure</name>
<description>Envoie '403 FORBIDDEN' au lieu de '401 UNAUTHORIZED' si
l'authentification r&eacute;ussit et si l'autorisation a &eacute;t&eacute; refus&eacute;e.
</description>
<syntax>AuthzSendForbiddenOnFailure On|Off</syntax>
<default>AuthzSendForbiddenOnFailure Off</default>
<contextlist><context>directory</context><context>.htaccess</context>
</contextlist>
<compatibility>Disponible depuis la version 2.3.11 d'Apache HTTPD</compatibility>

<usage>
    <p>Par d&eacute;faut, si l'authentification r&eacute;ussit, alors que
    l'autorisation est refus&eacute;e, Apache HTTPD renvoie un code de r&eacute;ponse
    HTTP '401 UNAUTHORIZED'. En g&eacute;n&eacute;ral, les navigateurs proposent alors
    une nouvelle fois &agrave; l'utilisateur la bo&icirc;te de dialogue de saisie du
    mot de passe, ce qui n'est pas toujours souhaitable. La directive
    <directive>AuthzSendForbiddenOnFailure</directive> permet de changer
    le code de r&eacute;ponse en '403 FORBIDDEN'.</p>

    <note type="warning"><title>Avertissement de s&eacute;curit&eacute;</title>
    <p>La modification de la r&eacute;ponse en cas de refus d'autorisation
    diminue la s&eacute;curit&eacute; du mot de passe, car elle indique &agrave; un &eacute;ventuel
    attaquant que le mot de passe qu'il a saisi &eacute;tait correct.</p>
    </note>
</usage>
</directivesynopsis>

</modulesynopsis>
