/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.movie;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.ExportedSymbol;
import com.anotherbigidea.flash.movie.Frame;
import com.anotherbigidea.flash.movie.ImportedSymbol;
import com.anotherbigidea.flash.movie.Symbol;
import com.anotherbigidea.flash.movie.TimeLine;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.Vector;

public class Movie
implements TimeLine {
    protected int width;
    protected int height;
    protected int frameRate;
    protected Color backColor;
    protected int version;
    protected boolean isProtected;
    protected Map importLibraries;
    protected Vector exportedSymbols;
    protected SortedMap frames = new TreeMap();
    protected int frameCount = 0;
    protected HashMap definedSymbols = new HashMap();
    protected int depth = 1;
    protected int maxId = 1;

    public Movie() {
        this.width = 550;
        this.height = 400;
        this.frameRate = 12;
        this.version = 5;
    }

    public Movie(int n, int n2, int n3, int n4, Color color) {
        this.width = n;
        this.height = n2;
        this.frameRate = n3;
        this.version = n4;
        this.backColor = color;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public int getVersion() {
        return this.version;
    }

    public Color getBackColor() {
        return this.backColor;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public void setFrameRate(int n) {
        this.frameRate = n;
    }

    public void setVersion(int n) {
        this.version = n;
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void protect(boolean bl) {
        this.isProtected = bl;
    }

    public int getFrameCount() {
        return this.frameCount;
    }

    public Frame getFrame(int n) {
        if (n < 1) {
            return null;
        }
        Integer n2 = new Integer(n);
        Frame frame = (Frame)this.frames.get(n2);
        if (frame == null) {
            frame = new Frame(n, this);
            this.frames.put(n2, frame);
            if (n > this.frameCount) {
                this.frameCount = n;
            }
        }
        return frame;
    }

    public Frame appendFrame() {
        ++this.frameCount;
        Frame frame = new Frame(this.frameCount, this);
        this.frames.put(new Integer(this.frameCount), frame);
        return frame;
    }

    public int getAvailableDepth() {
        return this.depth;
    }

    public void setAvailableDepth(int n) {
        if (n < 1) {
            return;
        }
        this.depth = n;
    }

    public ImportedSymbol[] importSymbols(String string, String[] stringArray) {
        ArrayList<ImportedSymbol> arrayList;
        if (this.importLibraries == null) {
            this.importLibraries = new HashMap();
        }
        if ((arrayList = (ArrayList<ImportedSymbol>)this.importLibraries.get(string)) == null) {
            arrayList = new ArrayList<ImportedSymbol>();
            this.importLibraries.put(string, arrayList);
        }
        ImportedSymbol[] importedSymbolArray = new ImportedSymbol[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            ImportedSymbol importedSymbol;
            importedSymbolArray[i] = importedSymbol = new ImportedSymbol(0, stringArray[i], string);
            arrayList.add(importedSymbol);
        }
        return importedSymbolArray;
    }

    public void clearImports() {
        if (this.importLibraries != null) {
            this.importLibraries.clear();
        }
    }

    public ImportedSymbol[] getImportedSymbols() {
        if (this.importLibraries == null) {
            return new ImportedSymbol[0];
        }
        Vector vector = new Vector();
        for (List list : this.importLibraries.values()) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                vector.add(iterator.next());
            }
        }
        Object[] objectArray = new ImportedSymbol[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public void exportSymbols(String[] stringArray, Symbol[] symbolArray) {
        if (this.exportedSymbols == null) {
            this.exportedSymbols = new Vector();
        }
        for (int i = 0; i < stringArray.length && i < symbolArray.length; ++i) {
            this.exportedSymbols.add(new ExportedSymbol(symbolArray[i], stringArray[i]));
        }
    }

    public ExportedSymbol[] getExportedSymbols() {
        if (this.exportedSymbols == null) {
            return new ExportedSymbol[0];
        }
        Object[] objectArray = new ExportedSymbol[this.exportedSymbols.size()];
        this.exportedSymbols.copyInto(objectArray);
        return objectArray;
    }

    public void clearExports() {
        if (this.exportedSymbols != null) {
            this.exportedSymbols.clear();
        }
    }

    public void write(SWFTagTypes sWFTagTypes) throws IOException {
        Object object;
        String[] stringArray;
        this.definedSymbols.clear();
        this.maxId = 1;
        sWFTagTypes.header(this.version, -1L, this.width * 20, this.height * 20, this.frameRate, -1);
        if (this.backColor == null) {
            this.backColor = new Color(255, 255, 255);
        }
        sWFTagTypes.tagSetBackgroundColor(this.backColor);
        if (this.isProtected) {
            sWFTagTypes.tagProtect(null);
        }
        if (this.importLibraries != null && !this.importLibraries.isEmpty()) {
            for (Object object2 : this.importLibraries.keySet()) {
                List list = (List)this.importLibraries.get(object2);
                stringArray = new String[list.size()];
                object = new int[list.size()];
                int n = 0;
                for (ImportedSymbol importedSymbol : list) {
                    stringArray[n] = importedSymbol.getName();
                    object[n] = importedSymbol.define(this, sWFTagTypes, sWFTagTypes);
                    ++n;
                }
                sWFTagTypes.tagImport((String)object2, stringArray, (int[])object);
            }
        }
        if (this.exportedSymbols != null && !this.exportedSymbols.isEmpty()) {
            Object object2;
            String[] stringArray2 = new String[this.exportedSymbols.size()];
            object2 = new int[this.exportedSymbols.size()];
            int n = 0;
            stringArray = this.exportedSymbols.iterator();
            while (stringArray.hasNext()) {
                object = (ExportedSymbol)stringArray.next();
                stringArray2[n] = ((ExportedSymbol)object).getExportName();
                object2[n] = ((ExportedSymbol)object).getSymbol().define(this, sWFTagTypes, sWFTagTypes);
                ++n;
            }
            sWFTagTypes.tagExport(stringArray2, (int[])object2);
        }
        int n = 0;
        for (Frame frame : this.frames.values()) {
            int n2 = frame.getFrameNumber();
            while (n2 > n + 1) {
                sWFTagTypes.tagShowFrame();
                ++n;
            }
            frame.write(this, sWFTagTypes, sWFTagTypes);
            n = n2;
        }
        sWFTagTypes.tagEnd();
    }

    public void write(String string) throws IOException {
        this.write(string, false);
    }

    public void write(OutputStream outputStream) throws IOException {
        this.write(outputStream, false);
    }

    public void write(String string, boolean bl) throws IOException {
        SWFWriter sWFWriter = new SWFWriter(string);
        TagWriter tagWriter = new TagWriter(sWFWriter);
        sWFWriter.setCompression(bl);
        this.write(tagWriter);
    }

    public void write(OutputStream outputStream, boolean bl) throws IOException {
        SWFWriter sWFWriter = new SWFWriter(outputStream);
        TagWriter tagWriter = new TagWriter(sWFWriter);
        sWFWriter.setCompression(bl);
        this.write(tagWriter);
    }
}

