/*
 * Decompiled with CFR 0.152.
 */
package com.anotherbigidea.flash.structs;

import com.anotherbigidea.io.InStream;
import com.anotherbigidea.io.OutStream;
import java.io.IOException;

public class ColorTransform {
    protected double multRed = 1.0;
    protected double multGreen = 1.0;
    protected double multBlue = 1.0;
    protected int addRed = 0;
    protected int addGreen = 0;
    protected int addBlue = 0;
    protected double multAlpha = 1.0;
    protected int addAlpha = 0;

    public double getMultRed() {
        return this.multRed;
    }

    public double getMultGreen() {
        return this.multGreen;
    }

    public double getMultBlue() {
        return this.multBlue;
    }

    public int getAddRed() {
        return this.addRed;
    }

    public int getAddGreen() {
        return this.addGreen;
    }

    public int getAddBlue() {
        return this.addBlue;
    }

    public void setMultRed(double d) {
        this.multRed = d;
    }

    public void setMultGreen(double d) {
        this.multGreen = d;
    }

    public void setMultBlue(double d) {
        this.multBlue = d;
    }

    public void setAddRed(int n) {
        this.addRed = n;
    }

    public void setAddGreen(int n) {
        this.addGreen = n;
    }

    public void setAddBlue(int n) {
        this.addBlue = n;
    }

    public ColorTransform() {
    }

    public ColorTransform(double d, double d2, double d3, int n, int n2, int n3) {
        this.multRed = d;
        this.multGreen = d2;
        this.multBlue = d3;
        this.addRed = n;
        this.addGreen = n2;
        this.addBlue = n3;
    }

    public ColorTransform(int n, int n2, int n3) {
        this.addRed = n;
        this.addGreen = n2;
        this.addBlue = n3;
    }

    public ColorTransform(double d, double d2, double d3) {
        this.multRed = d;
        this.multGreen = d2;
        this.multBlue = d3;
    }

    public ColorTransform(InStream inStream) throws IOException {
        inStream.synchBits();
        boolean bl = inStream.readUBits(1) == 1L;
        boolean bl2 = inStream.readUBits(1) == 1L;
        int n = (int)inStream.readUBits(4);
        if (bl2) {
            this.multRed = (double)inStream.readSBits(n) / 256.0;
            this.multGreen = (double)inStream.readSBits(n) / 256.0;
            this.multBlue = (double)inStream.readSBits(n) / 256.0;
        }
        if (bl) {
            this.addRed = inStream.readSBits(n);
            this.addGreen = inStream.readSBits(n);
            this.addBlue = inStream.readSBits(n);
        }
    }

    public void write(OutStream outStream) throws IOException {
        int n;
        int n2;
        int n3;
        outStream.flushBits();
        boolean bl = this.addRed != 0 || this.addGreen != 0 || this.addBlue != 0;
        boolean bl2 = this.multRed != 1.0 || this.multGreen != 1.0 || this.multBlue != 1.0;
        int n4 = (int)(this.multRed * 256.0);
        int n5 = (int)(this.multGreen * 256.0);
        int n6 = (int)(this.multBlue * 256.0);
        int n7 = 1;
        if (bl) {
            n3 = OutStream.determineSignedBitSize(this.addRed);
            n2 = OutStream.determineSignedBitSize(this.addGreen);
            n = OutStream.determineSignedBitSize(this.addBlue);
            if (n7 < n3) {
                n7 = n3;
            }
            if (n7 < n2) {
                n7 = n2;
            }
            if (n7 < n) {
                n7 = n;
            }
        }
        if (bl2) {
            n3 = OutStream.determineSignedBitSize(n4);
            n2 = OutStream.determineSignedBitSize(n5);
            n = OutStream.determineSignedBitSize(n6);
            if (n7 < n3) {
                n7 = n3;
            }
            if (n7 < n2) {
                n7 = n2;
            }
            if (n7 < n) {
                n7 = n;
            }
        }
        outStream.writeUBits(1, bl ? 1L : 0L);
        outStream.writeUBits(1, bl2 ? 1L : 0L);
        outStream.writeUBits(4, n7);
        if (bl2) {
            outStream.writeSBits(n7, n4);
            outStream.writeSBits(n7, n5);
            outStream.writeSBits(n7, n6);
        }
        if (bl) {
            outStream.writeSBits(n7, this.addRed);
            outStream.writeSBits(n7, this.addGreen);
            outStream.writeSBits(n7, this.addBlue);
        }
        outStream.flushBits();
    }

    public void writeWithoutAlpha(OutStream outStream) throws IOException {
        this.write(outStream);
    }

    public void writeWithAlpha(OutStream outStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        outStream.flushBits();
        boolean bl = this.addRed != 0 || this.addGreen != 0 || this.addBlue != 0 || this.addAlpha != 0;
        boolean bl2 = this.multRed != 1.0 || this.multGreen != 1.0 || this.multBlue != 1.0 || this.multAlpha != 1.0;
        int n5 = (int)(this.multRed * 256.0);
        int n6 = (int)(this.multGreen * 256.0);
        int n7 = (int)(this.multBlue * 256.0);
        int n8 = (int)(this.multAlpha * 256.0);
        int n9 = 1;
        if (bl) {
            n4 = OutStream.determineSignedBitSize(this.addRed);
            n3 = OutStream.determineSignedBitSize(this.addGreen);
            n2 = OutStream.determineSignedBitSize(this.addBlue);
            n = OutStream.determineSignedBitSize(this.addAlpha);
            if (n9 < n4) {
                n9 = n4;
            }
            if (n9 < n3) {
                n9 = n3;
            }
            if (n9 < n2) {
                n9 = n2;
            }
            if (n9 < n) {
                n9 = n;
            }
        }
        if (bl2) {
            n4 = OutStream.determineSignedBitSize(n5);
            n3 = OutStream.determineSignedBitSize(n6);
            n2 = OutStream.determineSignedBitSize(n7);
            n = OutStream.determineSignedBitSize(n8);
            if (n9 < n4) {
                n9 = n4;
            }
            if (n9 < n3) {
                n9 = n3;
            }
            if (n9 < n2) {
                n9 = n2;
            }
            if (n9 < n) {
                n9 = n;
            }
        }
        outStream.writeUBits(1, bl ? 1L : 0L);
        outStream.writeUBits(1, bl2 ? 1L : 0L);
        outStream.writeUBits(4, n9);
        if (bl2) {
            outStream.writeSBits(n9, n5);
            outStream.writeSBits(n9, n6);
            outStream.writeSBits(n9, n7);
            outStream.writeSBits(n9, n8);
        }
        if (bl) {
            outStream.writeSBits(n9, this.addRed);
            outStream.writeSBits(n9, this.addGreen);
            outStream.writeSBits(n9, this.addBlue);
            outStream.writeSBits(n9, this.addAlpha);
        }
        outStream.flushBits();
    }

    public String toString() {
        return " cxform(+rgb,*rgb)=(" + this.addRed + "," + this.addGreen + "," + this.addBlue + "," + this.multRed + "," + this.multGreen + "," + this.multBlue + ")";
    }
}

