/*
 * Decompiled with CFR 0.152.
 */
package org.javaswf.swf.model;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.javaswf.swf.model.SWFTag;
import org.javaswf.swf.model.SWFTimeline;

public class SWFFrame {
    private String frameLabel;
    private SWFTimeline timeline;
    private boolean isAnchorFrame;
    private List tags;

    SWFFrame(SWFTimeline sWFTimeline) {
        this.timeline = sWFTimeline;
    }

    public int getTagCount() {
        if (this.tags == null) {
            return 0;
        }
        return this.tags.size();
    }

    public Iterator tags() {
        if (this.tags == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.tags.iterator();
    }

    public void appendTag(SWFTag sWFTag) {
        sWFTag.setFrame(this);
        if (this.tags == null) {
            this.tags = new ArrayList();
        }
        this.tags.add(sWFTag);
    }

    public SWFTimeline getTimeline() {
        return this.timeline;
    }

    public String getFrameLabel() {
        return this.frameLabel;
    }

    public boolean isAnchorFrame() {
        return this.isAnchorFrame;
    }

    public void setAnchorFrame(boolean bl) {
        this.isAnchorFrame = bl;
    }

    void setLabel(String string) {
        this.frameLabel = string;
    }

    public void write(SWFTagTypes sWFTagTypes) throws IOException {
        if (this.tags != null) {
            for (SWFTag sWFTag : this.tags) {
                sWFTag.writeTag(sWFTagTypes);
            }
        }
        if (this.frameLabel != null) {
            sWFTagTypes.tagFrameLabel(this.frameLabel, this.isAnchorFrame);
        }
        sWFTagTypes.tagShowFrame();
    }
}

