/*
 * Decompiled with CFR 0.152.
 */
package org.javaswf.tools.merger;

import com.anotherbigidea.flash.interfaces.SWFActionBlock;
import com.anotherbigidea.flash.interfaces.SWFActions;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.movie.ImageUtil;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.javaswf.tools.merger.ActionExtractor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class SWFMerger {
    private SWFTagTypes swf;
    private int nextSymbolId = 1;
    private int nextDepth = 1;

    public SWFMerger(SWFWriter sWFWriter) {
        this.swf = new TagWriter(sWFWriter);
    }

    public void processMergeSpec(File file) throws Exception {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        this.processMergeSpec(document);
    }

    public void processMergeSpec(Document document) throws Exception {
        Element element = document.getDocumentElement();
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element)) continue;
            Element element2 = (Element)node;
            String string = element2.getTagName();
            if (string.equals("frames")) {
                int n = this.getIntAttr(element2, "count");
                while (n-- > 0) {
                    this.swf.tagShowFrame();
                }
                continue;
            }
            if (!string.equals("frame")) continue;
            String string2 = element2.getAttribute("name");
            Properties properties = new Properties();
            NodeList nodeList2 = element2.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                node = nodeList2.item(j);
                if (!(node instanceof Element)) continue;
                Element element3 = (Element)node;
                string = element3.getTagName();
                if (string.equals("actions")) {
                    this.importActions(element3, properties);
                    continue;
                }
                if (string.equals("import")) {
                    this.importAsset(element3);
                    continue;
                }
                if (!string.equals("variable")) continue;
                properties.setProperty(this.getAttr(element3, "name"), this.getAttr(element3, "value"));
            }
            if (properties.size() > 0) {
                this.setVars(properties);
            }
            if (string2.length() > 0) {
                this.swf.tagFrameLabel(string2);
            }
            this.swf.tagShowFrame();
        }
    }

    private void setVars(Properties properties) throws IOException {
        SWFActions sWFActions = this.swf.tagDoAction();
        SWFActionBlock sWFActionBlock = sWFActions.start(0);
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = properties.getProperty(string);
            sWFActionBlock.push(string);
            sWFActionBlock.push(string2);
            sWFActionBlock.setVariable();
        }
        sWFActionBlock.end();
        sWFActions.done();
    }

    private void importActions(Element element, Properties properties) throws Exception {
        if (properties.size() > 0) {
            this.setVars(properties);
        }
        properties.clear();
        String string = this.getAttr(element, "file");
        String string2 = this.getAttr(element, "frame");
        ActionExtractor actionExtractor = new ActionExtractor(string2);
        byte[] byArray = actionExtractor.getActions(string);
        if (byArray == null) {
            throw new Exception("Failed to find actions in " + string + " in frame " + string2);
        }
        this.swf.tag(12, true, byArray);
    }

    private void importAsset(Element element) throws Exception {
        String string = this.getAttr(element, "file");
        String string2 = this.getAttr(element, "name");
        String string3 = element.getAttribute("alias");
        int n = this.getIntAttr(element, "depth", this.nextDepth);
        if (n >= this.nextDepth) {
            this.nextDepth = n + 1;
        }
        if (string.toLowerCase().endsWith(".jpg") || string.toLowerCase().endsWith(".jpeg")) {
            this.importImage(string, string2, n);
            return;
        }
    }

    private void importImage(String string, String string2, int n) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(string);
        int[] nArray = new int[2];
        byte[] byArray = ImageUtil.normalizeJPEG(fileInputStream, nArray);
        fileInputStream.close();
        int n2 = nArray[0] * 20;
        int n3 = nArray[1] * 20;
        int n4 = this.nextSymbolId++;
        int n5 = this.nextSymbolId++;
        int n6 = this.nextSymbolId++;
        Rect rect = new Rect(0, 0, n2, n3);
        this.swf.tagDefineBitsJPEG2(n4, byArray);
        SWFShape sWFShape = this.swf.tagDefineShape2(n5, rect);
        Matrix matrix = new Matrix(20.0, 20.0, 0.0, 0.0, 0.0, 0.0);
        sWFShape.defineFillStyle(n4, matrix, true);
        sWFShape.setFillStyle1(1);
        sWFShape.setLineStyle(0);
        sWFShape.line(n2, 0);
        sWFShape.line(0, n3);
        sWFShape.line(-n2, 0);
        sWFShape.line(0, -n3);
        sWFShape.done();
        SWFTagTypes sWFTagTypes = this.swf.tagDefineSprite(n6);
        sWFTagTypes.tagPlaceObject2(false, -1, 1, n5, new Matrix(), null, -1, null, 0);
        sWFTagTypes.tagShowFrame();
        sWFTagTypes.tagEnd();
        this.swf.tagPlaceObject2(false, -1, n, n6, new Matrix(), null, -1, string2, 0);
    }

    private int getIntAttr(Element element, String string) throws Exception {
        try {
            return Integer.parseInt(element.getAttribute(string));
        }
        catch (Exception exception) {
            throw new Exception("Element <" + element.getTagName() + "> requires numeric attribute " + string);
        }
    }

    private int getIntAttr(Element element, String string, int n) throws Exception {
        try {
            return Integer.parseInt(element.getAttribute(string));
        }
        catch (Exception exception) {
            return n;
        }
    }

    private String getAttr(Element element, String string) throws Exception {
        String string2 = element.getAttribute(string);
        if (string2.length() > 0) {
            return string2;
        }
        throw new Exception("Element <" + element.getTagName() + "> requires attribute " + string);
    }

    public static void main(String[] stringArray) throws Exception {
        String string = stringArray[0];
        String string2 = stringArray[1];
        int n = Integer.parseInt(stringArray[2]);
        int n2 = Integer.parseInt(stringArray[3]);
        int n3 = Integer.parseInt(stringArray[4]);
        SWFWriter sWFWriter = new SWFWriter(string2);
        sWFWriter.header(6, -1L, 20 * n, 20 * n2, n3, -1);
        new TagWriter(sWFWriter).tagSetBackgroundColor(new Color(255, 255, 255));
        SWFMerger sWFMerger = new SWFMerger(sWFWriter);
        sWFMerger.processMergeSpec(new File(string));
        sWFWriter.tag(0, false, null);
    }
}

