/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.imports;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;

public class AvoidStarImportCheck
extends Check {
    private String[] mExcludes = new String[0];

    public int[] getDefaultTokens() {
        return new int[]{30};
    }

    public void setExcludes(String[] aExcludes) {
        this.mExcludes = new String[aExcludes.length];
        for (int i = 0; i < aExcludes.length; ++i) {
            this.mExcludes[i] = aExcludes[i];
            if (this.mExcludes[i].endsWith(".*")) continue;
            this.mExcludes[i] = this.mExcludes[i] + ".*";
        }
    }

    public void visitToken(DetailAST aAST) {
        FullIdent name = FullIdent.createFullIdentBelow(aAST);
        if (name != null && name.getText().endsWith(".*")) {
            boolean exempt = false;
            for (int i = 0; i < this.mExcludes.length && !exempt; ++i) {
                if (!name.getText().equals(this.mExcludes[i])) continue;
                exempt = true;
            }
            if (!exempt) {
                this.log(aAST.getLineNo(), "import.avoidStar", (Object)name.getText());
            }
        }
    }
}

