/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.carbon.HMHelpContentRec;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolTip
extends Widget {
    Shell parent;
    Shell tip;
    int x;
    int y;
    boolean spikeAbove;
    boolean autohide;
    TextLayout layoutText;
    TextLayout layoutMessage;
    String text;
    String message;
    Region region;
    Font boldFont;
    Runnable runnable;
    int helpString;
    static final int BORDER = 5;
    static final int PADDING = 5;
    static final int INSET = 4;
    static final int TIP_HEIGHT = 20;
    static final int IMAGE_SIZE = 16;
    static final int DELAY = 10000;

    public ToolTip(Shell parent, int style) {
        super(parent, ToolTip.checkStyle(style));
        this.parent = parent;
        this.createWidget();
    }

    static int checkStyle(int style) {
        int mask = 11;
        if ((style & mask) == 0) {
            return style;
        }
        return ToolTip.checkBits(style, 2, 8, 1, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void configure() {
        int[] polyline;
        Display display = this.parent.getDisplay();
        int x = this.x;
        int y = this.y;
        if (x == -1 || y == -1) {
            org.eclipse.swt.graphics.Point point = display.getCursorLocation();
            x = point.x;
            y = point.y;
        }
        Monitor monitor = this.parent.getMonitor();
        Rectangle dest = monitor.getBounds();
        org.eclipse.swt.graphics.Point size = this.getSize(dest.width / 4);
        int w = size.x;
        int h = size.y;
        int t = (this.style & 0x1000) != 0 ? 20 : 0;
        int i = (this.style & 0x1000) != 0 ? 16 : 0;
        this.tip.setSize(w, h + t);
        boolean bl = this.spikeAbove = dest.height >= y + size.y + t;
        if (dest.width >= x + size.x) {
            if (dest.height >= y + size.y + t) {
                int[] nArray = new int[68];
                nArray[1] = 5 + t;
                nArray[2] = 1;
                nArray[3] = 5 + t;
                nArray[4] = 1;
                nArray[5] = 3 + t;
                nArray[6] = 3;
                nArray[7] = 1 + t;
                nArray[8] = 5;
                nArray[9] = 1 + t;
                nArray[10] = 5;
                nArray[11] = t;
                nArray[12] = 16;
                nArray[13] = t;
                nArray[14] = 16;
                nArray[16] = 35;
                nArray[17] = t;
                nArray[18] = w - 5;
                nArray[19] = t;
                nArray[20] = w - 5;
                nArray[21] = 1 + t;
                nArray[22] = w - 3;
                nArray[23] = 1 + t;
                nArray[24] = w - 1;
                nArray[25] = 3 + t;
                nArray[26] = w - 1;
                nArray[27] = 5 + t;
                nArray[28] = w;
                nArray[29] = 5 + t;
                nArray[30] = w;
                nArray[31] = h - 5 + t;
                nArray[32] = w - 1;
                nArray[33] = h - 5 + t;
                nArray[34] = w - 1;
                nArray[35] = h - 3 + t;
                nArray[36] = w - 2;
                nArray[37] = h - 3 + t;
                nArray[38] = w - 2;
                nArray[39] = h - 2 + t;
                nArray[40] = w - 3;
                nArray[41] = h - 2 + t;
                nArray[42] = w - 3;
                nArray[43] = h - 1 + t;
                nArray[44] = w - 5;
                nArray[45] = h - 1 + t;
                nArray[46] = w - 5;
                nArray[47] = h + t;
                nArray[48] = 5;
                nArray[49] = h + t;
                nArray[50] = 5;
                nArray[51] = h - 1 + t;
                nArray[52] = 3;
                nArray[53] = h - 1 + t;
                nArray[54] = 3;
                nArray[55] = h - 2 + t;
                nArray[56] = 2;
                nArray[57] = h - 2 + t;
                nArray[58] = 2;
                nArray[59] = h - 3 + t;
                nArray[60] = 1;
                nArray[61] = h - 3 + t;
                nArray[62] = 1;
                nArray[63] = h - 5 + t;
                nArray[65] = h - 5 + t;
                nArray[67] = 5 + t;
                polyline = nArray;
                this.tip.setLocation(Math.max(0, x - i), y);
            } else {
                int[] nArray = new int[68];
                nArray[1] = 5;
                nArray[2] = 1;
                nArray[3] = 5;
                nArray[4] = 1;
                nArray[5] = 3;
                nArray[6] = 3;
                nArray[7] = 1;
                nArray[8] = 5;
                nArray[9] = 1;
                nArray[10] = 5;
                nArray[12] = w - 5;
                nArray[14] = w - 5;
                nArray[15] = 1;
                nArray[16] = w - 3;
                nArray[17] = 1;
                nArray[18] = w - 1;
                nArray[19] = 3;
                nArray[20] = w - 1;
                nArray[21] = 5;
                nArray[22] = w;
                nArray[23] = 5;
                nArray[24] = w;
                nArray[25] = h - 5;
                nArray[26] = w - 1;
                nArray[27] = h - 5;
                nArray[28] = w - 1;
                nArray[29] = h - 3;
                nArray[30] = w - 2;
                nArray[31] = h - 3;
                nArray[32] = w - 2;
                nArray[33] = h - 2;
                nArray[34] = w - 3;
                nArray[35] = h - 2;
                nArray[36] = w - 3;
                nArray[37] = h - 1;
                nArray[38] = w - 5;
                nArray[39] = h - 1;
                nArray[40] = w - 5;
                nArray[41] = h;
                nArray[42] = 35;
                nArray[43] = h;
                nArray[44] = 16;
                nArray[45] = h + t;
                nArray[46] = 16;
                nArray[47] = h;
                nArray[48] = 5;
                nArray[49] = h;
                nArray[50] = 5;
                nArray[51] = h - 1;
                nArray[52] = 3;
                nArray[53] = h - 1;
                nArray[54] = 3;
                nArray[55] = h - 2;
                nArray[56] = 2;
                nArray[57] = h - 2;
                nArray[58] = 2;
                nArray[59] = h - 3;
                nArray[60] = 1;
                nArray[61] = h - 3;
                nArray[62] = 1;
                nArray[63] = h - 5;
                nArray[65] = h - 5;
                nArray[67] = 5;
                polyline = nArray;
                this.tip.setLocation(Math.max(0, x - i), y - size.y - t);
            }
        } else if (dest.height >= y + size.y + t) {
            int[] nArray = new int[68];
            nArray[1] = 5 + t;
            nArray[2] = 1;
            nArray[3] = 5 + t;
            nArray[4] = 1;
            nArray[5] = 3 + t;
            nArray[6] = 3;
            nArray[7] = 1 + t;
            nArray[8] = 5;
            nArray[9] = 1 + t;
            nArray[10] = 5;
            nArray[11] = t;
            nArray[12] = w - 35;
            nArray[13] = t;
            nArray[14] = w - 16;
            nArray[16] = w - 16;
            nArray[17] = t;
            nArray[18] = w - 5;
            nArray[19] = t;
            nArray[20] = w - 5;
            nArray[21] = 1 + t;
            nArray[22] = w - 3;
            nArray[23] = 1 + t;
            nArray[24] = w - 1;
            nArray[25] = 3 + t;
            nArray[26] = w - 1;
            nArray[27] = 5 + t;
            nArray[28] = w;
            nArray[29] = 5 + t;
            nArray[30] = w;
            nArray[31] = h - 5 + t;
            nArray[32] = w - 1;
            nArray[33] = h - 5 + t;
            nArray[34] = w - 1;
            nArray[35] = h - 3 + t;
            nArray[36] = w - 2;
            nArray[37] = h - 3 + t;
            nArray[38] = w - 2;
            nArray[39] = h - 2 + t;
            nArray[40] = w - 3;
            nArray[41] = h - 2 + t;
            nArray[42] = w - 3;
            nArray[43] = h - 1 + t;
            nArray[44] = w - 5;
            nArray[45] = h - 1 + t;
            nArray[46] = w - 5;
            nArray[47] = h + t;
            nArray[48] = 5;
            nArray[49] = h + t;
            nArray[50] = 5;
            nArray[51] = h - 1 + t;
            nArray[52] = 3;
            nArray[53] = h - 1 + t;
            nArray[54] = 3;
            nArray[55] = h - 2 + t;
            nArray[56] = 2;
            nArray[57] = h - 2 + t;
            nArray[58] = 2;
            nArray[59] = h - 3 + t;
            nArray[60] = 1;
            nArray[61] = h - 3 + t;
            nArray[62] = 1;
            nArray[63] = h - 5 + t;
            nArray[65] = h - 5 + t;
            nArray[67] = 5 + t;
            polyline = nArray;
            this.tip.setLocation(Math.min(dest.width - size.x, x - size.x + i), y);
        } else {
            int[] nArray = new int[68];
            nArray[1] = 5;
            nArray[2] = 1;
            nArray[3] = 5;
            nArray[4] = 1;
            nArray[5] = 3;
            nArray[6] = 3;
            nArray[7] = 1;
            nArray[8] = 5;
            nArray[9] = 1;
            nArray[10] = 5;
            nArray[12] = w - 5;
            nArray[14] = w - 5;
            nArray[15] = 1;
            nArray[16] = w - 3;
            nArray[17] = 1;
            nArray[18] = w - 1;
            nArray[19] = 3;
            nArray[20] = w - 1;
            nArray[21] = 5;
            nArray[22] = w;
            nArray[23] = 5;
            nArray[24] = w;
            nArray[25] = h - 5;
            nArray[26] = w - 1;
            nArray[27] = h - 5;
            nArray[28] = w - 1;
            nArray[29] = h - 3;
            nArray[30] = w - 2;
            nArray[31] = h - 3;
            nArray[32] = w - 2;
            nArray[33] = h - 2;
            nArray[34] = w - 3;
            nArray[35] = h - 2;
            nArray[36] = w - 3;
            nArray[37] = h - 1;
            nArray[38] = w - 5;
            nArray[39] = h - 1;
            nArray[40] = w - 5;
            nArray[41] = h;
            nArray[42] = w - 16;
            nArray[43] = h;
            nArray[44] = w - 16;
            nArray[45] = h + t;
            nArray[46] = w - 35;
            nArray[47] = h;
            nArray[48] = 5;
            nArray[49] = h;
            nArray[50] = 5;
            nArray[51] = h - 1;
            nArray[52] = 3;
            nArray[53] = h - 1;
            nArray[54] = 3;
            nArray[55] = h - 2;
            nArray[56] = 2;
            nArray[57] = h - 2;
            nArray[58] = 2;
            nArray[59] = h - 3;
            nArray[60] = 1;
            nArray[61] = h - 3;
            nArray[62] = 1;
            nArray[63] = h - 5;
            nArray[65] = h - 5;
            nArray[67] = 5;
            polyline = nArray;
            this.tip.setLocation(Math.min(dest.width - size.x, x - size.x + i), y - size.y - t);
        }
        if ((this.style & 0x1000) != 0) {
            if (this.region != null) {
                this.region.dispose();
            }
            this.region = new Region(display);
            this.region.add(polyline);
            this.tip.setRegion(this.region);
        }
    }

    void createWidget() {
        super.createWidget();
        this.autohide = true;
        this.y = -1;
        this.x = -1;
        this.text = "";
        this.message = "";
    }

    void disposeTip() {
        if (this.tip != null) {
            this.tip.dispose();
        }
        this.tip = null;
        if (this.region != null) {
            this.region.dispose();
        }
        this.region = null;
        if (this.layoutText != null) {
            this.layoutText.dispose();
        }
        this.layoutText = null;
        if (this.layoutMessage != null) {
            this.layoutMessage.dispose();
        }
        this.layoutMessage = null;
        if (this.boldFont != null) {
            this.boldFont.dispose();
        }
        this.boldFont = null;
    }

    public boolean getAutoHide() {
        this.checkWidget();
        return this.autohide;
    }

    public String getMessage() {
        this.checkWidget();
        return this.message;
    }

    public Shell getParent() {
        this.checkWidget();
        return this.parent;
    }

    org.eclipse.swt.graphics.Point getSize(int maxWidth) {
        int textWidth = 0;
        int messageWidth = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(-1);
            textWidth = this.layoutText.getBounds().width;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(-1);
            messageWidth = this.layoutMessage.getBounds().width;
        }
        int messageTrim = 28;
        boolean hasImage = this.layoutText != null && (this.style & 0x1000) != 0 && (this.style & 0xB) != 0;
        int textTrim = messageTrim + (hasImage ? 16 : 0);
        int width = Math.min(maxWidth, Math.max(textWidth + textTrim, messageWidth + messageTrim));
        int textHeight = 0;
        int messageHeight = 0;
        if (this.layoutText != null) {
            this.layoutText.setWidth(maxWidth - textTrim);
            textHeight = this.layoutText.getBounds().height;
        }
        if (this.layoutMessage != null) {
            this.layoutMessage.setWidth(maxWidth - messageTrim);
            messageHeight = this.layoutMessage.getBounds().height;
        }
        int height = 20 + messageHeight;
        if (this.layoutText != null) {
            height += Math.max(16, textHeight) + 10;
        }
        return new org.eclipse.swt.graphics.Point(width, height);
    }

    public String getText() {
        this.checkWidget();
        return this.text;
    }

    public boolean getVisible() {
        this.checkWidget();
        if (this.tip != null) {
            return this.tip.getVisible();
        }
        if (this.display.helpWidget == this) {
            int window = OS.FrontWindow();
            int[] windowClass = new int[1];
            OS.GetWindowClass(window, windowClass);
            return windowClass[0] == 10;
        }
        return false;
    }

    public boolean isVisible() {
        this.checkWidget();
        return this.getVisible();
    }

    void onMouseDown(Event event) {
        this.notifyListeners(13, new Event());
        this.setVisible(false);
    }

    void onPaint(Event event) {
        GC gc = event.gc;
        int x = 10;
        int y = 10;
        if ((this.style & 0x1000) != 0 && this.spikeAbove) {
            y += 20;
        }
        if (this.layoutText != null) {
            int id = this.style & 0xB;
            if ((this.style & 0x1000) != 0 && id != 0) {
                Display display = this.getDisplay();
                Image image = display.getSystemImage(id);
                Rectangle rect = image.getBounds();
                gc.drawImage(image, 0, 0, rect.width, rect.height, x, y, 16, 16);
                x += 16;
            }
            this.layoutText.draw(gc, x += 4, y);
            y += 10 + Math.max(16, this.layoutText.getBounds().height);
        }
        if (this.layoutMessage != null) {
            x = 14;
            this.layoutMessage.draw(gc, x, y);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.runnable != null) {
            Display display = this.getDisplay();
            display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        this.disposeTip();
        if (this.helpString != 0) {
            OS.CFRelease(this.helpString);
        }
        this.helpString = 0;
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void setAutoHide(boolean autohide) {
        this.checkWidget();
        this.autohide = autohide;
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if (this.x == x && this.y == y) {
            return;
        }
        this.x = x;
        this.y = y;
        if (this.tip != null && this.tip.getVisible()) {
            this.configure();
        }
    }

    public void setLocation(org.eclipse.swt.graphics.Point location) {
        this.checkWidget();
        if (location == null) {
            SWT.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setMessage(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.message = string;
        if (this.tip != null) {
            this.layoutMessage.setText(string);
            if (this.tip.getVisible()) {
                this.configure();
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        this.text = string;
        if (this.tip != null) {
            this.layoutText.setText(string);
            TextStyle style = new TextStyle(this.boldFont, null, null);
            this.layoutText.setStyle(style, 0, string.length());
            if (this.tip.getVisible()) {
                this.configure();
            }
        }
    }

    public void setVisible(boolean visible) {
        if (this.helpString != 0) {
            OS.CFRelease(this.helpString);
        }
        this.helpString = 0;
        if (this.runnable != null) {
            this.display.timerExec(-1, this.runnable);
        }
        this.runnable = null;
        if (visible) {
            OS.HMHideTag();
            this.display.helpWidget = this;
            if (!this.autohide || (this.style & 0x1000) != 0) {
                if (this.tip == null) {
                    this.tip = new Shell(this.parent, 16392);
                    Color background = this.display.getSystemColor(29);
                    this.tip.setBackground(background);
                    Listener listener = new Listener(){

                        public void handleEvent(Event event) {
                            switch (event.type) {
                                case 9: {
                                    ToolTip.this.onPaint(event);
                                    break;
                                }
                                case 3: {
                                    ToolTip.this.onMouseDown(event);
                                }
                            }
                        }
                    };
                    this.tip.addListener(9, listener);
                    this.tip.addListener(3, listener);
                    this.layoutText = new TextLayout(this.display);
                    this.layoutText.setText(this.text);
                    Font font = this.display.getSystemFont();
                    FontData data = font.getFontData()[0];
                    this.boldFont = new Font(this.display, data.getName(), data.getHeight(), 1);
                    TextStyle style = new TextStyle(this.boldFont, null, null);
                    this.layoutText.setStyle(style, 0, this.text.length());
                    this.layoutMessage = new TextLayout(this.display);
                    this.layoutMessage.setText(this.message);
                }
                this.configure();
                this.tip.setVisible(true);
                if (this.autohide) {
                    this.runnable = new Runnable(){

                        public void run() {
                            if (!ToolTip.this.isDisposed()) {
                                ToolTip.this.setVisible(false);
                            }
                        }
                    };
                    this.display.timerExec(10000, this.runnable);
                }
            } else {
                if (this.tip != null) {
                    this.disposeTip();
                }
                if (this.x == -1 || this.y == -1) {
                    Point pt = new Point();
                    OS.GetGlobalMouse(pt);
                    this.x = pt.h;
                    this.y = pt.v;
                }
                StringBuffer string = new StringBuffer(this.text);
                if (this.text.length() > 0) {
                    string.append("\n\n");
                }
                string.append(this.message);
                char[] buffer = new char[string.length()];
                string.getChars(0, buffer.length, buffer, 0);
                this.helpString = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
                HMHelpContentRec helpContent = new HMHelpContentRec();
                helpContent.tagSide = (short)23;
                helpContent.absHotRect_left = (short)this.x;
                helpContent.absHotRect_top = (short)this.y;
                helpContent.absHotRect_right = (short)(this.x + 1);
                helpContent.absHotRect_bottom = (short)(this.y + 1);
                helpContent.content0_contentType = 1667658612;
                helpContent.content0_tagCFString = this.helpString;
                helpContent.content1_contentType = 1667658612;
                helpContent.content1_tagCFString = this.helpString;
                OS.HMDisplayTag(helpContent);
            }
        } else if (this.display.helpWidget == this) {
            this.display.helpWidget = null;
            OS.HMHideTag();
            if (this.tip != null) {
                this.tip.setVisible(false);
            }
        }
    }
}

