// Created on Feb 24, 2005

package examples;

import java.io.IOException;

import com.anotherbigidea.flash.SWFConstants;
import com.anotherbigidea.flash.interfaces.SWFShape;
import com.anotherbigidea.flash.structs.Color;
import com.anotherbigidea.flash.structs.Matrix;
import com.anotherbigidea.flash.structs.Rect;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;

/**
 * Example of generating a gradient. 
 *
 * @author nick
 */
public class MakeGradient {
	
	private static final int TWIPS = SWFConstants.TWIPS; 
	
	/**
	 * @param args args[0] is filename to output
	 */
	public static void main(String[] args) throws IOException {
		SWFWriter swfFile = new SWFWriter( args[0] );
		TagWriter tags    = new TagWriter( swfFile );
		
		tags.header( 5, -1, 400*TWIPS, 400*TWIPS, 12, -1 );
		
		tags.tagSetBackgroundColor( new Color(255,255,255) );
		
		//define a 200*200 square shape, origin is at center
		SWFShape shape = tags.tagDefineShape( 1, 
				                  new Rect( -100*TWIPS, -100*TWIPS, 100*TWIPS, 100*TWIPS ) );
		
		//define a gradient
		int[] ratios = { 0, 64, 128, 182, 255 };
		
		Color[] colors = { 
			new Color(  0,  0,  0), //black
			new Color(255,255,255), //white
			new Color(255,  0,  0), //red
			new Color(255,  0,  0), //red
			new Color(255,255,255)  //white
		};
		
		/*-----------------------------------------
		  Scale the 32ktwips gradient square down to 200pixels.
		  Rotate clockwise 90 degrees.
		  No translation - already centered.
		-------------------------------------------*/
		double scale = ((double)(200*TWIPS)) / 32768.0;
		double angle = -Math.PI / 2.0;
		
		double skew0  = scale * -Math.sin( angle );
		double skew1  = scale * Math.sin( angle );
		double scaleX = scale * Math.cos( angle );
		double scaleY = scale * Math.cos( angle );
		
		Matrix matrix = new Matrix( scaleX, scaleY, 
                					skew0,  skew1,
                					0.0, 0.0 );
		
		shape.defineFillStyle( matrix, ratios, colors, false /*linear*/ );
		
		//set the fill gradiant
		shape.setFillStyle0( 1 );
		
		//set line style to 1 pixel black
		shape.defineLineStyle( 1*TWIPS, new Color(0,0,0) );
		shape.setLineStyle( 1 );
		
		//draw the vectors
		shape.move(-100*TWIPS,-100*TWIPS); //top left
		shape.line( 200*TWIPS,         0);
		shape.line(         0, 200*TWIPS);
		shape.line(-200*TWIPS,         0);
		shape.line(         0,-200*TWIPS);
		shape.done();
		
		//place the shape
		tags.tagPlaceObject( 1, 1, new Matrix( 200*TWIPS, 200*TWIPS ), null );
		
		//end of frame 1
		tags.tagShowFrame();
		
		//end of SWF
		tags.tagEnd();
	}
}
