package org.javaswf.tools.compressor;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.writers.SWFTagTypesImpl;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;

/**
 * Converts an uncompressed SWF to a ZLIB compressed one.
 * If the input version is 5 then it is changed to 6.
 * 
 * @author nmain
 */
public class Compressor extends SWFTagTypesImpl {

    public Compressor( SWFTagTypes tags ) {
        super( tags );
    }
    
    /**
     * Interface SWFTags
     */
    public void header( int version, long length,
                        int twipsWidth, int twipsHeight,
                        int frameRate, int frameCount ) throws IOException
    {
        super.header( ( version < 6 ) ? 6 : version, -1, 
                       twipsWidth, twipsHeight, 
                       frameRate, frameCount );
    }
    
    public static void main( String[] args ) throws IOException
    {
        FileInputStream in = new FileInputStream( args[0] );
        FileOutputStream out = new FileOutputStream( args[1] );
        
        SWFWriter writer = new SWFWriter( out );
        TagWriter tagger = new TagWriter( writer );
        Compressor compressor = new Compressor( tagger );        
        TagParser parser = new TagParser( compressor );
        SWFReader reader = new SWFReader( parser, in );
        writer.setCompression( true );
        reader.readFile();
        
        in.close();
        out.flush();
        out.close();
    }  
    
}
