/****************************************************************
 * Copyright (c) 2004, David N. Main, All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or
 * without modification, are permitted provided that the 
 * following conditions are met:
 *
 * 1. Redistributions of source code must retain the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer. 
 * 
 * 2. Redistributions in binary form must reproduce the above 
 * copyright notice, this list of conditions and the following 
 * disclaimer in the documentation and/or other materials 
 * provided with the distribution.
 * 
 * 3. The name of the author may not be used to endorse or 
 * promote products derived from this software without specific 
 * prior written permission. 
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY 
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, 
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT 
 * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; 
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) 
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, 
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 ****************************************************************/
 
package org.javaswf.swf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

/**
 * Base for SWF objects that have an id
 * @author Nick
 */
public abstract class SWFSymbol extends SWFTag {

    private int id;
    private List incomingReferences = new ArrayList();
    
    protected SWFSymbol( int id ) {
        this.id = id;
    }
    
    /**
     * @return the numeric id of the symbol
     */
    public int getSymbolId() {
        return id;
    }
    
    /**
     * Get the references to this symbol
     * @return SWFTag instances
     */
    public Iterator getIncomingReferences() {
    	return incomingReferences.iterator();
    }
    
    /**
     * Make a new reference to this symbol.
     * A given tag may have more than one reference to this symbol
     * 
     * @param referer the tag that refers to this symbol
     */
    public void makeReference( SWFTag referer ) {
    	incomingReferences.add( referer );
    }
    
    /**
     * Remove a reference.  Only one reference is removed, other references
     * from the same tag are left intact.
     * 
     * @param referer the tag to remove
     */
    public void removeReference( SWFTag referer ) {
    	incomingReferences.remove( referer );
    }
}
