import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Arrays;

import com.anotherbigidea.flash.interfaces.SWFTagTypes;
import com.anotherbigidea.flash.interfaces.SWFTags;
import com.anotherbigidea.flash.readers.SWFReader;
import com.anotherbigidea.flash.readers.TagParser;
import com.anotherbigidea.flash.writers.SWFWriter;
import com.anotherbigidea.flash.writers.TagWriter;

/**
 * Parse swf args[0] and write it out as args[0]+".out" then compare the
 * two files to ensure they are identical.
 * 
 * @author nmain
 */
public class Test {
    public static void main( String[] args ) throws IOException {
        FileOutputStream out = new FileOutputStream( args[0] + ".out" );
        SWFTags     swf  = new SWFWriter( out );
        SWFTagTypes tags = new TagWriter( swf );       
        
        FileInputStream in  = new FileInputStream( args[0] );
        SWFTags tagparser = new TagParser( tags );
        SWFReader reader = new SWFReader( tagparser, in );
        
        try
        {
            reader.readFile();
        }
        finally
        {        
            out.close();
            in.close();
        }        
        
        
        RandomAccessFile r1 = new RandomAccessFile( args[0], "r" );
        RandomAccessFile r2 = new RandomAccessFile( args[0]+".out", "r" );
        
        byte[] b1 = new byte[ (int) r1.length() ];
        byte[] b2 = new byte[ (int) r2.length() ];
        
        r1.readFully( b1 );
        r2.readFully( b2 );
        
        r1.close();
        r2.close();

        System.out.println( "--> " + Arrays.equals( b1, b2 ));
    }
}
